/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.opendocument;

import javax.swing.table.TableModel;
import org.makagiga.commons.TK;
import org.makagiga.commons.XMLBuilder;
import org.makagiga.opendocument.ValueType;

public final class Content
extends XMLBuilder {
    public void addTableCell(Object object, ValueType valueType) {
        switch (valueType) {
            case STRING: {
                this.beginTag("table:table-cell", new Object[]{"office:value-type", valueType});
                this.addTextLine(object.toString());
                break;
            }
            default: {
                this.beginTag("table:table-cell", new Object[]{"office:value-type", valueType, "office:value", object});
                this.addTextLine(object.toString());
            }
        }
        this.endTag("table:table-cell");
    }

    public void addTableModel(TableModel tableModel) {
        this.addTableModel(tableModel, null);
    }

    public void addTableModel(TableModel tableModel, TableModelFilter tableModelFilter) {
        int n;
        int n2 = tableModel.getColumnCount();
        this.singleTag("table:table-column", "table:number-columns-repeated", n2);
        if (n2 == 0) {
            return;
        }
        this.beginTableRow();
        for (n = 0; n < n2; ++n) {
            if (tableModelFilter != null && !tableModelFilter.includeColumn(n)) continue;
            this.addTableCell(tableModel.getColumnName(n), ValueType.STRING);
        }
        this.endTableRow();
        n = tableModel.getRowCount();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            if (tableModelFilter != null && !tableModelFilter.includeRow(i)) continue;
            this.beginTableRow();
            for (int j = 0; j < n2; ++j) {
                ValueType valueType;
                Object object;
                if (tableModelFilter != null && !tableModelFilter.includeColumn(j)) continue;
                if (tableModelFilter == null) {
                    object = tableModel.getValueAt(i, j);
                    valueType = ValueType.get(object);
                } else {
                    object = tableModelFilter.formatValue(i, j, tableModel.getValueAt(i, j));
                    valueType = tableModelFilter.getValueType(i, j, object);
                }
                this.addTableCell(object, valueType);
            }
            this.endTableRow();
        }
    }

    public void addTextBlock(String string) {
        if (TK.isEmpty(string)) {
            this.addTextLine(string);
        } else {
            String[] stringArray;
            for (String string2 : stringArray = string.split("\n")) {
                this.addTextLine(string2);
            }
        }
    }

    public void addTextLine(String string) {
        this.addTextLine(string, null);
    }

    public void addTextLine(String string, String string2) {
        if (string2 == null) {
            this.doubleTag("text:p", this.escapeText(string), new Object[0]);
        } else {
            this.doubleTag("text:p", this.escapeText(string), "text:style-name", string2);
        }
    }

    public void beginSpreadsheet() {
        this.beginTag("office:spreadsheet");
    }

    public void endSpreadsheet() {
        this.endTag("office:spreadsheet");
    }

    public void beginTable(String string) {
        this.beginTag("table:table", "table:name", string, "table:print", true);
    }

    public void endTable() {
        this.endTag("table:table");
    }

    public void beginTableRow() {
        this.beginTag("table:table-row");
    }

    public void endTableRow() {
        this.endTag("table:table-row");
    }

    public void beginText() {
        this.beginTag("office:text");
    }

    public void endText() {
        this.endTag("office:text");
    }

    protected Content() {
        this.beginTag("office:document-content", "xmlns:office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0", "xmlns:number", "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0", "xmlns:style", "urn:oasis:names:tc:opendocument:xmlns:style:1.0", "xmlns:table", "urn:oasis:names:tc:opendocument:xmlns:table:1.0", "xmlns:text", "urn:oasis:names:tc:opendocument:xmlns:text:1.0", "office:version", "1.0");
        this.beginTag("office:body");
    }

    protected void end() {
        this.endTag("office:body");
        this.endTag("office:document-content");
    }

    private void doCreateSpaces(StringBuilder stringBuilder, int n) {
        switch (n) {
            case 0: {
                return;
            }
            case 1: {
                stringBuilder.append(' ');
                break;
            }
            case 2: {
                stringBuilder.append(" <text:s/>");
                break;
            }
            default: {
                stringBuilder.append(' ').append("<text:s text:c=\"").append(n - 1).append("\"/>");
            }
        }
    }

    private String escapeText(String string) {
        if (TK.isEmpty(string)) {
            return "";
        }
        char[] cArray = Content.escape(string).toCharArray();
        int n = 0;
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder(cArray.length * 2);
        for (char c : cArray) {
            if (c == ' ') {
                ++n2;
            } else {
                this.doCreateSpaces(stringBuilder, n2);
                n2 = 0;
                if (c == '\t') {
                    stringBuilder.append("<text:tab/>");
                } else {
                    stringBuilder.append(c);
                }
            }
            if (++n <= cArray.length - 1) continue;
            this.doCreateSpaces(stringBuilder, n2);
        }
        return stringBuilder.toString();
    }

    public static class TableModelFilter {
        public Object formatValue(int n, int n2, Object object) {
            return object;
        }

        public ValueType getValueType(int n, int n2, Object object) {
            return ValueType.get(object);
        }

        public boolean includeColumn(int n) {
            return true;
        }

        public boolean includeRow(int n) {
            return true;
        }
    }
}

