/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.internetsearch;

import edu.umd.cs.findbugs.annotation.SuppressWarnings;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.Net;
import org.makagiga.commons.TK;
import org.makagiga.commons.icons.Favicon;

@XmlRootElement(name="OpenSearchDescription", namespace="http://a9.com/-/spec/opensearch/1.1/")
public final class OpenSearchDescription
implements Serializable {
    private static final long serialVersionUID = -3310949286299886347L;
    public static final String MIME = "application/opensearchdescription+xml";
    private List<Image> image;
    private List<String> inputEncoding;
    private List<String> outputEncoding;
    private List<Url> url;
    @SuppressWarnings(value="SE_TRANSIENT_FIELD_NOT_RESTORED")
    private transient MIcon iconCache;
    private String attribution;
    private String contact;
    private String description;
    private String developer;
    private String longName;
    private String shortName;
    private String tags;

    public String formatTemplate(String string) {
        String string2;
        if (TK.isEmpty(this.url)) {
            return null;
        }
        Url url = this.url.get(0);
        String string3 = url.getTemplate();
        if (string3 == null) {
            return null;
        }
        if (string == null) {
            string = "";
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        block4: for (int i = 0; i < string3.length(); ++i) {
            char c = string3.charAt(i);
            switch (c) {
                case '{': {
                    if (!bl) {
                        bl = true;
                        bl2 = false;
                        stringBuilder.setLength(0);
                        continue block4;
                    }
                    throw new IllegalArgumentException("Malformed URL template: " + string3);
                }
                case '}': {
                    if (bl) {
                        bl = false;
                        string2 = stringBuilder.toString();
                        Param.formatValue(stringBuilder2, this, url, string, bl2, string2);
                        bl3 = true;
                        continue block4;
                    }
                    throw new IllegalArgumentException("Malformed URL template: " + string3);
                }
                default: {
                    if (bl) {
                        if (c == '?') {
                            bl2 = true;
                            continue block4;
                        }
                        stringBuilder.append(c);
                        continue block4;
                    }
                    stringBuilder2.append(c);
                }
            }
        }
        if (!TK.isEmpty(url.getParam())) {
            if (!bl3) {
                stringBuilder2.append('?');
            }
            for (Param param : url.getParam()) {
                if (stringBuilder2.charAt(stringBuilder2.length() - 1) != '?') {
                    stringBuilder2.append('&');
                }
                stringBuilder2.append(param.getName());
                stringBuilder2.append('=');
                bl2 = false;
                string2 = param.getValue();
                if (string2 == null) continue;
                if (string2.startsWith("{") && string2.endsWith("}")) {
                    if (string2.endsWith("?}")) {
                        bl2 = true;
                        string2 = string2.replace("?}", "");
                    } else {
                        string2 = string2.replace("}", "");
                    }
                    string2 = string2.replace("{", "");
                    Param.formatValue(stringBuilder2, this, url, string, bl2, string2);
                    continue;
                }
                stringBuilder2.append(this.encode(string2));
            }
        }
        return stringBuilder2.toString();
    }

    @XmlElement(name="Attribution", namespace="http://a9.com/-/spec/opensearch/1.1/")
    public String getAttribution() {
        return this.attribution;
    }

    public void setAttribution(String string) {
        this.attribution = OpenSearchDescription.limit(string, 256);
    }

    @XmlElement(name="Contact", namespace="http://a9.com/-/spec/opensearch/1.1/")
    public String getContact() {
        return this.contact;
    }

    public void setContact(String string) {
        this.contact = string;
    }

    @XmlElement(name="Description", namespace="http://a9.com/-/spec/opensearch/1.1/", required=true)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string == null ? "" : OpenSearchDescription.limit(string, 1024);
    }

    @XmlElement(name="Developer", namespace="http://a9.com/-/spec/opensearch/1.1/")
    public String getDeveloper() {
        return this.developer;
    }

    public void setDeveloper(String string) {
        this.developer = OpenSearchDescription.limit(string, 64);
    }

    @XmlTransient
    public synchronized MIcon getIcon() {
        if (this.iconCache == null) {
            if (TK.isEmpty(this.image)) {
                this.iconCache = new MIcon();
                return this.iconCache;
            }
            Image image = this.image.get(0);
            if (image.value == null) {
                this.iconCache = new MIcon();
                return this.iconCache;
            }
            try {
                this.iconCache = MIcon.fromDataURI(image.value);
            }
            catch (IOException iOException) {
                if (MLogger.isDeveloper()) {
                    MLogger.exception(iOException);
                }
                if (Net.isHTTP(image.value)) {
                    try {
                        this.iconCache = new Favicon(null, new URL(image.value), true, image.getWidth());
                    }
                    catch (MalformedURLException malformedURLException) {
                        MLogger.exception(iOException);
                        this.iconCache = new MIcon();
                    }
                }
                this.iconCache = new MIcon();
            }
        }
        return this.iconCache;
    }

    @XmlElement(name="Image", namespace="http://a9.com/-/spec/opensearch/1.1/")
    public synchronized List<Image> getImage() {
        return this.image;
    }

    public synchronized void setImage(List<Image> list) {
        this.image = list;
    }

    @XmlElement(name="InputEncoding", namespace="http://a9.com/-/spec/opensearch/1.1/")
    public List<String> getInputEncoding() {
        return this.inputEncoding;
    }

    public void setInputEncoding(List<String> list) {
        this.inputEncoding = list;
    }

    @XmlElement(name="LongName", namespace="http://a9.com/-/spec/opensearch/1.1/")
    public String getLongName() {
        return this.longName;
    }

    public void setLongName(String string) {
        this.longName = OpenSearchDescription.limit(string, 48);
    }

    @XmlElement(name="OutputEncoding", namespace="http://a9.com/-/spec/opensearch/1.1/")
    public List<String> getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setOutputEncoding(List<String> list) {
        this.outputEncoding = list;
    }

    @XmlElement(name="ShortName", namespace="http://a9.com/-/spec/opensearch/1.1/", required=true)
    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String string) {
        this.shortName = string == null ? "" : OpenSearchDescription.limit(string, 16);
    }

    @XmlElement(name="Tags", namespace="http://a9.com/-/spec/opensearch/1.1/")
    public String getTags() {
        return this.tags;
    }

    public void setTags(String string) {
        this.tags = OpenSearchDescription.limit(string, 256);
    }

    @XmlElement(name="Url", namespace="http://a9.com/-/spec/opensearch/1.1/", required=true)
    public List<Url> getUrl() {
        return this.url;
    }

    public void setUrl(List<Url> list) {
        this.url = list;
    }

    private static String limit(String string, int n) {
        if (string == null) {
            return null;
        }
        if (string.length() > n) {
            return string.substring(0, n);
        }
        return string;
    }

    public String toString() {
        return this.longName == null ? this.shortName : this.longName;
    }

    private String encode(String string) {
        String string2 = TK.isEmpty(this.inputEncoding) ? "UTF-8" : this.inputEncoding.get(0);
        try {
            return URLEncoder.encode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            MLogger.exception(unsupportedEncodingException);
            return TK.escapeURL(string);
        }
    }

    public static final class Url
    implements Serializable {
        private int indexOffset = 1;
        private int pageOffset = 1;
        private List<Param> param;
        private String method;
        private String template;
        private String type;

        @XmlAttribute(name="indexOffset")
        public int getIndexOffset() {
            return this.indexOffset;
        }

        public void setIndexOffset(int n) {
            this.indexOffset = n;
        }

        @XmlAttribute(name="method")
        public String getMethod() {
            return this.method;
        }

        public void setMethod(String string) {
            this.method = string;
        }

        @XmlAttribute(name="pageOffset")
        public int getPageOffset() {
            return this.pageOffset;
        }

        public void setPageOffset(int n) {
            this.pageOffset = n;
        }

        @XmlElement(name="Param", namespace="http://a9.com/-/spec/opensearch/1.1/")
        public List<Param> getParam() {
            return this.param;
        }

        public void setParam(List<Param> list) {
            this.param = list;
        }

        @XmlAttribute(name="template", required=true)
        public String getTemplate() {
            return this.template;
        }

        public void setTemplate(String string) {
            this.template = string;
        }

        @XmlAttribute(name="type", required=true)
        public String getType() {
            return this.type;
        }

        public void setType(String string) {
            this.type = string;
        }

        public String toString() {
            return String.format("Template \"%s\" of type \"%s\"", this.template, this.type);
        }
    }

    public static final class Param
    implements Serializable {
        private String name;
        private String value;

        @XmlAttribute(name="name")
        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        @XmlAttribute(name="value")
        public String getValue() {
            return this.value;
        }

        public void setValue(String string) {
            this.value = string;
        }

        private static void formatValue(StringBuilder stringBuilder, OpenSearchDescription openSearchDescription, Url url, String string, boolean bl, String string2) {
            if ("count".equals(string2)) {
                if (!bl) {
                    stringBuilder.append(10);
                }
            } else if ("inputEncoding".equals(string2)) {
                String string3 = TK.isEmpty(openSearchDescription.inputEncoding) ? "UTF-8" : (String)openSearchDescription.inputEncoding.get(0);
                stringBuilder.append(string3);
            } else if ("outputEncoding".equals(string2)) {
                String string4 = TK.isEmpty(openSearchDescription.outputEncoding) ? "UTF-8" : (String)openSearchDescription.outputEncoding.get(0);
                stringBuilder.append(string4);
            } else if ("searchTerms".equals(string2)) {
                stringBuilder.append(openSearchDescription.encode(string));
            } else if ("startIndex".equals(string2)) {
                stringBuilder.append(url.getIndexOffset());
            } else if ("startPage".equals(string2)) {
                stringBuilder.append(url.getPageOffset());
            } else if ("referrer:source".equals(string2)) {
                stringBuilder.append(openSearchDescription.encode(MApplication.getInternalName()));
            }
        }
    }

    public static final class Image
    implements Serializable {
        private int height;
        private int width;
        private String type;
        private String value;

        @XmlAttribute(name="width")
        public int getWidth() {
            return this.width;
        }

        public void setWidth(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Image width cannot be less than zero");
            }
            this.width = n;
        }

        @XmlAttribute(name="height")
        public int getHeight() {
            return this.height;
        }

        public void setHeight(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Image height cannot be less than zero");
            }
            this.height = n;
        }

        @XmlAttribute(name="type")
        public String getType() {
            return this.type;
        }

        public void setType(String string) {
            this.type = string;
        }

        @XmlValue
        public String getValue() {
            return this.value;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public String toString() {
            return String.format("Image \"%s\" (%s x %s) of type \"%s\"", this.value, this.width, this.height, this.type);
        }
    }
}

