/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.fs.feeds;

import java.awt.Color;
import java.awt.event.InputEvent;
import java.io.FileNotFoundException;
import java.lang.ref.WeakReference;
import java.net.UnknownHostException;
import java.util.List;
import javax.swing.SwingUtilities;
import org.makagiga.MainWindow;
import org.makagiga.commons.Config;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MDataAction;
import org.makagiga.commons.MDate;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MNotification;
import org.makagiga.commons.MTree;
import org.makagiga.commons.MV;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.feeds.AbstractChannel;
import org.makagiga.feeds.AbstractItem;
import org.makagiga.feeds.Feed;
import org.makagiga.feeds.FeedException;
import org.makagiga.feeds.FeedListException;
import org.makagiga.feeds.FeedUtils;
import org.makagiga.feeds.archive.Archive;
import org.makagiga.feeds.archive.ArchiveException;
import org.makagiga.feeds.archive.ArchiveItem;
import org.makagiga.fs.AbstractFS;
import org.makagiga.fs.MetaInfo;
import org.makagiga.fs.feeds.FeedDownloader;
import org.makagiga.fs.feeds.FeedsFS;
import org.makagiga.fs.feeds.FeedsFSPlugin;
import org.makagiga.fs.feeds.Filters;
import org.makagiga.tree.Tree;
import org.xml.sax.SAXParseException;

public final class FeedThread
implements Runnable {
    private volatile boolean aborted;
    private boolean expandFolder;
    private Feed feed;
    private final FeedsFS fs;
    private final MetaInfo parent;
    private final Result result = new Result();
    private static final String MESSAGE_PROPERTY = "org.makagiga.fs.feeds.FeedThread.message";
    private final String url;
    boolean fetchOffline;

    public FeedThread(FeedsFS feedsFS, MetaInfo metaInfo, boolean bl, String string) {
        this.fs = feedsFS;
        this.parent = metaInfo;
        this.expandFolder = bl;
        Config config = metaInfo.getConfig();
        this.url = string == null ? config.read("x.url", null) : string;
        MLogger.debug("feed", "Start fetch: %s", this.url);
        metaInfo.setProperty("metaInfo.override.icon", "ui/refresh");
        metaInfo.setProperty("metaInfo.override.name", "%name [" + UI._("Click to cancel download") + "]");
        metaInfo.setProperty("feed.loadCompleteStory", config.read("x.loadCompleteStory", false));
        metaInfo.setProperty("feed.thread", this);
        metaInfo.refresh(false);
    }

    public void abort() {
        this.aborted = true;
    }

    public MetaInfo getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Thread.currentThread().setPriority(4);
        if (this.isAborted()) {
            MLogger.debug("feed", "Fetch aborted (1)");
            try {
                UI.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        FeedThread.this.cleanUp();
                        FeedThread.this.updateTree();
                    }
                });
                return;
            }
            catch (Exception var1_1) {
                MLogger.exception(var1_1);
            }
            return;
        }
        var1_2 = false;
        var2_3 = null;
        try {
            block37: {
                if (TK.isEmpty(this.url)) {
                    throw new IllegalArgumentException(UI._("Invalid feed address"));
                }
                if (this.fetchOffline) {
                    TK.sleep(100L);
                    var1_2 = true;
                } else {
                    this.feed = new Feed();
                    try {
                        this.parent.clearProperty("feed.lastFetch");
                        Result.access$302(this.result, this.feed.download(this.url));
                        this.parent.setProperty("feed.lastFetch", System.currentTimeMillis());
                    }
                    catch (FeedException var3_4) {
                        var4_10 = var3_4.getCause();
                        if (var4_10 instanceof FileNotFoundException) {
                            var1_2 = true;
                            var2_3 = new Exception(UI._("File not found"), (Throwable)var4_10);
                        }
                        if (var4_10 instanceof SAXParseException) {
                            var1_2 = true;
                            var2_3 = new Exception("Malformed XML file", (Throwable)var4_10);
                        }
                        if (var4_10 instanceof UnknownHostException == false) throw var3_4;
                        var1_2 = true;
                        var2_3 = new Exception(UI._("Invalid RSS feed address or temporary network failure"), (Throwable)var4_10);
                    }
                }
                if (Result.access$300(this.result) != null) {
                    MLogger.debug("feed", "Channel (%s): %s", new Object[]{this.url, Result.access$300(this.result)});
                }
                var3_5 = (FeedsFSPlugin)this.fs.getInfo().getPluggable();
                var5_11 = this.parent;
                synchronized (var5_11) {
                    var4_10 = var3_5.readSettings(this.parent, true);
                    ** if (!this.isAborted()) goto lbl52
                }
lbl-1000:
                // 1 sources

                {
                    MLogger.debug("feed", "Fetch aborted (3)");
                    UI.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            FeedThread.this.cleanUp();
                            FeedThread.this.updateTree();
                        }
                    });
                    return;
                }
lbl52:
                // 1 sources

                if (!var1_2) break block37;
                try {
                    var5_11 = Archive.getInstance().getChannel(this.url);
                    if (var5_11 != null && (var6_13 = var5_11.getChannel()) != null) {
                        Result.access$302(this.result, var6_13);
                        Result.access$402(this.result, var6_13.getItems());
                    }
                }
                catch (ArchiveException var5_12) {
                    if (this.fetchOffline) {
                        MLogger.warning("feed", var5_12.toString());
                        UI.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                FeedThread.this.cleanUp();
                                FeedThread.this.updateTree();
                            }
                        });
                        FeedDownloader.finished(this);
                        var6_14 = this.parent;
                        synchronized (var6_14) {
                            this.parent.clearProperty("feed.thread");
                            return;
                        }
                    }
                    MLogger.exception(var5_12);
                }
lbl74:
                // 2 sources

                while (true) {
                    UI.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            FeedThread.this.done();
                        }
                    });
                    if (var1_2 == false) return;
                    if (var2_3 == null) return;
                    throw var2_3;
                }
            }
            Result.access$402(this.result, Archive.getInstance().merge(this.url, Result.access$300(this.result), 0, var4_10.archivePolicy, var4_10.removeArticlesAfter));
            ** continue;
        }
        catch (FeedListException var3_6) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FeedThread.this.updateTree();
                    FeedThread.this.showFeedList();
                }
            });
            return;
        }
        catch (Exception var3_8) {
            MLogger.exception(var3_8);
            var4_10 = var3_8.getMessage();
            SwingUtilities.invokeLater(new Runnable((String)var4_10){
                final /* synthetic */ String val$text;
                {
                    this.val$text = string;
                }

                @Override
                public void run() {
                    FeedThread.this.parent.setProperty("metaInfo.override.icon", "ui/error");
                    FeedThread.this.parent.setProperty("metaInfo.override.name", "%name [" + this.val$text + "]");
                    FeedThread.this.updateTree();
                    if (!FeedThread.this.isAborted()) {
                        FeedThread.showNotification(FeedThread.this.parent, new ErrorAction(FeedThread.this.parent, this.val$text));
                    }
                }
            });
            return;
        }
        finally {
            FeedDownloader.finished(this);
            var3_7 = this.parent;
            synchronized (var3_7) {
                this.parent.clearProperty("feed.thread");
            }
        }
    }

    public synchronized void setExpandFolder(boolean bl) {
        this.expandFolder = bl;
    }

    private void cleanUp() {
        this.parent.setExtraInfo(null);
        this.parent.clearProperty("metaInfo.override.icon");
        this.parent.clearProperty("metaInfo.override.name");
    }

    private void done() {
        this.cleanUp();
        if (this.isAborted()) {
            MLogger.debug("feed", "Fetch aborted (2)");
            if (this.feed != null) {
                this.feed.cancelDownload();
            }
            this.updateTree();
            return;
        }
        if (TK.isEmpty(this.result.items)) {
            this.parent.setExtraInfo(UI._("New: {0}", 0));
            this.updateTree();
            return;
        }
        int n = 0;
        List<Filters.Criteria> list = Filters.loadCriteria(this.parent.getConfig());
        String string = null;
        for (Object object : this.result.items) {
            Float f;
            String string2;
            String string3 = ((AbstractItem)object).toString();
            String string4 = TK.rightSqueeze(string3, 128);
            if (string == null) {
                string = TK.rightSqueeze(TK.stripMarkupTags(string3), 50);
            }
            FeedsFS.ArticleMetaInfo articleMetaInfo = new FeedsFS.ArticleMetaInfo((AbstractFS)this.fs, string4, ((AbstractItem)object).getUniqueID());
            Color color = ((ArchiveItem)object).getColorValue();
            if (color == null) {
                if (((AbstractItem)object).isRead()) {
                    this.fs.markAsRead(articleMetaInfo);
                } else {
                    if (((AbstractItem)object).isNew()) {
                        articleMetaInfo.setNew(true);
                        ++n;
                    }
                    if (((AbstractItem)object).isAdvertisement()) {
                        articleMetaInfo.setColor(this.fs.adColor);
                    } else {
                        this.fs.markAsUnread(articleMetaInfo);
                    }
                }
            } else {
                articleMetaInfo.setColor(color);
                articleMetaInfo.setArticleColor(color);
            }
            Filters.apply(list, (ArchiveItem)object, articleMetaInfo);
            articleMetaInfo.setCategories(((ArchiveItem)object).getCategory());
            String string5 = ((ArchiveItem)object).getComment();
            if (string5 != null) {
                articleMetaInfo.setComment(string5);
            }
            if ((string2 = ((ArchiveItem)object).getIcon()) != null) {
                articleMetaInfo.setIconName(string2);
            }
            if ((f = ((ArchiveItem)object).getRating()) != null) {
                articleMetaInfo.setRating(f.floatValue());
            }
            articleMetaInfo.setTags(((ArchiveItem)object).getTags());
            MDate mDate = ((AbstractItem)object).getDate();
            if (mDate != null) {
                articleMetaInfo.setCreatedTime(mDate);
            }
            this.parent.add(articleMetaInfo);
        }
        Tree tree = Tree.getInstance();
        this.fs.updateInfo(this.parent);
        if (n > 0) {
            Object object;
            object = UI._("New Articles: {0}", "<b>" + n + "</b>");
            if (!TK.isEmpty(string)) {
                object = (String)object + "<br>" + TK.escapeXML(string);
            }
            FeedThread.showNotification(this.parent, new NotificationAction(this.parent, UI.makeHTML((String)object)));
        }
        if (this.expandFolder) {
            tree.setExpanded(this.parent, true);
        } else {
            this.updateTree();
        }
    }

    private boolean isAborted() {
        return this.aborted;
    }

    private void showFeedList() {
        String string = FeedUtils.getAddressFromList(this.feed);
        if (string != null) {
            if (this.fs.alreadyExists(null, string)) {
                this.parent.clearProperty("metaInfo.override.icon");
                this.updateTree();
                return;
            }
            this.parent.getConfig().write("x.url", string);
            this.parent.sync();
            FeedDownloader.download(this.fs, this.parent, this.expandFolder, string);
        } else {
            this.parent.setProperty("metaInfo.override.icon", "ui/question");
        }
    }

    private void updateTree() {
        this.parent.reload();
    }

    static void showNotification(MetaInfo metaInfo, MAction mAction) {
        if (MNotification.getMessageCount() > 0) {
            for (MNotification.Message message : MNotification.getInstance()) {
                if (!(message.getAction() instanceof Action) || ((Action)Action.class.cast(message.getAction())).getParent() != metaInfo) continue;
                MNotification.getInstance().hideMessage(message);
                break;
            }
        }
        MNotification.Message message = new MNotification.Message(mAction);
        mAction.putValue(MESSAGE_PROPERTY, new WeakReference<Object>(message));
        MNotification.getInstance().addMessage(message);
    }

    private static final class Result {
        private AbstractChannel<? extends AbstractItem> channel;
        private List<ArchiveItem> items;

        private Result() {
        }

        static /* synthetic */ AbstractChannel access$302(Result result, AbstractChannel abstractChannel) {
            result.channel = abstractChannel;
            return result.channel;
        }

        static /* synthetic */ AbstractChannel access$300(Result result) {
            return result.channel;
        }

        static /* synthetic */ List access$402(Result result, List list) {
            result.items = list;
            return result.items;
        }
    }

    public static final class NotificationAction
    extends Action {
        private ArchiveItem archiveItem;
        private FeedsFS.ArticleMetaInfo articleMetaInfo;

        public NotificationAction(FeedsFS.ArticleMetaInfo articleMetaInfo, ArchiveItem archiveItem) {
            super(articleMetaInfo, archiveItem.getTitle(), "ui/feed");
            this.articleMetaInfo = articleMetaInfo;
            this.archiveItem = archiveItem;
        }

        @Override
        public void onAction() {
            Object object;
            super.onAction();
            MetaInfo metaInfo = null;
            if (this.articleMetaInfo != null && this.archiveItem != null) {
                metaInfo = this.articleMetaInfo;
            }
            if (metaInfo == null && !(object = this.getParent().list(MV.MODEL)).isEmpty()) {
                metaInfo = (MetaInfo)object.get(0);
            }
            if (metaInfo != null) {
                object = Tree.getInstance();
                InputEvent inputEvent = null;
                WeakReference weakReference = this.getValue(FeedThread.MESSAGE_PROPERTY, null);
                if (weakReference != null) {
                    MNotification.Message message = (MNotification.Message)weakReference.get();
                    if (message != null) {
                        weakReference.clear();
                        inputEvent = message.getInputEvent();
                    }
                    this.putValue(FeedThread.MESSAGE_PROPERTY, null);
                }
                ((Tree)object).open(inputEvent, metaInfo);
                ((MTree)object).focusItem(metaInfo);
            }
        }

        private NotificationAction(MetaInfo metaInfo, String string) {
            super(metaInfo, string, "ui/feed");
        }
    }

    public static final class ErrorAction
    extends Action {
        public ErrorAction(MetaInfo metaInfo, String string) {
            super(metaInfo, UI._("Error: {0}", string), "ui/error");
        }

        @Override
        public void onAction() {
            super.onAction();
            Tree.getInstance().selectItem(this.getParent(), true);
        }
    }

    public static abstract class Action
    extends MDataAction<MetaInfo> {
        public MetaInfo getParent() {
            return (MetaInfo)this.getData();
        }

        @Override
        public void onAction() {
            MainWindow.getInstance().restore();
            MainWindow.showTree(null);
        }

        protected Action(MetaInfo metaInfo, String string, String string2) {
            super(metaInfo, metaInfo.toString(), string2);
            this.setShortDescription(string);
        }
    }
}

