/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.fs;

import java.io.File;
import java.io.IOException;
import java.security.BasicPermission;
import java.util.HashMap;
import java.util.Map;
import org.makagiga.commons.FS;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.UI;
import org.makagiga.fs.FSException;
import org.makagiga.fs.FSHelper;
import org.makagiga.fs.MetaInfo;

public final class MountManager {
    private static Map<String, MetaInfo> table;

    public static synchronized void mount(MetaInfo metaInfo) throws FSException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new Permission("mount"));
        }
        if (table == null) {
            table = new HashMap<String, MetaInfo>();
        }
        table.put(metaInfo.getMount(), metaInfo);
    }

    public static synchronized void unmount(MetaInfo metaInfo) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new Permission("unmount"));
        }
        if (table == null) {
            return;
        }
        String string = metaInfo.getMount();
        if (string != null) {
            table.remove(string);
            if (table.isEmpty()) {
                table = null;
            }
        }
    }

    public static synchronized void validate(String string) throws FSException {
        Comparable<MetaInfo> comparable;
        if (table != null && (comparable = table.get(string)) != null) {
            throw new FSException(UI._("\"{0}\" is already mounted as \"{1}\"", string, ((MetaInfo)comparable).getNicePath()));
        }
        comparable = new File(string);
        if (!((File)comparable).exists()) {
            throw new FSException(UI._("Directory \"{0}\" does not exist", string));
        }
        if (!FSHelper.isMakagigaFolder(string)) {
            throw new FSException(UI._("This is not a Makagiga folder ({0})", ((File)comparable).getName()));
        }
        try {
            String string2 = new File(FS.makePath(FS.getConfigDir(), "vfs")).getCanonicalPath();
            String string3 = ((File)comparable).getCanonicalPath();
            if (string3.startsWith(string2)) {
                throw new FSException(UI._("Cannot mount the selected directory: \"{0}\"", string));
            }
        }
        catch (IOException iOException) {
            MLogger.exception(iOException);
        }
    }

    private MountManager() {
    }

    public static final class Permission
    extends BasicPermission {
        private Permission(String string) {
            super(string);
        }
    }
}

