/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.fs;

import java.awt.Color;
import java.awt.Image;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.makagiga.Vars;
import org.makagiga.commons.Config;
import org.makagiga.commons.FS;
import org.makagiga.commons.Flags;
import org.makagiga.commons.HTMLBuilder;
import org.makagiga.commons.Lockable;
import org.makagiga.commons.MDate;
import org.makagiga.commons.MFormat;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MProperties;
import org.makagiga.commons.MRenderer;
import org.makagiga.commons.MTreeItem;
import org.makagiga.commons.MTreeModel;
import org.makagiga.commons.MV;
import org.makagiga.commons.Net;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.category.CategoryList;
import org.makagiga.commons.category.CategoryManager;
import org.makagiga.commons.preview.DefaultPreview;
import org.makagiga.commons.request.RequestInfo;
import org.makagiga.commons.request.RequestSource;
import org.makagiga.editors.EditorPlugin;
import org.makagiga.fs.AbstractFS;
import org.makagiga.fs.FSAction;
import org.makagiga.fs.FSException;
import org.makagiga.fs.FSProperties;
import org.makagiga.fs.LinkMetaInfo;
import org.makagiga.fs.MetaInfoAction;
import org.makagiga.fs.MountManager;
import org.makagiga.plugins.PluginInfo;
import org.makagiga.search.SortMethod;
import org.makagiga.tags.Tags;
import org.makagiga.tags.TagsUtils;
import org.makagiga.tree.Tree;
import org.makagiga.tree.tracker.Tracker;
import org.makagiga.tree.tracker.TrackerEvent;

public class MetaInfo
extends MTreeItem
implements Comparable<MetaInfo>,
Lockable,
RequestSource<DefaultPreview.Result> {
    public static final int VERSION = 1;
    public static final int NO_LOCK_INFO = 2;
    public static final int NO_TAGS_INFO = 4;
    public static final int NO_COMMENT_INFO = 8;
    public static final int NO_LOCATION_INFO = 16;
    public static final int NO_DATE_INFO = 32;
    public static final int NO_NAME_INFO = 64;
    public static final String EXTRA_COLOR = "metaInfo.extra.color";
    public static final String EXTRA_TEXT = "metaInfo.extra.text";
    public static final String OVERRIDE_ICON = "metaInfo.override.icon";
    public static final String OVERRIDE_NAME = "metaInfo.override.name";
    public static final String PREVIEW_IMAGE = "metaInfo.previewImage";
    public static final String PREVIEW_INFO = "metaInfo.previewInfo";
    public static final String PREVIEW_PROPERTIES = "metaInfo.previewProperties";
    public static final String NO_IMAGE_PREVIEW = "metaInfo.noImagePreview";
    @Deprecated
    public static final String PAINTER = "metaInfo.painter";
    public static final String OWNER = "metaInfo.owner";
    private static final int FS_ROOT = 1;
    private static final int FOLDER = 2;
    private static final int FILE = 4;
    private static final int NOT_SUPPORTED = 8;
    private static final int DYNAMIC_FOLDER = 16;
    private static final int VIRTUAL_FILE = 32;
    private static final int DUMMY = 64;
    private static final int BOOKMARK = 128;
    private static final int LOCKED = 256;
    private static final int WRITEABLE = 512;
    private static final int ENCRYPTED = 1024;
    private static final int OPEN = 2048;
    private AbstractFS fs;
    private CategoryList categoryList;
    private Color color;
    private Config config;
    private float rating;
    private static Image lockedMiniIcon;
    private int attr;
    private int usage;
    private long createdTime;
    private long openTime;
    private Map<String, Object> properties;
    private static MetaInfoAction.Icon rendererIcon;
    private MIcon icon;
    private MIcon lockedIconCache;
    private MIcon smallIcon;
    private String categories;
    private String comment;
    private String iconName;
    private String id = "";
    private String name;
    private String path;
    private String tags;

    @Override
    public void add(MutableTreeNode mutableTreeNode) {
        Tracker.add((MetaInfo)mutableTreeNode, TrackerEvent.ID.ITEM_ADDED);
        super.add(mutableTreeNode);
    }

    public static void addInfo(HTMLBuilder hTMLBuilder, String string, Object object) {
        hTMLBuilder.beginTag("tr");
        if (object == null) {
            hTMLBuilder.doubleTag("td", HTMLBuilder.escape(string), "colspan", 2);
        } else {
            hTMLBuilder.doubleTag("td", HTMLBuilder.escape(string), "align", "right");
            hTMLBuilder.doubleTag("td", HTMLBuilder.escape(object.toString()), new Object[0]);
        }
        hTMLBuilder.endTag("tr");
    }

    public static void addSeparator(HTMLBuilder hTMLBuilder) {
        hTMLBuilder.appendLine("<tr><td colspan=\"2\"><hr></td></tr>");
    }

    public static void addWarning(HTMLBuilder hTMLBuilder, String string) {
        hTMLBuilder.appendLine("<tr><td colspan=\"2\"><font color=\"#ff0000\">" + HTMLBuilder.escape(string) + "</font></td></tr>");
    }

    public boolean canModify() {
        return (this.attr & 0x100) == 0 && (this.attr & 0x200) != 0;
    }

    public void clearIcon() {
        this.icon = null;
        this.iconName = null;
        this.smallIcon = null;
    }

    public Object clearProperty(String string) {
        if (this.properties == null) {
            return null;
        }
        Object object = this.properties.remove(string);
        if (this.properties.isEmpty()) {
            this.properties = null;
        }
        return object;
    }

    @Override
    public int compareTo(MetaInfo metaInfo) {
        return TK.compare(this.path, metaInfo.path, "");
    }

    public static MetaInfo createDummy() {
        return MetaInfo.createDummy("", null);
    }

    public static MetaInfo createDummy(String string, MIcon mIcon) {
        MetaInfo metaInfo = MetaInfo.createVirtualFile(null, string, mIcon);
        metaInfo.attr |= 0x40;
        return metaInfo;
    }

    public static MetaInfo createDynamicFolder(AbstractFS abstractFS, String string) {
        return MetaInfo.createDynamicFolder(abstractFS, string, null);
    }

    public static MetaInfo createDynamicFolder(AbstractFS abstractFS, String string, String string2) {
        File file;
        MetaInfo metaInfo = new MetaInfo(abstractFS, string, 16);
        if (string != null && (file = metaInfo.getFile()).exists()) {
            metaInfo.setWriteable(file);
        }
        if (string2 == null) {
            metaInfo.initID();
        } else {
            metaInfo.id = string2;
        }
        return metaInfo;
    }

    public static MetaInfo createFile(AbstractFS abstractFS, String string, PluginInfo pluginInfo) {
        MetaInfo metaInfo;
        if (pluginInfo == null) {
            metaInfo = new MetaInfo(abstractFS, string, 12);
        } else {
            metaInfo = new MetaInfo(abstractFS, string, 4);
            if (!metaInfo.isCustomIcon()) {
                metaInfo.setIcon(pluginInfo.getIcon());
            }
        }
        metaInfo.setAllowsChildren(false);
        metaInfo.setWriteable(metaInfo.getFile());
        metaInfo.initID();
        return metaInfo;
    }

    public static MetaInfo createFile(AbstractFS abstractFS, String string, String string2) {
        return MetaInfo.createFile(abstractFS, string, EditorPlugin.findPluginForExtension(string2));
    }

    public static MetaInfo createFSRoot(AbstractFS abstractFS, String string) {
        return new MetaInfo(abstractFS, string, 1);
    }

    public static MetaInfo createLink(MetaInfo metaInfo) {
        if (metaInfo.isLink()) {
            return null;
        }
        return new LinkMetaInfo(metaInfo);
    }

    public static MetaInfo createFolder(AbstractFS abstractFS, String string, String string2) {
        FolderMetaInfo folderMetaInfo = new FolderMetaInfo(abstractFS, string, string2);
        super.initID();
        return folderMetaInfo;
    }

    public static MetaInfo createMainRoot() {
        return new MetaInfo(null, FS.makeConfigPath("vfs"), 0);
    }

    public static MetaInfo createVirtualFile(AbstractFS abstractFS, String string) {
        return MetaInfo.createVirtualFile(abstractFS, string, null);
    }

    public static MetaInfo createVirtualFile(AbstractFS abstractFS, String string, MIcon mIcon) {
        VirtualFileMetaInfo virtualFileMetaInfo = new VirtualFileMetaInfo(abstractFS, string);
        if (mIcon != null) {
            virtualFileMetaInfo.setIcon(mIcon);
        }
        return virtualFileMetaInfo;
    }

    @Deprecated
    public long getAge() {
        if (this.isVirtualFile()) {
            return -1L;
        }
        if (this.createdTime == 0L) {
            long l = this.getFile().lastModified();
            return l == 0L ? -1L : MDate.now().getDayCount(l);
        }
        return MDate.now().getDayCount(this.createdTime);
    }

    public String getID() {
        return this.id;
    }

    public void setID(String string) {
        this.id = TK.checkNull(string, "value");
    }

    public float getRating() {
        return this.rating;
    }

    public void setRating(float f) {
        this.rating = f;
    }

    public String getTargetPath() {
        return this.isMount() ? this.getMount() : this.getFilePath();
    }

    public void invalidatePreview(boolean bl) {
        if (!this.isFile()) {
            return;
        }
        this.clearProperty(NO_IMAGE_PREVIEW);
        this.clearProperty(PREVIEW_IMAGE);
        this.clearProperty(PREVIEW_PROPERTIES);
        RequestInfo requestInfo = (RequestInfo)this.clearProperty(PREVIEW_INFO);
        if (requestInfo != null) {
            requestInfo.setCancelled(true);
            if (bl) {
                Tree.getInstance().repaint(this.getTreePath());
            }
        }
    }

    public boolean isAnyFile() {
        return this.isFile() || this.isVirtualFile();
    }

    public boolean isAnyFolder() {
        return this.isFolder() || this.isDynamicFolder();
    }

    public boolean isBookmark() {
        return (this.attr & 0x80) != 0;
    }

    public void setBookmark(boolean bl) {
        this.attr = bl ? (this.attr |= 0x80) : (this.attr &= 0xFFFFFF7F);
    }

    public boolean isEncrypted() {
        return this.isFile() && (this.attr & 0x400) != 0;
    }

    public void setEncrypted(boolean bl) {
        if (this.isFile()) {
            this.attr = bl ? (this.attr |= 0x400) : (this.attr &= 0xFFFFFBFF);
            this.sync();
        }
    }

    public String getCategories() {
        return this.categories;
    }

    public void setCategories(String string) {
        this.categories = string;
        this.categoryList = null;
    }

    public CategoryList getCategoryList() {
        if (TK.isEmpty(this.categories)) {
            return null;
        }
        if (this.categoryList == null) {
            this.categoryList = new CategoryList(CategoryManager.getSharedInstance(), this.categories);
        }
        return this.categoryList;
    }

    @Deprecated
    public void setCategories(CategoryList categoryList) {
        String string = categoryList.toString();
        this.setCategories("".equals(string) ? null : string);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public Config getConfig() {
        return this.config;
    }

    public String getExtension() {
        return this.isFile() ? FS.getExtension(this.path) : null;
    }

    public File getFile() {
        return new File(this.path);
    }

    public String getFilePath() {
        return this.path;
    }

    public void setFilePath(String string) {
        if (this.isFSRoot()) {
            this.path = string;
            this.name = string;
        } else if (this.isVirtualFile()) {
            this.path = string;
            this.name = TK.escapeURL(string);
        } else {
            this.path = string;
            File file = this.getFile();
            if (this.isDynamicFolder()) {
                this.name = this.getPathWithoutExtension(file.getName());
                if (this.config != null) {
                    this.config.setPath(this.path);
                }
            } else if (this.isFile()) {
                this.name = this.getPathWithoutExtension(file.getName());
                if (this.config != null) {
                    this.config.setPath(this.path + ".properties");
                }
            } else if (this.isFolder()) {
                this.name = file.getName();
                if (this.config != null) {
                    this.config.setPath(FS.makePath(this.path, ".properties"));
                }
            } else {
                this.name = file.getName();
            }
        }
    }

    public AbstractFS getFS() {
        return this.fs;
    }

    public void setFS(AbstractFS abstractFS) {
        this.fs = abstractFS;
        if (this.fs != null && this.config != null) {
            this.config.write("fs", this.fs.getID());
        }
    }

    public void setFSFromConfig() {
        if (this.config != null) {
            this.setFS(Tree.getInstance().getFS(this.config.read("fs", null)));
        }
    }

    public MIcon getIcon() {
        if (this.icon == null) {
            if (this.isVirtualFile()) {
                return null;
            }
            if (this.iconName == null) {
                return null;
            }
            this.icon = MetaInfo.getIcon(this.iconName);
            if (this.icon == null) {
                this.iconName = "ui/misc";
                this.icon = MIcon.stock(this.iconName);
            }
        }
        if (this.icon != null && !this.canModify()) {
            if (this.lockedIconCache != null) {
                return this.lockedIconCache;
            }
            if (lockedMiniIcon == null) {
                lockedMiniIcon = UI.scaleImage(MIcon.getImage("ui/locked"), this.icon.getIconWidth() / 3, this.icon.getIconHeight() / 3, UI.Quality.HIGH);
            }
            this.lockedIconCache = new MIcon(this.icon.getImage());
            this.lockedIconCache.setOverlay(lockedMiniIcon);
            return this.lockedIconCache;
        }
        return this.icon;
    }

    public void setIcon(MIcon mIcon) {
        this.clearProperty(OVERRIDE_ICON);
        if (mIcon == null) {
            this.iconName = this.isDynamicFolder() ? "dynamicfolder" : (this.isFolder() ? "ui/folder" : "ui/file");
            this.icon = MIcon.stock(this.iconName);
        } else {
            this.iconName = null;
            this.icon = mIcon;
        }
        this.lockedIconCache = null;
        this.smallIcon = null;
    }

    public MetaInfo getLink() {
        return null;
    }

    public boolean isLink() {
        return false;
    }

    public String getMount() {
        return null;
    }

    public boolean isMount() {
        return false;
    }

    public void setMount(String string) {
    }

    public String getNicePath() {
        String string;
        if (this.fs == null) {
            return this.toString();
        }
        if (this.isFSRoot()) {
            return this.fs.getName();
        }
        if (this.isVirtualFile()) {
            MetaInfo metaInfo = this.getParentFolder();
            if (metaInfo == null) {
                return this.path;
            }
            return metaInfo.getNicePath() + " > " + this.path;
        }
        if (this.isRoot()) {
            string = this.path;
        } else if (this.path.startsWith(this.fs.getDirectory())) {
            string = this.path.substring(this.fs.getDirectory().length() + 1);
        } else {
            MetaInfo metaInfo = this.getParentFolder();
            if (metaInfo != null) {
                string = "...";
                if (!metaInfo.isFSRoot()) {
                    string = string + File.separator + metaInfo.name;
                }
            } else {
                string = "";
            }
            if (this.path != null) {
                string = string + File.separator + this.getFile().getName();
            }
        }
        return this.fs.getName() + " > " + TK.unescapeURL(this.getPathWithoutExtension(string).replace(File.separator, " > "));
    }

    public String getOverrideName() {
        String string = this.getProperty(OVERRIDE_NAME, null);
        String string2 = this.toString();
        if (string != null) {
            string2 = string.replace("%name", string2);
        }
        return string2;
    }

    public MetaInfo getParentFolder() {
        return (MetaInfo)this.getParentItem();
    }

    public PluginInfo getPluginInfo() {
        String string = this.getExtension();
        if (string == null) {
            return null;
        }
        return EditorPlugin.findPluginForExtension(string);
    }

    public <T> T getProperty(String string, T t) {
        if (this.properties == null) {
            return t;
        }
        Object object = this.properties.get(string);
        return (T)(object == null ? t : object);
    }

    public Object setProperty(String string, Object object) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        return this.properties.put(string, object);
    }

    @Deprecated
    public float getRatio() {
        long l = this.getAge();
        if (l <= 0L) {
            return 0.0f;
        }
        return this.isFolder() ? -1.0f : (float)this.getUsage() / (float)l;
    }

    public MIcon getSmallIcon() {
        if (this.smallIcon != null) {
            return this.smallIcon;
        }
        if (this.isCustomIcon()) {
            this.smallIcon = Net.isLocal(this.iconName) ? MIcon.fromFileURI(this.iconName, MIcon.getSmallSize()) : MIcon.small(this.iconName);
        } else {
            String string = MIcon.getName(this.icon);
            if (string != null) {
                this.smallIcon = MIcon.small(string);
            }
        }
        if (MIcon.isEmpty(this.smallIcon)) {
            this.smallIcon = this.getIcon();
            if (this.smallIcon != null) {
                this.smallIcon = this.smallIcon.scaleSmall();
            }
        }
        return this.smallIcon;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String string) {
        this.tags = string;
        if (this.isFile() || this.isAnyFolder()) {
            Tags.addAll(string);
        }
    }

    public void setTags(Tags tags) {
        String string = tags.toString();
        this.setTags("".equals(string) ? null : string);
    }

    public String getToolTipText(int n) {
        Object object;
        Object object2;
        String string;
        Flags flags = new Flags(n);
        HTMLBuilder hTMLBuilder = new HTMLBuilder();
        hTMLBuilder.beginHTML();
        hTMLBuilder.beginDoc();
        hTMLBuilder.beginTag("table", "border", 0);
        if (flags.isClear(64L)) {
            MetaInfo.addInfo(hTMLBuilder, TK.centerSqueeze(this.toString(), 128), null);
        }
        if ((string = this.getExtension()) == null) {
            if (this.isDynamicFolder()) {
                string = UI._("Virtual Folder");
            }
        } else {
            object2 = EditorPlugin.findPluginForExtension(string);
            string = (object2 == null ? UI._("Unknown") : (String)((PluginInfo)object2).name.get()) + " (" + string + ")";
        }
        if (string != null) {
            MetaInfo.addInfo(hTMLBuilder, UI._("Type:"), string);
        }
        if (!TK.isEmpty(this.comment) && flags.isClear(8L)) {
            int n2 = this.comment.indexOf(10);
            object = n2 == -1 ? this.comment : this.comment.substring(0, n2) + "...";
            MetaInfo.addInfo(hTMLBuilder, UI._("Comment:"), TK.centerSqueeze((String)object, 128));
        }
        if (this.tags != null && flags.isClear(4L)) {
            MetaInfo.addInfo(hTMLBuilder, UI._("Tags:"), TagsUtils.getLocalizedTags(this.tags));
        }
        if (this.categories != null) {
            MetaInfo.addInfo(hTMLBuilder, UI._("Categories:"), this.categories);
        }
        if (flags.isClear(32L)) {
            if (this.createdTime != 0L) {
                MetaInfo.addInfo(hTMLBuilder, UI._("Created:"), MetaInfo.formatDate(this.createdTime));
            }
            if (this.isFile()) {
                MetaInfo.addInfo(hTMLBuilder, UI._("Modified:"), MetaInfo.formatDate(this.getFile().lastModified()));
            }
        }
        if (flags.isClear(16L)) {
            MetaInfo.addInfo(hTMLBuilder, UI._("Location:"), TK.centerSqueeze(this.getNicePath(), 128));
        }
        if ((object2 = this.getMount()) != null) {
            MetaInfo.addInfo(hTMLBuilder, UI._("Mounted External Directory:"), object2);
        }
        if (!this.isWriteable()) {
            MetaInfo.addWarning(hTMLBuilder, UI._("This item is not writeable (read only)"));
        } else if (this.isLocked() && flags.isClear(2L)) {
            MetaInfo.addWarning(hTMLBuilder, UI._("This item is locked (read only)"));
        }
        if (flags.isClear(32L)) {
            long l;
            boolean bl = false;
            if (this.isFile() && this.openTime != 0L) {
                MetaInfo.addSeparator(hTMLBuilder);
                bl = true;
                MetaInfo.addInfo(hTMLBuilder, UI._("Last Opened:"), MetaInfo.formatDate(this.openTime));
            }
            if ((l = this.getAge()) != -1L) {
                if (!bl) {
                    MetaInfo.addSeparator(hTMLBuilder);
                }
                MetaInfo.addInfo(hTMLBuilder, UI._("Age:"), UI._("{0} day(s)", l));
            }
        }
        if (this.isFile()) {
            MetaInfo.addInfo(hTMLBuilder, UI._("Size:"), MFormat.toAutoSize(this.getFile().length()));
        }
        if (((Boolean)Vars.treeShowMetaInfo.get()).booleanValue() && (object = (MProperties)this.getProperty(PREVIEW_PROPERTIES, null)) != null) {
            String string2;
            String string3 = ((Properties)object).getProperty("image-type-property", "");
            if (!TK.isEmpty(string3)) {
                MetaInfo.addSeparator(hTMLBuilder);
                MetaInfo.addInfo(hTMLBuilder, UI._("Dimensions:"), String.format("%s x %s", ((Properties)object).getProperty("image-width-property", "?"), ((Properties)object).getProperty("image-height-property", "?")));
                MetaInfo.addInfo(hTMLBuilder, UI._("Type:"), string3);
                MetaInfo.addInfo(hTMLBuilder, "bpp:", ((Properties)object).getProperty("image-width-bpp", "?"));
            }
            if ((string2 = ((Properties)object).getProperty("url-property", null)) != null) {
                MetaInfo.addSeparator(hTMLBuilder);
                MetaInfo.addInfo(hTMLBuilder, "URL:", TK.centerSqueeze(string2, 128));
            }
        }
        if (this.getFS() instanceof FSProperties) {
            ((FSProperties)FSProperties.class.cast(this.getFS())).updateInfo(this, hTMLBuilder);
        }
        hTMLBuilder.endTag("table");
        hTMLBuilder.endDoc();
        return hTMLBuilder.length() == 75 ? null : hTMLBuilder.toString();
    }

    @Deprecated
    public int getUsage() {
        return this.usage;
    }

    public boolean isCustomIcon() {
        return this.iconName != null;
    }

    public boolean isDummy() {
        return (this.attr & 0x40) != 0;
    }

    public boolean isDynamicFolder() {
        return (this.attr & 0x10) != 0;
    }

    public boolean isFile() {
        return (this.attr & 4) != 0;
    }

    public boolean isFolder() {
        return (this.attr & 2) != 0;
    }

    public boolean isFSRoot() {
        return (this.attr & 1) != 0;
    }

    @Override
    public boolean isLocked() {
        return (this.attr & 0x100) != 0;
    }

    @Override
    public void setLocked(boolean bl) {
        this.attr = bl ? (this.attr |= 0x100) : (this.attr &= 0xFFFFFEFF);
        this.lockedIconCache = null;
    }

    public boolean isOpen() {
        if (!this.isAnyFile()) {
            return false;
        }
        return (this.attr & 0x800) != 0;
    }

    public void setOpen(boolean bl) {
        this.attr = bl ? (this.attr |= 0x800) : (this.attr &= 0xFFFFF7FF);
    }

    public boolean isPermission(FSAction fSAction) {
        if (this.fs == null) {
            return false;
        }
        return this.fs.isPermission(this, fSAction);
    }

    public boolean isSortable() {
        return this.isFolder() || this.isFSRoot();
    }

    public SortMethod getSortMethod() {
        return this.config.readEnum("sortMethod", SortMethod.NAME);
    }

    @Deprecated
    public boolean isSupported() {
        return (this.attr & 8) == 0;
    }

    public boolean isVirtualFile() {
        return (this.attr & 0x20) != 0;
    }

    public boolean isWriteable() {
        return (this.attr & 0x200) != 0;
    }

    public void setWriteable(boolean bl) {
        this.attr = bl ? (this.attr |= 0x200) : (this.attr &= 0xFFFFFDFF);
    }

    public void setWriteable(File file) {
        this.setWriteable((Boolean)Vars.treeReadOnly.get() == false && file.canWrite());
    }

    public List<MetaInfo> list(MV mV) {
        return this.listChildren(MetaInfo.class, mV);
    }

    public void setCreatedTime(MDate mDate) {
        this.createdTime = mDate.getTime();
    }

    public void setExtraInfo(Object object) {
        if (object == null) {
            this.clearProperty(EXTRA_COLOR);
            this.clearProperty(EXTRA_TEXT);
        } else {
            this.setProperty(EXTRA_COLOR, Color.WHITE);
            this.setProperty(EXTRA_TEXT, object.toString());
        }
    }

    public void setLastOpenTime() {
        this.openTime = MDate.currentTime();
        ++this.usage;
    }

    @Override
    public void setupRenderer(MRenderer<?> mRenderer) {
        if (rendererIcon == null) {
            rendererIcon = new MetaInfoAction.Icon();
        }
        rendererIcon.update(this);
        mRenderer.setIcon(rendererIcon);
        mRenderer.setText(this.toString());
    }

    public void sync() {
        if (this.config == null) {
            return;
        }
        if (!this.isWriteable()) {
            return;
        }
        this.config.write("bookmark", (this.attr & 0x80) != 0);
        if (TK.isEmpty(this.categories)) {
            this.config.removeString("categories");
        } else {
            this.config.write("categories", this.categories);
        }
        this.config.write("color", this.color);
        this.config.write("comment", this.comment);
        this.config.writeDate("created", this.createdTime);
        if (this.isFile()) {
            this.config.write("encrypted", (this.attr & 0x400) != 0);
        }
        this.config.write("icon", this.iconName);
        this.config.write("id", this.id);
        this.config.writeDate("lastOpen", this.openTime);
        this.config.write("locked", (this.attr & 0x100) != 0);
        this.config.write("rating", this.rating);
        if (TK.isEmpty(this.tags)) {
            this.config.removeString("tags");
        } else {
            this.config.write("tags", this.tags);
        }
        this.config.write("usage", this.usage);
        this.config.write("version", 1);
        if (this.isFolder()) {
            this.config.write("mount", this.getMount());
        }
        this.config.sync();
    }

    private static String formatDate(long l) {
        if (l == 0L) {
            return null;
        }
        return new MDate(l).fancyFormat(1, true);
    }

    private String getPathWithoutExtension(String string) {
        if (this.isLink()) {
            return this.getLink().getPathWithoutExtension(string);
        }
        if (this.isFolder()) {
            return string;
        }
        return FS.getBaseName(string);
    }

    public String getIconName() {
        return this.iconName;
    }

    public void setIconName(String string) {
        this.clearProperty(OVERRIDE_ICON);
        this.iconName = string;
        this.icon = MetaInfo.getIcon(this.iconName);
        if (this.icon == null) {
            this.setIcon(null);
            return;
        }
        this.lockedIconCache = null;
        this.smallIcon = null;
    }

    public void refresh(boolean bl) {
        if (this.isDummy()) {
            return;
        }
        Tree tree = Tree.getInstance();
        ((MTreeModel)tree.getModel()).nodeChanged(this);
        if (bl) {
            tree.repaint(this.getTreePath());
        }
        for (AbstractFS abstractFS : tree.getFileSystems().values()) {
            if (abstractFS == this.getFS()) continue;
            abstractFS.refreshNotify(this, bl);
        }
    }

    public void reload() {
        Tree tree = Tree.getInstance();
        boolean bl = tree.isExpanded(this);
        ((DefaultTreeModel)tree.getModel()).reload(this);
        if (bl) {
            tree.setExpanded(this, true);
        }
    }

    public String toString() {
        if (this.isFSRoot()) {
            return this.fs.getName();
        }
        return TK.unescapeURL(this.name);
    }

    @Override
    public void requestDone(RequestInfo<DefaultPreview.Result> requestInfo, DefaultPreview.Result result) {
        Image image;
        Icon icon = result == null ? null : (Icon)result.getProperties().get("icon-property");
        Image image2 = image = result == null ? null : result.getImage();
        if (image == null) {
            this.clearProperty(PREVIEW_IMAGE);
            this.setProperty(NO_IMAGE_PREVIEW, true);
        } else {
            this.setProperty(PREVIEW_IMAGE, image);
            this.clearProperty(NO_IMAGE_PREVIEW);
        }
        if (result == null) {
            this.clearProperty(PREVIEW_PROPERTIES);
        } else {
            this.setProperty(PREVIEW_PROPERTIES, result.getProperties());
        }
        if (icon != null && this.iconName == null) {
            this.setIcon(new MIcon(UI.toBufferedImage(icon)).scaleUI());
        }
        this.refresh(false);
        Tracker.add(this, TrackerEvent.ID.ITEM_PREVIEW_CHANGED);
    }

    protected MetaInfo(AbstractFS abstractFS, String string, int n) {
        this.fs = abstractFS;
        this.attr = n | 0x200;
        this.setFilePath(string);
        this.loadFromFile();
        if (abstractFS == null) {
            this.setFSFromConfig();
        } else {
            this.setFS(abstractFS);
        }
    }

    private static MIcon getIcon(String string) {
        return string == null ? null : MIcon.fromFileURI(string, MIcon.getUISize());
    }

    private void initID() {
        this.id = this.config.read("id", null);
        if (this.id == null) {
            this.id = this.isWriteable() ? TK.createRandomUUID() : "";
        }
    }

    private void loadFromFile() {
        if (this.isLink()) {
            this.getLink().loadFromFile();
            return;
        }
        Object object = this.isDynamicFolder() ? this.path : (this.isVirtualFile() ? null : (this.isFile() ? this.path + ".properties" : (this.isFolder() || this.isFSRoot() ? FS.makePath(this.path, ".properties") : null)));
        Config config = object == null ? null : (this.config = new Config((String)object, this.isWriteable() || this.isMount() ? 0 : 1));
        if (this.config == null) {
            return;
        }
        if (this.config.read("bookmark", false)) {
            this.attr |= 0x80;
        }
        this.categories = this.config.read("categories", null);
        this.color = this.config.readColor("color", null);
        this.comment = this.config.read("comment", null);
        this.createdTime = this.config.readDate("created", 0L).getTime();
        if (this.createdTime == 0L) {
            this.createdTime = this.getFile().lastModified();
        }
        if (this.isFile() && this.config.read("encrypted", false)) {
            this.attr |= 0x400;
        }
        if (this.config.read("locked", false)) {
            this.attr |= 0x100;
        }
        String string = this.isDynamicFolder() ? "dynamicfolder" : (this.isFolder() ? "ui/folder" : null);
        this.iconName = this.config.read("icon", string);
        this.openTime = this.config.readDate("lastOpen", 0L).getTime();
        this.rating = this.config.readFloat("rating", 0.0f);
        this.setTags(this.config.read("tags", null));
        this.usage = this.config.readInt("usage", 0);
        if (this.isFolder()) {
            this.setMount(this.config.read("mount", null));
        }
    }

    MetaInfo() {
    }

    private static final class FolderMetaInfo
    extends MetaInfo {
        private String mount;

        @Override
        public String getMount() {
            return this.mount;
        }

        @Override
        public boolean isMount() {
            return this.mount != null;
        }

        @Override
        public void setMount(String string) {
            this.mount = string;
        }

        private FolderMetaInfo(AbstractFS abstractFS, String string, String string2) {
            super(abstractFS, string, 2);
            File file = this.getFile();
            this.setWriteable(file);
            if (string2 != null) {
                this.setMount(string2);
                this.sync();
            }
            if (this.isMount()) {
                try {
                    MountManager.validate(this.getMount());
                    MountManager.mount(this);
                    this.setWriteable(new File(this.getMount()).canWrite());
                }
                catch (FSException fSException) {
                    MLogger.error("vfs", fSException.getMessage());
                    this.setProperty(MetaInfo.OVERRIDE_ICON, "ui/error");
                    this.setProperty(MetaInfo.OVERRIDE_NAME, "%name [" + fSException.getMessage() + "]");
                }
            }
        }
    }

    public static class VirtualFileMetaInfo
    extends MetaInfo {
        public VirtualFileMetaInfo(AbstractFS abstractFS, String string) {
            super(abstractFS, string, 32);
            this.setAllowsChildren(false);
        }
    }
}

