/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors.text;

import java.awt.Color;
import java.util.Map;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.StyleSheet;
import org.makagiga.commons.ActionGroup;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MColorIcon;
import org.makagiga.commons.MColorPicker;
import org.makagiga.commons.MDataAction;
import org.makagiga.commons.MFontComboBox;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MSlider;
import org.makagiga.commons.MToggleButton;
import org.makagiga.commons.MTogglePanel;
import org.makagiga.commons.UI;
import org.makagiga.editors.Designer;
import org.makagiga.editors.Editor;
import org.makagiga.editors.text.TextEditorCore;
import org.makagiga.editors.text.TextEditorKit;

public final class TextEditorDesigner
extends Designer {
    private ActionGroup highlightActionGroup;
    private ActionGroup styleActionGroup;
    private MColorPicker fontColor;
    private MFontComboBox fontName;
    private MLabel fontSizeInfo;
    private MSlider fontSize;
    private static TextEditorDesigner _instance;

    public static synchronized void freeInstance() {
        _instance = null;
    }

    public ActionGroup getHighlightActionGroup() {
        return this.highlightActionGroup;
    }

    public static synchronized TextEditorDesigner getInstance() {
        if (_instance == null) {
            _instance = new TextEditorDesigner();
        }
        return _instance;
    }

    public ActionGroup getStyleActionGroup() {
        return this.styleActionGroup;
    }

    @Override
    public void setLocked(boolean bl) {
        super.setLocked(bl);
        this.highlightActionGroup.setEnabled(!bl);
        this.styleActionGroup.setEnabled(!bl);
        this.fontColor.setEnabled(!bl);
        this.fontName.setEnabled(!bl);
        this.fontSize.setEnabled(!bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(TextEditorCore textEditorCore) {
        MutableAttributeSet mutableAttributeSet = textEditorCore.getInputAttributes();
        try {
            this.fontName.setEventsEnabled(false);
            this.fontName.setSelectedItem(StyleConstants.getFontFamily(mutableAttributeSet));
        }
        finally {
            this.fontName.setEventsEnabled(true);
        }
        this.styleActionGroup.setSelected("bold", StyleConstants.isBold(mutableAttributeSet));
        this.styleActionGroup.setSelected("italic", StyleConstants.isItalic(mutableAttributeSet));
        this.styleActionGroup.setSelected("underline", StyleConstants.isUnderline(mutableAttributeSet));
        this.styleActionGroup.setSelected("strike-through", StyleConstants.isStrikeThrough(mutableAttributeSet));
        int n = StyleConstants.getFontSize(mutableAttributeSet);
        this.fontSize.setValue(n, true);
        this.fontSizeInfo.setNumber(StyleSheet.getIndexOfSize(n));
    }

    private TextEditorDesigner() {
        this.setDisplayText(UI._("Properties"));
        this.initFontProperties();
        this.initFontColor();
        this.initFontBackground();
    }

    private static TextEditorCore getCore() {
        return Editor.getCurrentCore(TextEditorCore.class);
    }

    private void initFontBackground() {
        this.highlightActionGroup = new ActionGroup();
        int n = 0;
        int[] nArray = new int[]{49, 50, 51, 52, 53, 54};
        for (Map.Entry<Color, String> entry : TextEditorKit.highlightColors.entrySet()) {
            HighlightAction highlightAction = new HighlightAction(entry.getKey(), entry.getValue(), nArray[n++]);
            this.highlightActionGroup.add(TextEditorKit.makeClassID(entry.getValue()), highlightAction);
        }
        this.highlightActionGroup.addSeparator();
        HighlightAction highlightAction = new HighlightAction(null, MActionInfo.CLEAR.getText(), 48);
        this.highlightActionGroup.add("no_highlight", highlightAction);
    }

    private void initFontColor() {
        this.fontColor = new MColorPicker(){

            @Override
            protected void onChange() {
                _instance.setCharacterColor(this.getColor());
            }
        };
        this.add(new MTogglePanel(UI._("Color"), this.fontColor, "font-color", true));
    }

    private void initFontProperties() {
        MPanel mPanel = MPanel.createGroupPanel(true);
        this.fontName = new MFontComboBox(){

            @Override
            protected void onSelect() {
                _instance.setCharacterFamily((String)TextEditorDesigner.this.fontName.getSelectedItem());
            }
        };
        this.fontName.setRequestFocusEnabled(false);
        this.fontSize = new MSlider(){

            @Override
            protected void onChange() {
                TextEditorDesigner.this.setCharacterSize(TextEditorDesigner.this.fontSize.getValue());
            }
        };
        this.fontSize.setRequestFocusEnabled(false);
        this.fontSize.setToolTipText(UI._("HTML font size"));
        this.fontSize.setMinimum(8);
        this.fontSize.setMaximum(32);
        this.fontSize.setValue(UI.getDefaultFontSize());
        this.fontSize.showSimpleLabels();
        this.fontSize.setEventsEnabled(true);
        this.fontSizeInfo = new MLabel();
        this.fontSizeInfo.setLabelFor(this.fontSize);
        this.fontSizeInfo.setToolTipText(this.fontSize.getToolTipText());
        this.styleActionGroup = new ActionGroup();
        CharacterAction characterAction = new CharacterAction(UI._("Bold"), "text/bold", StyleConstants.Bold, 66);
        this.styleActionGroup.addCheckBox("bold", characterAction);
        CharacterAction characterAction2 = new CharacterAction(UI._("Italic"), "text/italic", StyleConstants.Italic, 73);
        this.styleActionGroup.addCheckBox("italic", characterAction2);
        CharacterAction characterAction3 = new CharacterAction(UI._("Underline"), "text/underline", StyleConstants.Underline, 85);
        this.styleActionGroup.addCheckBox("underline", characterAction3);
        CharacterAction characterAction4 = new CharacterAction(UI._("Strike Through"), "text/strikethrough", StyleConstants.StrikeThrough);
        this.styleActionGroup.addCheckBox("strike-through", characterAction4);
        mPanel.getGroupLayout().beginRows().addComponent(this.fontName).beginColumns().addComponent(new StyleButton(characterAction)).addComponent(new StyleButton(characterAction2)).addComponent(new StyleButton(characterAction3)).addComponent(new StyleButton(characterAction4)).end().beginColumns().addComponent(this.fontSize).addGap().addComponent(this.fontSizeInfo).addGap().end().end();
        this.add(new MTogglePanel(UI._("Font"), mPanel, "font-properties", true));
    }

    private void setCharacterBackground(Color color) {
        TextEditorCore textEditorCore = TextEditorDesigner.getCore();
        if (textEditorCore != null) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            SimpleAttributeSet simpleAttributeSet2 = new SimpleAttributeSet();
            if (color == null) {
                simpleAttributeSet2.addAttribute(HTML.Attribute.CLASS, "no_highlight");
                simpleAttributeSet.removeAttribute(StyleConstants.Background);
            } else {
                String string = TextEditorKit.makeClassID(TextEditorKit.highlightColors.get(color));
                simpleAttributeSet2.addAttribute(HTML.Attribute.CLASS, string);
            }
            simpleAttributeSet.addAttribute(HTML.Tag.SPAN, simpleAttributeSet2);
            textEditorCore.setCharacterAttributes(simpleAttributeSet, false);
        }
    }

    private void setCharacterColor(Color color) {
        TextEditorCore textEditorCore = TextEditorDesigner.getCore();
        if (textEditorCore != null) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setForeground(simpleAttributeSet, color);
            textEditorCore.setCharacterAttributes(simpleAttributeSet, false);
        }
    }

    private void setCharacterFamily(String string) {
        if (string == null) {
            return;
        }
        TextEditorCore textEditorCore = TextEditorDesigner.getCore();
        if (textEditorCore != null) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setFontFamily(simpleAttributeSet, string);
            textEditorCore.setCharacterAttributes(simpleAttributeSet, false);
        }
    }

    private void setCharacterSize(int n) {
        TextEditorCore textEditorCore = TextEditorDesigner.getCore();
        if (textEditorCore != null) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setFontSize(simpleAttributeSet, n);
            textEditorCore.setCharacterAttributes(simpleAttributeSet, false);
            this.fontSizeInfo.setNumber(StyleSheet.getIndexOfSize(n));
        }
    }

    private void setCharactertStyle(Object object, boolean bl) {
        TextEditorCore textEditorCore = TextEditorDesigner.getCore();
        if (textEditorCore != null) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            simpleAttributeSet.addAttribute(object, bl);
            textEditorCore.setCharacterAttributes(simpleAttributeSet, false);
        }
    }

    private static final class StyleButton
    extends MToggleButton {
        private StyleButton(MAction mAction) {
            this.setAction(mAction);
            this.setRequestFocusEnabled(false);
            this.setToolTipText(this.getText());
            this.setText(null);
        }
    }

    private static final class HighlightAction
    extends MDataAction<Color> {
        @Override
        public void onAction() {
            TextEditorDesigner textEditorDesigner = _instance;
            textEditorDesigner.setCharacterBackground((Color)this.getData());
        }

        private HighlightAction(Color color, String string, int n) {
            super(color, string);
            this.setAcceleratorKey(n, 2);
            if (color != null) {
                int n2 = MIcon.getSmallSize();
                this.setSmallIcon(new MColorIcon(color, n2, n2, MColorIcon.Type.RECTANGLE));
            } else {
                this.setSmallIcon(MActionInfo.DELETE_NO_KEY_STROKE.getSmallIcon());
            }
            this.setToolTipText(UI._("Highlight: {0}", string));
        }
    }

    private static final class CharacterAction
    extends MDataAction<Object> {
        public CharacterAction(String string, String string2, Object object) {
            super(object, string, MIcon.small(string2));
        }

        public CharacterAction(String string, String string2, Object object, int n) {
            super(object, string, MIcon.small(string2));
            this.setAcceleratorKey(n, CharacterAction.getMenuMask());
        }

        @Override
        public void onAction() {
            TextEditorDesigner textEditorDesigner = _instance;
            textEditorDesigner.setCharactertStyle(this.getData(), this.isSelected());
        }
    }
}

