/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors.image.tools;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import org.makagiga.commons.UI;
import org.makagiga.editors.image.tools.Tool;

public class LineTool
extends Tool {
    private boolean drawing;
    private final Point end = new Point();
    private final Point start = new Point();

    public LineTool() {
        super(UI._("Line"), "line");
        this.setKeyStroke(76, 64);
        this.setUpdateOnMouseRelease(true);
    }

    @Override
    public void draw(Graphics2D graphics2D, int n, int n2) {
        if (this.drawing) {
            graphics2D.drawLine(this.start.x, this.start.y, this.end.x, this.end.y);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.end.setLocation(this.convertPoint(mouseEvent));
        this.core.repaint();
        this.drawing = true;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.start.setLocation(this.convertPoint(mouseEvent));
        this.core.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.drawing) {
            this.end.setLocation(this.convertPoint(mouseEvent));
            super.mouseReleased(mouseEvent);
            this.drawing = false;
        }
    }
}

