/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors;

import java.awt.Window;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import org.makagiga.Tabs;
import org.makagiga.commons.Config;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MPasswordField;
import org.makagiga.commons.MPasswordPanel;
import org.makagiga.commons.PassiveException;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.crypto.CryptoUtils;
import org.makagiga.commons.crypto.PBEInfo;
import org.makagiga.editors.Editor;
import org.makagiga.fs.MetaInfo;
import org.makagiga.tree.Tree;

public final class EditorCrypto {
    @Deprecated
    public static final String CIPHER_INFO_PROPERTY = "org.makagiga.editors.EditorCrypto.cipherInfo";

    static CipherInputStream createCipherInputStream(Window window, Editor<?> editor, MetaInfo metaInfo, Map<String, String> map, InputStream inputStream) throws Exception {
        if (editor.pbeInfo == null) {
            editor.pbeInfo = EditorCrypto.enterPassword(window, map, UI._("Enter password to open \"{0}\"", metaInfo));
        }
        return new CipherInputStream(inputStream, editor.pbeInfo.createCipher(2));
    }

    static Output createCipherOutputStream(Editor<?> editor, OutputStream outputStream) throws Exception {
        return new Output(outputStream, editor.pbeInfo.createCipher(1));
    }

    public static boolean setPasswordDialog(Window window, MetaInfo metaInfo) {
        Tabs tabs = Tabs.getInstance();
        int n = tabs.findEditor(metaInfo);
        if (n != -1) {
            tabs.closeEditorAt(n, 3);
        }
        Tree.getInstance().open(metaInfo);
        Editor<?> editor = tabs.getTabAt(metaInfo);
        if (editor == null) {
            MMessage.error(window, UI._("Could not set password"));
            return false;
        }
        try {
            PBEInfo pBEInfo = EditorCrypto.newPassword(window, metaInfo);
            if (pBEInfo != null) {
                editor.pbeInfo = pBEInfo;
                metaInfo.setEncrypted(true);
                try {
                    editor.saveToFile();
                    return true;
                }
                catch (Exception exception) {
                    editor.pbeInfo = null;
                    metaInfo.setEncrypted(false);
                    throw exception;
                }
            }
        }
        catch (Exception exception) {
            MMessage.error(window, exception);
        }
        return false;
    }

    private EditorCrypto() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PBEInfo enterPassword(Window window, Map<String, String> map, String string) throws Exception {
        char[] cArray = MMessage.enterPassword(window, string);
        if (cArray == null) {
            throw new PassiveException(UI._("Invalid password"));
        }
        MLogger.debug("pbe", "PROPERTIES:");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            MLogger.debug("pbe", "\t%s=\"%s\"", entry.getKey(), entry.getValue());
        }
        try {
            PBEInfo pBEInfo = new PBEInfo(cArray, map.get("TRANSFORMATION"), CryptoUtils.parseByteArray(map.get("SALT")));
            return pBEInfo;
        }
        finally {
            MPasswordField.clear(cArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PBEInfo newPassword(Window window, MetaInfo metaInfo) throws InvalidKeySpecException, NoSuchAlgorithmException {
        int n = 6;
        String string = "<b>" + TK.escapeXML(metaInfo.toString()) + "</b>";
        String string2 = UI.makeHTML(UI._("New password for {0}", string) + "<br>" + "<br>" + UI._("Note: Meta info (comment, tags, etc) will not be encrypted!"));
        MPasswordPanel.Info info = MMessage.newPassword(window, string2, n |= 0x20);
        if (info == null) {
            return null;
        }
        char[] cArray = info.getNewPassword();
        try {
            PBEInfo pBEInfo = new PBEInfo(cArray, "PBEWithSHA1AndDESede", CryptoUtils.createSalt(9));
            return pBEInfo;
        }
        finally {
            info.clear();
            MPasswordField.clear(cArray);
        }
    }

    @Deprecated
    public static CipherInputStream createCipherInputStream(MetaInfo metaInfo, InputStream inputStream) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static DigestOutputStream createDigestCipherOutputStream(MetaInfo metaInfo, OutputStream outputStream) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static void deletePrivateData() {
    }

    @Deprecated
    public static boolean isEncrypted(Config config) {
        return config.read("encrypted", false);
    }

    @Deprecated
    public static boolean isEncrypted(MetaInfo metaInfo) {
        return metaInfo.isEncrypted();
    }

    @Deprecated
    public static void setPassword(Window window, MetaInfo metaInfo) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static void updateConfig(MetaInfo metaInfo, DigestOutputStream digestOutputStream) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static void updateWarningLabel(MLabel mLabel, MetaInfo metaInfo) {
        if (metaInfo.isEncrypted()) {
            mLabel.setIcon(MIcon.small("ui/info"));
            mLabel.setHTML(TK.escapeXML(UI._("This feature is disabled for encrypted files")));
            mLabel.setVisible(true);
        } else {
            mLabel.setIcon(null);
            mLabel.setText(null);
            mLabel.setVisible(false);
        }
    }

    @Deprecated
    public static void validate(MetaInfo metaInfo) throws Exception {
        throw new UnsupportedOperationException();
    }

    private static final class Output
    extends CipherOutputStream {
        private boolean closed;

        @Override
        public synchronized void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                super.close();
            } else {
                try {
                    this.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.out.close();
            }
        }

        private Output(OutputStream outputStream, Cipher cipher) {
            super(outputStream, cipher);
        }
    }

    public static final class InfoLabel
    extends MLabel {
        public InfoLabel() {
            this.setIcon(MIcon.small("ui/info"));
            this.setHTML(TK.escapeXML(UI._("This feature is disabled for encrypted files")));
            this.setStyle("font-size: smaller");
            this.setVisible(false);
        }

        public void update(MetaInfo metaInfo) {
            this.setVisible(metaInfo.isEncrypted());
        }
    }
}

