/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.desktop.note;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JPasswordField;
import javax.swing.TransferHandler;
import javax.swing.text.JTextComponent;
import org.makagiga.commons.ClipboardException;
import org.makagiga.commons.FileSelection;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MClipboard;
import org.makagiga.commons.MDataTransfer;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMainWindow;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MStatusBar;
import org.makagiga.commons.MText;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.StringProperty;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.desktop.Desktop;
import org.makagiga.desktop.Widget;
import org.makagiga.desktop.WidgetPlugin;
import org.makagiga.desktop.note.NoteWidget;
import org.makagiga.plugins.PluginException;
import org.makagiga.plugins.PluginInfo;
import org.makagiga.plugins.PluginMenu;
import org.makagiga.plugins.PluginType;

public final class NoteWidgetPlugin
extends WidgetPlugin
implements PluginMenu {
    @Override
    public Widget create() {
        return new NoteWidget(this);
    }

    @Override
    @Deprecated
    public boolean canImport(Transferable transferable, TransferHandler.DropLocation dropLocation) {
        return false;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        if (!transferSupport.isDrop()) {
            return false;
        }
        for (DataFlavor dataFlavor : transferSupport.getDataFlavors()) {
            if (!FileSelection.isURIList(dataFlavor) && !dataFlavor.equals(DataFlavor.javaFileListFlavor)) continue;
            return false;
        }
        return transferSupport.isDataFlavorSupported(DataFlavor.stringFlavor);
    }

    @Override
    @Deprecated
    public boolean importData(Transferable transferable, TransferHandler.DropLocation dropLocation) {
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        try {
            String string = MDataTransfer.getString(transferSupport.getTransferable());
            if (string == null) {
                return false;
            }
            return NoteWidgetPlugin.createNote(transferSupport.getDropLocation().getDropPoint(), string, null) != null;
        }
        catch (IOException iOException) {
            MLogger.exception(iOException);
            return false;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            MLogger.exception(unsupportedFlavorException);
            return false;
        }
    }

    public static NoteWidget createNote(Point point, String string, String string2) {
        PluginInfo pluginInfo = PluginType.WIDGET.getByID("{ebbb4c5b-27b3-4232-b5df-cebf750dc185}");
        if (pluginInfo == null) {
            return null;
        }
        Widget widget = Desktop.getInstance().addWidget(pluginInfo.getID(), point);
        if (widget instanceof NoteWidget) {
            NoteWidget noteWidget = (NoteWidget)widget;
            noteWidget.setText(string);
            if (string2 != null) {
                noteWidget.setTitle(string2);
            }
            noteWidget.select();
            return noteWidget;
        }
        MMessage.error(null, UI._("Could not create widget"));
        return null;
    }

    @Override
    public void onPostInit() throws PluginException {
        super.onPostInit();
        MText.addGlobalMenu(new MText.GlobalMenu(){

            @Override
            public void onGlobalMenu(JTextComponent jTextComponent, MMenu mMenu) {
                if (jTextComponent instanceof JPasswordField) {
                    return;
                }
                final StringProperty stringProperty = new StringProperty(jTextComponent.getSelectedText());
                if (stringProperty.isNull()) {
                    stringProperty.set(MText.getPlainText(jTextComponent));
                }
                AddStickyNoteAction addStickyNoteAction = new AddStickyNoteAction(){

                    @Override
                    public void onAction() {
                        NoteWidgetPlugin.this.addStickyNote((String)stringProperty.get(), null);
                    }
                };
                addStickyNoteAction.setEnabled(!stringProperty.isEmpty() && !Desktop.getInstance().isLocked());
                mMenu.add(addStickyNoteAction);
            }
        });
    }

    @Override
    public void updateMenu(String string, MMenu mMenu) {
        if ("TRAY_MENU".equals(string) || "WIDGETS_MENU".equals(string)) {
            mMenu.add(new PasteAsStickyNoteAction());
        }
    }

    @Override
    public void updateToolBar(String string, MToolBar mToolBar) {
    }

    private void addStickyNote(String string, String string2) {
        NoteWidget noteWidget;
        if (TK.isEmpty(string2) && !TK.isEmpty(string)) {
            string2 = TK.rightSqueeze(string, 64);
        }
        if ((noteWidget = NoteWidgetPlugin.createNote(null, string, string2)) == null) {
            MStatusBar.error(UI._("Error"));
        } else {
            MStatusBar.info(UI._("OK"));
            MMainWindow mMainWindow = MApplication.getMainWindow();
            if (mMainWindow != null) {
                mMainWindow.restore();
                mMainWindow.setDesktopVisible(true);
            }
            noteWidget.select();
        }
    }

    private final class PasteAsStickyNoteAction
    extends MAction {
        @Override
        public void onAction() {
            try {
                String string = MClipboard.getString();
                NoteWidgetPlugin.this.addStickyNote(string, null);
                if (string == null) {
                    MStatusBar.error(UI._("Paste failed"));
                }
            }
            catch (ClipboardException clipboardException) {
                MMessage.error(this.getSourceWindow(), clipboardException);
            }
        }

        private PasteAsStickyNoteAction() {
            super(UI._("Paste Text as Sticky Note"), "ui/paste");
            this.setEnabled(!Desktop.getInstance().isLocked());
        }
    }

    private static class AddStickyNoteAction
    extends MAction {
        private AddStickyNoteAction() {
            super(UI._("Add Sticky Note"), "notepad");
        }
    }
}

