/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.desktop.note;

import edu.umd.cs.findbugs.annotation.SuppressWarnings;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.text.JTextComponent;
import org.makagiga.commons.Config;
import org.makagiga.commons.CoolHeader;
import org.makagiga.commons.Focusable;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MDocumentAdapter;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MText;
import org.makagiga.commons.MTextArea;
import org.makagiga.commons.MTimer;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.PassiveException;
import org.makagiga.commons.UI;
import org.makagiga.commons.fx.Blend;
import org.makagiga.commons.print.PrintDialog;
import org.makagiga.commons.print.TextPrintInfo;
import org.makagiga.desktop.Widget;
import org.makagiga.desktop.note.NoteBorder;
import org.makagiga.desktop.note.NoteWidgetPlugin;
import org.makagiga.form.Default;
import org.makagiga.form.Field;
import org.makagiga.form.Form;
import org.makagiga.form.FormPanel;
import org.makagiga.form.Info;
import org.makagiga.form.SimpleForm;

public final class NoteWidget
extends Widget
implements Focusable {
    private final MTextArea text;
    private MTimer syncTimer;
    private final NoteWidgetPlugin plugin;

    public NoteWidget(NoteWidgetPlugin noteWidgetPlugin) {
        super(noteWidgetPlugin.getIcon());
        this.setSettingsActionVisible(true);
        this.plugin = noteWidgetPlugin;
        Config config = Config.getDefault();
        int n = config.readInt(noteWidgetPlugin.getGlobalEntry("default.width"), 350, 250, Integer.MAX_VALUE);
        int n2 = config.readInt(noteWidgetPlugin.getGlobalEntry("default.height"), 256, 156, Integer.MAX_VALUE);
        this.setDefaultSize(n, n2);
        this.setToolBarEnabled(true);
        this.text = new MTextArea();
        this.text.setBorder(BorderFactory.createCompoundBorder(new NoteBorder(), UI.createEmptyBorder(this.getContentMargin())));
        this.text.setStyle("font-size: x-large; font-weight: bold");
        this.text.setWordWrap(true);
        MText.setupMargin(this.text);
        this.addCenter(this.text, 2);
    }

    @Override
    public void focus() {
        this.text.requestFocusInWindow();
    }

    public String getText() {
        return this.text.getText();
    }

    public void setText(String string) {
        this.text.setText(string);
        this.text.scrollToTop();
    }

    public JTextComponent getTextComponent() {
        return this.text;
    }

    @Override
    @Deprecated
    protected void onActivate() {
    }

    @Override
    protected final void onClose() {
    }

    @Override
    @Deprecated
    protected void onDeactivate() {
    }

    @Override
    @Deprecated
    protected void onMinimize() {
    }

    @Override
    protected void onRestoreSession() throws Exception {
        try {
            MText.load((JTextComponent)this.text, new File(this.getWorkingDirectory(), "data.txt"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.text.getDocument().addDocumentListener(new MDocumentAdapter<MTextArea>(){

            @Override
            protected void onChange(DocumentEvent documentEvent) {
                NoteWidget.this.syncLater();
            }
        });
        Config config = Config.getDefault();
        Color color = config.readColor(this.plugin.getGlobalEntry("default.color"), new Color(0xFFFFC0));
        Color color2 = config.readColor(this.plugin.getGlobalEntry("default.textColor"), Color.BLACK);
        Font font = config.readFont(Config.getPlatformKey(this.plugin.getGlobalEntry("default.font")), this.text.getFont());
        config = this.getConfig();
        this.setup(false, config.readColor("x.color", color), config.readColor("x.textColor", color2), config.readFont(Config.getPlatformKey("x.font"), font), config.read("x.title", UI._("Note")));
    }

    @Override
    protected void onSaveSession() throws Exception {
        this.saveData();
        this.saveConfig(false);
    }

    @Override
    protected void onSettings(Window window) {
        this.configure(window);
    }

    @Override
    protected void onShutDown() {
        super.onShutDown();
        if (this.syncTimer != null) {
            this.syncTimer.stop();
        }
    }

    @Override
    protected void updateToolBar(MToolBar mToolBar) {
        PrintAction printAction = new PrintAction();
        printAction.connect((JComponent)this, 1);
        mToolBar.add(printAction);
        mToolBar.add(new MApplication.SettingsAction(){

            @Override
            public void onAction() {
                NoteWidget.this.configure(this.getSourceWindow());
            }
        }, 1);
        mToolBar.readConfig("note-widget");
    }

    private void configure(Window window) {
        SettingsForm settingsForm = new SettingsForm();
        settingsForm.name = this.getTitle();
        settingsForm.backgroundColor = this.text.getBackground();
        settingsForm.textColor = this.text.getForeground();
        settingsForm.font = this.text.getFont();
        FormPanel<SettingsForm> formPanel = new FormPanel<SettingsForm>(settingsForm){

            @Override
            protected boolean onAccept() {
                SettingsForm settingsForm = (SettingsForm)this.getForm();
                NoteWidget.this.setup(true, settingsForm.backgroundColor, settingsForm.textColor, settingsForm.font, settingsForm.name);
                NoteWidget.this.saveConfig(true);
                return true;
            }

            @Override
            protected void onUserClick() {
                Config config = Config.getDefault();
                SettingsForm settingsForm = (SettingsForm)this.getForm();
                config.write(NoteWidget.this.plugin.getGlobalEntry("default.color"), settingsForm.backgroundColor);
                config.write(NoteWidget.this.plugin.getGlobalEntry("default.textColor"), settingsForm.textColor);
                config.write(Config.getPlatformKey(NoteWidget.this.plugin.getGlobalEntry("default.font")), settingsForm.font);
                Rectangle rectangle = NoteWidget.this.getBounds();
                config.write(NoteWidget.this.plugin.getGlobalEntry("default.width"), rectangle.width);
                config.write(NoteWidget.this.plugin.getGlobalEntry("default.height"), rectangle.height);
                config.sync();
            }
        };
        formPanel.setLabel("name", UI._("Name:"));
        formPanel.setLabel("backgroundColor", UI._("Background"));
        formPanel.setLabel("textColor", UI._("Text"));
        settingsForm.previewField = (CoolHeader)formPanel.getComponent("preview");
        settingsForm.updatePreview();
        MDialog mDialog = formPanel.createSettingsDialog(window, 1039);
        mDialog.changeButton((AbstractButton)mDialog.getUserButton(), MActionInfo.SAVE_AS_DEFAULT);
        mDialog.packFixed();
        mDialog.exec();
    }

    private void saveConfig(boolean bl) {
        Config config = this.getConfig();
        config.write("x.color", this.text.getBackground());
        config.write("x.textColor", this.text.getForeground());
        config.write(Config.getPlatformKey("x.font"), this.text.getFont());
        config.write("x.title", this.getTitle());
        if (bl) {
            config.sync();
        }
    }

    private void saveData() throws IOException {
        if (this.syncTimer != null) {
            this.syncTimer.stop();
        }
        if (this.text.isModified()) {
            MText.save((JTextComponent)this.text, new File(this.getWorkingDirectory(), "data.txt"));
            this.text.setModified(false, null);
        }
    }

    private void setup(boolean bl, Color color, Color color2, Font font, String string) {
        if (bl) {
            Blend.animateBackground(this.text, null, color);
        } else {
            this.text.setBackground(color);
        }
        this.text.setForeground(color2);
        this.text.setCaretColor(color2);
        this.text.setFont(font);
        this.setTitle(string);
    }

    private void syncLater() {
        if (this.syncTimer == null) {
            this.syncTimer = new MTimer(MTimer.Format.SECONDS, 5){

                @Override
                protected boolean onTimeout() {
                    this.stop();
                    try {
                        NoteWidget.this.saveData();
                    }
                    catch (IOException iOException) {
                        MMessage.error(NoteWidget.this.getWindowAncestor(), new PassiveException(iOException), NoteWidget.this.getTitle());
                    }
                    return false;
                }
            };
        }
        this.syncTimer.restart();
    }

    @Form
    @SuppressWarnings(value="UUF_UNUSED_FIELD")
    public static final class SettingsForm
    extends SimpleForm {
        @Default
        @Field(autoCompletion="newfile")
        private String name;
        @Info(type=5)
        private final String colors = UI._("Colors");
        @Field
        private Color backgroundColor;
        @Field
        private Color textColor;
        @Info(type=5)
        private final String view = UI._("View");
        @Field
        private Font font;
        @Info(type=3)
        private final String preview = UI._("Preview");
        private CoolHeader previewField;

        public void setBackgroundColor(Color color) {
            this.backgroundColor = color;
            this.updatePreview();
        }

        public void setFont(Font font) {
            this.font = font;
            this.updatePreview();
        }

        public void setTextColor(Color color) {
            this.textColor = color;
            this.updatePreview();
        }

        private void updatePreview() {
            this.previewField.setColor(this.backgroundColor, this.textColor, true);
            this.previewField.setFont(this.font);
        }
    }

    private final class PrintAction
    extends MApplication.PrintAction {
        @Override
        public void onAction() {
            String string = NoteWidget.this.getTitle();
            String string2 = TextPrintInfo.getCurrentDateTime();
            PrintDialog printDialog = new PrintDialog(this.getSourceWindow(), new TextPrintInfo(string, NoteWidget.this.text, string, string2));
            printDialog.exec();
        }

        private PrintAction() {
        }
    }
}

