/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.desktop.calendar;

import org.makagiga.commons.Config;
import org.makagiga.commons.MDate;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMenuAdapter;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MSmallButton;
import org.makagiga.commons.MTextField;
import org.makagiga.commons.UI;
import org.makagiga.desktop.Widget;
import org.makagiga.desktop.WidgetPlugin;
import org.makagiga.desktop.calendar.CalendarComponent;
import org.makagiga.desktop.calendar.CalendarWidget;
import org.makagiga.editors.todo.TodoEditorPlugin;
import org.makagiga.form.PropertyPanel;
import org.makagiga.fs.FSException;
import org.makagiga.fs.MetaInfo;
import org.makagiga.fs.MetaInfoAction;
import org.makagiga.fs.tree.TreeFS;
import org.makagiga.plugins.PluginOptions;
import org.makagiga.search.Hit;
import org.makagiga.search.Query;
import org.makagiga.search.SortMethod;

public final class CalendarWidgetPlugin
extends WidgetPlugin
implements PluginOptions<OptionsPanel> {
    @Override
    public Widget create() {
        return new CalendarWidget(this);
    }

    @Override
    public OptionsPanel createPluginConfigPanel() {
        return new OptionsPanel();
    }

    @Override
    @Deprecated
    public boolean isVisibleInOptionsDialog() {
        return false;
    }

    @Override
    public void loadPluginConfig(OptionsPanel optionsPanel) {
        optionsPanel.information.setText(this.getValue("onThisDay"));
        optionsPanel.news.setText(this.getValue("news"));
    }

    @Override
    public void savePluginConfig(OptionsPanel optionsPanel) {
        this.setValue("onThisDay", optionsPanel.information.getText());
        this.setValue("news", optionsPanel.news.getText());
    }

    @Deprecated
    protected String getValue(String string) {
        String string2 = null;
        if (string2 == null) {
            string2 = this.getDefaultValue(string);
        }
        return string2;
    }

    @Deprecated
    protected void setValue(String string, String string2) {
        Config.getDefault().write(this.getGlobalEntry(string), string2);
    }

    private String getDefaultValue(String string) {
        return this.getConfig().read("x." + string, null);
    }

    MMenu createTaskMenu(final CalendarComponent calendarComponent) {
        MMenu mMenu = new MMenu(UI._("Add a New Task for This Day"), "ui/newfile");
        mMenu.addMenuListener(new MMenuAdapter(true){

            @Override
            protected void onSelect(MMenu mMenu) {
                Query query = new Query(SortMethod.PATH);
                query.add("type", "mgtodo");
                Query.Hits hits = query.start();
                mMenu.removeAll();
                mMenu.setSplitMenu(true);
                mMenu.addTitle(UI._("Todo Lists"));
                MDate mDate = (MDate)calendarComponent.getSelectedDate();
                for (Hit hit : hits) {
                    if (!((MetaInfo)hit.get()).canModify()) continue;
                    mMenu.add(new AddTaskAction((MetaInfo)hit.get(), mDate));
                }
                mMenu.addSeparator(false);
                MetaInfo metaInfo = MetaInfo.createDummy(UI._("New File"), MIcon.small("ui/newfile"));
                mMenu.add(new AddTaskAction(metaInfo, mDate));
            }
        });
        return mMenu;
    }

    private static final class AddTaskAction
    extends MetaInfoAction {
        private final MDate date;

        @Override
        public void onAction() {
            MetaInfo metaInfo = (MetaInfo)this.getData();
            if (metaInfo.isDummy()) {
                TreeFS treeFS = TreeFS.getInstance();
                try {
                    metaInfo = treeFS.createUniqueFile(treeFS.getRoot(), UI._("New File"), "mgtodo");
                }
                catch (FSException fSException) {
                    MMessage.error(this.getSourceWindow(), fSException);
                }
            }
            TodoEditorPlugin.newTask(metaInfo, this.date);
        }

        private AddTaskAction(MetaInfo metaInfo, MDate mDate) {
            super(metaInfo, true);
            this.date = mDate;
        }
    }

    public final class OptionsPanel
    extends PropertyPanel {
        private final MTextField information;
        private final MTextField news;

        @Override
        public void restoreDefaultValues() {
            this.information.setText(CalendarWidgetPlugin.this.getDefaultValue("onThisDay"));
            this.news.setText(CalendarWidgetPlugin.this.getDefaultValue("news"));
        }

        private OptionsPanel() {
            this.add(MLabel.createSmall("Button Actions", MIcon.small("ui/info")));
            this.addContentGap();
            this.information = new MTextField();
            this.information.setAutoCompletion("linkurl");
            this.add(MLabel.createFor(this.information, "Show Information for This Day"));
            this.addGap();
            this.add(this.information);
            this.addContentGap();
            this.news = new MTextField();
            this.news.setAutoCompletion("linkurl");
            this.add(MLabel.createFor(this.news, "News"));
            this.addGap();
            this.add(this.news);
            this.addContentGap();
            this.addGap();
            this.add(new MSmallButton(this.createDefaultsAction(), false));
        }
    }
}

