/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.desktop;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.InputEvent;
import java.beans.PropertyVetoException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.makagiga.commons.Config;
import org.makagiga.commons.Focusable;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MDesktopPane;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MInternalFrame;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.desktop.Pager;
import org.makagiga.desktop.Widget;
import org.makagiga.desktop.WidgetPeer;
import org.makagiga.desktop.ui.WidgetDesktopIconUI;
import org.makagiga.desktop.ui.WidgetInternalFrameUI;
import org.makagiga.plugins.PluginInfo;

public class WidgetInternalFrame
extends MInternalFrame
implements WidgetPeer {
    private boolean settingsActionVisible;
    private Widget widget;

    @Override
    public Icon getIcon() {
        return this.getFrameIcon();
    }

    public Widget getWidget() {
        return this.widget;
    }

    @Override
    public void setIcon(Icon icon) {
        if (icon instanceof ImageIcon && icon.getIconHeight() != 16) {
            Image image = ((ImageIcon)ImageIcon.class.cast(icon)).getImage();
            MIcon mIcon = new MIcon(UI.scaleImage(image, 16, 16, UI.Quality.HIGH));
            super.setIcon(mIcon);
        } else {
            super.setIcon(icon);
        }
    }

    @Override
    public void updateUI() {
        this.setUI(new WidgetInternalFrameUI(this));
        this.invalidateUI(new WidgetDesktopIconUI());
    }

    @Override
    public boolean isSettingsActionVisible() {
        return this.settingsActionVisible;
    }

    @Override
    public void setSettingsActionVisible(boolean bl) {
        this.settingsActionVisible = bl;
    }

    @Override
    public void restoreSession(Config config) {
        boolean bl = config.read("Widget.icon", false);
        try {
            this.setIcon(bl);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        if (bl && this.desktopIcon != null) {
            int n = config.readInt("Widget.iconX", -1);
            int n2 = config.readInt("Widget.iconY", -1);
            if (n != -1 && n2 != -1) {
                this.desktopIcon.setLocation(n, n2);
            }
        }
    }

    @Override
    public void saveSession(Config config) {
        boolean bl = this.isIcon();
        config.write("Widget.icon", bl);
        if (bl && this.desktopIcon != null) {
            config.write("Widget.iconX", this.desktopIcon.getX());
            config.write("Widget.iconY", this.desktopIcon.getY());
        }
    }

    @Override
    protected boolean canClose() {
        return !this.widget.getConfirmClose() || MMessage.confirmDelete(this.widget.getWindowAncestor(), UI._("Are you sure you want to delete this widget?"), TK.centerSqueeze(this.getTitle()));
    }

    @Override
    protected void onActivate() {
        if (this.widget != null) {
            this.widget.onActivate();
            this.widget.initToolBar();
            if (this.widget instanceof Focusable) {
                ((Focusable)Focusable.class.cast(this.widget)).focus();
            }
        }
    }

    @Override
    protected void onClose() {
        if (this.widget != null) {
            this.widget.onClose();
        }
    }

    @Override
    protected MMenu onContextMenu(InputEvent inputEvent) {
        MMenu mMenu = new MMenu();
        this.addTitle(mMenu);
        Pager pager = Pager.getInstance();
        mMenu.add(pager.createMoveToDesktopMenu(this));
        mMenu.addSeparator();
        MAction mAction = new MAction(MActionInfo.ABOUT){

            @Override
            public void onAction() {
                PluginInfo pluginInfo = WidgetInternalFrame.this.widget.getPluginInfo();
                if (pluginInfo != null) {
                    pluginInfo.about(this.getSourceWindow());
                }
            }
        };
        mAction.setEnabled(this.widget.getPluginInfo() != null);
        mMenu.add(mAction);
        boolean bl = MDesktopPane.isLocked(this);
        MApplication.SettingsAction settingsAction = new MApplication.SettingsAction(){

            @Override
            public void onAction() {
                WidgetInternalFrame.this.widget.onSettings(this.getSourceWindow());
            }
        };
        settingsAction.setEnabled(!bl && this.settingsActionVisible && !this.widget.onUpdateSettingsMenu(mMenu));
        mMenu.add(settingsAction);
        mMenu.addSeparator();
        mMenu.add(this.createCloseAction());
        return mMenu;
    }

    @Override
    protected void onDeactivate() {
        if (this.widget != null) {
            this.widget.onDeactivate();
            this.widget.hideToolBar();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void onDispose() {
        if (this.widget != null) {
            try {
                this.widget.onShutDown();
            }
            finally {
                this.widget.delete();
                this.widget.setWidgetPeer(null);
                this.widget = null;
            }
        }
    }

    @Override
    protected void onMinimize() {
        if (this.widget != null) {
            this.widget.onMinimize();
            this.widget.hideToolBar();
        }
    }

    @Override
    protected boolean shouldPaintBorder() {
        if (this.widget != null) {
            if (!this.widget.isShaped()) {
                return true;
            }
            if (this.widget.isDropShadowSupported()) {
                return !UI.isGTK() && !UI.isWindows();
            }
        }
        return super.shouldPaintBorder();
    }

    WidgetInternalFrame(Widget widget, String string, Icon icon) {
        super(string);
        this.widget = widget;
        this.setIcon(icon);
        this.setMaximumSize(new Dimension(640, 480));
        this.addCenter(widget);
    }

    void updateVirtualDesktop() {
        int n = this.widget.getDesktopNumber();
        Pager pager = Pager.getInstance();
        if (n < 0 || n > pager.getNumber() - 1) {
            this.widget.setDesktopNumber(0);
            n = 0;
        }
        this.setVisible(n == pager.getCurrent());
    }
}

