/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.db;

import java.awt.Image;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.imageio.ImageIO;
import org.makagiga.commons.AbstractListTableModel;
import org.makagiga.commons.FS;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.TK;
import org.makagiga.db.DBException;
import org.makagiga.db.DBManager;
import org.makagiga.db.DBRecord;
import org.makagiga.db.DBRecordDialog;
import org.makagiga.db.DBView;

public class DBTableModel
extends AbstractListTableModel<DBRecord> {
    private boolean needUpdateColumns = true;
    private final Connection connection;
    private final int idIndex;
    private static MLogger log = MLogger.get("db");
    private final String tableName;
    private String[] columnID;

    public DBTableModel(Connection connection, String string, int n) {
        super(0);
        this.connection = connection;
        this.tableName = TK.validateID(string);
        this.idIndex = n;
    }

    public void delete(DBRecord dBRecord, int n) throws DBException {
        PreparedStatement preparedStatement = null;
        try {
            String string = "DELETE FROM " + this.tableName + " WHERE ID=?";
            log.debugFormat("delete(\"%s\"): %s", dBRecord, string);
            preparedStatement = this.connection.prepareStatement(string);
            preparedStatement.setObject(1, dBRecord.getId());
            preparedStatement.executeUpdate();
            this.removeRow(n);
        }
        catch (SQLException sQLException) {
            try {
                throw new DBException(sQLException);
            }
            catch (Throwable throwable) {
                DBManager.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        DBManager.closeStatement(preparedStatement);
    }

    public String getColumnID(int n) {
        return this.columnID[n];
    }

    public Connection getConnection() {
        return this.connection;
    }

    public int getIdIndex() {
        return this.idIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Image getImage(DBRecord dBRecord, int n) throws DBException {
        Blob blob;
        PreparedStatement preparedStatement;
        block11: {
            ResultSet resultSet;
            block10: {
                preparedStatement = null;
                preparedStatement = this.connection.prepareStatement("SELECT " + this.getColumnID(n) + " FROM " + this.tableName + " WHERE ID=?");
                preparedStatement.setObject(1, dBRecord.getId());
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) break block10;
                Image image = null;
                DBManager.closeStatement(preparedStatement);
                return image;
            }
            blob = resultSet.getBlob(1);
            if (blob != null) break block11;
            Image image = null;
            DBManager.closeStatement(preparedStatement);
            return image;
        }
        InputStream inputStream = null;
        inputStream = blob.getBinaryStream();
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        FS.close(inputStream);
        DBManager.closeStatement(preparedStatement);
        return bufferedImage;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        FS.close(inputStream);
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        throw new DBException(iOException);
                    }
                    catch (SQLException sQLException) {
                        throw new DBException(sQLException);
                    }
                }
                catch (Throwable throwable2) {
                    DBManager.closeStatement(preparedStatement);
                    throw throwable2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String getLargeText(DBRecord dBRecord, int n) throws DBException {
        Clob clob;
        PreparedStatement preparedStatement;
        block11: {
            ResultSet resultSet;
            block10: {
                preparedStatement = null;
                preparedStatement = this.connection.prepareStatement("SELECT " + this.getColumnID(n) + " FROM " + this.tableName + " WHERE ID=?");
                preparedStatement.setObject(1, dBRecord.getId());
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) break block10;
                String string = null;
                DBManager.closeStatement(preparedStatement);
                return string;
            }
            clob = resultSet.getClob(1);
            if (clob != null) break block11;
            String string = null;
            DBManager.closeStatement(preparedStatement);
            return string;
        }
        Reader reader = null;
        reader = clob.getCharacterStream();
        StringWriter stringWriter = new StringWriter((int)clob.length());
        FS.copyChars(reader, stringWriter);
        String string = stringWriter.toString();
        FS.close(reader);
        DBManager.closeStatement(preparedStatement);
        return string;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        FS.close(reader);
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        throw new DBException(iOException);
                    }
                    catch (SQLException sQLException) {
                        throw new DBException(sQLException);
                    }
                }
                catch (Throwable throwable2) {
                    DBManager.closeStatement(preparedStatement);
                    throw throwable2;
                }
            }
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        DBRecord dBRecord = (DBRecord)this.getRowAt(n);
        return dBRecord.getObject(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void setValueAt(Object var1_1, int var2_2, int var3_3) {
        block11: {
            var4_4 = (DBRecord)this.getRowAt(var2_2);
            var4_4.setObject(var3_3, var1_1);
            var5_5 = null;
            try {
                var6_6 = "UPDATE " + this.tableName + " SET " + this.columnID[var3_3] + " = ? WHERE ID = ?";
                DBTableModel.log.debugFormat("setValueAt(\"%s\", %s, %s): %s", new Object[]{var1_1, var2_2, var3_3, var6_6});
                var5_5 = this.connection.prepareStatement(var6_6);
                var5_5.setObject(1, var1_1);
                var5_5.setObject(2, var4_4.getId());
                var5_5.executeUpdate();
                ** try [egrp 1[TRYBLOCK] [0 : 141->149)] { 
            }
            catch (SQLException var6_8) {
                MMessage.error(null, var6_8);
                break block11;
            }
            finally {
                try {
                    DBManager.closeStatement(var5_5);
                }
                catch (DBException var6_9) {
                    MMessage.error(null, var6_9);
                }
            }
lbl-1000:
            // 1 sources

            {
                DBManager.closeStatement(var5_5);
            }
lbl15:
            // 1 sources

            catch (DBException var6_7) {
                MMessage.error(null, var6_7);
            }
            {
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insert(DBRecord dBRecord) throws DBException {
        CloseableList closeableList = new CloseableList();
        PreparedStatement preparedStatement = null;
        try {
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            for (n = 0; n < dBRecord.getColumnCount(); ++n) {
                if (n == this.getIdIndex()) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.columnID[n]);
                if (stringBuilder2.length() > 0) {
                    stringBuilder2.append(", ");
                }
                stringBuilder2.append("?");
            }
            n = 0;
            String string = "INSERT INTO " + this.tableName + "(" + stringBuilder + ") VALUES(" + stringBuilder2 + ")";
            log.debugFormat("insert(\"%s\"): %s", dBRecord, string);
            preparedStatement = this.connection.prepareStatement(string);
            for (int i = 0; i < dBRecord.getColumnCount(); ++i) {
                if (i == this.getIdIndex()) continue;
                Object object = dBRecord.getObject(i);
                this.setupStatement(preparedStatement, object, ++n, closeableList);
            }
            preparedStatement.executeUpdate();
            this.addRow(dBRecord);
            this.selectAll();
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                throw new DBException(fileNotFoundException);
                catch (SQLException sQLException) {
                    throw new DBException(sQLException);
                }
            }
            catch (Throwable throwable) {
                DBManager.closeStatement(preparedStatement);
                closeableList.closeAll();
                throw throwable;
            }
        }
        DBManager.closeStatement(preparedStatement);
        closeableList.closeAll();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(DBRecord dBRecord, int n) throws DBException {
        CloseableList closeableList = new CloseableList();
        PreparedStatement preparedStatement = null;
        try {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < dBRecord.getColumnCount(); ++i) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.columnID[i]).append(" = ?");
            }
            String string = "UPDATE " + this.tableName + " SET " + stringBuilder + " WHERE ID = ?";
            log.debugFormat("insert(\"%s\"): %s", dBRecord, string);
            preparedStatement = this.connection.prepareStatement(string);
            DBRecord dBRecord2 = (DBRecord)this.getRowAt(n);
            int n2 = 0;
            Object object = dBRecord2.getId();
            for (int i = 0; i < dBRecord.getColumnCount(); ++i) {
                Object object2 = dBRecord.getObject(i);
                dBRecord2.setObject(i, object2);
                this.setupStatement(preparedStatement, object2, ++n2, closeableList);
            }
            preparedStatement.setObject(++n2, object);
            preparedStatement.executeUpdate();
            this.fireTableRowsUpdated(n, n + 1);
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                throw new DBException(fileNotFoundException);
                catch (SQLException sQLException) {
                    throw new DBException(sQLException);
                }
            }
            catch (Throwable throwable) {
                DBManager.closeStatement(preparedStatement);
                closeableList.closeAll();
                throw throwable;
            }
        }
        DBManager.closeStatement(preparedStatement);
        closeableList.closeAll();
    }

    public void update(String string) throws DBException {
        Statement statement = null;
        try {
            log.debugFormat("update(\"%s\")", string);
            statement = this.connection.createStatement();
            statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            try {
                throw new DBException(sQLException);
            }
            catch (Throwable throwable) {
                DBManager.closeStatement(statement);
                throw throwable;
            }
        }
        DBManager.closeStatement(statement);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void select(String string) throws DBException {
        this.setEventsEnabled(false);
        Statement statement = null;
        try {
            int n;
            Object object;
            log.debugFormat("select(\"%s\")", string);
            statement = this.connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            if (this.needUpdateColumns) {
                object = resultSet.getMetaData();
                n = object.getColumnCount();
                this.needUpdateColumns = false;
                AbstractListTableModel.ColumnInfo[] columnInfoArray = new AbstractListTableModel.ColumnInfo[n];
                this.columnID = new String[n];
                for (int i = 0; i < n; ++i) {
                    String string2;
                    String string3 = object.getColumnLabel(i + 1);
                    this.columnID[i] = string2 = object.getColumnName(i + 1);
                    String string4 = string3.equals(string2) ? DBView.getColumnDisplayName(string2) : string3;
                    columnInfoArray[i] = new AbstractListTableModel.ColumnInfo(string4, Class.forName(object.getColumnClassName(i + 1)), object.isWritable(i + 1) && !object.isReadOnly(i + 1), string2);
                }
                this.setColumnInfo(columnInfoArray);
                this.fireTableStructureChanged();
            } else {
                n = this.getColumnCount();
            }
            this.clear();
            while (resultSet.next()) {
                object = new DBRecord(n, this.idIndex, resultSet);
                this.addRow(object);
            }
            this.fireTableDataChanged();
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                throw new DBException(classNotFoundException);
                catch (SQLException sQLException) {
                    throw new DBException(sQLException);
                }
            }
            catch (Throwable throwable) {
                this.setEventsEnabled(true);
                DBManager.closeStatement(statement);
                throw throwable;
            }
        }
        this.setEventsEnabled(true);
        DBManager.closeStatement(statement);
    }

    public void selectAll() throws DBException {
        this.select("SELECT * FROM " + this.tableName);
    }

    private void setupStatement(PreparedStatement preparedStatement, Object object, int n, CloseableList closeableList) throws FileNotFoundException, SQLException {
        if (object instanceof File) {
            FS.BufferedFileInput bufferedFileInput = new FS.BufferedFileInput((File)object);
            closeableList.add(bufferedFileInput);
            preparedStatement.setBinaryStream(n, bufferedFileInput);
        } else if (object instanceof DBRecord.LargeText) {
            StringReader stringReader = new StringReader(object.toString());
            closeableList.add(stringReader);
            preparedStatement.setCharacterStream(n, stringReader);
        } else {
            preparedStatement.setObject(n, object);
        }
    }

    @Deprecated
    protected void close(Statement statement) throws DBException {
        DBManager.closeStatement(statement);
    }

    boolean addRecordUI(Window window) {
        DBRecordDialog<DBTableModel> dBRecordDialog = new DBRecordDialog<DBTableModel>(window, DBRecordDialog.Mode.ADD, this, null);
        if (dBRecordDialog.exec()) {
            try {
                this.insert(dBRecordDialog.updatedRecord());
                return true;
            }
            catch (DBException dBException) {
                this.handleErrorUI(window, dBException);
            }
        }
        return false;
    }

    boolean deleteRecordUI(Window window, DBRecord dBRecord) {
        if (MMessage.confirmDelete(window, MMessage.getSimpleConfirmMessage(), dBRecord)) {
            try {
                this.delete(dBRecord, dBRecord.modelIndex);
                return true;
            }
            catch (DBException dBException) {
                this.handleErrorUI(window, dBException);
            }
        }
        return false;
    }

    boolean editRecordUI(Window window, DBRecord dBRecord) {
        DBRecordDialog<DBTableModel> dBRecordDialog = new DBRecordDialog<DBTableModel>(window, DBRecordDialog.Mode.EDIT, this, dBRecord);
        if (dBRecordDialog.exec()) {
            try {
                this.update(dBRecordDialog.updatedRecord(), dBRecord.modelIndex);
                return true;
            }
            catch (DBException dBException) {
                this.handleErrorUI(window, dBException);
            }
        }
        return false;
    }

    void handleErrorUI(Window window, DBException dBException) {
        MMessage.error(window, dBException);
    }

    private static final class CloseableList
    extends MArrayList<Closeable> {
        private CloseableList() {
        }

        private void closeAll() {
            for (Closeable closeable : this) {
                FS.close(closeable);
            }
        }
    }

    public static final class DataList
    extends MArrayList<DataInfo> {
        public DataInfo add(String string, String string2) {
            return this.add(string, string2, null);
        }

        public DataInfo add(String string, String string2, Class<?> clazz) {
            DataInfo dataInfo = new DataInfo(string, string2, clazz);
            this.add(dataInfo);
            return dataInfo;
        }

        public DataInfo addId() {
            return this.add("id", "INTEGER IDENTITY NOT NULL", null);
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "()";
            }
            return "(" + this.toString(", ") + ")";
        }
    }

    public static final class DataInfo {
        private final Class<?> viewAs;
        private final String columnName;
        private final String type;

        public DataInfo(String string, String string2, Class<?> clazz) {
            this.columnName = TK.validateID(string);
            this.type = TK.checkNullOrEmpty(string2);
            this.viewAs = clazz;
        }

        public String toString() {
            return this.columnName + " " + this.type;
        }
    }
}

