/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.db;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.makagiga.commons.TK;
import org.makagiga.db.DBException;
import org.makagiga.db.DBTableModel;

public class DBRecord {
    private int idIndex;
    private Object[] data;
    int modelIndex;

    public DBRecord(int n, int n2) {
        this.data = new Object[n];
        this.idIndex = n2;
    }

    public DBRecord(int n, int n2, ResultSet resultSet) throws DBException {
        this(n, n2);
        try {
            for (int i = 0; i < n; ++i) {
                this.data[i] = resultSet.getObject(i + 1);
            }
        }
        catch (SQLException sQLException) {
            throw new DBException(sQLException);
        }
    }

    public DBRecord(DBTableModel dBTableModel) {
        this(dBTableModel.getColumnCount(), dBTableModel.getIdIndex());
    }

    public BigDecimal getBigDecimal(int n) {
        return (BigDecimal)this.data[n];
    }

    public Boolean getBoolean(int n) {
        return (Boolean)this.data[n];
    }

    public int getColumnCount() {
        return this.data.length;
    }

    @Deprecated
    public Double getDouble(int n) {
        return (Double)this.data[n];
    }

    @Deprecated
    public Float getFloat(int n) {
        return (Float)this.data[n];
    }

    public Object getId() {
        return this.data[this.idIndex];
    }

    @Deprecated
    public Integer getInteger(int n) {
        return (Integer)this.data[n];
    }

    @Deprecated
    public Long getLong(int n) {
        return (Long)this.data[n];
    }

    @Deprecated
    public Short getShort(int n) {
        return (Short)this.data[n];
    }

    public Number getNumber(int n) {
        return (Number)this.data[n];
    }

    public Object getObject(int n) {
        return this.data[n];
    }

    public void setObject(int n, Object object) {
        this.data[n] = object;
    }

    public String getString(int n) {
        return (String)this.data[n];
    }

    public Timestamp getTimestamp(int n) {
        return (Timestamp)this.data[n];
    }

    public boolean isNull(int n) {
        return this.data[n] == null;
    }

    public String toString() {
        return TK.toString(this.data, ", ");
    }

    public static final class LargeText {
        private final String text;

        public LargeText(String string) {
            this.text = TK.checkNull(string);
        }

        public boolean isEmpty() {
            return this.text.isEmpty();
        }

        public String toString() {
            return this.text;
        }
    }
}

