/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.db;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.makagiga.db.DBException;

public abstract class DBManager {
    protected Connection connection;
    protected String url;
    protected String user;
    private final String className;
    private final String password;

    public static String createH2FileURL(File file) {
        return "jdbc:h2:file:" + file.getPath();
    }

    public static String createHSQLDBFileURL(File file) {
        return "jdbc:hsqldb:file:" + file.getPath();
    }

    public synchronized void closeConnection() throws DBException {
        if (this.connection == null) {
            throw new DBException("Already closed: " + this.url);
        }
        try {
            this.connection.close();
            this.connection = null;
        }
        catch (SQLException sQLException) {
            throw new DBException(sQLException);
        }
    }

    public static void closeStatement(Statement statement) throws DBException {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            throw new DBException(sQLException);
        }
    }

    public synchronized void establishConnection() throws DBException {
        if (this.connection != null) {
            throw new DBException("Already connected: " + this.url);
        }
        try {
            Class.forName(this.className);
            this.connection = DriverManager.getConnection(this.url, this.user, this.password);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DBException(classNotFoundException);
        }
        catch (SQLException sQLException) {
            throw new DBException(sQLException);
        }
    }

    public synchronized Connection getConnection() {
        return this.connection;
    }

    public synchronized String getURL() {
        return this.url;
    }

    public synchronized String getUser() {
        return this.user;
    }

    public static DBManager newH2DBManager(String string) throws DBException {
        return new H2DBManager(string, "sa", "");
    }

    public static DBManager newH2DBManager(String string, String string2, String string3) throws DBException {
        return new H2DBManager(string, string2, string3);
    }

    public static DBManager newHSQLDBManager(String string) throws DBException {
        return new HSQLDBManager(string, "sa", "");
    }

    public static DBManager newHSQLDBManager(String string, String string2, String string3) throws DBException {
        return new HSQLDBManager(string, string2, string3);
    }

    public synchronized void shutDown() throws DBException {
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            statement.execute("SHUTDOWN");
        }
        catch (SQLException sQLException) {
            throw new DBException(sQLException);
        }
        finally {
            DBManager.closeStatement(statement);
        }
    }

    public synchronized String toString() {
        return "URL=\"" + this.url + "\", User=\"" + this.user + "\", Class=\"" + this.className + "\"";
    }

    protected DBManager(String string, String string2, String string3, String string4) throws DBException {
        this.className = string;
        this.url = string2;
        this.user = string3;
        this.password = string4;
    }

    private static final class HSQLDBManager
    extends DBManager {
        private HSQLDBManager(String string, String string2, String string3) throws DBException {
            super("org.hsqldb.jdbcDriver", string, string2, string3);
        }
    }

    private static final class H2DBManager
    extends DBManager {
        private H2DBManager(String string, String string2, String string3) throws DBException {
            super("org.h2.Driver", string, string2, string3);
        }
    }
}

