/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.console;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.makagiga.commons.CommandOptions;
import org.makagiga.commons.Config;
import org.makagiga.commons.MHighlighter;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MObject;
import org.makagiga.commons.MTextField;
import org.makagiga.console.Console;

public abstract class ConsoleCommand
implements Config.GlobalEntry,
Serializable {
    private CommandOptions commandOptions;
    private Icon smallIcon;
    private Set<String> aliasNames;
    private String description;
    private String name;

    public ConsoleCommand(String string) {
        this(null, string);
    }

    public ConsoleCommand(String string, String string2) {
        this.name = string;
        this.description = string2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ConsoleCommand)) {
            return false;
        }
        ConsoleCommand consoleCommand = (ConsoleCommand)object;
        return MObject.safeEquals(this.name, consoleCommand.name) && MObject.safeEquals(this.description, consoleCommand.description) && ((Object)this.getAliasNames()).equals(consoleCommand.getAliasNames());
    }

    public int hashCode() {
        return MObject.hashCode(this.name, this.description, this.getAliasNames());
    }

    public synchronized Set<String> getAliasNames() {
        if (this.aliasNames == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.aliasNames);
    }

    public List<String> getAutoCompletionList() {
        return Collections.emptyList();
    }

    public String getDescription() {
        return this.description;
    }

    @Deprecated
    public void setDescription(String string) {
        this.description = string;
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public void setName(String string) {
        this.name = string;
    }

    public Icon getSmallIcon() {
        return this.smallIcon;
    }

    public void setSmallIcon(Icon icon) {
        this.smallIcon = icon;
    }

    public void setSmallIcon(String string) {
        this.setSmallIcon(string == null ? (Icon)null : MIcon.small(string));
    }

    public boolean handleUknownCommand(Console console, String string) {
        return false;
    }

    public abstract Object onCommand(Console var1, String ... var2);

    public boolean onExclusiveCommand(Console console, String string) {
        return false;
    }

    public boolean onHighlight(MHighlighter<MTextField> mHighlighter, String string, List<String> list) {
        return false;
    }

    public boolean onHelp(Console console) {
        return false;
    }

    @Override
    public String getGlobalEntry(String string) {
        return this.getClass().getName() + "." + string;
    }

    protected synchronized void addAliasName(String string) {
        if (this.aliasNames == null) {
            this.aliasNames = new HashSet<String>();
        }
        this.aliasNames.add(string);
    }

    protected CommandOptions createCommandOptions() {
        return null;
    }

    protected final synchronized CommandOptions getCommandOptions() {
        if (this.commandOptions == null) {
            this.commandOptions = this.createCommandOptions();
        }
        return this.commandOptions;
    }
}

