/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.console;

import edu.umd.cs.findbugs.annotation.SuppressWarnings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.security.AccessController;
import java.security.BasicPermission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeMap;
import javax.script.ScriptException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.text.AttributeSet;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.makagiga.commons.ActionGroup;
import org.makagiga.commons.Args;
import org.makagiga.commons.ClipboardException;
import org.makagiga.commons.ColorProperty;
import org.makagiga.commons.CommandOptions;
import org.makagiga.commons.Config;
import org.makagiga.commons.CoolHeader;
import org.makagiga.commons.FileCache;
import org.makagiga.commons.FontProperty;
import org.makagiga.commons.Kiosk;
import org.makagiga.commons.LogFile;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MClipboard;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MFormat;
import org.makagiga.commons.MFrame;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MScrollPane;
import org.makagiga.commons.MSplashScreen;
import org.makagiga.commons.MStatusBar;
import org.makagiga.commons.MTextField;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.MUndoManager;
import org.makagiga.commons.MainView;
import org.makagiga.commons.PropertyAccess;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.XMLHelper;
import org.makagiga.commons.mods.Mods;
import org.makagiga.commons.script.ScriptError;
import org.makagiga.commons.script.ScriptYourself;
import org.makagiga.commons.util.CollectionMap;
import org.makagiga.console.ConsoleCommand;
import org.makagiga.console.ConsoleCommandLine;
import org.makagiga.console.ConsoleConfig;
import org.makagiga.console.ConsoleOutput;
import org.makagiga.console.ConsolePlugin;
import org.makagiga.console.DebugCommand;
import org.makagiga.console.HistoryCommand;
import org.makagiga.console.JVisualVMCommand;
import org.makagiga.console.ScriptCommand;
import org.makagiga.plugins.PluginInfo;
import org.makagiga.plugins.PluginManager;
import org.makagiga.plugins.PluginType;

public final class Console
extends MPanel
implements Iterable<ConsoleCommand> {
    public static final String MOD_CLOSE_CONSOLE = "close@org.makagiga.console.Console";
    public static final String MOD_SHOW_CONSOLE = "show@org.makagiga.console.Console";
    private final ActionGroup actionGroup = new ActionGroup();
    private static boolean firstShow = true;
    private static boolean wasFatal;
    private static Console _console;
    private ConsoleCommandLine commandLinePanel;
    private ConsoleConfig consoleConfig;
    private ConsoleOutput output;
    private static Control _control;
    private static Frame _frame;
    private static IO _globalIO;
    private final IO io;
    private final Map<String, ConsoleCommand> commands = new TreeMap<String, ConsoleCommand>();
    private static Map<String, ConsoleCommand> staticCommands;
    private MPanel consoleConfigPanel;
    private MPanel flipPanel;
    private MScrollPane outputScrollPane;
    private MToolBar toolBar;
    private MUndoManager configUndoManager;
    private final SimpleAttributeSet alternateLineColor;
    ConsoleCommand exclusiveCommand;

    public Console(boolean bl) {
        this(new IO(null), bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Console(IO iO, boolean bl) {
        this.io = iO;
        Object object = this.io;
        synchronized (object) {
            this.io.console = this;
        }
        this.alternateLineColor = new SimpleAttributeSet();
        StyleConstants.setBackground(this.alternateLineColor, MColor.getBrighter(MColor.SKY_BLUE, 80));
        if (bl) {
            this.initCommands();
        }
        this.configUndoManager = new MUndoManager();
        this.configUndoManager.updateUndoRedoActions(false);
        if (((Boolean)Kiosk.actionSettings.get()).booleanValue()) {
            this.actionGroup.add("configure", new MAction(MActionInfo.SETTINGS){

                @Override
                public void onAction() {
                    Console.this.setConfigMode(Console.this.outputScrollPane.isVisible());
                }
            }).setShowTextInToolBar(true);
            this.actionGroup.addSeparator();
        }
        this.actionGroup.add("undo", this.configUndoManager.getUndoAction()).setShowTextInToolBar(true);
        this.actionGroup.add("redo", this.configUndoManager.getRedoAction());
        this.actionGroup.add("help", new MAction(MActionInfo.HELP){

            @Override
            public void onAction() {
                Console.this.executeCommand("help", true);
            }
        }).setShowTextInToolBar(true);
        this.toolBar = new MToolBar();
        this.toolBar.setID("console");
        this.toolBar.setTextPosition(MToolBar.TextPosition.ALONGSIDE_ICONS);
        this.actionGroup.updateToolBar(this.toolBar);
        ScriptYourself.install(this.toolBar);
        this.addNorth(this.toolBar);
        this.output = new ConsoleOutput();
        this.consoleConfigPanel = MPanel.createBorderPanel();
        object = new CoolHeader();
        ((CoolHeader)object).setWarningMessage(UI._("This panel contains advanced settings for experienced users"));
        this.consoleConfigPanel.addSouth((JComponent)object);
        this.outputScrollPane = new MScrollPane(this.output, 2);
        this.flipPanel = MPanel.createCardPanel();
        this.flipPanel.add((Component)this.outputScrollPane, "output");
        this.flipPanel.add((Component)this.consoleConfigPanel, "config");
        this.addCenter(this.flipPanel);
        this.commandLinePanel = new ConsoleCommandLine(this);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!"value".equals(propertyChangeEvent.getPropertyName())) {
                    return;
                }
                if (propertyChangeEvent.getSource() == MApplication.consoleFontSize) {
                    Console.this.updateFontSize();
                } else if (propertyChangeEvent.getSource() == MApplication.consolePrompt) {
                    Console.this.updatePromptText();
                }
            }
        };
        MApplication.consoleFontSize.addPropertyChangeListener(propertyChangeListener);
        MApplication.consolePrompt.addPropertyChangeListener(propertyChangeListener);
        this.updatePromptText();
        this.addSouth(this.commandLinePanel);
        this.updateFontSize();
        HistoryCommand historyCommand = this.getHistoryCommand();
        if (historyCommand != null) {
            historyCommand.installKeyboardHandler(this.commandLinePanel.commandLine);
        }
        new MAction("Console.VK_PAGE_DOWN"){

            @Override
            public void onAction() {
                MAction.fire("scrollDown", Console.this.outputScrollPane);
            }
        }.connect(this.commandLinePanel.commandLine, 0, 34);
        new MAction("Console.VK_PAGE_UP"){

            @Override
            public void onAction() {
                MAction.fire("scrollUp", Console.this.outputScrollPane);
            }
        }.connect(this.commandLinePanel.commandLine, 0, 33);
    }

    public void append(String string) {
        this.append(null, string);
    }

    public void append(final AttributeSet attributeSet, final String string) {
        UI.invokeLater(new Runnable(){

            @Override
            public void run() {
                JViewport jViewport;
                if (Console.this.output == null) {
                    return;
                }
                Console.this.output.append(attributeSet, string);
                boolean bl = false;
                if (Console.this.outputScrollPane != null && (jViewport = Console.this.outputScrollPane.getViewport()) != null) {
                    Dimension dimension = jViewport.getViewSize();
                    Rectangle rectangle = jViewport.getViewRect();
                    int n = dimension.height - rectangle.y;
                    boolean bl2 = bl = n < rectangle.height + 10;
                }
                if (Console.this.output.getDocument().getLength() > 524288) {
                    Console.this.output.clear();
                }
                if (bl && Console.this.output.isDisplayable()) {
                    Console.this.output.scrollToEnd();
                }
            }
        });
    }

    public static MutableAttributeSet createColorAttr(Color color) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, color);
        return simpleAttributeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(String string, String ... stringArray) {
        Console.checkPermission("execute");
        ConsoleCommand consoleCommand = this.getCommand(string);
        if (consoleCommand == null) {
            throw new UnsupportedOperationException("Command not found: " + string);
        }
        String[] stringArray2 = stringArray == null ? TK.EMPTY_STRING_ARRAY : stringArray;
        CommandOptions commandOptions = consoleCommand.getCommandOptions();
        if (commandOptions != null) {
            commandOptions.set(stringArray);
        }
        Console console = this;
        synchronized (console) {
            return consoleCommand.onCommand(this, stringArray2);
        }
    }

    public void executeCommand(String string) {
        this.executeCommand(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCommand(String string, boolean bl) {
        List<String> list;
        Console.checkPermission("executeCommand");
        try {
            list = TK.parseArguments(string);
        }
        catch (ParseException parseException) {
            Console console = this;
            synchronized (console) {
                this.io.printError(parseException.getMessage());
                MutableAttributeSet mutableAttributeSet = Console.createColorAttr(MColor.DARK_RED);
                this.io.printLine(mutableAttributeSet, "\t" + string);
                if (parseException.getErrorOffset() > 0) {
                    this.io.printLine(mutableAttributeSet, "\t" + TK.filler('.', parseException.getErrorOffset()) + "^");
                }
                this.output.scrollToEnd();
            }
            return;
        }
        if (list.isEmpty()) {
            this.output.scrollToEnd();
            return;
        }
        String string2 = list.get(0);
        list.remove(0);
        boolean bl2 = false;
        Console console = this;
        synchronized (console) {
            if (bl && "help".equals(string2) && this.exclusiveCommand != null) {
                if (this.exclusiveCommand.onHelp(this)) {
                    bl2 = true;
                }
            } else if (!bl && this.exclusiveCommand != null) {
                if (this.exclusiveCommand.onExclusiveCommand(this, string)) {
                    bl2 = true;
                }
            } else if (this.doExecute(string2, list.toArray(new String[list.size()]))) {
                bl2 = true;
            } else {
                boolean bl3 = false;
                if (!string2.isEmpty()) {
                    Config config = Config.getDefault();
                    Object object = config.getRegisteredProperties();
                    for (Map.Entry<String, PropertyAccess<?>> entry : object.entrySet()) {
                        if (!entry.getKey().equals(string2)) continue;
                        if (list.isEmpty()) {
                            this.io.printLine("VARIABLE: " + Console.formatVar(entry, -1));
                            bl2 = true;
                        } else {
                            try {
                                if (!entry.getKey().startsWith("Kiosk.") || MMessage.simpleConfirm(this.getWindowAncestor())) {
                                    this.io.printLine("BEFORE: " + Console.formatVar(entry, -1));
                                    entry.getValue().parse(list.get(0));
                                    this.io.printLine("AFTER: " + Console.formatVar(entry, -1));
                                    bl2 = true;
                                    config.sync();
                                }
                            }
                            catch (ParseException parseException) {
                                this.io.printError(parseException.toString());
                            }
                        }
                        bl3 = true;
                        break;
                    }
                }
                if (!bl3 && string != null) {
                    for (Object object : this) {
                        if (!((ConsoleCommand)object).handleUknownCommand(this, string)) continue;
                        bl2 = true;
                        bl3 = true;
                        break;
                    }
                }
                if (!bl3) {
                    if ("god".equals(string)) {
                        this.io.printLine("god mode on");
                    } else if ("give weapon_bfg".equals(string)) {
                        this.io.printLine("Plugin not found. Use plasmagun instead.");
                    } else {
                        this.io.printError(UI._("Unknown command: {0}", string2));
                    }
                }
            }
            this.saveHistory(string, bl2);
            this.io.printLine();
            this.commandLinePanel.commandLine.clear();
            this.output.scrollToEnd();
        }
    }

    public ActionGroup getActionGroup() {
        Console.checkPermission("getActionGroup");
        return this.actionGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsoleCommand getCommand(String string) {
        Console.checkPermission("getCommand");
        Console console = this;
        synchronized (console) {
            return this.commands.get(string);
        }
    }

    public MTextField getCommandLine() {
        Console.checkPermission("getCommandLine");
        return this.commandLinePanel.commandLine;
    }

    public MPanel getCommandLinePanel() {
        Console.checkPermission("getCommandLinePanel");
        return this.commandLinePanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static Control getControl() {
        Console.checkPermission("getControl");
        Class<Console> clazz = Console.class;
        synchronized (Console.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return _control;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void setControl(Control control) {
        Console.checkPermission("setControl");
        Class<Console> clazz = Console.class;
        synchronized (Console.class) {
            if (_control != null) {
                throw new IllegalStateException("Console.Control already set");
            }
            _control = control;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static Console getInstance() {
        return Console.getInstance(false);
    }

    public static synchronized Console getInstance(boolean bl) {
        Console.checkPermission("getInstance");
        if (_console == null) {
            _console = new Console(_globalIO, firstShow);
            if (!Mods.contains(MOD_SHOW_CONSOLE) && _control == null) {
                _frame = new Frame(_console);
                _control = _frame;
            }
            if (firstShow) {
                firstShow = false;
                if (_frame != null) {
                    _frame.setLocationRelativeTo(null);
                }
                Console.doShow(bl);
                if (Console._console.io.getLog() != null) {
                    Console._console.output.append(Console.createColorAttr(Color.GRAY), Console._console.io.getLog().toString());
                }
                Console._console.io.printLine();
                MutableAttributeSet mutableAttributeSet = Console.createColorAttr(MColor.DARK_GREEN);
                Console._console.io.printLine(mutableAttributeSet, " " + UI._("Type \"help\" to see all commands"));
                Console._console.io.printLine();
                Console._console.output.scrollToEnd();
            }
        } else {
            Console.doShow(bl);
        }
        Console._console.commandLinePanel.commandLine.makeDefault();
        return _console;
    }

    public IO getIO() {
        Console.checkPermission("getIO");
        return this.io;
    }

    @Deprecated
    public static LogFile getLogFile() {
        return MApplication.getLogFile();
    }

    public JTextComponent getOutput() {
        Console.checkPermission("getOutput");
        return this.output;
    }

    public MLabel getPrompt() {
        Console.checkPermission("getPrompt");
        return this.commandLinePanel.prompt;
    }

    public MToolBar getToolBar() {
        Console.checkPermission("getToolBar");
        return this.toolBar;
    }

    public static void init() {
        Console.checkPermission("init");
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, final Throwable throwable) {
                MLogger.exception(throwable);
                UI.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Console.doHandleUncaughtException(throwable);
                        }
                        catch (ThreadDeath threadDeath) {
                            throw threadDeath;
                        }
                        catch (Throwable throwable2) {
                            MLogger.warning("core", "Exception in error handler");
                            MLogger.exception(throwable2);
                        }
                    }
                });
            }
        });
        _globalIO = new IO(MApplication.getLogFile());
        _globalIO.redirectOutput();
        MApplication.addShutDownListener(new MApplication.ShutDownListener(){

            @Override
            public void shutDown(MApplication.ShutDownEvent shutDownEvent) {
                if (Console.isInstance()) {
                    for (ConsoleCommand consoleCommand : Console.getInstance(false)) {
                        TK.dispose(consoleCommand);
                    }
                }
                if (_globalIO != null) {
                    _globalIO.shutDown();
                    _globalIO = null;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initCommands() {
        Console.checkPermission("initCommands");
        this.register("args", new ConsoleCommand(UI._("Show available command line arguments")){

            @Override
            public Object onCommand(Console console, String ... stringArray) {
                Args.helpCLI();
                return null;
            }
        });
        ConsoleCommand consoleCommand = new ConsoleCommand(UI._("Clear the output history.")){

            @Override
            public Object onCommand(Console console, String ... stringArray) {
                HistoryCommand historyCommand;
                Console.this.output.clear();
                if (Console.this.io.getLog() != null) {
                    Console.this.io.getLog().clear();
                }
                if ((historyCommand = Console.this.getHistoryCommand()) != null) {
                    historyCommand.clearHistory();
                }
                return null;
            }
        };
        consoleCommand.setSmallIcon(MActionInfo.CLEAR_HISTORY.getIconName());
        this.register("clear", consoleCommand);
        this.register("crash", new ConsoleCommand("Raise null pointer exception (test)"){

            @Override
            public Object onCommand(Console console, String ... stringArray) {
                try {
                    TK.checkNull(null, "null");
                }
                catch (NullPointerException nullPointerException) {
                    MMessage.error(Console.this.getWindowAncestor(), nullPointerException);
                }
                return null;
            }
        });
        this.register(new DebugCommand());
        ConsoleCommand consoleCommand2 = new ConsoleCommand(UI._("Close")){

            @Override
            public Object onCommand(Console console, String ... stringArray) {
                if (!Boolean.TRUE.equals(Mods.exec(console, Console.MOD_CLOSE_CONSOLE, new Object[0]))) {
                    Console.getControl().close(console);
                }
                return null;
            }
        };
        consoleCommand2.setSmallIcon("ui/close");
        this.register("exit", consoleCommand2);
        this.register("flush", new ConsoleCommand("Flush internal caches"){

            @Override
            public Object onCommand(Console console, String ... stringArray) {
                if (Console.this.io.getLog() != null) {
                    Console.this.io.getLog().flush();
                }
                MIcon.Cache.getInstance().clear();
                FileCache.getInstance().clear();
                XMLHelper.clearContextCache();
                return null;
            }
        });
        this.register("gc", new ConsoleCommand("Run Garbage Collector (debug)"){

            @Override
            @SuppressWarnings(value="Dm")
            public Object onCommand(Console console, String ... stringArray) {
                System.gc();
                return null;
            }
        });
        this.register("getenv", new ConsoleCommand("Show system environment variables"){

            @Override
            public Object onCommand(Console console, String ... stringArray) {
                Map<String, String> map = System.getenv();
                int n = TK.maxLength(map.keySet());
                int n2 = 0;
                for (Map.Entry<String, String> entry : TK.sortByKey(map, null).entrySet()) {
                    Console.this.io.printLine(console.getRowAttr(n2++), "%-" + n + "s = %s", entry.getKey(), entry.getValue());
                }
                return null;
            }
        });
        ConsoleCommand consoleCommand3 = new ConsoleCommand(UI._("Show console commands")){

            @Override
            public Object onCommand(Console console, String ... stringArray) {
                console.listCommands();
                Console.this.io.printLine();
                if (Console.this.io.getLog() != null) {
                    Console.this.io.printLine("Log: " + Console.this.io.getLog().getFile());
                }
                Console.this.io.printLine();
                Console.this.io.printLine("See: http://sourceforge.net/apps/mediawiki/makagiga/index.php?title=Console");
                return null;
            }
        };
        consoleCommand3.setSmallIcon(MActionInfo.HELP.getSmallIcon());
        this.register("help", consoleCommand3);
        this.register(new JVisualVMCommand());
        this.register("mem", new ConsoleCommand("Show memory information"){

            @Override
            public Object onCommand(Console console, String ... stringArray) {
                MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
                long l = memoryMXBean.getHeapMemoryUsage().getUsed();
                long l2 = memoryMXBean.getNonHeapMemoryUsage().getUsed();
                Console.this.io.printLine(console.getRowAttr(0), "Heap memory usage     = " + MFormat.toMB(l));
                Console.this.io.printLine(console.getRowAttr(1), "Non-heap memory usage = " + MFormat.toMB(l2));
                Console.this.io.printLine(console.getRowAttr(0), "Total                 = " + MFormat.toMB(l + l2));
                Console.this.io.printLine(console.getRowAttr(1), "Objects pending finalization = " + memoryMXBean.getObjectPendingFinalizationCount());
                return null;
            }
        });
        ConsoleCommand consoleCommand4 = new ConsoleCommand(UI._("Quit application")){

            @Override
            public Object onCommand(Console console, String ... stringArray) {
                MApplication.quit();
                return null;
            }
        };
        consoleCommand4.setSmallIcon("ui/quit");
        this.register("quit", consoleCommand4);
        ConsoleCommand consoleCommand5 = new ConsoleCommand(UI._("Reset variable (example: {0})", "reset UI.buttonIcons")){

            @Override
            public Object onCommand(Console console, String ... stringArray) {
                if (stringArray.length == 0) {
                    return null;
                }
                Map<String, PropertyAccess<?>> map = Config.getDefault().getRegisteredProperties();
                for (Map.Entry<String, PropertyAccess<?>> entry : map.entrySet()) {
                    if (!entry.getKey().equals(stringArray[0])) continue;
                    IO iO = console.getIO();
                    iO.printLine("BEFORE: " + Console.formatVar(entry, -1));
                    entry.getValue().reset();
                    iO.printLine("AFTER: " + Console.formatVar(entry, -1));
                    break;
                }
                return null;
            }
        };
        consoleCommand5.setSmallIcon("ui/revert");
        this.register("reset", consoleCommand5);
        this.register("uuidgen", new ConsoleCommand("Generate an unique ID (used in plugins)"){

            @Override
            public Object onCommand(Console console, String ... stringArray) {
                final String string = TK.createRandomUUID();
                MButton mButton = new MButton(new MAction(MActionInfo.COPY){

                    @Override
                    public void onAction() {
                        try {
                            MClipboard.setString(string);
                        }
                        catch (ClipboardException clipboardException) {
                            MLogger.exception(clipboardException);
                        }
                    }
                });
                console.getIO().printComponent(mButton);
                console.getIO().printLine();
                return string;
            }
        });
        this.register(new VarListCommand());
        this.register("version", new ConsoleCommand(UI._("Show application version")){

            @Override
            public Object onCommand(Console console, String ... stringArray) {
                Args.versionCLI();
                return null;
            }
        });
        this.register(new HistoryCommand());
        this.register(new ScriptCommand());
        this.registerPlugins();
        Class<Console> clazz = Console.class;
        synchronized (Console.class) {
            if (staticCommands != null) {
                for (ConsoleCommand consoleCommand6 : staticCommands.values()) {
                    this.register(consoleCommand6);
                }
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    public static synchronized boolean isInstance() {
        return _console != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ConsoleCommand> iterator() {
        Console.checkPermission("iterator");
        Console console = this;
        synchronized (console) {
            return TK.unmodifiableIterator(this.commands.values().iterator());
        }
    }

    public String readLine(ConsoleCommand consoleCommand, String string, String string2) {
        TK.checkNull(consoleCommand, "command");
        return MMessage.input(this.getWindowAncestor(), string, string2, consoleCommand.getName(), "ui/console", "console-input");
    }

    public char[] readPassword(ConsoleCommand consoleCommand, String string) {
        TK.checkNull(consoleCommand, "command");
        return MMessage.enterPassword(this.getWindowAncestor(), string, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String string, ConsoleCommand consoleCommand) {
        Console.checkPermission("register");
        Console console = this;
        synchronized (console) {
            this.checkOverride(string);
            consoleCommand.setName(string);
            this.commands.put(string, consoleCommand);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ConsoleCommand consoleCommand) {
        Console.checkPermission("register");
        Console console = this;
        synchronized (console) {
            this.checkOverride(consoleCommand.getName());
            this.commands.put(consoleCommand.getName(), consoleCommand);
            for (String string : consoleCommand.getAliasNames()) {
                this.checkOverride(string);
                this.commands.put(string, consoleCommand);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void registerCommand(ConsoleCommand consoleCommand) {
        Console.checkPermission("register");
        Class<Console> clazz = Console.class;
        synchronized (Console.class) {
            if (staticCommands == null) {
                staticCommands = TK.newHashMap();
            }
            staticCommands.put(consoleCommand.getName(), consoleCommand);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setExclusiveMode(ConsoleCommand consoleCommand) {
        Console.checkPermission("setExclusiveMode");
        Console console = this;
        synchronized (console) {
            this.exclusiveCommand = consoleCommand;
            this.updatePromptText();
        }
    }

    private void checkOverride(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && this.commands.containsKey(string)) {
            securityManager.checkPermission(new Permission("override"));
        }
    }

    private static void checkPermission(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new Permission(string));
        }
    }

    private boolean doExecute(String string, String ... stringArray) {
        try {
            Object object = this.execute(string, stringArray);
            if (object != null) {
                MutableAttributeSet mutableAttributeSet = Console.createColorAttr(MColor.DARK_GREEN);
                this.io.printLine(mutableAttributeSet, object.toString());
            }
            return true;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return false;
        }
    }

    private static void doHandleUncaughtException(Throwable throwable) {
        if (!MApplication.isInitialized() && !wasFatal) {
            wasFatal = true;
            Config config = Config.getDefault();
            config.write("safeMode", true);
            config.sync();
            try {
                MMessage.error(null, throwable, UI.makeHTML(UI._("A fatal error occured.<br>See <code>{0}</code> file for details.", MApplication.getLogFile().getFile())));
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable2) {
                MLogger.warning("core", "UI error");
                MLogger.exception(throwable2);
            }
            Window window = MainView.getWindow();
            if (window != null) {
                window.dispose();
            }
            System.exit(1);
        }
        if (throwable instanceof ScriptException || throwable.getClass().getName().startsWith("sun.org.mozilla.javascript.")) {
            ScriptError.getSharedInstance().showError(throwable);
            return;
        }
        if (throwable.getCause() instanceof PrivilegedActionException || throwable.getCause() instanceof ScriptException) {
            ScriptError.getSharedInstance().showError(throwable.getCause());
            return;
        }
        if (MLogger.isDeveloper()) {
            MSplashScreen.close();
            if (((Boolean)Kiosk.consoleEnabled.get()).booleanValue()) {
                Console.getInstance(true);
            }
        }
        if (throwable instanceof OutOfMemoryError) {
            MStatusBar.error(throwable);
        }
    }

    private static void doShow(boolean bl) {
        if (!bl) {
            return;
        }
        if (Boolean.TRUE.equals(Mods.exec(_console, MOD_SHOW_CONSOLE, new Object[0]))) {
            return;
        }
        if (_control != null) {
            _control.show(_console);
        }
    }

    private static String formatValue(Object object) {
        if (object == null) {
            return "<null>";
        }
        if (object instanceof Color) {
            return ColorProperty.toString((Color)object);
        }
        if (object instanceof Font) {
            return FontProperty.toString((Font)object);
        }
        if (object instanceof String) {
            return "\"" + object + "\"";
        }
        return object.toString();
    }

    private static String formatVar(Map.Entry<String, PropertyAccess<?>> entry, int n) {
        PropertyAccess<?> propertyAccess = entry.getValue();
        String string = n == -1 ? "%s = %s%s" : "%-" + n + "s = %s%s";
        return String.format(string, entry.getKey(), Console.formatValue(propertyAccess.get()), propertyAccess.isDefaultValue() ? "" : " [default: " + Console.formatValue(propertyAccess.getDefaultValue()) + "]");
    }

    private HistoryCommand getHistoryCommand() {
        return (HistoryCommand)this.getCommand("history");
    }

    /*
     * WARNING - void declaration
     */
    private void listCommands() {
        CollectionMap<ConsoleCommand, String> collectionMap = new CollectionMap<ConsoleCommand, String>(CollectionMap.MapType.LINKED_HASH_MAP, CollectionMap.CollectionType.TREE_SET);
        for (ConsoleCommand object : this.commands.values()) {
            Collection<String> collection = collectionMap.add(object, object.getName());
            collection.addAll(object.getAliasNames());
        }
        int n = 0;
        for (Collection collection : collectionMap.values()) {
            n = Math.max(n, TK.toString(collection, ", ").length());
        }
        boolean bl = false;
        for (Map.Entry entry : collectionMap) {
            void var3_7;
            String string = TK.toString(entry.getValue(), ", ");
            String string2 = ((ConsoleCommand)entry.getKey()).getDescription();
            if (string2 == null) {
                string2 = "[" + UI._("No Description") + "]";
            }
            this.io.printLine(this.getRowAttr((int)(++var3_7)), "%-" + n + "s  %s", string, string2);
        }
    }

    private void registerPlugins() {
        for (PluginInfo serializable : PluginType.CONSOLE.get()) {
            ConsolePlugin consolePlugin = (ConsolePlugin)serializable.getPluggable();
            try {
                ConsoleCommand consoleCommand = (ConsoleCommand)consolePlugin.create();
                if (consoleCommand.getSmallIcon() == null) {
                    consoleCommand.setSmallIcon(serializable.getSmallIcon());
                }
                this.register(consoleCommand);
            }
            catch (Exception exception) {
                MLogger.exception(exception);
            }
        }
        for (ConsoleCommand consoleCommand : ServiceLoader.load(ConsoleCommand.class)) {
            this.register(consoleCommand);
        }
        for (ConsoleCommand consoleCommand : PluginManager.loadServices(ConsoleCommand.class)) {
            this.register(consoleCommand);
        }
    }

    private void saveHistory(String string, boolean bl) {
        HistoryCommand historyCommand = this.getHistoryCommand();
        if (historyCommand != null) {
            if (bl && historyCommand.isHistoryEnabled()) {
                this.commandLinePanel.commandLine.saveAutoCompletion();
            }
            historyCommand.addHistory(string);
        } else if (bl) {
            this.commandLinePanel.commandLine.saveAutoCompletion();
        }
    }

    private void setConfigMode(boolean bl) {
        this.flipPanel.showCard(bl ? "config" : "output");
        this.commandLinePanel.setVisible(!bl);
        Config config = Config.getDefault();
        MAction mAction = (MAction)this.actionGroup.getAction("configure");
        if (bl) {
            if (mAction != null) {
                mAction.setActionInfo(MActionInfo.BACK);
            }
            if (this.consoleConfig == null) {
                this.consoleConfig = new ConsoleConfig();
                this.configUndoManager.setOwner(this.consoleConfig);
                ((ConsoleConfig.Model)this.consoleConfig.getModel()).addUndoableEditListener(this.configUndoManager.createUndoableEditListener());
                this.consoleConfigPanel.addCenter(this.consoleConfig);
                this.consoleConfigPanel.validate();
            }
            this.consoleConfig.updateModel();
            this.consoleConfig.requestFocusInWindow();
            this.configUndoManager.updateUndoRedoActions(true);
            this.consoleConfig.getColumnManager().readConfig(config, null, this.consoleConfig);
        } else {
            if (mAction != null) {
                mAction.setActionInfo(MActionInfo.SETTINGS);
            }
            this.commandLinePanel.commandLine.makeDefault();
            this.configUndoManager.updateUndoRedoActions(false);
            this.consoleConfig.getColumnManager().writeConfig(config, null, this.consoleConfig);
        }
        MAction mAction2 = (MAction)this.actionGroup.getAction("help");
        mAction2.setEnabled(!bl);
    }

    private void updateFontSize() {
        int n = MApplication.consoleFontSize.normalize(8, 32);
        Font font = UI.createMonospacedFont(n);
        this.output.setFont(font);
        this.commandLinePanel.prompt.setFont(font);
        this.commandLinePanel.commandLine.setFont(font);
    }

    private void updatePromptText() {
        MLabel mLabel = this.getPrompt();
        StringBuilder stringBuilder = new StringBuilder();
        if (this.exclusiveCommand != null) {
            stringBuilder.append('[').append(this.exclusiveCommand.getName()).append("] ");
            mLabel.setIcon(this.exclusiveCommand.getSmallIcon());
        } else {
            mLabel.setIcon(null);
        }
        stringBuilder.append((String)MApplication.consolePrompt.get());
        mLabel.setText(stringBuilder.toString());
    }

    AttributeSet getRowAttr(int n) {
        return n % 2 != 0 ? this.alternateLineColor : null;
    }

    private static final class VarListCommand
    extends ConsoleCommand {
        @Override
        public Object onCommand(Console console, String ... stringArray) {
            Map<String, PropertyAccess<?>> map = TK.sortByKey(Config.getDefault().getRegisteredProperties(), null);
            int n = TK.maxLength(map.keySet());
            int n2 = 0;
            for (Map.Entry<String, PropertyAccess<?>> entry : map.entrySet()) {
                console.io.printLine(console.getRowAttr(n2++), Console.formatVar(entry, n));
            }
            return null;
        }

        private VarListCommand() {
            super("varlist", UI._("Show variables. Type \"VARIABLE_NAME NEW_VALUE\" to set value (example: {0}).", "UI.buttonIcons true"));
            this.setSmallIcon("ui/configure");
        }
    }

    public static final class Permission
    extends BasicPermission {
        private Permission(String string) {
            super(string);
        }
    }

    public static final class IO
    extends FilterOutputStream {
        private final boolean applicationLog;
        private boolean inPrint;
        private Console console;
        private final LogFile log;
        private final MutableAttributeSet stdAttr = new SimpleAttributeSet();
        private PrintStream oldErr;
        private PrintStream oldOut;
        private PrintStream printStream;

        public IO(LogFile logFile) {
            super(new ByteArrayOutputStream());
            StyleConstants.setForeground(this.stdAttr, MColor.DARK_RED);
            this.applicationLog = logFile == null ? false : logFile == MApplication.getLogFile();
            this.log = logFile;
        }

        public LogFile getLog() {
            return this.log;
        }

        public void print(String string) {
            this.print(null, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void print(AttributeSet attributeSet, final String string) {
            if (this.inPrint) {
                return;
            }
            try {
                this.inPrint = true;
                if (this.oldErr != null) {
                    this.oldErr.print(string);
                }
                if (this.log != null) {
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager == null) {
                        this.log.append(string);
                    } else {
                        AccessController.doPrivileged(new PrivilegedAction<Void>(){

                            @Override
                            public Void run() {
                                if (!IO.this.applicationLog) {
                                    throw new SecurityException("Invalid log file");
                                }
                                IO.this.log.append(string);
                                return null;
                            }
                        });
                    }
                }
                if (this.console != null) {
                    this.console.append(attributeSet, string);
                }
            }
            finally {
                this.inPrint = false;
            }
        }

        public MutableAttributeSet printComponent(Component component) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setComponent(simpleAttributeSet, component);
            this.print(simpleAttributeSet, " ");
            return simpleAttributeSet;
        }

        public MutableAttributeSet printError(String string) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setBold(simpleAttributeSet, true);
            StyleConstants.setForeground(simpleAttributeSet, Color.RED);
            this.print(simpleAttributeSet, UI._("Error:"));
            this.printLine(" " + string);
            return simpleAttributeSet;
        }

        public MutableAttributeSet printIcon(Icon icon) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setIcon(simpleAttributeSet, icon);
            this.print(simpleAttributeSet, " ");
            return simpleAttributeSet;
        }

        public void printLine(String string) {
            this.print(string + '\n');
        }

        public void printLine(AttributeSet attributeSet, String string) {
            this.print(attributeSet, string + '\n');
        }

        public void printLine() {
            this.printLine("");
        }

        public void printLine(String string, Object ... objectArray) {
            this.printLine(String.format(string, objectArray));
        }

        public void printLine(AttributeSet attributeSet, String string, Object ... objectArray) {
            this.printLine(attributeSet, String.format(string, objectArray));
        }

        public synchronized void redirectOutput() {
            if (this.printStream != null) {
                return;
            }
            try {
                this.printStream = new PrintStream((OutputStream)this, false, "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                MLogger.exception(unsupportedEncodingException);
                this.printStream = new PrintStream(this);
            }
            this.oldErr = System.err;
            this.oldOut = System.out;
            System.setErr(this.printStream);
            System.setOut(this.printStream);
        }

        public synchronized void shutDown() {
            if (this.oldErr != null) {
                System.setErr(this.oldErr);
            }
            if (this.oldOut != null) {
                System.setOut(this.oldOut);
            }
            if (this.log != null) {
                this.log.close();
            }
            this.oldErr = null;
            this.oldOut = null;
            this.printStream = null;
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            try {
                this.print(this.stdAttr, new String(byArray, "UTF8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.print(this.stdAttr, new String(byArray, n, n2));
        }
    }

    public static final class Frame
    extends MFrame
    implements Control {
        @Override
        public void close(Console console) {
            this.dispose();
        }

        @Override
        public void show(Console console) {
            this.setVisible(true);
        }

        private Frame(Console console) {
            super(UI._("Console"));
            this.setDefaultCloseOperation(2);
            Dimension dimension = UI.WindowSize.MEDIUM.getDimension();
            this.setMinimumSize(new Dimension(dimension.width / 2, dimension.height / 2));
            this.setSize(dimension);
            this.addCenter(console);
        }
    }

    public static interface Control {
        public void close(Console var1);

        public void show(Console var1);
    }

    public static final class Action
    extends MAction {
        public Action() {
            super(UI._("Console"), "ui/console", 75, Action.getMenuMask() | 1);
            this.setMouseGesture("Dcs");
        }

        @Override
        public void onAction() {
            if (((Boolean)Kiosk.consoleEnabled.get()).booleanValue()) {
                Console.getInstance(true);
            }
        }
    }
}

