/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.validator;

import javax.swing.JList;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.makagiga.commons.validator.Validator;

public class ListSelectionValidator
extends Validator<ListSelectionModel> {
    private ListSelectionListener listener;

    public ListSelectionValidator() {
    }

    public ListSelectionValidator(JList jList) {
        super(jList);
    }

    @Override
    protected ListSelectionModel getValue() {
        return ((JList)JList.class.cast(this.getComponent())).getSelectionModel();
    }

    @Override
    protected void install() {
        this.listener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ListSelectionValidator.this.revalidate();
                }
            }
        };
        this.getValue().addListSelectionListener(this.listener);
    }

    @Override
    protected void uninstall() {
        this.getValue().removeListSelectionListener(this.listener);
        this.listener = null;
    }

    @Override
    protected boolean isValid() throws Exception {
        return !this.getValue().isSelectionEmpty();
    }
}

