/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.Window;
import java.io.File;
import java.util.Calendar;
import javax.swing.JComponent;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MCalendar;
import org.makagiga.commons.MCalendarPanel;
import org.makagiga.commons.MColorChooser;
import org.makagiga.commons.MDateSpinner;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MFileChooser;
import org.makagiga.commons.MFontChooser;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.UI;

public final class Input {
    public static Color getColor(Window window, Color color, String string) {
        return MColorChooser.getColor(window, string, color);
    }

    public static Color getColor(Window window, Color color, String string, Color color2) {
        return MColorChooser.getColor(window, string, color, color2);
    }

    public static MCalendar getDateTime(Window window, Calendar calendar, String string, String string2) {
        return Input.getDateTime(window, calendar, string, string2, -1, -1);
    }

    public static MCalendar getDateTime(Window window, Calendar calendar, String string, int n, int n2) {
        return Input.getDateTime(window, calendar, string, null, n, n2);
    }

    public static File getDirectory(Window window, String string, String string2) {
        MFileChooser mFileChooser = MFileChooser.createDirectoryChooser(window, string);
        mFileChooser.setConfigKey(string2);
        if (mFileChooser.openDialog()) {
            return mFileChooser.getSelectedFile();
        }
        return null;
    }

    public static File getImageFile(Window window) {
        return Input.getImageFile(window, UI._("Select an Image"));
    }

    public static File getImageFile(Window window, String string) {
        MFileChooser mFileChooser = MFileChooser.createFileChooser(window, string);
        mFileChooser.addImageIOReaderFilter();
        mFileChooser.setConfigKey("image");
        if (mFileChooser.openDialog()) {
            return mFileChooser.getSelectedFile();
        }
        return null;
    }

    public static Font getFont(Window window, Font font) {
        return MFontChooser.getFont(window, font, null);
    }

    public static Font getFont(Window window, Font font, JComponent jComponent) {
        return MFontChooser.getFont(window, font, jComponent);
    }

    public static char[] getPassword(Window window, String string) {
        return MMessage.enterPassword(window, string, 0);
    }

    public static char[] getPassword(Window window, String string, int n) {
        return MMessage.enterPassword(window, string, n);
    }

    public static String getText(Window window, String string, String string2, String string3, String string4, String string5) {
        return MMessage.input(window, string, string2, string3, string4, string5);
    }

    public static String getText(Window window, String string, String string2, String string3) {
        return MMessage.input(window, string, string2, string3);
    }

    private Input() {
    }

    private static MCalendar getDateTime(Window window, Calendar calendar, String string, String string2, int n, int n2) {
        DateTimeDialog dateTimeDialog = new DateTimeDialog(window, calendar, string, string2, n, n2);
        if (!dateTimeDialog.exec(dateTimeDialog.calendarPanel.getDateSpinner())) {
            return null;
        }
        return dateTimeDialog.calendarPanel.getDateSpinner().toCalendar();
    }

    private static final class DateTimeDialog
    extends MDialog {
        private final MCalendarPanel calendarPanel;

        @Override
        protected void onUserClick() {
            this.calendarPanel.setTodayDate();
        }

        private DateTimeDialog(Window window, Calendar calendar, String string, String string2, int n, int n2) {
            super(window, string, MActionInfo.SET_DATE_TIME.getIconName(), 15);
            this.getUserButton().setIconName(MActionInfo.CURRENT_DATE_AND_TIME.getIconName());
            this.getUserButton().setText(null);
            this.getUserButton().setToolTipText(MActionInfo.CURRENT_DATE_AND_TIME.getText());
            this.calendarPanel = new MCalendarPanel();
            this.calendarPanel.setClearTime(false);
            this.calendarPanel.setShowInfo(false);
            this.calendarPanel.setTodayButtonVisible(false);
            this.calendarPanel.setValue(calendar.getTime());
            MDateSpinner mDateSpinner = this.calendarPanel.getDateSpinner();
            UI.changeFontSize(mDateSpinner, 4);
            if (string2 == null) {
                mDateSpinner.setDateTimeFormat(n, n2);
            } else {
                mDateSpinner.setSimpleFormat(string2);
            }
            this.addCenter(this.calendarPanel);
            this.pack();
        }
    }
}

