/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.proxy;

import java.io.IOException;
import java.net.Proxy;
import javax.swing.DefaultCellEditor;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import org.makagiga.commons.ActionGroup;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MComboBox;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MRadioButton;
import org.makagiga.commons.MScrollPane;
import org.makagiga.commons.MTable;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.UI;
import org.makagiga.commons.proxy.ProxyInfo;
import org.makagiga.commons.proxy.ProxyManager;
import org.makagiga.commons.proxy.ProxyModel;

public final class ProxyPanel
extends MPanel {
    private ActionGroup actionGroup;
    private MRadioButton useCustomProxy;
    private MRadioButton useSystemProxy;
    private ProxyModel model;
    private Table table;

    public ProxyPanel(ProxyModel proxyModel) {
        super(1);
        this.model = proxyModel;
    }

    public void apply() {
        this.model.setEnabled(this.useCustomProxy.isSelected());
        this.model.setSystem(this.useSystemProxy.isSelected());
        try {
            this.model.write(ProxyManager.getDefaultFile());
        }
        catch (IOException iOException) {
            MMessage.error(this.getWindowAncestor(), iOException);
        }
        ProxyManager.init();
    }

    protected void deleteProxy() {
        this.table.deleteSelected(this.getWindowAncestor(), null, 1);
    }

    protected void init() {
        this.actionGroup = new ActionGroup("proxy-panel", UI._("Connection Settings"));
        this.actionGroup.add("new", new MAction(MActionInfo.NEW){

            @Override
            public void onAction() {
                ProxyPanel.this.newProxy();
            }
        });
        this.actionGroup.addSeparator();
        this.actionGroup.add("delete", new MAction(MActionInfo.DELETE){

            @Override
            public void onAction() {
                ProxyPanel.this.deleteProxy();
            }
        });
        MRadioButton mRadioButton = new MRadioButton(UI._("No Proxy")){

            @Override
            protected void onClick() {
                ProxyPanel.this.updateComponents();
            }
        };
        this.add(mRadioButton);
        this.addContentGap();
        this.add(new MLabel(UI._("Connect to the Internet using Proxy Servers:")));
        this.addGap();
        this.useSystemProxy = new MRadioButton(UI._("Use system configuration")){

            @Override
            protected void onClick() {
                ProxyPanel.this.updateComponents();
            }
        };
        this.add(this.useSystemProxy);
        this.addGap();
        this.useCustomProxy = new MRadioButton(UI._("Use custom configuration:")){

            @Override
            protected void onClick() {
                ProxyPanel.this.updateComponents();
                if (this.isSelected()) {
                    ProxyPanel.this.table.requestFocusInWindow();
                }
            }
        };
        this.add(this.useCustomProxy);
        MToolBar mToolBar = new MToolBar(MIcon.Size.MEDIUM);
        mToolBar.setTextPosition(MToolBar.TextPosition.ALONGSIDE_ICONS);
        this.model.getUndoManager().updateToolBar(mToolBar);
        mToolBar.addSeparator();
        this.actionGroup.updateToolBar(mToolBar);
        mToolBar.readConfig("proxy");
        mToolBar.setOpaque(false);
        this.setIndentBorder(mToolBar);
        this.add(mToolBar);
        this.table = new Table(this.model);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ProxyPanel.this.updateActions();
            }
        });
        this.actionGroup.installPopupMenu(this.table);
        MLabel mLabel = MLabel.createFor(this.table, UI._("Proxy Servers:"));
        this.setIndentBorder(mLabel);
        this.add(mLabel);
        this.addGap();
        MScrollPane mScrollPane = new MScrollPane(this.table);
        mScrollPane.setMaximumHeight(100);
        this.add(mScrollPane);
        UI.group(mRadioButton, this.useSystemProxy, this.useCustomProxy);
        if (this.model.isSystem()) {
            this.useSystemProxy.setSelected(true);
        } else if (this.model.isEnabled()) {
            this.useCustomProxy.setSelected(true);
        } else {
            mRadioButton.setSelected(true);
        }
        this.updateComponents();
    }

    protected void newProxy() {
        ProxyInfo proxyInfo = new ProxyInfo();
        proxyInfo.setEnabled(true);
        this.model.addRow(proxyInfo);
        this.table.selectRow(this.table.getRowCount() - 1);
    }

    protected void updateActions() {
        this.model.getUndoManager().updateUndoRedoActions(this.table.isEnabled());
        this.actionGroup.setEnabled("new", this.useCustomProxy.isSelected());
        this.actionGroup.setEnabled("delete", this.useCustomProxy.isSelected() && this.table.isSelection());
    }

    protected void updateComponents() {
        this.table.setEnabled(this.useCustomProxy.isSelected());
        this.updateActions();
    }

    private static final class Table
    extends MTable<ProxyModel> {
        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            int n3 = this.convertColumnIndexToModel(n2);
            if (n3 == 4) {
                int n4 = this.convertRowIndexToModel(n);
                Proxy.Type type = ((ProxyInfo)((ProxyModel)this.getModel()).getRowAt(n4)).getType();
                MComboBox mComboBox = new MComboBox();
                mComboBox.addItem((Proxy.Type)Proxy.Type.HTTP);
                mComboBox.addItem((Proxy.Type)Proxy.Type.SOCKS);
                mComboBox.setSelectedItem((Object)type);
                return new DefaultCellEditor(mComboBox);
            }
            return super.getCellEditor(n, n2);
        }

        private Table(ProxyModel proxyModel) {
            super(proxyModel);
        }
    }
}

