/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.print;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.makagiga.commons.CoolHeader;
import org.makagiga.commons.Flags;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MNumberSpinner;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MTimer;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.print.PrintInfo;

public class PrintPreviewPanel
extends MPanel {
    private boolean inPageNumberUpdate;
    private Border shadowBorder;
    private final CoolHeader errorLabel;
    private int pageCount;
    private MLabel pageLabel;
    private MNumberSpinner<Integer> pageNumber;
    private MPanel pagePanel;
    private MToolBar toolBar;
    private MTimer calcPageCountTimer;
    private final PrintInfo printInfo;
    Flags flags = new Flags();
    int orientation = 1;
    MLabel preview;

    public PrintPreviewPanel(PrintInfo printInfo) {
        this.printInfo = printInfo;
        this.createPagePanel();
        this.createToolBar();
        this.preview = new MLabel();
        this.preview.setHorizontalAlignment(0);
        this.preview.setVerticalAlignment(1);
        this.preview.setStyle("font-weight: bold; margin: " + this.getContentMargin());
        this.preview.setToolTipText(UI._("Print Preview"));
        this.addCenter(this.preview, 1);
        this.errorLabel = new CoolHeader();
        this.errorLabel.setVisible(false);
        this.addSouth(this.errorLabel);
    }

    public MPanel getPagePanel() {
        return this.pagePanel;
    }

    @Deprecated
    public MToolBar getToolBar() {
        return this.toolBar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(boolean bl) {
        Printable printable = this.getPrintable();
        if (printable == null) {
            this.setInfo(UI._("Preview not available"));
            this.pageLabel.setVisible(false);
            this.pageNumber.setEnabled(false);
        } else {
            if (bl) {
                try {
                    this.inPageNumberUpdate = true;
                    this.pageNumber.setNumber(1);
                }
                finally {
                    this.inPageNumberUpdate = false;
                }
                this.calcPageCount();
            }
            this.generatePreview(printable);
        }
    }

    protected void shutdown() {
        if (this.calcPageCountTimer != null) {
            this.calcPageCountTimer.stop();
        }
    }

    private void calcPageCount() {
        this.shutdown();
        this.pageCount = 0;
        final Printable printable = this.getPrintable();
        this.calcPageCountTimer = new MTimer(200){

            @Override
            protected boolean onTimeout() {
                if (PrintPreviewPanel.this.generatePreview(printable, PrintPreviewPanel.this.pageCount, false) != null) {
                    PrintPreviewPanel.this.pageCount++;
                    PrintPreviewPanel.this.updateComponents();
                    return true;
                }
                this.stop();
                PrintPreviewPanel.this.updateComponents();
                return false;
            }
        };
        this.calcPageCountTimer.start();
    }

    private void createPagePanel() {
        this.pagePanel = MPanel.createVBoxPanel();
        this.pagePanel.addGap();
        this.pageLabel = new MLabel();
        this.pagePanel.add(this.pageLabel);
        this.pagePanel.addGap();
        this.pageNumber = new MNumberSpinner();
        this.pageNumber.setRange((Comparable<Integer>)1, (Comparable<Integer>)Integer.MAX_VALUE);
        this.pageNumber.setNumber(1);
        this.pageNumber.setToolTipText(UI._("Page"));
        this.pageNumber.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!PrintPreviewPanel.this.inPageNumberUpdate) {
                    PrintPreviewPanel.this.refresh(false);
                }
            }
        });
        this.pageLabel.setLabelFor(this.pageNumber);
        this.pagePanel.add(this.pageNumber);
    }

    private void createToolBar() {
        this.toolBar = new MToolBar(1);
        this.toolBar.setTextPosition(MToolBar.TextPosition.ALONGSIDE_ICONS);
        this.toolBar.add(this.getPagePanel());
        this.toolBar.readConfig("print-preview");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generatePreview(Printable printable) {
        Printable printable2 = printable;
        synchronized (printable2) {
            BufferedImage bufferedImage = this.generatePreview(printable, this.pageNumber.getNumber() - 1, true);
            if (bufferedImage == null) {
                this.setInfo(UI._("No such page/empty page: {0}", this.pageNumber.getNumber()));
            } else {
                this.errorLabel.setVisible(false);
                this.preview.setImage(bufferedImage);
                this.preview.setPreferredSize(new Dimension(bufferedImage.getWidth() + this.getContentMargin() * 4, bufferedImage.getHeight() + this.getContentMargin() * 4));
                this.preview.setText(null);
            }
            this.updateComponents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage generatePreview(Printable printable, int n, boolean bl) {
        int n2;
        PageFormat pageFormat = this.getPageFormat();
        int n3 = (int)pageFormat.getWidth() + 5;
        int n4 = (int)pageFormat.getHeight() + 5;
        BufferedImage bufferedImage = UI.createCompatibleImage(n3, n4, false);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (this.shadowBorder == null) {
            this.shadowBorder = UI.createDropShadowBorder();
        }
        if (this.shadowBorder != null) {
            n2 = 6;
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(0, 0, n3 - n2, n4 - n2);
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawRect(0, 0, n3 - n2, n4 - n2);
            Color color = this.getBackground();
            if (color == null) {
                color = Color.WHITE;
            }
            graphics2D.setColor(color);
            graphics2D.fillRect(n3 - 5, 0, 5, n4);
            graphics2D.fillRect(0, n4 - 5, n3 - 5, 5);
            this.shadowBorder.paintBorder(this, graphics2D, 0, 0, n3, n4);
        } else {
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(0, 0, n3 - 1, n4 - 1);
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawRect(0, 0, n3 - 1, n4 - 1);
        }
        try {
            if (bl) {
                UI.setWaitCursor(this, true);
            }
            if ((n2 = printable.print(graphics2D, pageFormat, n)) == 1) {
                bufferedImage = null;
            }
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            MLogger.exception(negativeArraySizeException);
        }
        catch (PrinterException printerException) {
            MLogger.exception(printerException);
            this.setError(printerException.getLocalizedMessage());
        }
        finally {
            graphics2D.dispose();
            if (bl) {
                UI.setWaitCursor(this, false);
            }
        }
        return bufferedImage;
    }

    private PageFormat getPageFormat() {
        PageFormat pageFormat = new PageFormat();
        pageFormat.setOrientation(this.orientation);
        return pageFormat;
    }

    private Printable getPrintable() {
        try {
            return this.printInfo.getPrintable(this.flags);
        }
        catch (PrinterException printerException) {
            MLogger.exception(printerException);
            this.setError(printerException.getLocalizedMessage());
            return null;
        }
    }

    private void setError(String string) {
        this.errorLabel.setVisible(true);
        this.errorLabel.setErrorMessage(string);
    }

    private void setInfo(String string) {
        this.errorLabel.setVisible(true);
        this.errorLabel.setWarningMessage(string);
    }

    private void updateComponents() {
        this.pageLabel.setHTML(UI._("Page {0} of {1}", "<b>" + Math.max(Math.min(this.pageNumber.getNumber(), this.pageCount), 1) + "</b>", "<b>" + Math.max(this.pageCount, 1) + (this.calcPageCountTimer.isRunning() ? "+" : "") + "</b>"));
    }

    void dispose() {
        this.calcPageCountTimer = TK.dispose(this.calcPageCountTimer);
        this.pageNumber = null;
        this.preview.setIcon(null);
    }
}

