/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.preview;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;
import org.makagiga.commons.FS;
import org.makagiga.commons.FileCache;
import org.makagiga.commons.MGuardedObject;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MProperties;
import org.makagiga.commons.MZip;
import org.makagiga.commons.PermissionInfo;
import org.makagiga.commons.RegExp;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.preview.AbstractPreview;
import org.makagiga.commons.preview.Preview;
import org.makagiga.commons.request.AbstractRequestManager;
import org.makagiga.commons.request.RequestInfo;
import org.makagiga.commons.request.RequestProperties;
import org.makagiga.commons.request.RequestSource;

public final class DefaultPreview
extends AbstractRequestManager<Result>
implements Preview {
    private final Map<String, Preview> handlers = new HashMap<String, Preview>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(String string, Preview preview) {
        TK.checkNull(preview, "preview");
        DefaultPreview defaultPreview = this;
        synchronized (defaultPreview) {
            this.handlers.put(TK.toUpperCase(string), preview);
        }
    }

    @Override
    public synchronized Image getImage(File file, int n, MProperties mProperties) throws Exception {
        Preview preview;
        File file2;
        mProperties.clear();
        FileCache fileCache = FileCache.getInstance();
        long l = file.lastModified();
        String string = FS.getPortableConfigPath(file.getPath());
        String string2 = string + "-" + n;
        String string3 = string + "-" + n + "-properties";
        File file3 = fileCache.getFile(string3, l);
        if (file3 != null) {
            try {
                mProperties.loadUTF8(file3);
                MLogger.info("preview", "Using cached properties: %s (%s)", file3.getName(), file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((file2 = fileCache.getFile(string2, l)) != null) {
            MLogger.info("preview", "Using cached thumbnail: %s (%s)", file2.getName(), file);
            try {
                return ImageIO.read(file2);
            }
            catch (Exception exception) {
                MLogger.exception(exception);
                fileCache.removeItem(string2);
            }
        }
        if ((preview = this.getPreview(FS.getExtension(file))) == null) {
            return null;
        }
        if (file.length() == 0L) {
            return null;
        }
        try {
            Image image = preview.getImage(file, n, mProperties);
            if (image != null) {
                if (preview.shouldScale(file)) {
                    image = DefaultPreview.scale(image, n);
                } else if (image instanceof BufferedImage && image.getWidth(null) > n) {
                    BufferedImage bufferedImage = (BufferedImage)image;
                    image = bufferedImage.getSubimage(0, 0, n, Math.min(bufferedImage.getHeight(), n));
                }
                file2 = fileCache.createFile(string2, l, ".png", "preview");
                ImageIO.write((RenderedImage)UI.toBufferedImage(image, true), "png", file2);
            }
            if (!mProperties.isEmpty()) {
                if (file3 == null) {
                    file3 = fileCache.createFile(string3, l, ".properties", "preview");
                }
                mProperties.setSafeStore(true);
                mProperties.storeUTF8(file3);
            }
            return image;
        }
        catch (Exception exception) {
            fileCache.removeItem(string2);
            fileCache.removeItem(string3);
            throw exception;
        }
    }

    public static DefaultPreview getInstance() {
        return (DefaultPreview)LazyDefaultPreviewHolder.INSTANCE.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Preview getPreview(String string) {
        if (TK.isEmpty(string)) {
            return null;
        }
        String string2 = TK.toUpperCase(string);
        DefaultPreview defaultPreview = this;
        synchronized (defaultPreview) {
            for (Map.Entry<String, Preview> entry : this.handlers.entrySet()) {
                String string3 = entry.getKey();
                if ("*".equals(string3) || !string2.equals(string3)) continue;
                return entry.getValue();
            }
            return this.handlers.get("*");
        }
    }

    public static synchronized BufferedImage getTextImage(File file, int n) throws Exception {
        return DefaultPreview.getTextImage(FS.read(file, "UTF8"), n);
    }

    public static synchronized BufferedImage getTextImage(String string, int n) {
        if (TK.isEmpty(string)) {
            return null;
        }
        int n2 = n;
        int n3 = n;
        BufferedImage bufferedImage = UI.createCompatibleImage(n2, n3, false);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, n2, n3);
        Font font = new Font("DialogInput", 0, UI.getDefaultFontSize() - 1);
        graphics2D.setFont(font);
        UI.setTextAntialiasing(graphics2D, null);
        UI.paintText(1, graphics2D, new Rectangle(0, 0, n2, n3), null, Color.BLACK, string.split("\n"));
        graphics2D.dispose();
        return bufferedImage;
    }

    public synchronized void removeHandler(String string) {
        this.handlers.remove(TK.toUpperCase(string));
    }

    public synchronized void removePreview(File file) {
        FileCache fileCache = FileCache.getInstance();
        String string = Pattern.quote(FS.getPortableConfigPath(file.getPath()));
        fileCache.removeItem(new RegExp(string + "\\-\\d+|" + string + "\\-\\d+\\-properties"));
        string = Pattern.quote(file.getPath());
        fileCache.removeItem(new RegExp(string + "\\-\\d+|" + string + "\\-\\d+\\-properties"));
    }

    public synchronized RequestInfo<Result> requestPreview(RequestSource<Result> requestSource, File file, int n) {
        MLogger.info("preview", "\"%s\" requested preview of \"%s\" (%d)", requestSource, file, n);
        RequestProperties requestProperties = new RequestProperties();
        requestProperties.put("file", file);
        requestProperties.put("width", n);
        return this.startRequest(requestSource, requestProperties);
    }

    public static synchronized Image scale(Image image, int n) {
        if (image == null) {
            return null;
        }
        if (image.getWidth(null) > n) {
            BufferedImage bufferedImage = UI.createCompatibleImage(n, n, true);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            double d = UI.getAutoScale(image, new Dimension(n, n));
            graphics2D.scale(d, d);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.drawImage(image, 0, 0, null);
            graphics2D.dispose();
            return bufferedImage;
        }
        return image;
    }

    @Override
    public boolean shouldScale(File file) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Image getHTMLImage(File file, int n) throws Exception {
        int n2;
        int n3;
        String string = FS.read(file, "UTF8");
        if (string != null) {
            n3 = (string = string.replace("<html xmlns=\"http://www.w3.org/1999/xhtml\">", "<html>")).indexOf("<head>");
            if (n3 != -1 && (n2 = string.indexOf("</head>")) != -1 && n2 > n3) {
                string = string.substring(0, n3) + string.substring(n2 + "</head>".length());
            }
            string = string.replaceAll("<body>|</body>", "");
        }
        if (BasicHTML.isHTMLString(string)) {
            n3 = n;
            n2 = n;
            JTextField jTextField = new JTextField();
            UI.setFixedSize(jTextField, n3, n2);
            View view = BasicHTML.createHTMLView(jTextField, string);
            view.setSize(n3, n2);
            BufferedImage bufferedImage = UI.createCompatibleImage(n3, n2, false);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(0, 0, n3, n2);
            Rectangle rectangle = new Rectangle(0, 0, n3, n2);
            graphics2D.setClip(rectangle);
            try {
                view.paint(graphics2D, rectangle);
            }
            catch (Exception exception) {
                MLogger.exception(exception);
            }
            finally {
                graphics2D.dispose();
            }
            return bufferedImage;
        }
        return DefaultPreview.getTextImage(string, n);
    }

    @Override
    protected Result getResult(RequestInfo<Result> requestInfo) throws Exception {
        MLogger.info("preview", "Getting preview for \"%s\"...", requestInfo.getSource());
        try {
            MProperties mProperties = new MProperties();
            Image image = this.getImage(requestInfo.getProperty("file", null), requestInfo.getProperty("width", 0), mProperties);
            return new Result(image, mProperties);
        }
        catch (Error error) {
            MLogger.exception(error);
            return null;
        }
    }

    private DefaultPreview() {
        super(1, 150L);
        AbstractPreview abstractPreview = new AbstractPreview(false){

            @Override
            public Image getImage(File file, int n, MProperties mProperties) throws Exception {
                return DefaultPreview.getTextImage(file, n);
            }
        };
        this.addHandler("HTM", abstractPreview);
        this.addHandler("HTML", abstractPreview);
        AbstractPreview abstractPreview2 = new AbstractPreview(true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Image getImage(File file, int n, MProperties mProperties) throws Exception {
                String string = FS.getExtension(file);
                if (string == null) {
                    return null;
                }
                Iterator<ImageReader> iterator = ImageIO.getImageReadersBySuffix(string);
                if (!iterator.hasNext()) {
                    return null;
                }
                BufferedImage bufferedImage = null;
                ImageInputStream imageInputStream = null;
                ImageReader imageReader = iterator.next();
                try {
                    imageInputStream = ImageIO.createImageInputStream(file);
                    imageReader.setInput(imageInputStream);
                    float f = (float)n * 4.2f;
                    int n2 = Math.max(imageReader.getHeight(0), imageReader.getWidth(0));
                    int n3 = (int)((float)n2 / f);
                    ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
                    if (n3 > 1) {
                        imageReadParam.setSourceSubsampling(n3, n3, 0, 0);
                    }
                    bufferedImage = imageReader.read(0, imageReadParam);
                }
                finally {
                    imageInputStream.close();
                    imageReader.dispose();
                }
                if (bufferedImage != null) {
                    mProperties.setPropertyValue("image-width-property", bufferedImage.getWidth(null));
                    mProperties.setPropertyValue("image-height-property", bufferedImage.getHeight(null));
                    mProperties.setPropertyValue("image-width-bpp", bufferedImage.getColorModel().getPixelSize());
                    mProperties.setProperty("image-type-property", TK.toUpperCase(string));
                }
                return bufferedImage;
            }
        };
        this.addHandler("BMP", abstractPreview2);
        this.addHandler("GIF", abstractPreview2);
        this.addHandler("JPG", abstractPreview2);
        this.addHandler("JPEG", abstractPreview2);
        this.addHandler("PNG", abstractPreview2);
        AbstractPreview abstractPreview3 = new AbstractPreview(false){

            @Override
            public Image getImage(File file, int n, MProperties mProperties) throws Exception {
                return DefaultPreview.getTextImage(file, n);
            }
        };
        this.addHandler("TXT", abstractPreview3);
        AbstractPreview abstractPreview4 = new AbstractPreview(false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Image getImage(File file, int n, MProperties mProperties) throws Exception {
                MZip mZip = null;
                try {
                    mZip = MZip.read(file);
                    StringBuilder stringBuilder = new StringBuilder(1024);
                    for (ZipEntry zipEntry : mZip) {
                        stringBuilder.append(zipEntry.getName()).append('\n');
                    }
                    BufferedImage bufferedImage = DefaultPreview.getTextImage(stringBuilder.toString(), n);
                    return bufferedImage;
                }
                finally {
                    FS.close(mZip);
                }
            }
        };
        this.addHandler("ZIP", abstractPreview4);
    }

    private static final class LazyDefaultPreviewHolder {
        private static final MGuardedObject<DefaultPreview> INSTANCE = new MGuardedObject<DefaultPreview>(new DefaultPreview(), "org.makagiga.commons.preview.DefaultPreview", PermissionInfo.ThreatLevel.LOW, "Preview");

        private LazyDefaultPreviewHolder() {
        }
    }

    public static class Result {
        private final Image image;
        private final MProperties properties;

        public Image getImage() {
            return this.image;
        }

        public MProperties getProperties() {
            return this.properties;
        }

        private Result(Image image, MProperties mProperties) {
            this.image = image;
            this.properties = mProperties;
        }
    }
}

