/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.icons;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.makagiga.commons.FileCache;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.Net;
import org.makagiga.commons.UI;
import org.makagiga.commons.request.AbstractRequestManager;
import org.makagiga.commons.request.RequestInfo;
import org.makagiga.commons.request.RequestProperties;
import org.makagiga.commons.request.RequestSource;

public class Favicon
extends MIcon
implements RequestSource<Image> {
    public static final int DEFAULT_FAVICON_SIZE = 16;
    private static BufferedImage DUMMY_IMAGE = UI.createCompatibleImage(16, 16, true);
    private static FaviconRequestManager _frm;
    private static final MLogger log;
    private RequestInfo<Image> requestInfo;
    private URL iconURL;

    public Favicon(ImageObserver imageObserver, URL uRL) {
        this(imageObserver, uRL, false, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Favicon(ImageObserver imageObserver, URL uRL, boolean bl, int n) {
        super(DUMMY_IMAGE);
        Object object;
        Object object2;
        this.setImageObserver(imageObserver);
        try {
            if (bl) {
                this.iconURL = uRL;
            } else {
                object2 = uRL.toString();
                object = uRL.getFile();
                if (!((String)object).isEmpty()) {
                    object2 = ((String)object2).replaceAll(Pattern.quote((String)object) + "$", "");
                }
                this.iconURL = new URL((String)object2 + "/favicon.ico");
            }
        }
        catch (MalformedURLException malformedURLException) {
            MLogger.exception(malformedURLException);
            this.iconURL = uRL;
        }
        log.debugFormat("Using icon URL: %s", this.iconURL);
        object2 = Favicon.class;
        synchronized (Favicon.class) {
            if (_frm == null) {
                _frm = new FaviconRequestManager();
            }
            object = new RequestProperties();
            ((HashMap)object).put("iconURL", this.iconURL);
            ((HashMap)object).put("size", n);
            this.requestInfo = _frm.startRequest(this, (RequestProperties)object);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public synchronized void cancelRequest() {
        if (this.requestInfo != null) {
            this.requestInfo.setCancelled(true);
            this.requestInfo = null;
        }
    }

    public URL getIconURL() {
        return this.iconURL;
    }

    @Override
    public void requestDone(RequestInfo<Image> requestInfo, Image image) {
        if (image != null) {
            this.setImage(image);
            if (this.getImageObserver() != null) {
                this.getImageObserver().imageUpdate(image, 32, 0, 0, image.getWidth(null), image.getHeight(null));
            }
        }
    }

    static {
        log = MLogger.get("favicon");
    }

    private static final class FaviconRequestManager
    extends AbstractRequestManager<Image> {
        @Override
        protected Image getResult(RequestInfo<Image> requestInfo) throws Exception {
            URL uRL = requestInfo.getProperty("iconURL", null);
            FileCache fileCache = FileCache.getInstance();
            File file = fileCache.getFile(uRL);
            if (file != null && file.exists() && file.length() == 0L) {
                log.debugFormat("No favicon: %s", uRL);
                return null;
            }
            file = null;
            Net.DownloadInfo downloadInfo = new Net.DownloadInfo(uRL, ".favicon", 3);
            try {
                downloadInfo.startDownload();
                file = downloadInfo.getFile();
                if (file == null) {
                    return null;
                }
            }
            catch (IOException iOException) {
                fileCache.createFile(uRL, Long.MIN_VALUE, ".favicon", "download");
                if (MLogger.isDeveloper()) {
                    MLogger.exception(iOException);
                }
                return null;
            }
            Image image = null;
            int n = requestInfo.getProperty("size", 16);
            if (uRL.getPath().endsWith(".ico")) {
                List<Image> list = MIcon.getIcoImages(file);
                for (Image image2 : list) {
                    if (image2.getWidth(null) != n || image2.getHeight(null) != n) continue;
                    image = image2;
                    break;
                }
                if (image == null && !list.isEmpty()) {
                    image = list.get(0);
                }
            } else {
                image = ImageIO.read(file);
            }
            if (image != null && (((Image)image).getWidth(null) != n || ((Image)image).getHeight(null) != n)) {
                image = UI.scaleImage(image, n, n, UI.Quality.HIGH);
            }
            return image;
        }

        private FaviconRequestManager() {
            super(1, 100L);
        }
    }
}

