/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.crypto;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import javax.crypto.Mac;
import org.makagiga.commons.TK;

public final class CryptoUtils {
    public static void clear(byte[] byArray) {
        if (byArray != null) {
            Arrays.fill(byArray, (byte)0);
        }
    }

    public static void clear(char[] cArray) {
        if (cArray != null) {
            Arrays.fill(cArray, '\u0000');
        }
    }

    public static byte[] createSalt(int n) {
        byte[] byArray = new byte[n];
        new SecureRandom().nextBytes(byArray);
        return byArray;
    }

    public static byte[] parseByteArray(String string) throws ParseException {
        if (string == null) {
            return TK.EMPTY_BYTE_ARRAY;
        }
        try {
            List<String> list = TK.fastSplit(string, ',');
            byte[] byArray = new byte[list.size()];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = Byte.parseByte(list.get(i));
            }
            return byArray;
        }
        catch (NumberFormatException numberFormatException) {
            ParseException parseException = new ParseException(numberFormatException.getMessage(), 0);
            parseException.initCause(numberFormatException);
            throw parseException;
        }
    }

    public static String toString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(Byte.toString(by));
        }
        return stringBuilder.toString();
    }

    private CryptoUtils() {
    }

    public static final class MacOutputStream
    extends FilterOutputStream {
        private final Mac mac;

        public MacOutputStream(OutputStream outputStream, Mac mac) {
            super(outputStream);
            this.mac = TK.checkNull(mac);
        }

        public Mac getMac() {
            return this.mac;
        }

        @Override
        public void write(int n) throws IOException {
            this.out.write(n);
            this.mac.update((byte)n);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.out.write(byArray, n, n2);
            this.mac.update(byArray, n, n2);
        }
    }

    public static final class MacInputStream
    extends FilterInputStream {
        private final Mac mac;

        public MacInputStream(InputStream inputStream, Mac mac) {
            super(inputStream);
            this.mac = TK.checkNull(mac);
        }

        public Mac getMac() {
            return this.mac;
        }

        @Override
        public int read() throws IOException {
            int n = this.in.read();
            if (n != -1) {
                this.mac.update((byte)n);
            }
            return n;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.in.read(byArray, n, n2);
            if (n3 > 0) {
                this.mac.update(byArray, n, n3);
            }
            return n3;
        }
    }
}

