/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.beans;

import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.makagiga.commons.Flags;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.StringList;
import org.makagiga.commons.TK;
import org.makagiga.commons.WTFError;
import org.makagiga.commons.beans.ContainerDelegate;

public abstract class AbstractBeanInfo
extends SimpleBeanInfo {
    @Deprecated
    public static final String DEFAULT_SEARCH_PATH = "makagiga.beans.infos";
    @Deprecated
    protected Class<?> beanClass;
    protected static final int PREFERRED = 1;
    protected static final int BOUND = 2;
    protected static final int EXPERT = 4;
    protected static final int HIDDEN = 8;
    private final BeanDescriptor beanDescriptor;
    private static boolean initDone;
    private String iconName;

    public AbstractBeanInfo(Class<?> clazz, String string) {
        this.beanClass = TK.checkNull(clazz, "beanClass");
        this.beanDescriptor = new BeanDescriptor(clazz);
        this.beanDescriptor.setDisplayName(TK.checkNull(string, "displayName"));
        for (Method method : clazz.getMethods()) {
            if (!method.isAnnotationPresent(ContainerDelegate.class)) continue;
            this.setContainer(true, method.getName());
            break;
        }
    }

    @Deprecated
    public static synchronized void addBeanInfoSearchPath(String string) {
        TK.checkNullOrEmpty(string, "path");
        String[] stringArray = Introspector.getBeanInfoSearchPath();
        StringList stringList = new StringList();
        if (stringArray != null) {
            stringList.addAll(stringArray);
        }
        if (!stringList.contains(string)) {
            stringList.add(string);
        }
        Introspector.setBeanInfoSearchPath(stringList.toArray());
    }

    @Override
    public BeanInfo[] getAdditionalBeanInfo() {
        try {
            return new BeanInfo[]{Introspector.getBeanInfo(this.beanClass.getSuperclass())};
        }
        catch (IntrospectionException introspectionException) {
            throw new WTFError(introspectionException);
        }
    }

    @Override
    public BeanDescriptor getBeanDescriptor() {
        return this.beanDescriptor;
    }

    @Override
    public Image getIcon(int n) {
        if (this.iconName == null) {
            return null;
        }
        switch (n) {
            case 1: 
            case 3: {
                return MIcon.stock(this.iconName, 16).getImage();
            }
            case 2: 
            case 4: {
                return MIcon.stock(this.iconName, 32).getImage();
            }
        }
        return null;
    }

    @Deprecated
    public static synchronized void init() {
        if (!initDone) {
            initDone = true;
            if (Beans.isDesignTime()) {
                AbstractBeanInfo.addBeanInfoSearchPath(DEFAULT_SEARCH_PATH);
            }
        }
    }

    protected PropertyDescriptor createEventsControlPropertyDescriptor() {
        return this.createPropertyDescriptor("eventsEnabled", 8, "Whether or not \"onChange\" event handler method is enabled");
    }

    protected PropertyDescriptor createIconNamePropertyDescriptor() {
        return this.createPropertyDescriptor("iconName", 1, "The icon name (example: ui/ok)");
    }

    protected PropertyDescriptor createMouseWheelEventsControlPropertyDescriptor() {
        return this.createPropertyDescriptor("mouseWheelEventsEnabled", 1, "Whether or not additional mouse wheel support is enabled");
    }

    protected PropertyDescriptor createPropertyDescriptor(String string, int n, String string2) {
        TK.checkNullOrEmpty(string, "propertyName");
        try {
            Flags flags = new Flags(n);
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(string, this.beanClass);
            propertyDescriptor.setBound(flags.isSet(2L));
            propertyDescriptor.setExpert(flags.isSet(4L));
            propertyDescriptor.setHidden(flags.isSet(8L));
            propertyDescriptor.setPreferred(flags.isSet(1L));
            propertyDescriptor.setShortDescription(string2);
            return propertyDescriptor;
        }
        catch (IntrospectionException introspectionException) {
            throw new IllegalArgumentException(introspectionException);
        }
    }

    protected PropertyDescriptor createValuePropertyDescriptor(boolean bl) {
        int n = 1;
        if (bl) {
            n |= 2;
        }
        return this.createPropertyDescriptor("value", n, "The selected value");
    }

    protected void setContainer(boolean bl, String string) {
        if (string != null) {
            this.beanDescriptor.setValue("containerDelegate", string);
        }
        this.beanDescriptor.setValue("isContainer", bl);
    }

    protected void setEnum(PropertyDescriptor propertyDescriptor, Enum<?>[] enumArray) {
        EnumItem[] enumItemArray = new EnumItem[enumArray.length];
        for (int i = 0; i < enumArray.length; ++i) {
            Enum<?> enum_ = enumArray[i];
            enumItemArray[i] = new EnumItem(enum_.toString(), enum_, enum_.getClass().getName().replace('$', '.') + "." + enum_.name());
        }
        this.setEnum(propertyDescriptor, enumItemArray);
    }

    protected void setEnum(PropertyDescriptor propertyDescriptor, EnumItem ... enumItemArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>(enumItemArray.length * 3);
        for (EnumItem enumItem : enumItemArray) {
            arrayList.add(enumItem.getDisplayName());
            arrayList.add(enumItem.getValue());
            arrayList.add(enumItem.getCode());
        }
        propertyDescriptor.setValue("enumerationValues", arrayList.toArray());
    }

    protected void setIconName(String string) {
        this.iconName = string;
    }

    public static final class EnumItem {
        private final Object value;
        private final String code;
        private final String displayName;

        public EnumItem(String string, Object object, String string2) {
            this.displayName = TK.checkNullOrEmpty(string, "displayName");
            this.value = TK.checkNull(object, "value");
            this.code = TK.checkNullOrEmpty(string2, "code");
        }

        public String getCode() {
            return this.code;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

