/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JViewport;
import org.makagiga.commons.MScrollPane;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;

public final class Watermark {
    public static final int MEDIUM = 64;
    public static final int LARGE = 128;
    public static final int ORIGINAL = -1;
    private boolean initViewport = true;
    private Image image;
    private int imageHeight;
    private int imageWidth;
    private int margin;

    public Watermark(Image image, int n) {
        this(image, n, 0);
    }

    public Watermark(Image image, int n, int n2) {
        TK.checkNull(image, "image");
        if (n == -1) {
            this.image = image;
            this.imageWidth = image.getWidth(null);
            this.imageHeight = image.getHeight(null);
        } else {
            this.image = UI.scaleImage(image, n, n, UI.Quality.MEDIUM);
            this.imageWidth = n;
            this.imageHeight = n;
        }
        this.margin = n2;
    }

    public void paint(JComponent jComponent, Graphics graphics) {
        Dimension dimension;
        Point point;
        if (this.image == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        JViewport jViewport = MScrollPane.getViewport(jComponent);
        if (this.initViewport) {
            this.initViewport = false;
            if (jViewport != null) {
                jViewport.setScrollMode(0);
            }
        }
        if (jViewport == null) {
            point = new Point();
            dimension = jComponent.getSize();
        } else {
            point = jViewport.getViewPosition();
            dimension = jViewport.getSize();
        }
        graphics2D.setComposite(AlphaComposite.SrcOver.derive(0.1f));
        graphics2D.drawImage(this.image, point.x + (dimension.width - this.imageWidth - this.margin), point.y + (dimension.height - this.imageHeight - this.margin), null);
    }
}

