/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.io.Serializable;
import java.util.Arrays;
import org.makagiga.commons.TK;

public abstract class Tuple
implements Serializable {
    protected Object[] array;
    private transient int hash;

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Tuple)) {
            return false;
        }
        return Arrays.equals(this.array, ((Tuple)Tuple.class.cast((Object)object)).array);
    }

    public final int hashCode() {
        if (this.hash == 0) {
            this.hash = Arrays.hashCode(this.array);
        }
        return this.hash;
    }

    public final Object get(int n) {
        return this.array[n];
    }

    public final String join(String string) {
        return TK.join(this.array, string);
    }

    public static <T1, T2> Two<T1, T2> of(T1 T1, T2 T2) {
        return new Two(T1, T2);
    }

    public static <T1, T2, T3> Three<T1, T2, T3> of(T1 T1, T2 T2, T3 T3) {
        return new Three(T1, T2, T3);
    }

    public static <T1, T2, T3, T4> Four<T1, T2, T3, T4> of(T1 T1, T2 T2, T3 T3, T4 T4) {
        return new Four(T1, T2, T3, T4);
    }

    public final int size() {
        return this.array.length;
    }

    public final String toString() {
        return this.join(", ");
    }

    public final Object[] values() {
        return (Object[])this.array.clone();
    }

    private Tuple(int n) {
        this.array = new Object[n];
    }

    public static final class Four<T1, T2, T3, T4>
    extends Tuple {
        public T1 get1() {
            return (T1)this.array[0];
        }

        public T2 get2() {
            return (T2)this.array[1];
        }

        public T3 get3() {
            return (T3)this.array[2];
        }

        public T4 get4() {
            return (T4)this.array[3];
        }

        private Four(T1 T1, T2 T2, T3 T3, T4 T4) {
            super(4);
            this.array[0] = T1;
            this.array[1] = T2;
            this.array[2] = T3;
            this.array[3] = T4;
        }
    }

    public static final class Three<T1, T2, T3>
    extends Tuple {
        public T1 get1() {
            return (T1)this.array[0];
        }

        public T2 get2() {
            return (T2)this.array[1];
        }

        public T3 get3() {
            return (T3)this.array[2];
        }

        private Three(T1 T1, T2 T2, T3 T3) {
            super(3);
            this.array[0] = T1;
            this.array[1] = T2;
            this.array[2] = T3;
        }
    }

    public static final class Two<T1, T2>
    extends Tuple {
        public T1 get1() {
            return (T1)this.array[0];
        }

        public T2 get2() {
            return (T2)this.array[1];
        }

        private Two(T1 T1, T2 T2) {
            super(2);
            this.array[0] = T1;
            this.array[1] = T2;
        }
    }
}

