/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.lang.ref.WeakReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.makagiga.commons.CoolHeader;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MButtonPanel;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MHighlighter;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MTabbedPane;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.painters.GlassPainter;
import org.makagiga.commons.validator.Validator;
import org.makagiga.commons.validator.ValidatorMessage;

public class MWizardDialog
extends MDialog {
    private final EventListenerList listenerList = new EventListenerList();
    private MButton backButton;
    private MButton cancelButton;
    private MButton nextButton;
    private MTabbedPane<Page> pages = new MTabbedPane<Page>(){

        @Override
        public void setEnabledAt(int n, boolean bl) {
            super.setEnabledAt(n, bl);
            Component component = this.getTabComponentAt(n);
            if (component != null) {
                component.setEnabled(bl);
            }
        }
    };
    private StaticHandler staticHandler;

    public MWizardDialog(Window window, String string) {
        this(window, string, MIcon.stock("ui/wizard"));
    }

    public MWizardDialog(Window window, String string, Icon icon) {
        super(window, string, icon, 4);
        this.pages.setTabPlacement(2);
        this.addCenter(this.pages);
        this.installValidatorMessage();
        this.addSouth(this.createButtonsPanel());
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public Page addPage(String string, JComponent jComponent) {
        return this.addPage(string, null, jComponent);
    }

    public Page addPage(String string, String string2, JComponent jComponent) {
        return this.addPage(string, null, string2, jComponent);
    }

    public Page addPage(String string, Icon icon, String string2, JComponent jComponent) {
        Page page = new Page(string2, jComponent);
        this.pages.addTab(string, icon, page);
        MLabel mLabel = new MLabel(string, icon);
        mLabel.setHorizontalAlignment(0);
        mLabel.setHorizontalTextPosition(0);
        mLabel.setVerticalAlignment(0);
        mLabel.setVerticalTextPosition(3);
        this.pages.setTabComponentAt(this.pages.getTabCount() - 1, mLabel);
        return page;
    }

    public void complete() {
        this.cancelButton.setEnabled(false);
        this.backButton.setEnabled(false);
        this.nextButton.setEnabled(true);
    }

    @Override
    public boolean exec(JComponent jComponent) {
        int n = this.pages.getTabCount();
        for (int i = 1; i < n; ++i) {
            this.pages.setEnabledAt(i, false);
        }
        this.updateState();
        this.staticHandler = new StaticHandler(this);
        this.pages.addChangeListener(this.staticHandler);
        return super.exec(jComponent);
    }

    public Page getCurrentPage() {
        return this.pages.getSelectedTab();
    }

    public void setCurrentPage(Page page) {
        this.pages.setSelectedComponent(page);
    }

    public boolean isDone() {
        return this.pages.getSelectedIndex() == this.pages.getTabCount() - 1;
    }

    public void nextPage() {
        if (!this.cancelButton.isEnabled()) {
            this.accept();
            return;
        }
        int n = this.pages.getTabCount();
        int n2 = this.pages.getSelectedIndex();
        if (n2 < n - 1) {
            this.pages.setEnabledAt(++n2, true);
            this.pages.setSelectedIndex(n2);
        }
        if (this.isDone()) {
            for (int i = 0; i < n - 1; ++i) {
                this.pages.setEnabledAt(i, false);
            }
        }
    }

    public void previousPage() {
        int n = this.pages.getSelectedIndex();
        if (n > 0) {
            this.pages.setEnabledAt(n, false);
            this.pages.setEnabledAt(n - 1, true);
            this.pages.setSelectedIndex(n - 1);
        }
    }

    public void setDescription(final String string) {
        final Page page = this.pages.getSelectedTab();
        if (page == null) {
            return;
        }
        UI.invokeLater(new Runnable(){

            @Override
            public void run() {
                page.setDescription(string);
            }
        });
    }

    protected MPanel createButtonsPanel() {
        MPanel mPanel = MPanel.createHBoxPanel();
        mPanel.setMargin(mPanel.getContentMargin(), mPanel.getContentMargin(), 0, 5);
        this.cancelButton = new MButton(UI._("Cancel"));
        this.cancelButton.setIconNameUI("ui/cancel");
        this.cancelButton.onClick(this, "reject");
        mPanel.add(this.cancelButton);
        mPanel.addContentGap();
        mPanel.addStretch();
        this.backButton = new MButton();
        this.backButton.setIconNameUI("ui/previous");
        if (this.backButton.getIcon() == null) {
            this.backButton.setText("< " + UI._("Back"));
        } else {
            this.backButton.setText(UI._("Back"));
        }
        this.backButton.onClick(this, "previousPage");
        this.nextButton = new MButton();
        this.nextButton.onClick(this, "nextPage");
        this.setDefault(this.nextButton);
        MButtonPanel mButtonPanel = new MButtonPanel(5, this.backButton, this.nextButton);
        if (mButtonPanel.getPainter() == null) {
            mButtonPanel.setMargin(0);
        }
        mPanel.add(mButtonPanel);
        this.setCancelButton(this.cancelButton);
        this.setOKButton(this.nextButton);
        return mPanel;
    }

    protected void fireStateChanged() {
        TK.fireStateChanged(this, this.getChangeListeners());
    }

    @Override
    protected void onClose() {
        super.onClose();
        if (this.staticHandler != null) {
            this.pages.removeChangeListener(this.staticHandler);
            this.staticHandler = null;
        }
    }

    protected void updateState() {
        int n = this.pages.getTabCount();
        int n2 = this.pages.getSelectedIndex();
        if (n2 == n - 2) {
            this.backButton.setEnabled(n2 > 0);
            this.nextButton.setEnabled(true);
            this.nextButton.setIconNameUI("ui/ok");
            this.nextButton.setText(UI._("Finish"));
        } else if (n2 == n - 1) {
            this.backButton.setEnabled(false);
            this.nextButton.setEnabled(false);
            this.nextButton.setIconNameUI("ui/close");
            this.nextButton.setText(UI._("Close"));
        } else {
            this.backButton.setEnabled(n2 > 0);
            this.nextButton.setEnabled(true);
            this.nextButton.setIconNameUI("ui/next");
            if (this.nextButton.getIcon() == null) {
                this.nextButton.setText(UI._("Next") + " >");
            } else {
                this.nextButton.setText(UI._("Next"));
            }
        }
        this.updateMnemonic(this.nextButton);
        ValidatorMessage validatorMessage = this.getValidatorMessage();
        if (validatorMessage != null) {
            validatorMessage.setVisible(false);
        }
        Page page = this.getCurrentPage();
        for (Validator<?> validator : this.getValidatorSupport()) {
            JComponent jComponent = validator.getComponent();
            if (jComponent == null) continue;
            validator.setEnabled(page == UI.getAncestorOfClass(Page.class, jComponent));
        }
        this.getValidatorSupport().validate(this);
    }

    private static final class StaticHandler
    implements ChangeListener {
        private final WeakReference<MWizardDialog> wizardDialogRef;

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            MWizardDialog mWizardDialog = (MWizardDialog)this.wizardDialogRef.get();
            if (mWizardDialog != null) {
                mWizardDialog.updateState();
                mWizardDialog.fireStateChanged();
            }
        }

        private StaticHandler(MWizardDialog mWizardDialog) {
            this.wizardDialogRef = TK.newWeakRef(mWizardDialog);
        }
    }

    public static class Page
    extends MPanel {
        private final CoolHeader description = new CoolHeader();

        public Page(String string, JComponent jComponent) {
            this.description.setColor(MHighlighter.OK_COLOR, Color.BLACK);
            this.description.setDirection(CoolHeader.Direction.BOTTOM);
            this.description.setRoundType(GlassPainter.RoundType.BOTTOM);
            this.addNorth(this.description);
            this.addCenter(jComponent);
            this.setDescription(string);
        }

        public void setDescription(String string) {
            this.description.setText(string);
            this.description.setVisible(!TK.isEmpty(string));
        }
    }
}

