/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MRenderer;
import org.makagiga.commons.MV;
import org.makagiga.commons.TK;

public class MTreeItem
implements MRenderer.Renderable,
MutableTreeNode,
Serializable {
    private static final long serialVersionUID = 2879837469836957677L;
    private boolean allowsChildren = true;
    private boolean visible = true;
    private static final Enumeration<TreeNode> EMPTY_LIST = Collections.enumeration(new MArrayList(0));
    private MutableTreeNode parent;
    private transient Object userObject;
    MArrayList<MutableTreeNode> children;

    public void add(MutableTreeNode mutableTreeNode) {
        this.reparent(mutableTreeNode);
        if (this.children == null) {
            this.children = new MArrayList();
        }
        this.children.add(mutableTreeNode);
    }

    public TreeNode getChildAt(int n, MV mV) {
        if (this.children == null) {
            throw new ArrayIndexOutOfBoundsException("Node is empty");
        }
        if (mV == MV.VIEW) {
            int n2 = -1;
            for (MutableTreeNode mutableTreeNode : this.children) {
                if (!this.isVisible(mutableTreeNode) || ++n2 != n) continue;
                return mutableTreeNode;
            }
        }
        return (TreeNode)this.children.get(n);
    }

    public int getChildCount(MV mV) {
        if (this.children == null) {
            return 0;
        }
        if (mV == MV.VIEW) {
            int n = 0;
            for (MutableTreeNode mutableTreeNode : this.children) {
                if (!this.isVisible(mutableTreeNode)) continue;
                ++n;
            }
            return n;
        }
        return this.children.size();
    }

    public int getIndex(TreeNode treeNode, MV mV) {
        if (this.children == null) {
            return -1;
        }
        if (mV == MV.VIEW) {
            int n = -1;
            for (MutableTreeNode mutableTreeNode : this.children) {
                if (!this.isVisible(mutableTreeNode)) continue;
                ++n;
                if (mutableTreeNode != treeNode) continue;
                return n;
            }
            return -1;
        }
        return this.children.indexOf(treeNode);
    }

    public MTreeItem getParentItem() {
        return (MTreeItem)this.parent;
    }

    public TreeNode[] getPathArray() {
        List<TreeNode> list = this.getPathList();
        return list.toArray(new TreeNode[list.size()]);
    }

    public List<TreeNode> getPathList() {
        LinkedList<TreeNode> linkedList = new LinkedList<TreeNode>();
        TreeNode treeNode = this;
        do {
            linkedList.addFirst(treeNode);
        } while ((treeNode = treeNode.getParent()) != null);
        return linkedList;
    }

    public TreePath getTreePath() {
        return new TreePath(this.getPathArray());
    }

    public boolean isEmpty(MV mV) {
        return this.getChildCount(mV) == 0;
    }

    public boolean isFilter() {
        if (this.children == null) {
            return false;
        }
        for (MutableTreeNode mutableTreeNode : this.children) {
            if (this.isVisible(mutableTreeNode)) continue;
            return true;
        }
        return false;
    }

    public boolean isNodeAncestor(MutableTreeNode mutableTreeNode) {
        if (mutableTreeNode == null) {
            return false;
        }
        if (mutableTreeNode == this) {
            return true;
        }
        return this.getPathList().contains(mutableTreeNode);
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public List<MTreeItem> listChildren(MV mV) {
        int n = this.getChildCount(mV);
        if (n == 0) {
            return Collections.emptyList();
        }
        MArrayList<MTreeItem> mArrayList = new MArrayList<MTreeItem>(n);
        if (mV == MV.MODEL) {
            for (int i = 0; i < n; ++i) {
                mArrayList.add((MTreeItem)this.children.get(i));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                mArrayList.add((MTreeItem)this.getChildAt(i, mV));
            }
        }
        return mArrayList;
    }

    public <T extends MTreeItem> List<T> listChildren(Class<T> clazz, MV mV) {
        int n = this.getChildCount(mV);
        if (n == 0) {
            return Collections.emptyList();
        }
        MArrayList<MTreeItem> mArrayList = new MArrayList<MTreeItem>(n);
        for (int i = 0; i < n; ++i) {
            mArrayList.add((MTreeItem)this.getChildAt(i, mV));
        }
        return mArrayList;
    }

    public boolean matches(MTreeItem mTreeItem) {
        return false;
    }

    public void removeAllChildren() {
        if (this.children != null) {
            this.children.clear();
            this.children = null;
        }
    }

    @Override
    @Deprecated
    public Enumeration<? extends TreeNode> children() {
        return this.children == null ? EMPTY_LIST : Collections.enumeration(this.children);
    }

    @Override
    public boolean getAllowsChildren() {
        return this.allowsChildren;
    }

    public void setAllowsChildren(boolean bl) {
        if (bl != this.allowsChildren) {
            this.allowsChildren = bl;
            if (!this.allowsChildren) {
                this.removeAllChildren();
            }
        }
    }

    @Override
    @Deprecated
    public TreeNode getChildAt(int n) {
        return this.getChildAt(n, MV.MODEL);
    }

    @Override
    @Deprecated
    public int getChildCount() {
        return this.getChildCount(MV.MODEL);
    }

    @Override
    @Deprecated
    public int getIndex(TreeNode treeNode) {
        return this.getIndex(treeNode, MV.MODEL);
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(MutableTreeNode mutableTreeNode) {
        this.parent = mutableTreeNode;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object object) {
        this.userObject = object;
    }

    @Override
    public void insert(MutableTreeNode mutableTreeNode, int n) {
        this.reparent(mutableTreeNode);
        if (this.children == null) {
            this.children = new MArrayList();
        }
        this.children.add(n, mutableTreeNode);
    }

    @Override
    public boolean isLeaf() {
        return this.isEmpty(MV.MODEL);
    }

    @Override
    public void remove(int n) {
        if (this.children != null) {
            this.remove((MutableTreeNode)this.children.get(n));
        }
    }

    @Override
    public void remove(MutableTreeNode mutableTreeNode) {
        if (this.children != null) {
            this.children.remove(mutableTreeNode);
        }
        mutableTreeNode.setParent(null);
    }

    @Override
    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    public void reparent(MutableTreeNode mutableTreeNode) {
        mutableTreeNode.removeFromParent();
        mutableTreeNode.setParent(this);
    }

    @Override
    public void setupRenderer(MRenderer<?> mRenderer) {
        mRenderer.setIcon(null);
        mRenderer.setText(this.toString());
    }

    private boolean isVisible(MutableTreeNode mutableTreeNode) {
        return !(mutableTreeNode instanceof MTreeItem) || ((MTreeItem)MTreeItem.class.cast(mutableTreeNode)).isVisible();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.userObject = TK.deserialize(objectInputStream, "userObject");
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        TK.serialize(objectOutputStream, "userObject", this.userObject);
    }
}

