/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.makagiga.commons.FS;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.TK;

public class MProcess
implements Runnable {
    private MLogger log = MLogger.get("process");
    private OutputStream errStream;
    private OutputStream outStream;
    private Process process;

    public MProcess(String string) throws IOException {
        this.process = Runtime.getRuntime().exec(string);
        this.init(System.out, System.err);
    }

    public MProcess(String ... stringArray) throws IOException {
        this.process = Runtime.getRuntime().exec(stringArray);
        this.init(System.out, System.err);
    }

    public MProcess(File file, String ... stringArray) throws IOException {
        this(file, System.out, System.err, stringArray);
    }

    public MProcess(File file, OutputStream outputStream, OutputStream outputStream2, String ... stringArray) throws IOException {
        this.process = Runtime.getRuntime().exec(stringArray, null, file);
        this.init(outputStream, outputStream2);
    }

    public void closeAllStreams() {
        FS.close(this.process.getErrorStream());
        FS.close(this.process.getInputStream());
        FS.close(this.process.getOutputStream());
    }

    public Process getProcess() {
        return this.process;
    }

    public OutputStream getTargetErrorStream() {
        return this.errStream;
    }

    public OutputStream getTargetOutputStream() {
        return this.outStream;
    }

    public boolean isRunning() {
        try {
            this.process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
    }

    public void kill() {
        this.process.destroy();
    }

    @Override
    @Deprecated
    public void run() {
        this.log.debug("Begin thread");
        do {
            try {
                FS.copyStream(this.process.getInputStream(), this.outStream);
                FS.copyStream(this.process.getErrorStream(), this.errStream);
            }
            catch (IOException iOException) {
                this.log.warning(iOException.toString());
                break;
            }
            TK.sleep(50L);
        } while (this.isRunning());
        this.log.debug("End thread");
        this.onExit();
    }

    protected void onExit() {
    }

    private void init(OutputStream outputStream, OutputStream outputStream2) {
        this.outStream = TK.checkNull(outputStream, "outStream");
        this.errStream = TK.checkNull(outputStream2, "errStream");
        Thread thread = new Thread((Runnable)this, this.toString());
        thread.setDaemon(true);
        thread.start();
    }
}

