/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Dimension;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import org.makagiga.commons.Config;
import org.makagiga.commons.CoolHeader;
import org.makagiga.commons.Kiosk;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MProgressBar;
import org.makagiga.commons.MSmallButton;
import org.makagiga.commons.MTimer;
import org.makagiga.commons.MWindow;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.WindowDragAdapter;
import org.makagiga.commons.mods.Mods;

public class MNotification
implements Iterable<Message> {
    public static final String MOD_INIT = "init@org.makagiga.commons.MNotification";
    public static final String MOD_UPDATE_VIEW = "updateView@org.makagiga.commons.MNotification";
    private boolean needUpdate = true;
    private final CoolHeader count;
    private final MArrayList<Message> messages = new MArrayList();
    private final MLabel icon;
    private final MLabel text;
    private final MLabel title;
    private static MNotification _instance;
    private final MPanel mainPanel;
    private final MProgressBar timeout;
    private final MSmallButton closeButton;
    private final PopupWindow popupWindow = new PopupWindow();

    public synchronized void addMessage(Message message) {
        TK.checkNull(message, "message");
        if (message._timeout == -1) {
            this.needUpdate = this.messages.isEmpty();
            this.messages.add(message);
            this.updateWindow(this.messages.size() == 1);
        } else {
            this.needUpdate = true;
            this.messages.add(0, message);
            this.updateWindow(true);
        }
    }

    public MButton getCloseButton() {
        return this.closeButton;
    }

    public MLabel getCountLabel() {
        return this.count;
    }

    public MLabel getIconLabel() {
        return this.icon;
    }

    public MPanel getMainPanel() {
        return this.mainPanel;
    }

    public static synchronized MNotification getInstance() {
        if (_instance == null) {
            _instance = new MNotification();
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMessageCount() {
        Class<MNotification> clazz = MNotification.class;
        synchronized (MNotification.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance == null ? 0 : MNotification._instance.messages.size();
        }
    }

    @Deprecated
    public synchronized List<Message> getMessages() {
        return (List)this.messages.clone();
    }

    public MProgressBar getProgressBar() {
        return this.timeout;
    }

    public MLabel getTextLabel() {
        return this.text;
    }

    public MLabel getTitleLabel() {
        return this.title;
    }

    public static void hideMessage(Class<? extends Action> clazz) {
        if (MNotification.getMessageCount() == 0) {
            return;
        }
        MNotification mNotification = MNotification.getInstance();
        for (Message message : mNotification) {
            Action action = message.getAction();
            if (action == null || action.getClass() != clazz) continue;
            mNotification.hideMessage(message);
        }
    }

    public synchronized void hideMessage(Message message) {
        this.needUpdate = true;
        this.messages.remove(TK.checkNull(message, "message"));
        message.shutDown();
        this.updateWindow(false);
    }

    public static Message showError(String string) {
        return MNotification.showMessage(UI._("Error"), string, "ui/error");
    }

    public static Message showInfo(String string) {
        return MNotification.showMessage(UI._("Information"), string, "ui/info");
    }

    public static Message showMessage(Message message) {
        MNotification.getInstance().addMessage(message);
        return message;
    }

    public static Message showMessage(String string, String string2, Icon icon) {
        Message message = new Message(string, string2, icon);
        MNotification.getInstance().addMessage(message);
        return message;
    }

    public static Message showMessage(String string, String string2, String string3) {
        return MNotification.showMessage(string, string2, MIcon.medium(string3));
    }

    public static Message showWarning(String string) {
        return MNotification.showMessage(UI._("Warning"), string, "ui/warning");
    }

    public void updateMessage(Message message) {
        this.updateMessage(message, true);
        this.updateSizeAndPosition(false);
    }

    @Override
    public Iterator<Message> iterator() {
        return this.getMessages().iterator();
    }

    protected MNotification() {
        this.mainPanel = MPanel.createBorderPanel(4);
        this.mainPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), UI.createEmptyBorder(4)));
        this.popupWindow.addCenter(this.mainPanel);
        MPanel mPanel = MPanel.createBorderPanel(4);
        mPanel.setOpaque(false);
        this.title = new MLabel();
        this.title.setStyle("font-weight: bold");
        mPanel.addCenter(this.title);
        this.closeButton = new MSmallButton(MActionInfo.CLOSE_NO_KEY_STROKE){

            @Override
            protected void onClick() {
                MNotification.this.closeCurrent();
            }
        };
        this.closeButton.setSafeAction(true);
        mPanel.addEast(this.closeButton);
        this.icon = new MLabel();
        this.mainPanel.addWest(this.icon);
        this.mainPanel.addNorth(mPanel);
        this.text = new MLabel();
        this.mainPanel.addCenter(this.text);
        this.count = new CoolHeader();
        this.count.setStyle("font-weight: bold");
        this.mainPanel.addEast(this.count);
        this.timeout = new MProgressBar();
        UI.SizeVariant.MINI.apply(this.timeout);
        this.timeout.setMinimum(0);
        this.mainPanel.addSouth(this.timeout);
        MMouseAdapter mMouseAdapter = new MMouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!mouseEvent.isConsumed() && (2.isLeft(mouseEvent) || 2.isMiddle(mouseEvent))) {
                    mouseEvent.consume();
                    MNotification.this.executeMessageAction(mouseEvent.getSource(), mouseEvent);
                }
            }

            @Override
            public void popupTrigger(MouseEvent mouseEvent) {
                MNotification.this.showPopupMenu(mouseEvent);
            }
        };
        this.icon.addMouseListener(mMouseAdapter);
        this.mainPanel.addMouseListener(mMouseAdapter);
        this.text.addMouseListener(mMouseAdapter);
        new WindowDragAdapter(this.title){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (((Boolean)Kiosk.notificationLocked.get()).booleanValue()) {
                    return;
                }
                super.mouseDragged(mouseEvent);
                PopupWindow popupWindow = MNotification.this.popupWindow;
                UI.notificationX.set(popupWindow.getX());
                UI.notificationY.set(popupWindow.getY());
                UI.horizontalNotificationPosition.set(UI.HorizontalPosition.LEFT);
                UI.verticalNotificationPosition.set(UI.VerticalPosition.TOP);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (((Boolean)Kiosk.notificationLocked.get()).booleanValue()) {
                    return;
                }
                super.mousePressed(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (((Boolean)Kiosk.notificationLocked.get()).booleanValue()) {
                    return;
                }
                super.mouseReleased(mouseEvent);
                Config.getDefault().sync();
            }
        };
        Mods.exec(this, MOD_INIT, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void closeAll() {
        Class<MNotification> clazz = MNotification.class;
        synchronized (MNotification.class) {
            if (_instance != null) {
                for (Message message : MNotification._instance.messages) {
                    message.shutDown();
                }
                MNotification._instance.messages.clear();
                if (MNotification._instance.popupWindow != null) {
                    MNotification._instance.popupWindow.dispose();
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    protected void closeCurrent() {
        Message message = this.getCurrentMessage();
        if (message != null) {
            this.hideMessage(message);
        }
    }

    protected Message getCurrentMessage() {
        return this.messages.isEmpty() ? null : this.messages.getFirst();
    }

    protected void showPopupMenu(MouseEvent mouseEvent) {
        MMenu mMenu = new MMenu();
        mMenu.add(new MAction(MActionInfo.CLOSE_NO_KEY_STROKE){

            @Override
            public void onAction() {
                MNotification.this.closeCurrent();
            }
        });
        mMenu.add(new MAction(UI._("Close All")){

            @Override
            public void onAction() {
                MNotification.closeAll();
            }
        });
        mMenu.addSeparator();
        mMenu.addCheckBox(new MAction(UI._("Transparent")){

            @Override
            public void onAction() {
                if (MNotification.this.popupWindow != null) {
                    UI.notificationTransparent.set(this.isSelected());
                    MNotification.this.popupWindow.updateTransparent();
                    Config.getDefault().sync();
                }
            }
        }, (Boolean)UI.notificationTransparent.get()).setEnabled(this.popupWindow != null);
        mMenu.showPopup(mouseEvent);
    }

    protected synchronized void updateMessage(Message message, boolean bl) {
        String string;
        if (!bl && !this.needUpdate) {
            return;
        }
        if (this.getCurrentMessage() != message) {
            return;
        }
        this.needUpdate = false;
        boolean bl2 = message.action != null;
        String string2 = "cursor: " + (bl2 ? "pointer" : "default");
        UI.setStyle(string2, this.icon, this.mainPanel, this.text);
        this.icon.setIcon(message.icon);
        String string3 = MApplication.getFullName();
        String string4 = string = message.title == null ? "" : message.title;
        if (!string.equals(string3)) {
            if (!TK.isEmpty(string)) {
                string = string + " - ";
            }
            string = string + string3;
        }
        this.title.setText(string);
        this.closeButton.setVisible(message.closeButtonVisible);
        if (TK.isEmpty(message.text)) {
            this.text.setText(null);
            this.text.setVisible(false);
        } else {
            this.text.setText(message.text);
            this.text.setVisible(true);
        }
        this.updateTimeoutProgressBar(message);
        Mods.exec(this, MOD_UPDATE_VIEW, message);
    }

    protected void updateSizeAndPosition(boolean bl) {
        if (this.popupWindow != null) {
            this.popupWindow.updateTransparent();
            int n = (Integer)UI.notificationX.get();
            int n2 = (Integer)UI.notificationY.get();
            if (n == -1 && n2 == -1) {
                this.popupWindow.showAtPosition(UI.VerticalPosition.BOTTOM, UI.HorizontalPosition.RIGHT);
                UI.notificationX.set(this.popupWindow.getX());
                UI.notificationY.set(this.popupWindow.getY());
            } else {
                this.popupWindow.pack();
                Dimension dimension = UI.getScreenSize();
                int n3 = dimension.width / 2;
                if (this.popupWindow.getWidth() > n3) {
                    this.popupWindow.setSize(n3, this.popupWindow.getHeight());
                }
                n = Math.max(n, 0);
                n2 = Math.max(n2, 0);
                int n4 = dimension.width - this.popupWindow.getWidth();
                if (UI.horizontalNotificationPosition.get() == UI.HorizontalPosition.RIGHT || n >= n4) {
                    n = n4;
                    UI.horizontalNotificationPosition.set(UI.HorizontalPosition.RIGHT);
                } else {
                    UI.horizontalNotificationPosition.set(UI.HorizontalPosition.LEFT);
                }
                int n5 = dimension.height - this.popupWindow.getHeight();
                if (UI.verticalNotificationPosition.get() == UI.VerticalPosition.BOTTOM || n2 >= n5) {
                    n2 = n5;
                    UI.verticalNotificationPosition.set(UI.VerticalPosition.BOTTOM);
                } else {
                    UI.verticalNotificationPosition.set(UI.VerticalPosition.TOP);
                }
                this.popupWindow.setLocation(n, n2);
                UI.notificationX.set(this.popupWindow.getX());
                UI.notificationY.set(this.popupWindow.getY());
                this.popupWindow.setVisible(true);
            }
        }
        if (bl) {
            this.paintImmediately();
        }
    }

    protected void updateTimeoutProgressBar(Message message) {
        if (message._timeout == -1) {
            this.timeout.setVisible(false);
        } else {
            this.timeout.setMaximum(message._timeout);
            this.timeout.setValue(message._currentTimeout);
            this.timeout.setVisible(true);
        }
    }

    protected void updateWindow(boolean bl) {
        if (this.messages.isEmpty()) {
            MNotification.closeAll();
            return;
        }
        int n = this.messages.size();
        if (n > 0) {
            this.count.setText("1 / " + n);
            this.count.setVisible(this.getCurrentMessage().countInfoVisible);
        } else {
            this.count.setText(null);
            this.count.setVisible(false);
        }
        this.updateMessage(this.getCurrentMessage(), false);
        this.updateSizeAndPosition(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void executeMessageAction(Object object, InputEvent inputEvent) {
        if (!this.messages.isEmpty()) {
            this.needUpdate = true;
            Message message = (Message)this.messages.remove(0);
            message.shutDown();
            this.updateWindow(true);
            Action action = message.action;
            if (action != null) {
                try {
                    message.inputEvent = inputEvent;
                    MAction.fire(action, object);
                }
                finally {
                    message.inputEvent = null;
                }
            }
        }
    }

    private synchronized void paintImmediately() {
        this.mainPanel.paintImmediately(this.mainPanel.getBounds());
    }

    private void updateTimeoutInfo(Message message) {
        if (message == this.messages.getFirst()) {
            this.updateTimeoutProgressBar(message);
        }
    }

    private static final class PopupWindow
    extends MWindow {
        private PopupWindow() {
            this.setAlwaysOnTop(true);
        }

        private void updateTransparent() {
            UI.setAlpha(this, (Boolean)UI.notificationTransparent.get() != false ? 0.85f : 1.0f);
        }
    }

    public static class Message {
        private Action action;
        private boolean closeButtonVisible = true;
        private boolean countInfoVisible = true;
        private Icon icon;
        private InputEvent inputEvent;
        private int _currentTimeout = -1;
        private int _timeout = -1;
        private MTimer timeoutTimer;
        private Object userObject;
        private String title;
        private String text;

        public Message() {
            this(null, null, (Icon)null);
        }

        public Message(Action action) {
            this.setAction(action);
        }

        public Message(String string, String string2, String string3) {
            this(string, string2, MIcon.medium(string3));
        }

        public Message(String string, String string2, Icon icon) {
            this.title = string;
            this.text = string2;
            this.icon = icon;
        }

        public Action getAction() {
            return this.action;
        }

        public void setAction(Action action) {
            this.action = action;
            if (this.action == null) {
                this.title = null;
                this.text = null;
                this.icon = null;
            } else {
                this.title = MAction.getValue(this.action, "Name", null);
                this.text = MAction.getValue(this.action, "ShortDescription", null);
                this.icon = MAction.getIcon(this.action, MIcon.Size.MEDIUM);
            }
        }

        public Icon getIcon() {
            return this.icon;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        public InputEvent getInputEvent() {
            return this.inputEvent;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String string) {
            this.text = string;
        }

        public int getTimeout() {
            return this._timeout;
        }

        public void setTimeout(int n) {
            if (n == -1) {
                n = 4000;
            }
            if (n != this._timeout) {
                this._currentTimeout = this._timeout = n;
                if (this._timeout == -1) {
                    if (this.timeoutTimer != null) {
                        this.timeoutTimer.stop();
                        this.timeoutTimer = null;
                    }
                } else {
                    if (this.timeoutTimer == null) {
                        this.timeoutTimer = new MTimer(100){

                            @Override
                            protected boolean onTimeout() {
                                if (Message.this._currentTimeout <= 0) {
                                    MNotification.getInstance().hideMessage(Message.this);
                                    this.stop();
                                    Message.this.timeoutTimer = null;
                                    return false;
                                }
                                MNotification.getInstance().updateTimeoutInfo(Message.this);
                                Message.this._currentTimeout -= 100;
                                return true;
                            }
                        };
                    }
                    this.timeoutTimer.restart();
                }
            }
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String string) {
            this.title = string;
        }

        public Object getUserObject() {
            return this.userObject;
        }

        public void setUserObject(Object object) {
            this.userObject = object;
        }

        public boolean isCloseButtonVisible() {
            return this.closeButtonVisible;
        }

        public void setCloseButtonVisible(boolean bl) {
            this.closeButtonVisible = bl;
        }

        public boolean isCountInfoVisible() {
            return this.countInfoVisible;
        }

        public void setCountInfoVisible(boolean bl) {
            this.countInfoVisible = bl;
        }

        protected void onClose() {
        }

        private void shutDown() {
            this.onClose();
            if (this.timeoutTimer != null) {
                this.timeoutTimer.stop();
                this.timeoutTimer = null;
            }
        }
    }

    public static enum Type {
        POPUP;

    }
}

