/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.swing.Box;
import org.makagiga.commons.ContainerIterator;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MHighlighter;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MScrollPane;
import org.makagiga.commons.MSmallButton;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.WTFError;
import org.makagiga.commons.fx.Blend;
import org.makagiga.commons.painters.GlassPainter;

public class MMultiPanel<I extends PanelItem>
extends MPanel {
    private boolean confirmRemove;
    private EnumSet<Button> visibleButtons = EnumSet.of(Button.ADD, Button.REMOVE);

    public MMultiPanel() {
        super(1);
        this.add(Box.createVerticalGlue());
    }

    public void addItem(I i) {
        this.addItem(i, false);
    }

    public void addItem(I i, boolean bl) {
        this.addItem(i, this.getComponentCount() - 1, bl);
    }

    public void addItem(I i, int n, boolean bl) {
        if (!this.containsItem(i)) {
            ItemWrapper itemWrapper = new ItemWrapper(this, (PanelItem)i, null);
            this.add((Component)itemWrapper, n);
            this.revalidate();
            this.repaint();
            if (bl) {
                Blend.animateBackground(itemWrapper, MHighlighter.OK_COLOR, null);
            }
            if (((Container)i).getComponentCount() > 0) {
                UI.requestFocus(((Container)i).getComponent(0));
            }
            this.updateCloseButtons();
        }
    }

    public boolean containsItem(I i) {
        return this.getItems().contains(i);
    }

    public boolean getConfirmRemove() {
        return this.confirmRemove;
    }

    public void setConfirmRemove(boolean bl) {
        this.confirmRemove = bl;
    }

    public int getItemCount() {
        return this.getItems().size();
    }

    public List<I> getItems() {
        ArrayList<PanelItem> arrayList = new ArrayList<PanelItem>();
        for (ItemWrapper itemWrapper : ContainerIterator.create(this, ItemWrapper.class)) {
            arrayList.add((PanelItem)itemWrapper.getView());
        }
        return arrayList;
    }

    public boolean isButtonVisible(Button button) {
        return this.visibleButtons.contains((Object)button);
    }

    public void setButtonVisible(Button button, boolean bl) {
        boolean bl2 = bl ? this.visibleButtons.add(button) : this.visibleButtons.remove((Object)button);
        if (bl2) {
            for (ItemWrapper itemWrapper : ContainerIterator.create(this, ItemWrapper.class)) {
                MButton mButton = ((PanelItem)itemWrapper.getView()).getButton(button);
                mButton.setVisible(bl);
            }
        }
    }

    public boolean isEmpty() {
        return this.getItems().isEmpty();
    }

    public void removeItem(I i) {
        boolean bl = false;
        for (ItemWrapper itemWrapper : ContainerIterator.create(this, ItemWrapper.class)) {
            if (itemWrapper.getView() != i) continue;
            this.remove(itemWrapper);
            bl = true;
        }
        if (bl) {
            this.updateCloseButtons();
            this.revalidate();
            this.repaint();
        }
    }

    protected I onAddItem(MButton mButton) {
        return null;
    }

    protected I onCopyItem(I i) {
        return null;
    }

    protected boolean onRemoveItem(I i) {
        return true;
    }

    private void updateCloseButtons() {
        boolean bl = this.getItemCount() > 1;
        for (ItemWrapper itemWrapper : ContainerIterator.create(this, ItemWrapper.class)) {
            MButton mButton = ((PanelItem)itemWrapper.getView()).getButton(Button.REMOVE);
            mButton.setEnabled(bl);
        }
    }

    private static final class ItemWrapper<I extends PanelItem>
    extends MPanel.Wrapper<I> {
        private ItemWrapper(MMultiPanel<I> mMultiPanel, I i) {
            super(5, 0, 0, i, null);
            this.setMargin(5);
            this.addEast(new ButtonPanel(mMultiPanel, (PanelItem)i, null));
            this.getLabel().setVisible(false);
            this.limitHeight((Component)i);
        }

        private ButtonPanel<I> getButtonPanel() {
            BorderLayout borderLayout = (BorderLayout)this.getLayout();
            return (ButtonPanel)borderLayout.getLayoutComponent("After");
        }

        /* synthetic */ ItemWrapper(MMultiPanel mMultiPanel, PanelItem panelItem, 1 var3_3) {
            this(mMultiPanel, panelItem);
        }
    }

    private static final class ButtonPanel<I extends PanelItem>
    extends MPanel {
        private final WeakReference<I> itemRef;
        private final WeakReference<MSmallButton> addButtonRef;
        private final WeakReference<MSmallButton> copyButtonRef;
        private final WeakReference<MSmallButton> removeButtonRef;

        private ButtonPanel(final MMultiPanel<I> mMultiPanel, I i) {
            super(0);
            this.itemRef = new WeakReference<I>(i);
            this.setMargin(1);
            this.setPainter(new GlassPainter());
            MSmallButton mSmallButton = new MSmallButton(MIcon.small("ui/newfile"), UI._("Add Item")){

                @Override
                protected void onClick() {
                    Object i = mMultiPanel.onAddItem(this);
                    if (i != null) {
                        mMultiPanel.addItem(i, true);
                        MScrollPane.scrollToBottom(mMultiPanel, true);
                    }
                }
            };
            this.add(mSmallButton);
            MSmallButton mSmallButton2 = new MSmallButton(MActionInfo.COPY){

                @Override
                protected void onClick() {
                    PanelItem panelItem = (PanelItem)ButtonPanel.this.itemRef.get();
                    PanelItem panelItem2 = mMultiPanel.onCopyItem(panelItem);
                    if (panelItem2 != null && panelItem2 != panelItem) {
                        mMultiPanel.addItem(panelItem2, true);
                        MScrollPane.scrollToBottom(mMultiPanel, true);
                    } else {
                        TK.beep();
                    }
                }
            };
            this.add(mSmallButton2);
            MSmallButton mSmallButton3 = new MSmallButton(MIcon.small("ui/close"), UI._("Remove Item")){

                @Override
                protected void onClick() {
                    PanelItem panelItem;
                    if (mMultiPanel.getItemCount() == 1) {
                        TK.beep();
                    } else if ((!mMultiPanel.confirmRemove || MMessage.simpleConfirm(this.getWindowAncestor(), MActionInfo.DELETE)) && mMultiPanel.onRemoveItem(panelItem = (PanelItem)ButtonPanel.this.itemRef.get())) {
                        mMultiPanel.removeItem(panelItem);
                    }
                }
            };
            mSmallButton3.setSafeAction(true);
            this.addGap();
            this.add(mSmallButton3);
            mSmallButton.setVisible(mMultiPanel.isButtonVisible(Button.ADD));
            mSmallButton2.setVisible(mMultiPanel.isButtonVisible(Button.COPY));
            mSmallButton3.setVisible(mMultiPanel.isButtonVisible(Button.REMOVE));
            this.addButtonRef = new WeakReference<1>(mSmallButton);
            this.copyButtonRef = new WeakReference<2>(mSmallButton2);
            this.removeButtonRef = new WeakReference<3>(mSmallButton3);
        }

        /* synthetic */ ButtonPanel(MMultiPanel mMultiPanel, PanelItem panelItem, org.makagiga.commons.MMultiPanel$1 var3_3) {
            this(mMultiPanel, panelItem);
        }
    }

    public static class PanelItem
    extends MPanel {
        public PanelItem() {
            this(5, 5);
        }

        public PanelItem(int n, int n2) {
            super(n, n2);
        }

        public PanelItem(LayoutManager layoutManager) {
            super(layoutManager);
        }

        public MButton getButton(Button button) {
            ItemWrapper itemWrapper = (ItemWrapper)this.getParent();
            ButtonPanel buttonPanel = itemWrapper.getButtonPanel();
            switch (button) {
                case ADD: {
                    return (MButton)buttonPanel.addButtonRef.get();
                }
                case COPY: {
                    return (MButton)buttonPanel.copyButtonRef.get();
                }
                case REMOVE: {
                    return (MButton)buttonPanel.removeButtonRef.get();
                }
            }
            throw new WTFError(button);
        }
    }

    public static enum Button {
        ADD,
        COPY,
        REMOVE;

    }
}

