/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import edu.umd.cs.findbugs.annotation.SuppressWarnings;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.makagiga.commons.BooleanProperty;
import org.makagiga.commons.ConfigEntry;
import org.makagiga.commons.FS;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MFormat;
import org.makagiga.commons.MSmallButton;
import org.makagiga.commons.MTimer;
import org.makagiga.commons.PropertyAccess;
import org.makagiga.commons.StringProperty;
import org.makagiga.commons.TK;
import org.makagiga.commons.TriBoolean;
import org.makagiga.commons.UI;

public final class MLogger
extends Logger {
    @ConfigEntry(value="Debug.log")
    public static final PropertyAccess<String> debugLog = new StringProperty("+core").getSecure();
    @ConfigEntry(value="developer")
    public static final PropertyAccess<Boolean> developer = new BooleanProperty().getSecure();
    private static boolean logAll;
    private static Map<String, Boolean> logConfig;
    private static final Map<String, MLogger> loggerMap;
    private static MLogger _instance;
    private static String lastDebugLog;

    @Deprecated
    public MLogger(String string) {
        super(string, null);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            this.doInit();
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    MLogger.this.doInit();
                    return null;
                }
            });
        }
    }

    public static MSmallButton createMemoryPanel() {
        final MSmallButton mSmallButton = new MSmallButton(){

            @Override
            @SuppressWarnings(value="Dm")
            protected void onClick() {
                System.gc();
            }
        };
        mSmallButton.setFocusable(false);
        mSmallButton.setStyle("font-size: smaller");
        mSmallButton.setText("GC");
        mSmallButton.setToolTipText(UI.makeHTML("Heap memory usage.<br>Click to run <i>Garbage Collector</i>."));
        MTimer mTimer = new MTimer(MTimer.Format.SECONDS, 2){
            private long max;
            private long oldUsed;

            @Override
            protected boolean onTimeout() {
                if (!MLogger.isDeveloper()) {
                    return true;
                }
                MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
                long l = memoryMXBean.getHeapMemoryUsage().getUsed();
                long l2 = l - this.oldUsed;
                this.oldUsed = l;
                this.max = Math.max(l, this.max);
                mSmallButton.setForeground(l2 <= 0L ? MColor.DARK_GREEN : MColor.DARK_RED);
                mSmallButton.setText(MFormat.toMB(l) + " / " + MFormat.toMB(this.max) + " [" + MFormat.toMB(l2) + "]");
                return true;
            }
        };
        mTimer.start();
        developer.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("value".equals(propertyChangeEvent.getPropertyName())) {
                    mSmallButton.setVisible((Boolean)propertyChangeEvent.getNewValue());
                }
            }
        });
        return mSmallButton;
    }

    public void debug(String string) {
        if (this.isDebug()) {
            this.info("[" + string + "]");
        }
    }

    public void debugFormat(String string, Object ... objectArray) {
        if (this.isDebug()) {
            this.info("[" + MLogger.format(string, objectArray) + "]");
        }
    }

    public static void debug(String string, String string2) {
        if (MLogger.isDebug(string)) {
            _instance.info(string + " [" + string2 + "]");
        }
    }

    public static void debug(String string, String string2, Object ... objectArray) {
        if (MLogger.isDebug(string)) {
            _instance.info(string + " [" + MLogger.format(string2, objectArray) + "]");
        }
    }

    public void error(String string) {
        if (this.isDebug()) {
            this.severe(string);
        }
    }

    public void errorFormat(String string, Object ... objectArray) {
        if (this.isDebug()) {
            this.severe(MLogger.format(string, objectArray));
        }
    }

    public static void error(String string, String string2) {
        if (MLogger.isDebug(string)) {
            _instance.severe(string + ": " + string2);
        }
    }

    public static void error(String string, String string2, Object ... objectArray) {
        if (MLogger.isDebug(string)) {
            _instance.severe(string + ": " + MLogger.format(string2, objectArray));
        }
    }

    public static void exception(Throwable throwable) {
        if (throwable == null) {
            return;
        }
        MLogger.error("exception", throwable.toString());
        System.err.println("Current Thread: " + Thread.currentThread());
        throwable.printStackTrace(System.err);
    }

    public static String format(String string, Object ... objectArray) {
        if (string == null) {
            return "null";
        }
        try {
            return String.format(string, objectArray);
        }
        catch (IllegalFormatException illegalFormatException) {
            illegalFormatException.printStackTrace(System.err);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MLogger get(String string) {
        MLogger mLogger;
        Map<String, MLogger> map = loggerMap;
        synchronized (map) {
            mLogger = loggerMap.get(string);
        }
        if (mLogger != null) {
            return mLogger;
        }
        mLogger = new MLogger(string);
        map = loggerMap;
        synchronized (map) {
            loggerMap.put(string, mLogger);
        }
        return mLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<MLogger> getLogs() {
        Map<String, MLogger> map = loggerMap;
        synchronized (map) {
            return new MArrayList<MLogger>(loggerMap.values());
        }
    }

    @Override
    public void info(String string) {
        super.info(string);
    }

    public void infoFormat(String string, Object ... objectArray) {
        if (this.isDebug()) {
            this.info(MLogger.format(string, objectArray));
        }
    }

    public static void info(String string, String string2) {
        if (MLogger.isDebug(string)) {
            _instance.info(string + ": " + string2);
        }
    }

    public static void info(String string, String string2, Object ... objectArray) {
        if (MLogger.isDebug(string)) {
            _instance.info(string + ": " + MLogger.format(string2, objectArray));
        }
    }

    public boolean isDebug() {
        return MLogger.isDebug(this.getName());
    }

    public static synchronized boolean isDebug(String string) {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            String string2 = securityManager == null ? debugLog.get() : AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return debugLog.get();
                }
            });
            if (string2 == null || !string2.equals(lastDebugLog)) {
                lastDebugLog = string2;
                logAll = false;
                logConfig.clear();
                if (!TK.isEmpty(lastDebugLog)) {
                    block6: for (String string3 : TK.fastSplit(lastDebugLog, ',')) {
                        if (string3.length() > 1) {
                            if (string3.equals("+all")) {
                                logAll = true;
                                continue;
                            }
                            switch (string3.charAt(0)) {
                                case '+': {
                                    logConfig.put(string3.substring(1), true);
                                    continue block6;
                                }
                                case '-': {
                                    logConfig.put(string3.substring(1), false);
                                    continue block6;
                                }
                            }
                            System.err.println("MAKAGIGA: Invalid logger configuration (org.makagiga.commons.MLogger.debugLog): " + string3);
                            continue;
                        }
                        System.err.println("MAKAGIGA: Invalid logger configuration (org.makagiga.commons.MLogger.debugLog): " + string3);
                    }
                }
            }
            Boolean bl = logConfig.get(string);
            if (logAll || MLogger.isDeveloper()) {
                return bl == null || bl != false;
            }
            return bl != null && bl != false || "log".equals(string);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            return false;
        }
    }

    public static boolean isDeveloper() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return developer.get();
        }
        TriBoolean triBoolean = AccessController.doPrivileged(new PrivilegedAction<TriBoolean>(){

            @Override
            public TriBoolean run() {
                return TriBoolean.from(developer.get());
            }
        });
        return triBoolean.isTrue();
    }

    public static void trace() {
        Thread.dumpStack();
    }

    public static void trace(int n) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i = 2; i < stackTraceElementArray.length && i - 2 < n; ++i) {
            System.err.println("\tat " + stackTraceElementArray[i]);
        }
    }

    @Override
    public void warning(String string) {
        if (this.isDebug()) {
            super.warning(string);
        }
    }

    public void warningFormat(String string, Object ... objectArray) {
        if (this.isDebug()) {
            super.warning(MLogger.format(string, objectArray));
        }
    }

    public static void warning(String string, String string2) {
        if (MLogger.isDebug(string)) {
            _instance.warning(string + ": " + string2);
        }
    }

    public static void warning(String string, String string2, Object ... objectArray) {
        if (MLogger.isDebug(string)) {
            _instance.warning(string + ": " + MLogger.format(string2, objectArray));
        }
    }

    public static void XXX() {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        if (stackTraceElementArray.length > 2) {
            MLogger.XXX("YOU ARE HERE: %s", stackTraceElementArray[2]);
        } else {
            MLogger.XXX("YOU ARE HERE");
        }
    }

    public static void XXX(Object object) {
        if (object == null) {
            _instance.finest("***: null");
        } else {
            _instance.finest("***: " + object.getClass().getName() + ": \"" + object + "\"");
        }
    }

    public static void XXX(String string) {
        _instance.finest("***: " + string);
    }

    public static void XXX(String string, Object ... objectArray) {
        MLogger.XXX(MLogger.format(string, objectArray));
    }

    public static void XXXTrace() {
        MLogger.XXX();
        MLogger.trace();
    }

    public static void XXXTrace(String string) {
        MLogger.XXX(string);
        MLogger.trace();
    }

    private MLogger() {
        this("log");
        this.setUseParentHandlers(false);
    }

    private void doInit() {
        super.addHandler(new MHandler());
        super.setLevel(Level.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        logConfig = new HashMap<String, Boolean>();
        loggerMap = TK.newHashMap();
        Class<MLogger> clazz = MLogger.class;
        synchronized (MLogger.class) {
            _instance = new MLogger();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static final class MHandler
    extends Handler {
        private final MFormatter formatter = new MFormatter();

        private MHandler() {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void publish(LogRecord logRecord) {
            System.err.println(this.formatter.format(logRecord));
        }
    }

    private static final class MFormatter
    extends Formatter {
        private MFormatter() {
        }

        @Override
        public String format(LogRecord logRecord) {
            StringBuilder stringBuilder = new StringBuilder();
            if (!FS.isRestricted()) {
                stringBuilder.append(MApplication.getInternalName()).append(' ');
            }
            stringBuilder.append('[').append(logRecord.getSequenceNumber()).append("] ").append(logRecord.getLevel()).append(": ");
            String string = logRecord.getLoggerName();
            if (!"log".equals(string)) {
                stringBuilder.append(string).append(": ");
            }
            stringBuilder.append(logRecord.getMessage());
            return stringBuilder.toString();
        }
    }
}

