/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.security.BasicPermission;
import org.makagiga.commons.PermissionInfo;
import org.makagiga.commons.TK;

public final class MGuardedObject<T> {
    private PermissionInfo.ThreatLevel threatLevel;
    private String description;
    private String name;
    private T object;

    @Deprecated
    public MGuardedObject(T t, String string) {
        this(t, string, PermissionInfo.ThreatLevel.UNKNOWN, null);
    }

    public MGuardedObject(T t, String string, PermissionInfo.ThreatLevel threatLevel, String string2) {
        this.object = TK.checkNull(t, "object");
        this.name = TK.checkNullOrEmpty(string, "name");
        this.threatLevel = TK.checkNull(threatLevel);
        this.description = string2;
    }

    public void clear() {
        if (this.object != null) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new Permission(this.name, "clear", this.threatLevel, this.description));
            }
            this.object = null;
        }
    }

    public T get() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new Permission(this.name, "get", this.threatLevel, this.description));
        }
        return this.object;
    }

    public static final class Permission
    extends BasicPermission
    implements PermissionInfo {
        public static final String CLEAR_ACTION = "clear";
        public static final String GET_ACTION = "get";
        private final String actions;
        private final String description;
        private final PermissionInfo.ThreatLevel threatLevel;

        @Deprecated
        public Permission(String string, String string2) {
            this(string, string2, PermissionInfo.ThreatLevel.UNKNOWN, null);
        }

        public Permission(String string, String string2, PermissionInfo.ThreatLevel threatLevel, String string3) {
            super(string);
            this.actions = string2;
            this.threatLevel = TK.checkNull(threatLevel);
            this.description = string3;
        }

        @Override
        public String getActions() {
            return this.actions;
        }

        @Override
        public String getPermissionDescription() {
            return this.description;
        }

        @Override
        public int getPermissionOptions() {
            return 0;
        }

        @Override
        public PermissionInfo.ThreatLevel getThreatLevel() {
            return this.threatLevel;
        }
    }
}

