/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import org.makagiga.commons.MDisposable;
import org.makagiga.commons.UI;

public class MGraphics2D
implements MDisposable {
    private Graphics2D g;
    private final Dimension size = new Dimension(0, 0);
    private final Point location = new Point();

    public MGraphics2D(BufferedImage bufferedImage) {
        this.g = bufferedImage.createGraphics();
        this.size.width = bufferedImage.getWidth();
        this.size.height = bufferedImage.getHeight();
    }

    public MGraphics2D(Graphics graphics) {
        this.g = (Graphics2D)graphics;
    }

    public static MGraphics2D copy(Graphics graphics) {
        return new MGraphics2D(graphics.create());
    }

    public static Shape createTriangle(int n, int n2, int n3, int n4, int n5, int n6) {
        Path2D.Float float_ = new Path2D.Float();
        float_.moveTo(n, n2);
        float_.lineTo(n3, n4);
        float_.lineTo(n5, n6);
        return float_;
    }

    public void drawHLine(int n, int n2, int n3) {
        this.g.drawLine(n, n2, n3, n2);
    }

    public void drawVLine(int n, int n2, int n3) {
        this.g.drawLine(n, n2, n, n3);
    }

    public void drawIcon(Component component, Icon icon, int n, int n2) {
        icon.paintIcon(component, this.g, n, n2);
    }

    public void drawIcon(Icon icon, int n, int n2) {
        icon.paintIcon(null, this.g, n, n2);
    }

    public void drawImage(Image image, int n, int n2) {
        this.g.drawImage(image, n, n2, null);
    }

    @Deprecated
    public void drawImage(Image image) {
        this.drawImage(image, this.location.x, this.location.y);
    }

    public void drawPoint(int n, int n2) {
        this.g.drawLine(n, n2, n, n2);
    }

    public void drawPoint(Point point) {
        this.drawPoint(point.x, point.y);
    }

    public static void drawPoint(Graphics graphics, int n, int n2) {
        graphics.drawLine(n, n2, n, n2);
    }

    public void drawString(String string, int n, int n2) {
        this.g.drawString(string, n, n2);
    }

    public void drawStringCentered(String string, int n, int n2, int n3, int n4) {
        FontMetrics fontMetrics = this.g.getFontMetrics();
        this.g.drawString(string, n + n3 / 2 - fontMetrics.stringWidth(string) / 2, n2 + n4 / 2 - fontMetrics.getHeight() / 2 + fontMetrics.getAscent());
    }

    public void drawStringCentered(String string, Component component) {
        this.drawStringCentered(string, 0, 0, component.getWidth(), component.getHeight());
    }

    public void fillRect() {
        this.g.fillRect(0, 0, this.size.width, this.size.height);
    }

    public static void fillRect(Graphics graphics, Component component) {
        graphics.fillRect(0, 0, component.getWidth(), component.getHeight());
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5) {
        this.g.fillRoundRect(n, n2, n3, n4, n5, n5);
    }

    public FontMetrics getFontMetrics() {
        return this.g.getFontMetrics();
    }

    public Graphics2D getGraphics2D() {
        return this.g;
    }

    public void setAlpha(float f) {
        this.g.setComposite(AlphaComposite.SrcOver.derive(f));
    }

    public void setAntialiasing(boolean bl) {
        UI.setAntialiasing(this.g, bl);
    }

    public void setColor(Color color) {
        this.g.setColor(color);
    }

    public void setFont(Font font) {
        this.g.setFont(font);
    }

    public void setFont(String string, int n, int n2) {
        this.g.setFont(new Font(string, n, n2));
    }

    public void setLineWidth(int n) {
        this.g.setStroke(new BasicStroke(n));
    }

    @Deprecated
    public void setLocation(int n, int n2) {
        this.location.setLocation(n, n2);
    }

    @Deprecated
    public void setLocation(Point point) {
        this.location.setLocation(point);
    }

    public void setTextAntialiasing(RenderingHints renderingHints) {
        UI.setTextAntialiasing(this.g, renderingHints);
    }

    @Override
    public Object dispose(Object ... objectArray) {
        if (this.g != null) {
            this.g.dispose();
            this.g = null;
        }
        return null;
    }
}

