/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.makagiga.commons.MComponent;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.fx.ComponentTransition;
import org.makagiga.commons.fx.ImageTransition;

public class MFlipPanel
extends MPanel {
    public static final String BACK_COMPONENT = "org.makagiga.commons.MFlipPanel.back";
    public static final String FRONT_COMPONENT = "org.makagiga.commons.MFlipPanel.front";
    private static final String ANIMATION_COMPONENT = "org.makagiga.commons.MFlipPanel.animation";
    private WeakReference<AnimationComponent> animationComponentRef;
    private WeakReference<Component> backComponentRef;
    private WeakReference<Component> frontComponentRef;
    String currentCard = "org.makagiga.commons.MFlipPanel.front";

    public MFlipPanel() {
        this(null, null);
    }

    public MFlipPanel(JComponent jComponent, JComponent jComponent2) {
        super(new CardLayout());
        if (jComponent != null) {
            this.setFrontComponent(jComponent);
        }
        if (jComponent2 != null) {
            this.setBackComponent(jComponent2);
        }
        AnimationComponent animationComponent = new AnimationComponent();
        this.add((Component)animationComponent, ANIMATION_COMPONENT);
        this.animationComponentRef = new WeakReference<AnimationComponent>(animationComponent);
    }

    public Component getBackComponent() {
        return this.backComponentRef == null ? null : (Component)this.backComponentRef.get();
    }

    public void setBackComponent(Component component) {
        this.add(component, BACK_COMPONENT);
        this.backComponentRef = new WeakReference<Component>(component);
    }

    public CardLayout getCards() {
        return (CardLayout)this.getLayout();
    }

    public Component getFrontComponent() {
        return this.frontComponentRef == null ? null : (Component)this.frontComponentRef.get();
    }

    public void setFrontComponent(Component component) {
        this.add(component, FRONT_COMPONENT);
        this.frontComponentRef = new WeakReference<Component>(component);
    }

    public ImageTransition.Effect getTransitionEffect() {
        AnimationComponent animationComponent = (AnimationComponent)this.animationComponentRef.get();
        return animationComponent == null ? null : animationComponent.effect;
    }

    public void setTransitionEffect(ImageTransition.Effect effect) {
        AnimationComponent animationComponent = (AnimationComponent)this.animationComponentRef.get();
        if (animationComponent != null) {
            animationComponent.effect = effect;
        }
    }

    public boolean isFrontVisible() {
        return FRONT_COMPONENT.equals(this.currentCard);
    }

    public void setFrontVisible(boolean bl) {
        this.setFrontVisible(bl, true);
    }

    public void setFrontVisible(boolean bl, boolean bl2) {
        if (bl == this.isFrontVisible()) {
            return;
        }
        this.currentCard = bl ? FRONT_COMPONENT : BACK_COMPONENT;
        AnimationComponent animationComponent = (AnimationComponent)this.animationComponentRef.get();
        if (animationComponent != null && animationComponent.transition != null) {
            animationComponent.unstallChangeListener();
            animationComponent.transition.stopTransition(this);
            animationComponent.transition = null;
        }
        if (this.getTransitionEffect() == null) {
            this.doFlip(this.currentCard);
            return;
        }
        if (animationComponent != null && bl2) {
            Component component = this.getBackComponent();
            Component component2 = this.getFrontComponent();
            if (component != null && component2 != null && component.getWidth() > 0 && component.getHeight() > 0 && component2.getWidth() > 0 && component2.getHeight() > 0) {
                animationComponent.transition = new ComponentTransition((Component)animationComponent, component.isVisible() ? component : component2, component.isVisible() ? component2 : component, animationComponent.effect);
                animationComponent.transition.startTransition(this);
                animationComponent.installChangeListener();
                this.showCard(ANIMATION_COMPONENT);
            } else {
                animationComponent.transition = null;
                this.doFlip(this.currentCard);
            }
        } else {
            this.doFlip(this.currentCard);
        }
    }

    public void toggle() {
        this.setFrontVisible(!this.isFrontVisible());
    }

    protected void onFlip() {
    }

    private void doFlip(String string) {
        this.showCard(string);
        this.onFlip();
    }

    private final class AnimationComponent
    extends MComponent {
        private ChangeListener changeListener;
        private ComponentTransition transition;
        private ImageTransition.Effect effect;

        @Override
        public void paintComponent(Graphics graphics) {
            if (this.transition == null) {
                return;
            }
            if (!this.transition.isTransitionActive()) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            this.transition.paintTransition(this, graphics2D);
        }

        private AnimationComponent() {
        }

        private void installChangeListener() {
            this.unstallChangeListener();
            this.changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (!AnimationComponent.this.transition.isTransitionActive()) {
                        MFlipPanel.this.doFlip(MFlipPanel.this.currentCard);
                    }
                }
            };
            this.transition.addChangeListener(this.changeListener);
        }

        private void unstallChangeListener() {
            if (this.changeListener != null) {
                this.transition.removeChangeListener(this.changeListener);
                this.changeListener = null;
            }
        }
    }
}

