/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilePermission;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import org.makagiga.commons.Config;
import org.makagiga.commons.ContainerIterator;
import org.makagiga.commons.FS;
import org.makagiga.commons.Kiosk;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MCheckBox;
import org.makagiga.commons.MComboBox;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MText;
import org.makagiga.commons.RegExp;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.preview.DefaultPreview;
import org.makagiga.commons.preview.PreviewPanel;

public class MFileChooser
extends JFileChooser {
    private static boolean initDone;
    private boolean autoAddExtension;
    private Component parent;
    private MCheckBox preview;
    private MCheckBox showHiddenFiles;
    private MComboBox<Charset> charset;
    private PreviewPanel previewPanel;
    private String configKey;

    public MFileChooser() {
        this((Window)null, (String)null);
    }

    public MFileChooser(Window window) {
        this(window, null);
    }

    public MFileChooser(Window window, String string) {
        this.parent = window;
        this.setAccessory(this.createAccessory());
        this.setDragEnabled((Boolean)Kiosk.actionDragDrop.get());
        this.setTitle(string);
        Config config = this.getConfigPrivileged();
        if (this.preview != null) {
            this.preview.setSelected(config.read("FileChooser.preview", true));
            this.setPreviewEnabled(this.preview.isSelected());
        }
        if (this.showHiddenFiles == null) {
            this.setFileHidingEnabled(false);
        } else if (config.read("FileChooser.showHiddenFiles", false)) {
            this.showHiddenFiles.setSelected(true);
            this.setFileHidingEnabled(false);
        } else {
            this.showHiddenFiles.setSelected(false);
            this.setFileHidingEnabled(true);
        }
        for (JTextField jTextField : ContainerIterator.findAll(this, JTextField.class)) {
            if (!jTextField.isVisible()) continue;
            MText.commonSetup(jTextField);
        }
    }

    public FileFilter addFilter(String string, String ... stringArray) {
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter(string + " [" + TK.toString(stringArray, ", ") + "]", stringArray);
        this.addChoosableFileFilter(fileNameExtensionFilter);
        return fileNameExtensionFilter;
    }

    public FileFilter addImageIOReaderFilter() {
        return this.addFilter(UI._("Images"), ImageIO.getReaderFileSuffixes());
    }

    public FileFilter addImageIOWriterFilter() {
        return this.addFilter(UI._("Images"), ImageIO.getWriterFileSuffixes());
    }

    public static MFileChooser createDirectoryChooser(Window window, String string) {
        MFileChooser mFileChooser = new MFileChooser(window, string);
        mFileChooser.setFileSelectionMode(1);
        return mFileChooser;
    }

    public static MFileChooser createFileChooser(Window window) {
        MFileChooser mFileChooser = new MFileChooser(window);
        mFileChooser.setFileSelectionMode(0);
        return mFileChooser;
    }

    public static MFileChooser createFileChooser(Window window, String string) {
        MFileChooser mFileChooser = new MFileChooser(window, string);
        mFileChooser.setFileSelectionMode(0);
        return mFileChooser;
    }

    public static void deletePrivateData() {
        Config config = Config.getDefault();
        config.removeAllValues(new RegExp("String\\.FileChooser\\.directory\\..+"));
        config.sync();
    }

    public boolean getAutoAddExtension() {
        return this.autoAddExtension;
    }

    public void setAutoAddExtension(boolean bl) {
        this.autoAddExtension = bl;
    }

    public String getCurrentDir() {
        return this.getCurrentDirectory().getPath();
    }

    public void setCurrentDir(String string) {
        this.setCurrentDirectory(string == null ? null : new File(string));
    }

    public Charset getSelectedCharset() {
        return this.charset.getSelectedItem();
    }

    public void setSelectedCharset(Charset charset) {
        this.charset.setSelectedItem(charset);
    }

    public String getSelectedPath() {
        File file = this.getSelectedFile();
        return file == null ? null : file.getPath();
    }

    public void setSelectedPath(String string) {
        this.setSelectedFile(new File(string));
    }

    public static synchronized void init() {
        if (initDone) {
            return;
        }
        if (UI.isMetal() || UI.isNimbus() || UI.isSubstance()) {
            UIManager.put("FileChooser.detailsViewIcon", MIcon.small("ui/detailedview"));
            UIManager.put("FileChooser.homeFolderIcon", MIcon.small("ui/home"));
            UIManager.put("FileChooser.listViewIcon", MIcon.small("ui/multicolumnview"));
            UIManager.put("FileChooser.newFolderIcon", MActionInfo.NEW_FOLDER.getSmallIcon());
            UIManager.put("FileChooser.upFolderIcon", MIcon.small("ui/up"));
            UIManager.put("FileView.directoryIcon", MIcon.small("ui/folder"));
            UIManager.put("FileView.fileIcon", MIcon.small("ui/file"));
        }
        initDone = true;
    }

    public boolean isCharsetVisible() {
        return this.charset != null && this.charset.isVisible();
    }

    public void setCharsetVisible(boolean bl, int n) {
        if (bl != this.isCharsetVisible()) {
            if (this.charset == null) {
                this.charset = new MComboBox();
                this.charset.addAllItems(Charset.availableCharsets().values());
                Config config = this.getConfigPrivileged();
                String string = config.read(this.getCharsetKey(n), "UTF-8");
                if (string != null) {
                    for (Charset charset : this.charset) {
                        if (!charset.name().equals(string)) continue;
                        this.charset.setSelectedItem(charset);
                        break;
                    }
                }
                this.charset.setToolTipText(UI._("Text Encoding"));
                this.getAccessory().add((Component)this.charset, 0);
                this.getAccessory().revalidate();
            }
            this.charset.setVisible(bl);
        }
    }

    public boolean openDialog() {
        if (this.showOpenDialog(this.parent) == 0) {
            this.previewPanel.cancel(true);
            this.saveConfig();
            return true;
        }
        this.previewPanel.cancel(true);
        return false;
    }

    public void saveConfig() {
        Config config = this.getConfigPrivileged();
        if (this.configKey != null) {
            config.write(Config.getPlatformKey(this.configKey), this.getCurrentDir());
        }
        if (this.charset != null) {
            config.write(this.getCharsetKey(this.getDialogType()), this.charset.getSelectedItem().name());
        }
        config.write("FileChooser.preview", this.preview != null && this.preview.isSelected());
        config.write("FileChooser.showHiddenFiles", !this.isFileHidingEnabled());
        if (System.getSecurityManager() == null) {
            config.sync();
        }
    }

    public boolean saveDialog() {
        if (this.showSaveDialog(this.parent) == 0) {
            this.previewPanel.cancel(true);
            this.saveConfig();
            File file = this.getSelectedFile();
            FileFilter fileFilter = this.getFileFilter();
            if (this.autoAddExtension && FS.getExtension(file) == null && fileFilter instanceof FileNameExtensionFilter) {
                FileNameExtensionFilter fileNameExtensionFilter = (FileNameExtensionFilter)fileFilter;
                file = new File(file.getPath() + "." + fileNameExtensionFilter.getExtensions()[0]);
                this.setSelectedFile(file);
            }
            return !file.exists() || MMessage.confirmFileOverwrite(null, null, file, null);
        }
        this.previewPanel.cancel(true);
        return false;
    }

    public void setApproveText(String string) {
        this.setApproveButtonText(string);
        this.setApproveButtonMnemonic(0);
    }

    public void setConfigKey(String string) {
        TK.checkNullOrEmpty(string, "value");
        this.configKey = "FileChooser.directory." + string;
        Config config = this.getConfigPrivileged();
        this.setCurrentDir(config.read(Config.getPlatformKey(this.configKey), FS.getUserDir()));
    }

    public void setPreviewEnabled(boolean bl) {
        this.previewPanel.setPreviewEnabled(bl);
        this.previewPanel.update(this.getSelectedFile());
    }

    public void setTitle(String string) {
        this.setDialogTitle(string);
    }

    @Override
    public void setup(FileSystemView fileSystemView) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new FilePermission("<<ALL FILES>>", "read,write"));
        }
        MFileChooser.init();
        super.setup(fileSystemView);
    }

    @Override
    public int showDialog(Component component, String string) {
        if (MApplication.forceRTL) {
            this.applyComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
        return super.showDialog(component, string);
    }

    protected MPanel createAccessory() {
        MPanel mPanel = MPanel.createVBoxPanel();
        mPanel.setMargin(0, 5, 0, 0);
        this.showHiddenFiles = new MCheckBox(UI._("Show Hidden Files"));
        this.showHiddenFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MCheckBox mCheckBox = (MCheckBox)actionEvent.getSource();
                MFileChooser.this.setFileHidingEnabled(!mCheckBox.isSelected());
            }
        });
        mPanel.add(this.showHiddenFiles);
        this.preview = new MCheckBox(UI._("Preview"));
        this.preview.onSelect(this, "previewEnabled");
        mPanel.add(this.preview);
        SecurityManager securityManager = System.getSecurityManager();
        DefaultPreview defaultPreview = securityManager == null ? DefaultPreview.getInstance() : AccessController.doPrivileged(new PrivilegedAction<DefaultPreview>(){

            @Override
            public DefaultPreview run() {
                return DefaultPreview.getInstance();
            }
        });
        this.previewPanel = new PreviewPanel(defaultPreview, 150);
        mPanel.add(this.previewPanel);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if ("directoryChanged".equals(string)) {
                    MFileChooser.this.previewPanel.clear();
                } else if ("SelectedFileChangedProperty".equals(string)) {
                    File file = (File)propertyChangeEvent.getNewValue();
                    MFileChooser.this.previewPanel.update(file);
                }
            }
        });
        return mPanel;
    }

    private String getCharsetKey(int n) {
        String string = "FileChooser.charset.";
        if (n == 2) {
            string = string + "custom";
        } else if (n == 0) {
            string = string + "open";
        } else if (n == 1) {
            string = string + "save";
        } else {
            throw new IllegalArgumentException("dialogType must be CUSTOM_DIALOG, OPEN_DIALOG or SAVE_DIALOG");
        }
        return string;
    }

    private Config getConfigPrivileged() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return Config.getDefault();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Config>(){

            @Override
            public Config run() {
                return Config.getDefault();
            }
        });
    }
}

