/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import javax.swing.Icon;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.WTFError;

public class MColorIcon
implements Icon,
Serializable {
    public static final int COMPONENT_SIZE = -1;
    public static final int UI_SIZE = -2;
    protected Color color;
    protected int height;
    protected int width;
    protected Type type;
    private Icon icon;
    private int padding;

    public MColorIcon() {
        this(Color.BLACK, MIcon.getDefaultSize());
    }

    public MColorIcon(Color color) {
        this(color, -2, -2, Type.RECTANGLE);
    }

    public MColorIcon(Color color, Icon icon) {
        this.color = color;
        this.icon = icon;
        this.type = Type.RECTANGLE;
    }

    public MColorIcon(Color color, int n) {
        this(color, n, n, Type.RECTANGLE);
    }

    public MColorIcon(Color color, Dimension dimension) {
        this(color, dimension.width, dimension.height, Type.RECTANGLE);
    }

    public MColorIcon(Color color, int n, int n2, Type type) {
        this.color = color;
        this.width = n;
        this.height = n2;
        this.type = TK.checkNull(type, "type");
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int n) {
        this.padding = n;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = TK.checkNull(type, "value");
    }

    @Override
    public int getIconHeight() {
        if (this.icon != null) {
            return this.makePadding(this.icon.getIconHeight());
        }
        switch (this.height) {
            case -2: 
            case -1: {
                return this.makePadding(MIcon.getSmallSize());
            }
        }
        return this.makePadding(this.height);
    }

    @Override
    public int getIconWidth() {
        if (this.icon != null) {
            return this.makePadding(this.icon.getIconWidth());
        }
        switch (this.width) {
            case -2: 
            case -1: {
                return this.makePadding(MIcon.getSmallSize());
            }
        }
        return this.makePadding(this.width);
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        int n3;
        int n4;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (component == null) {
            n4 = this.getIconWidth();
            n3 = this.getIconHeight();
        } else {
            if (this.width == -1) {
                n = 0;
                n4 = component.getWidth();
            } else {
                n4 = this.getIconWidth();
            }
            if (this.height == -1) {
                n2 = 0;
                n3 = component.getHeight();
            } else {
                n3 = this.getIconHeight();
            }
        }
        this.paintBackground(component, graphics2D, n, n2, n4, n3);
        if (this.icon != null) {
            this.icon.paintIcon(component, graphics2D, n + this.padding, n2 + this.padding);
        }
    }

    protected void paintBackground(Component component, Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        Cloneable cloneable;
        Color color;
        boolean bl;
        boolean bl2;
        if (component == null) {
            bl2 = true;
            bl = false;
        } else {
            bl2 = component.isEnabled();
            bl = component.isFocusOwner();
        }
        Color color2 = this.color == null ? (component == null ? Color.BLACK : component.getBackground()) : (color = this.color);
        if (color == null) {
            color = Color.BLACK;
        }
        Color color3 = bl2 ? color : color.darker();
        Color color4 = null;
        if (bl2 && component != null && (cloneable = component.getMousePosition()) != null) {
            color4 = MColor.getBrighter(color3);
        }
        if (color4 == null) {
            color4 = color3.darker();
        }
        cloneable = null;
        switch (this.type) {
            case OVAL: {
                cloneable = new Ellipse2D.Float((float)n + 2.0f, (float)n2 + 2.0f, n3 - 5, n4 - 5);
                break;
            }
            case RECTANGLE: {
                cloneable = new Rectangle2D.Float((float)n + 2.0f, (float)n2 + 2.0f, n3 - 5, n4 - 5);
                break;
            }
            case RECTANGLE_SIMPLE: {
                cloneable = new Rectangle2D.Float(n, n2, n3, n4);
                break;
            }
            default: {
                throw new WTFError(this.type);
            }
        }
        Object object = UI.setAntialiasing(graphics2D, true);
        graphics2D.setColor(color3);
        graphics2D.fill((Shape)((Object)cloneable));
        graphics2D.setColor(color4);
        graphics2D.draw((Shape)((Object)cloneable));
        if (this.type == Type.OVAL) {
            Composite composite = graphics2D.getComposite();
            Shape shape = graphics2D.getClip();
            Paint paint = graphics2D.getPaint();
            LinearGradientPaint linearGradientPaint = new LinearGradientPaint(2.0f, 2.0f, n3 - 3, n4 - 3, new float[]{0.0f, 0.6f}, new Color[]{Color.WHITE, UI.INVISIBLE});
            graphics2D.setClip((Shape)((Object)cloneable));
            graphics2D.setComposite(AlphaComposite.SrcOver.derive(0.6f));
            graphics2D.setPaint(linearGradientPaint);
            graphics2D.fill((Shape)((Object)cloneable));
            graphics2D.setClip(shape);
            graphics2D.setComposite(composite);
            graphics2D.setPaint(paint);
        }
        if (bl) {
            switch (this.type) {
                case OVAL: {
                    float f = 2.0f;
                    cloneable = new Ellipse2D.Float((float)n + 2.0f + f, (float)n2 + 2.0f + f, (float)(n3 - 5) - f * 2.0f, (float)(n4 - 5) - f * 2.0f);
                    break;
                }
                case RECTANGLE: {
                    float f = 2.0f;
                    cloneable = new Rectangle2D.Float((float)n + 2.0f + f, (float)n2 + 2.0f + f, (float)(n3 - 5) - f * 2.0f, (float)(n4 - 5) - f * 2.0f);
                    break;
                }
                case RECTANGLE_SIMPLE: {
                    cloneable = new Rectangle2D.Float((float)n + 2.0f, (float)n2 + 2.0f, n3 - 4, n4 - 4);
                    break;
                }
                default: {
                    throw new WTFError(this.type);
                }
            }
            graphics2D.setColor(MColor.getContrast(color3));
            graphics2D.draw((Shape)((Object)cloneable));
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    private int makePadding(int n) {
        if (this.padding == 0) {
            return n;
        }
        return n + this.padding * 2;
    }

    public static enum Type {
        OVAL,
        RECTANGLE,
        RECTANGLE_SIMPLE;

    }
}

