/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import org.makagiga.commons.Sortable;
import org.makagiga.commons.TK;

public class MArrayList<E>
extends ArrayList<E>
implements Sortable<E> {
    public MArrayList() {
    }

    public MArrayList(Collection<? extends E> collection) {
        super(collection);
    }

    public MArrayList(int n) {
        super(n);
    }

    public MArrayList(E ... EArray) {
        super(EArray.length);
        this.addAll(EArray);
    }

    public void addAll(E ... EArray) {
        Collections.addAll(this, EArray);
    }

    public static <E> MArrayList<E> create() {
        return new MArrayList<E>();
    }

    public static <E> MArrayList<E> create(int n) {
        return new MArrayList<E>(n);
    }

    @Override
    public E getFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.get(0);
    }

    @Override
    public E getLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.get(this.size() - 1);
    }

    @Deprecated
    public String join(String string) {
        return TK.join(this, string);
    }

    public E[] toArray(Class<E> clazz) {
        return TK.newArray(clazz, this.toArray());
    }

    public String toString(String string) {
        return TK.toString(this, string);
    }

    @Deprecated
    public List<E> unmodifiable() {
        return Collections.unmodifiableList(this);
    }

    @Override
    public void sort() {
        Collections.sort(this, null);
    }

    @Override
    public void sort(Comparator<E> comparator) {
        Collections.sort(this, comparator);
    }
}

