/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MObject;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;

public final class MActionInfo
implements Serializable {
    public static final MActionInfo ABOUT = new MActionInfo(UI._("About"), "ui/info");
    public static final MActionInfo ADD_STAR = new MActionInfo(UI._("Add Star"), "ui/star");
    public static final MActionInfo BACK = new MActionInfo(UI._("Back"), "ui/previous");
    public static final MActionInfo DOWNLOAD = new MActionInfo(UI._("Download"), "ui/download");
    public static final MActionInfo FORWARD = new MActionInfo(UI._("Forward"), "ui/next");
    public static final MActionInfo HELP = new MActionInfo(UI._("Help"), "ui/help", 112, 0);
    public static final MActionInfo REMOVE_STAR = new MActionInfo(UI._("Remove Star"), "ui/star");
    public static final MActionInfo ADVANCED = new MActionInfo(UI._("Advanced..."), "ui/warning");
    public static final MActionInfo CANCEL = new MActionInfo(UI._("Cancel"), "ui/cancel");
    public static final MActionInfo CLEAR = new MActionInfo(UI._("Clear"), "ui/delete");
    public static final MActionInfo CLEAR_HISTORY = new MActionInfo(UI._("Clear History"), "ui/delete");
    public static final MActionInfo CLEAR_LEFT = new MActionInfo(UI._("Clear"), "ui/clearleft");
    public static final MActionInfo CLEAR_RIGHT = new MActionInfo(UI._("Clear"), "ui/clearright");
    public static final MActionInfo CLOSE = new MActionInfo(UI._("Close"), "ui/close", 87, MAction.getMenuMask());
    public static final MActionInfo CLOSE_NO_KEY_STROKE = new MActionInfo(UI._("Close"), "ui/close");
    public static final MActionInfo CONTINUE = new MActionInfo(UI._("Continue"), "ui/next");
    public static final MActionInfo COPY = new MActionInfo(UI._("Copy"), "ui/copy", 67, MAction.getMenuMask());
    public static final MActionInfo COPY_AS_HTML = new MActionInfo(UI._("Copy as HTML"), "ui/copy");
    public static final MActionInfo CURRENT_DATE_AND_TIME = new MActionInfo(UI._("Current Date and Time"), "ui/star");
    public static final MActionInfo CUT = new MActionInfo(UI._("Cut"), "ui/cut", 88, MAction.getMenuMask());
    public static final MActionInfo DELETE = new MActionInfo(UI._("Delete"), "ui/delete", 127, 0);
    public static final MActionInfo DELETE_NO_KEY_STROKE = new MActionInfo(UI._("Delete"), "ui/delete");
    public static final MActionInfo FIND = new MActionInfo(UI._("Find..."), "ui/find", 70, MAction.getMenuMask());
    public static final MActionInfo IMPORT = new MActionInfo(UI._("Import"), "ui/ok");
    public static final MActionInfo INSTALL = new MActionInfo(UI._("Install"), "ui/save");
    public static final MActionInfo LOCK = new MActionInfo(UI._("Lock"), "ui/locked");
    public static final MActionInfo LOGIN = new MActionInfo(UI._("Login"), "ui/ok");
    public static final MActionInfo NEW = new MActionInfo(UI._("New"), "ui/newfile", 78, MAction.getMenuMask());
    public static final MActionInfo NEW_FOLDER = new MActionInfo(UI._("New Folder..."), "ui/newfolder", 78, MAction.getMenuMask() | 1);
    public static final MActionInfo NEXT = new MActionInfo(UI._("Next"), "ui/next");
    public static final MActionInfo NO_DATE_TIME = new MActionInfo(UI._("No Date/Time"), "ui/clearright");
    public static final MActionInfo OK = new MActionInfo(UI._("OK"), "ui/ok");
    public static final MActionInfo OPEN = new MActionInfo(UI._("Open..."), "ui/open", 79, MAction.getMenuMask());
    public static final MActionInfo OPEN_URI = new MActionInfo(UI._("Open"), "ui/misc", 76, MAction.getMenuMask());
    public static final MActionInfo OVERWRITE = new MActionInfo(UI._("Overwrite"), "ui/ok");
    public static final MActionInfo PASTE = new MActionInfo(UI._("Paste"), "ui/paste", 86, MAction.getMenuMask());
    public static final MActionInfo PREVIOUS = new MActionInfo(UI._("Previous"), "ui/previous");
    public static final MActionInfo PRINT = new MActionInfo(UI._("Print..."), "ui/print", 80, MAction.getMenuMask());
    public static final MActionInfo PROPERTIES = new MActionInfo(UI._("Properties"), "ui/properties", 10, 8);
    public static final MActionInfo QUIT = new MActionInfo(UI._("Quit"), "ui/quit", 81, MAction.getMenuMask() | 1);
    public static final MActionInfo REFRESH = new MActionInfo(UI._("Refresh"), "ui/refresh");
    public static final MActionInfo RESTORE_DEFAULT_VALUES = new MActionInfo(UI._("Restore Default Values"), "ui/revert");
    public static final MActionInfo REVERT = new MActionInfo(UI._("Revert"), "ui/revert");
    public static final MActionInfo SAVE = new MActionInfo(UI._("Save"), "ui/save", 83, MAction.getMenuMask());
    public static final MActionInfo SAVE_AS = new MActionInfo(UI._("Save As..."), "ui/save");
    public static final MActionInfo SAVE_AS_DEFAULT = new MActionInfo(UI._("Save As Default"), "ui/save");
    public static final MActionInfo SEARCH = new MActionInfo(UI._("Search..."), "ui/find");
    public static final MActionInfo SELECT_ALL = new MActionInfo(UI._("Select All"), null, 65, MAction.getMenuMask());
    @Deprecated
    public static final MActionInfo SET_AS_DEFAULT = new MActionInfo("Set As Default", "ui/save");
    public static final MActionInfo SET_DATE_TIME = new MActionInfo(UI._("Set Date/Time"), "ui/calendar");
    @Deprecated
    public static final MActionInfo SET_DEFAULT_VALUES = new MActionInfo("Set Default Values", "ui/revert");
    public static final MActionInfo SETTINGS = new MActionInfo(UI._("Settings"), "ui/configure");
    public static final MActionInfo SHOW_GRID = new MActionInfo(UI._("Show Grid"), "ui/grid");
    public static final MActionInfo SHOW_STARRED = new MActionInfo(UI._("Show Starred"), "ui/star");
    @Deprecated
    public static final MActionInfo STARRED = new MActionInfo(UI._("Starred"), "ui/star");
    public static final MActionInfo UNINSTALL = new MActionInfo(UI._("Uninstall"), "ui/delete");
    public static final MActionInfo UNLOCK = new MActionInfo(UI._("Unlock"), "ui/unlocked");
    public static final MActionInfo UNSELECT_ALL = new MActionInfo(UI._("Unselect All"), null, 65, MAction.getMenuMask() | 1);
    private int hash;
    private int keyCode;
    private int modifiers;
    private String iconName;
    private String text;

    public MActionInfo(String string, String string2) {
        this(string, string2, 0, 0);
    }

    public MActionInfo(String string, String string2, int n, int n2) {
        this.text = string;
        this.iconName = string2;
        this.keyCode = n;
        this.modifiers = n2;
    }

    public boolean equals(Object object) {
        switch (MObject.maybeEquals(this, object)) {
            case YES: {
                return true;
            }
            case NO: {
                return false;
            }
        }
        MActionInfo mActionInfo = (MActionInfo)object;
        return this.keyCode == mActionInfo.keyCode && this.modifiers == mActionInfo.modifiers && MObject.safeEquals(this.iconName, mActionInfo.iconName) && MObject.safeEquals(this.text, mActionInfo.text);
    }

    public String getDialogTitle() {
        int n;
        String string = this.getText();
        if (TK.isEmpty(string)) {
            return string;
        }
        if (string.startsWith("...")) {
            string = string.substring("...".length());
        }
        if ((n = string.lastIndexOf("...")) != -1) {
            string = string.substring(0, n);
        }
        return string.trim();
    }

    public Icon getIcon() {
        return MIcon.stock(this.iconName);
    }

    public String getIconName() {
        return this.iconName;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public KeyStroke getKeyStroke() {
        if (this.keyCode == 0) {
            return null;
        }
        return KeyStroke.getKeyStroke(this.keyCode, this.modifiers);
    }

    public Icon getMediumIcon() {
        return MIcon.medium(this.iconName);
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public Icon getSmallIcon() {
        return MIcon.small(this.iconName);
    }

    public String getText() {
        return this.text;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int n = MObject.hashCode(this.iconName, this.text);
            n = 31 * n + this.keyCode;
            this.hash = n = 31 * n + this.modifiers;
        }
        return this.hash;
    }
}

