/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.makagiga.commons.MBorder;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.UI;
import org.makagiga.commons.WTFError;
import org.makagiga.commons.painters.Painter;

public class ImageBorder
extends MBorder
implements Painter {
    private boolean visible = true;
    private Color outlineColor;
    private float alpha = 1.0f;
    private Image image;
    private final Object imageLock = new Object();
    private Position position = Position.DEFAULT;
    private final Rectangle userBounds = new Rectangle();

    public ImageBorder() {
        this((Image)null, Position.DEFAULT);
    }

    public ImageBorder(Icon icon, Position position) {
        this(icon instanceof ImageIcon ? ((ImageIcon)ImageIcon.class.cast(icon)).getImage() : UI.toBufferedImage(icon), position);
    }

    public ImageBorder(Image image, Position position) {
        super(true, 0, 0, 0, 0);
        this.image = image;
        this.position = position;
    }

    public ImageBorder(String string, Position position) {
        this(MIcon.stock(string), position);
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float f) {
        if (this.alpha < 0.0f || this.alpha > 1.0f) {
            throw new IllegalArgumentException("\"alpha\" value must be in range 0.0..1.0");
        }
        this.alpha = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage() {
        Object object = this.imageLock;
        synchronized (object) {
            return this.image;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(Image image) {
        Object object = this.imageLock;
        synchronized (object) {
            this.image = image;
        }
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Color color) {
        this.outlineColor = color;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public Rectangle getUserBounds() {
        return this.userBounds.getBounds();
    }

    public void setUserBounds(Rectangle rectangle) {
        this.userBounds.setBounds(rectangle);
    }

    @Override
    public boolean isBorderOpaque() {
        return super.isBorderOpaque();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Composite composite;
        if (!this.visible) {
            return;
        }
        Object object = this.imageLock;
        synchronized (object) {
            if (this.image == null) {
                return;
            }
        }
        object = (Graphics2D)graphics;
        if (this.alpha < 1.0f) {
            composite = ((Graphics2D)object).getComposite();
            ((Graphics2D)object).setComposite(AlphaComposite.SrcOver.derive(this.alpha));
        } else {
            composite = null;
        }
        Rectangle rectangle = this.getPaintBounds(component, n, n2);
        if (!rectangle.isEmpty()) {
            Object object2 = ((Graphics2D)object).getRenderingHint(RenderingHints.KEY_RENDERING);
            ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            Object object3 = this.imageLock;
            synchronized (object3) {
                if (this.image != null) {
                    ((Graphics)object).drawImage(this.image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
                }
            }
            ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_RENDERING, object2);
        }
        if (this.outlineColor != null) {
            ((Graphics)object).setColor(this.outlineColor);
            ((Graphics)object).drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (composite != null) {
            ((Graphics2D)object).setComposite(composite);
        }
    }

    public void setUserLocation(Point point) {
        this.userBounds.setLocation(point);
    }

    public void setUserLocation(int n, int n2) {
        this.userBounds.setLocation(n, n2);
    }

    public void setUserSize(Dimension dimension) {
        this.userBounds.setSize(dimension);
    }

    public void setUserSize(int n) {
        this.userBounds.setSize(n, n);
    }

    public void setUserSize(int n, int n2) {
        this.userBounds.setSize(n, n2);
    }

    @Override
    public Insets getPainterInsets(Component component) {
        return this.getBorderInsets(component);
    }

    @Override
    public void paint(Component component, Graphics2D graphics2D) {
        this.paintBorder(component, graphics2D, 0, 0, component.getWidth(), component.getHeight());
    }

    @Override
    public void paint(Component component, Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        this.paintBorder(component, graphics2D, n, n2, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Rectangle getPaintBounds(Component component, int n, int n2) {
        Rectangle rectangle = new Rectangle();
        switch (this.position) {
            case DEFAULT: {
                Object object = this.imageLock;
                synchronized (object) {
                    rectangle.setBounds(n, n2, this.image.getWidth(null), this.image.getHeight(null));
                    break;
                }
            }
            case CENTERED: {
                Object object = this.imageLock;
                synchronized (object) {
                    rectangle.setBounds(component.getWidth() / 2 - this.image.getWidth(null) / 2, component.getHeight() / 2 - this.image.getHeight(null) / 2, this.image.getWidth(null), this.image.getHeight(null));
                    break;
                }
            }
            case CENTERED_USER_BOUNDS: {
                if (this.userBounds.isEmpty()) {
                    rectangle.setBounds(this.userBounds);
                    break;
                }
                rectangle.setBounds(component.getWidth() / 2 - this.userBounds.width / 2, component.getHeight() / 2 - this.userBounds.height / 2, this.userBounds.width, this.userBounds.height);
                break;
            }
            case COMPONENT_SIZE: {
                rectangle.setBounds(0, 0, component.getWidth(), component.getHeight());
                break;
            }
            case USER_BOUNDS: {
                rectangle.setBounds(this.userBounds);
                break;
            }
            default: {
                throw new WTFError(this.position);
            }
        }
        return rectangle;
    }

    public static enum Position {
        DEFAULT,
        CENTERED,
        CENTERED_USER_BOUNDS,
        COMPONENT_SIZE,
        USER_BOUNDS;

    }
}

