/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Color;
import org.makagiga.commons.AbstractMarkupBuilder;
import org.makagiga.commons.ColorProperty;
import org.makagiga.commons.MColor;

public class HTMLBuilder
extends AbstractMarkupBuilder {
    public static final String HTML_5 = "<!DOCTYPE html>";
    public static final String HTML_TRANSITIONAL = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">";
    public static final String XHTML_STRICT = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">";
    public static final String UTF_8 = "UTF-8";
    private boolean html5;

    public HTMLBuilder() {
        super(false);
    }

    public HTMLBuilder(String string) {
        super(string.equals(HTML_5) || string.equals(XHTML_STRICT));
        this.html5 = string.equals(HTML_5);
        this.appendLine(string);
    }

    public void addAnchor(String string) {
        this.doubleTag("a", null, "name", string);
    }

    public void addAttr(String string, String string2) {
        this.appendLine("%s: %s;", string, string2);
    }

    public void addAttr(String string, Color color) {
        this.appendLine("%s: %s;", string, ColorProperty.toString(color));
    }

    public void addFeed(String string, String string2) {
        this.addLink(string, "alternate", "application/rss+xml", string2);
    }

    public void addHeader(int n, String string) {
        if (n < 1 || n > 6) {
            throw new IllegalArgumentException("Invalid header \"level\"");
        }
        this.doubleTag("h" + n, string, new Object[0]);
    }

    public void addLink(String string, String string2, String string3, String string4) {
        this.singleTag("link", "href", string, "rel", string2, "type", string3, "title", string4 == null ? "" : string4);
    }

    public void addMeta(String string, String string2) {
        this.singleTag("meta", "name", string, "content", string2);
    }

    public void addStyle(String string) {
        this.addLink(string, "stylesheet", "text/css", null);
    }

    public void beginDoc() {
        this.endTag("head");
        this.beginTag("body");
    }

    public void beginHTML(String string, String string2, String string3) {
        if (this.xml) {
            if (string3 == null) {
                if (this.html5) {
                    this.beginTag("html");
                } else {
                    this.beginTag("html", "xmlns", "http://www.w3.org/1999/xhtml");
                }
            } else if (this.html5) {
                this.beginTag("html", "lang", string3);
            } else {
                this.beginTag("html", "xmlns", "http://www.w3.org/1999/xhtml", "xml:lang", string3, "lang", string3);
            }
        } else if (string3 == null) {
            this.beginTag("html");
        } else {
            this.beginTag("html", "lang", string3);
        }
        this.decIndent();
        this.beginTag("head");
        if (string2 != null) {
            if (this.html5) {
                this.singleTag("meta", "charset", string2);
            } else {
                this.singleTag("meta", "http-equiv", "Content-Type", "content", "text/html; charset=" + string2);
            }
        }
        if (string != null) {
            this.doubleTag("title", HTMLBuilder.escape(string), new Object[0]);
        }
    }

    public void beginHTML(String string, String string2) {
        this.beginHTML(string, string2, null);
    }

    public void beginHTML(String string) {
        this.beginHTML(string, null, null);
    }

    public void beginHTML() {
        this.beginHTML(null, null, null);
    }

    public void beginRule(String string) {
        this.appendLine();
        this.appendLine("%s {", string);
        this.incIndent();
    }

    public void beginStyle() {
        this.appendLine("<style type=\"text/css\">");
    }

    public void bestLinkRules(Color color) {
        this.beginRule("a");
        this.addAttr("color", MColor.getLinkForeground(color));
        this.endRule();
        this.beginRule("a:visited");
        this.addAttr("color", MColor.getVisitedLinkForeground(color));
        this.endRule();
        this.beginRule("a:hover");
        this.addAttr("color", MColor.getHoverLinkForeground(color));
        this.endRule();
    }

    public String createImage(String string, String string2, String string3, String string4) {
        return this.createImage(string, string2, string3, string4, -1, -1);
    }

    public String createImage(String string, String string2, String string3, String string4, int n, int n2) {
        return String.format("<img%s src=\"%s\"%s%s alt=\"%s\"%s" + this.tagEnd, string == null ? "" : " class=\"" + string + "\"", string2, n == -1 ? "" : " width=\"" + n + "\"", n2 == -1 ? "" : " height=\"" + n2 + "\"", HTMLBuilder.escape(string3), string4 == null ? "" : " title=\"" + HTMLBuilder.escape(string4) + "\"");
    }

    public static String createLink(String string, String string2) {
        return String.format("<a href=\"%s\">%s</a>", string, HTMLBuilder.escape(string2));
    }

    public static String createLink(String string) {
        return HTMLBuilder.createLink(string, string);
    }

    public void endDoc() {
        this.endTag("body");
        this.endTag("html");
    }

    public void endRule() {
        this.decIndent();
        this.appendLine("}");
    }

    public void endStyle() {
        this.appendLine();
        this.appendLine("</style>");
    }

    public HTMLBuilder endSwingDoc() {
        this.endTag("html");
        return this;
    }

    public static HTMLBuilder newSwingDoc() {
        HTMLBuilder hTMLBuilder = new HTMLBuilder();
        hTMLBuilder.beginTag("html");
        return hTMLBuilder;
    }

    public void setDefaultStyle() {
        this.beginRule("a");
        this.addAttr("color", "blue");
        this.addAttr("text-decoration", "none");
        this.endRule();
        this.beginRule("a:hover");
        this.addAttr("color", "red");
        this.addAttr("text-decoration", "underline");
        this.endRule();
        this.beginRule("body");
        this.addAttr("background-color", "white");
        this.addAttr("color", "black");
        this.addAttr("font-family", "helvetica, arial, sans-serif");
        this.endRule();
    }
}

