/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.text.ParseException;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.makagiga.commons.BooleanProperty;
import org.makagiga.commons.ElementList;
import org.makagiga.commons.FS;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MObject;
import org.makagiga.commons.TK;
import org.makagiga.commons.WTFError;

public class ConfigFile
implements ElementList,
Iterable<Element>,
Serializable {
    public static final String APPLICATION_TYPE_VALUE = "Application";
    public static final String DIRECTORY_TYPE_VALUE = "Directory";
    public static final String LINK_TYPE_VALUE = "Link";
    private Format format;
    private final MArrayList<Element> elements = MArrayList.create(32);
    private String encoding = "UTF8";

    public ConfigFile() {
        this(Format.DESKTOP);
    }

    public ConfigFile(Format format) {
        this.format = TK.checkNull(format);
    }

    @Override
    public synchronized void add(Element element) {
        this.elements.add(element);
    }

    public synchronized List<Element> get() {
        return this.elements;
    }

    public synchronized Group get(String string) {
        Group group = null;
        for (Element element : this) {
            if (!(element instanceof Group)) continue;
            group = (Group)element;
            if (this.format.equals(group.getValue(), string)) break;
            group = null;
        }
        if (group == null) {
            group = new Group(this.getFormat(), string);
            this.add(group);
        }
        return group;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public Format getFormat() {
        return this.format;
    }

    public Group setDesktopEntry(String string, String string2) {
        Group group = this.get("Desktop Entry");
        group.set("Version", "1.0");
        group.set("Type", string);
        group.set("Name", string2);
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(1024);
        ConfigFile configFile = this;
        synchronized (configFile) {
            for (Element element : this) {
                stringBuilder.append(element);
            }
        }
        return stringBuilder.toString();
    }

    public void read(BufferedReader bufferedReader) throws IOException {
        String string;
        ElementList elementList = this;
        while ((string = bufferedReader.readLine()) != null) {
            String string2 = string.trim();
            if (string2.isEmpty()) {
                elementList.add(new Unknown(this.format, string));
                continue;
            }
            if (string2.startsWith(this.format.getComment())) {
                elementList.add(new Comment(this.format, string));
                continue;
            }
            if (string2.length() > 2 && string2.charAt(0) == '[' && string2.charAt(string2.length() - 1) == ']') {
                Group group = new Group(this.format, string2.substring(1, string2.length() - 1).trim());
                elementList = group;
                this.add(group);
                continue;
            }
            int n = string2.indexOf(61);
            if (n != -1) {
                int n2;
                String string3 = string2.substring(0, n).trim();
                int n3 = string3.indexOf(91);
                String string4 = null;
                if (n3 != -1 && (n2 = string3.indexOf(93, n3)) > n3) {
                    string4 = string3.substring(n3 + 1, n2);
                    string3 = string3.substring(0, n3);
                }
                String string5 = string2.substring(n + 1).trim();
                elementList.add(new Entry(this.format, string3, string5, string4));
                continue;
            }
            elementList.add(new Unknown(this.format, string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(File file) throws IOException {
        FS.TextReader textReader = null;
        try {
            textReader = new FS.TextReader(new FileInputStream(file), this.encoding);
            this.read(textReader);
        }
        catch (Throwable throwable) {
            FS.close(textReader);
            throw throwable;
        }
        FS.close(textReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(InputStream inputStream) throws IOException {
        FS.TextReader textReader = null;
        try {
            textReader = new FS.TextReader(inputStream, this.encoding);
            this.read(textReader);
        }
        catch (Throwable throwable) {
            FS.close(textReader);
            throw throwable;
        }
        FS.close(textReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file) throws IOException {
        FS.TextWriter textWriter = null;
        try {
            textWriter = new FS.TextWriter((OutputStream)new FileOutputStream(file), this.encoding);
            this.write(textWriter);
        }
        catch (Throwable throwable) {
            FS.close(textWriter);
            throw throwable;
        }
        FS.close(textWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream outputStream) throws IOException {
        FS.TextWriter textWriter = null;
        try {
            textWriter = new FS.TextWriter(outputStream, this.encoding);
            this.write(textWriter);
        }
        catch (Throwable throwable) {
            FS.close(textWriter);
            throw throwable;
        }
        FS.close(textWriter);
    }

    public void write(Writer writer) throws IOException {
        writer.write(this.toString());
    }

    @Override
    public synchronized Iterator<Element> iterator() {
        return this.elements.iterator();
    }

    public static final class Unknown
    extends Element {
        public Unknown(Format format, String string) {
            super(format, string);
        }
    }

    public static final class Group
    extends Element
    implements ElementList,
    Iterable<Element> {
        private final MArrayList<Element> elements = MArrayList.create(16);

        public Group(Format format, String string) {
            super(format, format.validateGroup(string));
        }

        @Override
        public synchronized void add(Element element) {
            this.elements.add(element);
        }

        public synchronized List<Element> get() {
            return this.elements;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String get(String string, String string2) {
            Group group = this;
            synchronized (group) {
                for (Element element : this) {
                    Entry entry;
                    if (!(element instanceof Entry) || !(entry = (Entry)element).getKey().equals(string)) continue;
                    return entry.getValue();
                }
            }
            return string2;
        }

        public boolean getBoolean(String string, boolean bl) {
            String string2 = this.get(string, null);
            if (string2 == null) {
                return bl;
            }
            try {
                return BooleanProperty.parseBoolean(string2);
            }
            catch (ParseException parseException) {
                return bl;
            }
        }

        public int getInteger(String string, int n) {
            try {
                String string2 = this.get(string, null);
                if (string2 == null) {
                    return n;
                }
                return Integer.parseInt(string2);
            }
            catch (Exception exception) {
                MLogger.exception(exception);
                return n;
            }
        }

        public void set(String string, boolean bl) {
            this.set(string, Boolean.toString(bl));
        }

        public void set(String string, int n) {
            this.set(string, Integer.toString(n));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(String string, String string2) {
            Entry entry = null;
            Group group = this;
            synchronized (group) {
                for (Element element : this) {
                    if (!(element instanceof Entry)) continue;
                    entry = (Entry)element;
                    if (entry.getKey().equals(string)) {
                        entry.setValue(string2);
                        return;
                    }
                    entry = null;
                }
            }
            if (entry == null) {
                this.add(new Entry(this.getFormat(), string, string2));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(1024);
            stringBuilder.append('[').append(this.getFormat().escapeGroup(this.getValue())).append(']').append(this.getFormat().getEOL());
            Group group = this;
            synchronized (group) {
                for (Element element : this) {
                    stringBuilder.append(element);
                }
            }
            return stringBuilder.toString();
        }

        @Override
        public synchronized Iterator<Element> iterator() {
            return this.elements.iterator();
        }
    }

    public static final class Entry
    extends Element {
        private final String key;
        private final String locale;

        public Entry(Format format, String string, String string2) {
            this(format, string, string2, null);
        }

        public Entry(Format format, String string, String string2, String string3) {
            super(format, string2);
            this.key = format.validateKey(string);
            this.locale = string3;
        }

        @Override
        public boolean equals(Object object) {
            switch (MObject.maybeEquals(this, object)) {
                case YES: {
                    return true;
                }
                case NO: {
                    return false;
                }
            }
            Entry entry = (Entry)object;
            return this.getFormat().equals(this.key, entry.key) && MObject.safeEquals(this.locale, entry.locale) && this.getValue().equals(entry.getValue());
        }

        public String getKey() {
            return this.key;
        }

        public String getLocale() {
            return this.locale;
        }

        @Override
        public synchronized int hashCode() {
            return MObject.hashCode(this.key, this.locale, this.getValue());
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(64);
            stringBuilder.append(this.getFormat().escapeKey(this.key));
            if (this.locale != null) {
                stringBuilder.append('[').append(this.locale).append(']');
            }
            stringBuilder.append('=').append(this.getFormat().escapeValue(this.getValue())).append(this.getFormat().getEOL());
            return stringBuilder.toString();
        }
    }

    public static abstract class Element
    implements Serializable {
        private final Format format;
        private String _value;

        public Element(Format format, String string) {
            this.format = TK.checkNull(format);
            this.setValue(string);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Element)) {
                return false;
            }
            return this.getValue().equals(((Element)Element.class.cast(object)).getValue());
        }

        public Format getFormat() {
            return this.format;
        }

        public synchronized String getValue() {
            return this._value;
        }

        public int hashCode() {
            return MObject.hashCode(this.getValue());
        }

        public String toString() {
            return this.getValue().concat(this.getFormat().getEOL());
        }

        protected synchronized void setValue(String string) {
            this._value = TK.checkNull(string);
        }
    }

    public static final class Comment
    extends Element {
        public Comment(Format format, String string) {
            super(format, string);
        }
    }

    public static enum Format {
        DESKTOP(true, ".desktop", "\n", "#", null, "[A-Za-z0-9\\-]+"),
        INI(false, ".ini", "\r\n", ";", null, null);

        private boolean caseSensitive;
        private Pattern groupPattern;
        private Pattern keyPattern;
        private String comment;
        private String eol;
        private String suffix;

        public boolean equals(String string, String string2) {
            if (this.caseSensitive) {
                return string.equals(string2);
            }
            return string.equalsIgnoreCase(string2);
        }

        public String escapeGroup(String string) {
            return string;
        }

        public String unescapeGroup(String string) {
            return string;
        }

        public String escapeKey(String string) {
            return string;
        }

        public String unescapeKey(String string) {
            return string;
        }

        public static String escape(String string) {
            if (string == null) {
                return null;
            }
            int n = string.length();
            if (n == 0) {
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder(n + n / 2);
            block7: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case ' ': {
                        stringBuilder.append("\\s");
                        continue block7;
                    }
                    case '\n': {
                        stringBuilder.append("\\n");
                        continue block7;
                    }
                    case '\r': {
                        stringBuilder.append("\\r");
                        continue block7;
                    }
                    case '\t': {
                        stringBuilder.append("\\t");
                        continue block7;
                    }
                    case '\\': {
                        stringBuilder.append("\\\\");
                        continue block7;
                    }
                    default: {
                        stringBuilder.append(c);
                    }
                }
            }
            return stringBuilder.toString();
        }

        public String escapeValue(String string) {
            switch (this) {
                case DESKTOP: {
                    return string;
                }
                case INI: {
                    return string;
                }
            }
            throw new WTFError(this);
        }

        public String unescapeValue(String string) {
            switch (this) {
                case DESKTOP: {
                    return string;
                }
                case INI: {
                    return string;
                }
            }
            throw new WTFError(this);
        }

        public String getComment() {
            return this.comment;
        }

        public String getEOL() {
            return this.eol;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        public String validateGroup(String string) {
            TK.checkNullOrEmpty(string);
            if (this == DESKTOP) {
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c != '[' && c != ']') continue;
                    throw new IllegalArgumentException("Group name contains [ or ] character");
                }
            }
            if (this.groupPattern != null && !this.groupPattern.matcher(string).matches()) {
                throw new IllegalArgumentException("Group \"" + string + "\" does not match a valid pattern: " + this.groupPattern);
            }
            return string;
        }

        public String validateKey(String string) {
            TK.checkNullOrEmpty(string);
            if (this.keyPattern != null && !this.keyPattern.matcher(string).matches()) {
                throw new IllegalArgumentException("Key \"" + string + "\" does not match a valid pattern: " + this.keyPattern);
            }
            return string;
        }

        private Format(boolean bl, String string2, String string3, String string4, String string5, String string6) {
            this.caseSensitive = bl;
            this.suffix = string2;
            this.eol = string3;
            this.comment = string4;
            this.groupPattern = string5 == null ? null : Pattern.compile(string5);
            this.keyPattern = string6 == null ? null : Pattern.compile(string6);
        }
    }
}

