/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.chart;

import java.awt.Color;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.filechooser.FileFilter;
import org.makagiga.chart.ChartModel;
import org.makagiga.chart.ChartPainter;
import org.makagiga.chart.ChartView;
import org.makagiga.commons.Config;
import org.makagiga.commons.Kiosk;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MCheckBox;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MFileChooser;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.UI;
import org.makagiga.commons.print.ImagePrintInfo;
import org.makagiga.commons.print.PrintDialog;

public class ChartPanel<M extends ChartModel>
extends MPanel {
    protected MCheckBox showText;
    private ChartView<M> view;
    private MToolBar toolBar;
    private String title;

    public ChartPanel(String string) {
        this(new ChartModel(), string);
    }

    public ChartPanel(M m, String string) {
        this.title = string;
        this.toolBar = new MToolBar();
        this.toolBar.setOpaque(false);
        if (MLogger.isDeveloper()) {
            this.toolBar.add(new MAction(MActionInfo.OPEN){

                @Override
                public void onAction() {
                    ChartPanel.this.open();
                }
            });
        }
        if (((Boolean)Kiosk.actionExport.get()).booleanValue()) {
            this.toolBar.add(new MAction(MActionInfo.SAVE){

                @Override
                public void onAction() {
                    ChartPanel.this.export();
                }
            });
        }
        this.toolBar.addGap();
        this.toolBar.add(new MApplication.PrintAction(){

            @Override
            public void onAction() {
                ChartPanel.this.print();
            }
        });
        this.showText = new MCheckBox(UI._("Show Text"));
        this.showText.onSelect(this, "textVisible");
        this.showText.setOpaque(false);
        if (((Boolean)Kiosk.actionSettings.get()).booleanValue()) {
            this.toolBar.addGap();
            this.toolBar.add(this.showText);
        }
        this.toolBar.readConfig("chart");
        this.addNorth(this.toolBar);
        this.view = new ChartView<M>(m);
        this.addCenter(this.view);
        this.setupChart();
        Config config = Config.getDefault();
        this.setTextVisible(config.read("Chart.Text.visible", true));
    }

    public M getModel() {
        return this.getView().getPainter().getModel();
    }

    public void setModel(M m) {
        this.getView().getPainter().setModel(m);
    }

    @Override
    public ChartPainter<M> getPainter() {
        return this.getView().getPainter();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public MToolBar getToolBar() {
        return this.toolBar;
    }

    public ChartView<M> getView() {
        return this.view;
    }

    public boolean isTextVisible() {
        return this.showText.isSelected();
    }

    public void setTextVisible(boolean bl) {
        this.showText.setSelected(bl);
        this.getView().getPainter().textVisible.set(bl);
        this.getView().repaint();
    }

    public static void showDialog(Window window, String string, Icon icon, int n, ChartModel chartModel) {
        ChartPanel<ChartModel> chartPanel = new ChartPanel<ChartModel>(chartModel, string);
        ChartPanel.showDialog(window, string, icon, n, chartPanel);
    }

    public static void showDialog(Window window, String string, Icon icon, int n, ChartPanel<?> chartPanel) {
        MDialog mDialog = new MDialog(window, string, icon, n);
        MToolBar mToolBar = chartPanel.getToolBar();
        if (mToolBar != null) {
            mDialog.setToolBar(mToolBar);
        }
        mDialog.addCenter(chartPanel);
        mDialog.setSize(UI.WindowSize.LARGE);
        mDialog.removeContentMargin();
        mDialog.exec(mDialog.getOKButton());
        if (mToolBar != null) {
            chartPanel.addNorth(mToolBar);
        }
        super.saveConfig();
    }

    protected void export() {
        Config config = Config.getDefault();
        MFileChooser mFileChooser = MFileChooser.createFileChooser(this.getWindowAncestor(), UI._("Save"));
        mFileChooser.addFilter("XML", "mgchart", "xml");
        FileFilter fileFilter = mFileChooser.addFilter("PNG", "png");
        MPanel mPanel = (MPanel)mFileChooser.getAccessory();
        mPanel.addSeparator(UI._("Options"));
        MCheckBox mCheckBox = new MCheckBox(UI._("Transparent"));
        mCheckBox.setSelected(config.read("Chart.Export.transparent", false));
        mPanel.add(mCheckBox);
        mFileChooser.setAutoAddExtension(true);
        mFileChooser.setConfigKey("exportChart");
        mFileChooser.setSelectedPath("chart");
        if (mFileChooser.saveDialog()) {
            config.write("Chart.Export.transparent", mCheckBox.isSelected());
            config.sync();
            try {
                File file = mFileChooser.getSelectedFile();
                if (mFileChooser.getFileFilter() == fileFilter) {
                    ChartView<M> chartView = this.getView();
                    Color color = mCheckBox.isSelected() ? null : (Color)chartView.getPainter().backgroundColor.get();
                    BufferedImage bufferedImage = chartView.getPainter().toBufferedImage(color);
                    ImageIO.write((RenderedImage)bufferedImage, "png", file);
                } else {
                    ChartPainter<M> chartPainter = this.getView().getPainter();
                    ((ChartModel)chartPainter.getModel()).write(file, chartPainter);
                }
            }
            catch (IOException iOException) {
                MMessage.error(this.getWindowAncestor(), iOException);
            }
        }
    }

    protected void print() {
        ImagePrintInfo imagePrintInfo = new ImagePrintInfo(this.getTitle(), this.getView().getPainter().toBufferedImage(null));
        PrintDialog printDialog = new PrintDialog(this.getWindowAncestor(), imagePrintInfo);
        printDialog.exec();
    }

    protected void setupChart() {
    }

    private void open() {
        MFileChooser mFileChooser = MFileChooser.createFileChooser(this.getWindowAncestor(), UI._("Open"));
        mFileChooser.addFilter("XML", "mgchart", "xml");
        mFileChooser.setConfigKey("importChart");
        mFileChooser.setSelectedPath("chart");
        if (mFileChooser.openDialog()) {
            try {
                File file = mFileChooser.getSelectedFile();
                ChartPainter<M> chartPainter = this.getView().getPainter();
                ((ChartModel)chartPainter.getModel()).read(file, chartPainter);
                this.getView().repaint();
            }
            catch (IOException iOException) {
                MMessage.error(this.getWindowAncestor(), iOException);
            }
        }
    }

    private void saveConfig() {
        Config config = Config.getDefault();
        config.write("Chart.Text.visible", this.showText.isSelected());
        config.sync();
    }
}

