/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.chart;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.makagiga.chart.ChartPainter;
import org.makagiga.commons.AbstractListTableModel;
import org.makagiga.commons.ColorProperty;
import org.makagiga.commons.FS;
import org.makagiga.commons.MFormat;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.Property;
import org.makagiga.commons.PropertyAccess;
import org.makagiga.commons.SimpleXMLReader;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.WTFError;
import org.makagiga.commons.XMLBuilder;

public class ChartModel
extends AbstractListTableModel<Item> {
    public static final int COLUMN_TEXT = 0;
    public static final int COLUMN_VALUE = 1;
    public static final int COLUMN_COLOR = 2;
    public static final int COLUMN_ICON = 3;
    private String format;

    public ChartModel() {
        super(new AbstractListTableModel.ColumnInfo(UI._("Text"), String.class), new AbstractListTableModel.ColumnInfo(UI._("Value"), Long.class), new AbstractListTableModel.ColumnInfo(UI._("Color"), Color.class), new AbstractListTableModel.ColumnInfo(UI._("Icon"), Icon.class));
    }

    public Item addEmptyInfo(Color color) {
        Item item = this.addItem("<" + UI._("No Items") + ">", 0L, color);
        item.setFormat("${text}");
        return item;
    }

    public Item addItem(String string, long l, Color color) {
        return this.addItem(string, l, color, (Icon)null);
    }

    public Item addItem(String string, long l, Color color, Icon icon) {
        Item item = new Item(string, l, color, icon);
        this.addRow(item);
        return item;
    }

    public Item addItem(String string, long l, Color color, String string2) {
        Item item = this.addItem(string, l, color);
        item.setIconPath(string2);
        return item;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Item item = (Item)this.getRowAt(n);
        switch (n2) {
            case 0: {
                return item.getText();
            }
            case 1: {
                return item.number;
            }
            case 2: {
                return item.getValue();
            }
            case 3: {
                return item.getIcon();
            }
        }
        MLogger.error("chart", "getValueAt: Unknown column: %s", n2);
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Item item = (Item)this.getRowAt(n);
        Item item2 = this.createCopyForUndo(item);
        switch (n2) {
            case 0: {
                item.setText((String)object);
                break;
            }
            case 1: {
                item.number = (Long)object;
                break;
            }
            case 2: {
                item.setValue((Color)object);
                break;
            }
            case 3: {
                if (object == null) {
                    item.setIconPath(null);
                } else if (object instanceof String) {
                    item.setIconPath((String)object);
                } else {
                    item.setIcon((Icon)object);
                }
                item.imageCache = null;
                break;
            }
            default: {
                MLogger.error("chart", "setValueAt: Unknown column: %s", n2);
            }
        }
        this.fireTableCellUpdated(n, n2);
        this.fireUndoableEditHappened(new AbstractListTableModel.ChangeUndo(this, item2, this.createCopyForUndo(item), n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(File file, ChartPainter<?> chartPainter) throws IOException {
        FS.BufferedFileInput bufferedFileInput = null;
        try {
            bufferedFileInput = new FS.BufferedFileInput(file);
            this.read(bufferedFileInput, chartPainter);
        }
        catch (Throwable throwable) {
            FS.close(bufferedFileInput);
            throw throwable;
        }
        FS.close(bufferedFileInput);
    }

    public void read(String string, ChartPainter<?> chartPainter) throws IOException {
        this.read(new File(string), chartPainter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void read(InputStream inputStream, ChartPainter<?> chartPainter) throws IOException {
        this.clear();
        final HashMap hashMap = chartPainter == null ? null : new HashMap();
        SimpleXMLReader simpleXMLReader = new SimpleXMLReader(){
            private boolean inItem;
            private boolean inPainter;
            private Item item;

            @Override
            protected void onEnd(String string) {
                if (this.inItem && "item".equals(string)) {
                    ChartModel.this.addRow(this.item);
                    this.inItem = false;
                } else if (this.inPainter && "painter".equals(string)) {
                    this.inPainter = false;
                }
            }

            @Override
            protected void onStart(String string) {
                String string2;
                String string3;
                if (!this.inItem && "item".equals(string)) {
                    this.item = new Item();
                    this.inItem = true;
                } else if (!this.inPainter && "painter".equals(string)) {
                    this.inPainter = true;
                } else if (this.inItem) {
                    if ("color".equals(string)) {
                        try {
                            this.item.setValue(ColorProperty.parseColor(this.getValue()));
                        }
                        catch (ParseException parseException) {
                            this.setError(parseException);
                        }
                    } else if ("icon".equals(string)) {
                        this.item.setIconPath(this.getValue());
                    } else if ("text".equals(string)) {
                        this.item.setText(this.getValue());
                    } else if ("value".equals(string)) {
                        try {
                            this.item.setNumber(Long.parseLong(this.getValue()));
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.setError(numberFormatException);
                        }
                    }
                } else if (this.inPainter && "property".equals(string) && hashMap != null && (string3 = this.getStringAttribute("name")) != null && (string2 = this.getStringAttribute("value")) != null) {
                    hashMap.put(string3, string2);
                }
            }
        };
        simpleXMLReader.read(inputStream);
        if (hashMap == null) return;
        try {
            for (Map.Entry<Field, PropertyAccess<?>> entry : Property.list(chartPainter).entrySet()) {
                Field field = entry.getKey();
                String string = (String)hashMap.get(field.getName());
                if (string == null) continue;
                PropertyAccess<?> propertyAccess = entry.getValue();
                try {
                    propertyAccess.parse(string);
                }
                catch (ParseException parseException) {
                    throw new IOException(parseException);
                    return;
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException(illegalAccessException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, ChartPainter<?> chartPainter) throws IOException {
        FS.BufferedFileOutput bufferedFileOutput = null;
        try {
            bufferedFileOutput = new FS.BufferedFileOutput(file);
            this.write(bufferedFileOutput, chartPainter);
        }
        catch (Throwable throwable) {
            FS.close(bufferedFileOutput);
            throw throwable;
        }
        FS.close(bufferedFileOutput);
    }

    public void write(String string, ChartPainter<?> chartPainter) throws IOException {
        this.write(new File(string), chartPainter);
    }

    public void write(OutputStream outputStream, ChartPainter<?> chartPainter) throws IOException {
        XMLBuilder xMLBuilder = new XMLBuilder();
        xMLBuilder.beginTag("chart", "version", "1");
        if (chartPainter != null) {
            try {
                this.writePainterProperties(xMLBuilder, chartPainter);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IOException(illegalAccessException);
            }
        }
        for (Item item : this) {
            xMLBuilder.beginTag("item");
            if (item.getValue() != null) {
                xMLBuilder.doubleTag("color", ColorProperty.toString((Color)item.getValue()), new Object[0]);
            }
            if (item.getIconPath() != null) {
                xMLBuilder.doubleTag("icon", XMLBuilder.escape(item.getIconPath()), new Object[0]);
            }
            if (item.getText() != null) {
                xMLBuilder.doubleTag("text", XMLBuilder.escape(item.getText()), new Object[0]);
            }
            xMLBuilder.doubleTag("value", Long.toString(item.getNumber()), new Object[0]);
            xMLBuilder.endTag("item");
        }
        xMLBuilder.endTag("chart");
        xMLBuilder.save(outputStream);
    }

    @Override
    protected Item createCopyForUndo(Item item) {
        return (Item)item.clone();
    }

    private void writePainterProperties(XMLBuilder xMLBuilder, ChartPainter<?> chartPainter) throws IllegalAccessException {
        xMLBuilder.beginTag("painter");
        for (Map.Entry<Field, PropertyAccess<?>> entry : Property.list(chartPainter).entrySet()) {
            PropertyAccess<?> propertyAccess = entry.getValue();
            xMLBuilder.singleTag("property", "name", entry.getKey().getName(), "value", Property.isString(propertyAccess) && propertyAccess.isNull() ? "" : propertyAccess);
        }
        xMLBuilder.endTag("painter");
    }

    String formatText(String string, Item item, long l) {
        String string2;
        String string3 = string;
        if (TK.isEmpty(string3)) {
            string3 = item.getFormat();
        }
        if (string3 == null) {
            string3 = this.format;
        }
        if (string3 == null) {
            return item.getText();
        }
        Color color = (Color)item.getValue();
        if (color != null && string3.contains("${color}")) {
            string3 = string3.replace("${color}", ColorProperty.toString(color));
        }
        long l2 = item.getNumber();
        if (string3.contains("${number}")) {
            string3 = string3.replace("${number}", Long.toString(l2));
        }
        if (string3.contains("${percent-float}")) {
            string3 = string3.replace("${percent-float}", MFormat.toPercent((float)l2 * 100.0f / (float)l));
        }
        if (string3.contains("${percent-int}")) {
            string3 = string3.replace("${percent-int}", Math.round((float)l2 * 100.0f / (float)l) + "%");
        }
        if ((string2 = item.getText()) != null) {
            string3 = string3.replace("${text}", string2);
        }
        return string3;
    }

    long getTotal() {
        long l = 0L;
        for (Item item : this) {
            l += item.number;
        }
        return l;
    }

    public static final class Sample
    extends ChartModel {
        public Sample() {
            this.addItem("Red", 1L, Color.RED);
            this.addItem("Green", 2L, Color.GREEN);
            this.addItem("Blue", 3L, Color.BLUE);
        }
    }

    public static class Item
    extends org.makagiga.commons.Item<Color>
    implements Cloneable {
        private static final long serialVersionUID = 5843531592685082836L;
        private Map<String, Object> properties;
        private String format;
        private String iconPath;
        transient BufferedImage imageCache;
        long number;

        public Item() {
            this(null, 0L, Color.BLACK, null);
        }

        public Item(String string, long l, Color color, Icon icon) {
            super(color, string);
            this.number = l;
            this.setIcon(icon);
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String string) {
            this.format = string;
        }

        public String getIconPath() {
            return this.iconPath;
        }

        public void setIconPath(String string) {
            this.icon = string == null ? null : MIcon.fromFileURI(string, -1);
            this.iconPath = string;
            this.imageCache = null;
        }

        public Image getImage() {
            if (this.imageCache == null) {
                Icon icon = this.getIcon();
                if (icon == null) {
                    return null;
                }
                this.imageCache = icon instanceof ImageIcon ? UI.toBufferedImage(((ImageIcon)ImageIcon.class.cast(icon)).getImage(), true) : UI.toBufferedImage(icon);
            }
            return this.imageCache;
        }

        public long getNumber() {
            return this.number;
        }

        public void setNumber(long l) {
            this.number = l;
        }

        public <T> T getProperty(String string, T t) {
            if (this.properties == null) {
                return t;
            }
            Object object = this.properties.get(string);
            return (T)(object == null ? t : object);
        }

        public void setProperty(String string, Object object) {
            if (this.properties == null) {
                this.properties = new HashMap<String, Object>();
            }
            this.properties.put(string, object);
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new WTFError(cloneNotSupportedException);
            }
        }
    }
}

