/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import org.makagiga.MainWindow;
import org.makagiga.Tabs;
import org.makagiga.commons.Config;
import org.makagiga.commons.HTMLBuilder;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MSplitPane;
import org.makagiga.commons.MToggleButton;
import org.makagiga.commons.MV;
import org.makagiga.commons.MWhatsThis;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.WTFError;
import org.makagiga.editors.Designer;
import org.makagiga.editors.Editor;
import org.makagiga.todo.TaskList;
import org.makagiga.todo.TaskState;
import org.makagiga.tools.summary.SummaryData;
import org.makagiga.tools.summary.SummaryPanel;
import org.makagiga.tree.Tree;
import org.makagiga.tree.TreePanel;

public final class Sidebar
extends MPanel {
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private Designer currentDesigner;
    private final MArrayList<Button> buttonList = new MArrayList();
    private MPanel buttonPanel;
    private MPanel mainPanel;
    private static Sidebar _instance = new Sidebar();
    private Tab lastTab;

    public Button addTab(JComponent jComponent, String string) {
        return this.addTab(jComponent, string, null, null, null);
    }

    public Button addTab(JComponent jComponent, String string, Action action, Action action2) {
        return this.addTab(jComponent, string, action, action2, null);
    }

    public Button getButtonFor(Tab tab) {
        for (Button button : this.buttonList) {
            if (button.tab != tab) continue;
            return button;
        }
        return null;
    }

    public List<Button> getButtonList() {
        return Collections.unmodifiableList(this.buttonList);
    }

    public MPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public MIcon.Size getIconSize() {
        return MIcon.Size.SMALL;
    }

    public static Sidebar getInstance() {
        return _instance;
    }

    public MPanel getMainPanel() {
        return this.mainPanel;
    }

    public void goTo(Tab tab) {
        this.goTo(tab, true);
    }

    public void goTo(Tab tab, boolean bl) {
        for (Button button : this.buttonList) {
            if (!button.isSelected()) continue;
            if (button.tab == this.lastTab) break;
            this.lastTab = button.tab;
            break;
        }
        if (!this.isSelected(tab)) {
            if (!this.getButtonFor(tab).isEnabled() && tab == Tab.DESIGNER) {
                return;
            }
            this.selectTab(tab);
        }
        switch (tab) {
            case TREE: {
                if (!bl) break;
                MainWindow.showSidebar();
                Tree tree = Tree.getInstance();
                tree.requestFocusInWindow();
                tree.focusItem(Tabs.getInstance().getCurrentMetaInfo());
                break;
            }
            case SUMMARY: {
                if (!bl) break;
                SummaryPanel.getInstance().focus();
                break;
            }
            case DESIGNER: {
                if (!bl || this.currentDesigner == null) break;
                UI.requestFocus(this.currentDesigner);
                break;
            }
            default: {
                throw new WTFError(tab);
            }
        }
    }

    public boolean isDesignerSelected() {
        return this.isSelected(Tab.DESIGNER);
    }

    public boolean isSelected(Tab tab) {
        return this.getButtonFor(tab).isSelected();
    }

    public boolean isSummarySelected() {
        return this.isSelected(Tab.SUMMARY);
    }

    public boolean isTreeSelected() {
        return this.isSelected(Tab.TREE);
    }

    public void selectLastTab() {
        if (this.lastTab != null) {
            this.selectTab(this.lastTab);
        }
    }

    public void setDesigner(Designer designer) {
        Button button = this.getButtonFor(Tab.DESIGNER);
        button.setEnabled(designer != null);
        UI.replaceComponent(this.mainPanel, this.currentDesigner, designer, Tab.DESIGNER.name(), false);
        this.currentDesigner = designer;
    }

    private Sidebar() {
        MWhatsThis.set(this, UI._("Sidebar")).setKeyStroke(120);
        this.mainPanel = MPanel.createCardPanel();
        this.addCenter(this.mainPanel);
        this.buttonPanel = MPanel.createGridPanel(1, 1);
        for (Tab tab : Tab.values()) {
            this.addTab(null, tab.name(), null, null, tab);
        }
        this.addSouth(this.buttonPanel);
        this.getButtonFor(Tab.TREE).setSelected(true);
        this.mainPanel.add((Component)TreePanel.getInstance(), Tab.TREE.name());
        this.mainPanel.add((Component)SummaryPanel.getInstance(), Tab.SUMMARY.name());
    }

    private Button addTab(JComponent jComponent, String string, Action action, Action action2, Tab tab) {
        if (tab == null) {
            TK.checkNull(jComponent, "component");
            TK.checkNullOrEmpty(string, "id");
        }
        Button button = new Button(string, action, action2, tab);
        this.buttonGroup.add(button);
        this.buttonList.add(button);
        if (tab == Tab.DESIGNER) {
            MWhatsThis.set(button, UI._("Designer")).setKeyStroke(115);
        }
        if (button.isVisibleInSidebar()) {
            GridLayout gridLayout = (GridLayout)this.buttonPanel.getLayout();
            if (gridLayout.getRows() == this.buttonPanel.getComponentCount()) {
                gridLayout.setRows(gridLayout.getRows() + 1);
            }
            this.buttonPanel.add(button);
        } else {
            button.setVisible(false);
        }
        if (jComponent != null) {
            this.mainPanel.add((Component)jComponent, string);
        }
        return button;
    }

    private void selectTab(Tab tab) {
        Button button = this.getButtonFor(tab);
        if (!button.isEnabled()) {
            return;
        }
        if (!button.isSelected()) {
            button.setSelected(true);
        }
        this.mainPanel.showCard(tab.name());
    }

    private void showButtonMenu(MouseEvent mouseEvent) {
        MMenu mMenu = new MMenu();
        for (final Button button : this.buttonList) {
            MAction mAction = new MAction(button.getText(), button.getIcon()){

                @Override
                public void onAction() {
                    button.setVisibleInSidebar(this.isSelected());
                    Sidebar.this.updateLayout();
                }
            };
            if (button.tab == Tab.TREE) {
                mAction.setEnabled(false);
            }
            mMenu.addCheckBox(mAction, button.isVisible());
        }
        mMenu.showPopup(mouseEvent);
    }

    private void updateLayout() {
        int n = 0;
        for (Button object : this.buttonList) {
            if (!object.isVisible()) continue;
            ++n;
        }
        this.buttonPanel.removeAll();
        GridLayout gridLayout = (GridLayout)this.buttonPanel.getLayout();
        gridLayout.setRows(n);
        for (Button button : this.buttonList) {
            if (!button.isVisible()) continue;
            this.buttonPanel.add(button);
        }
        this.buttonPanel.revalidate();
    }

    static void show(Tab tab, boolean bl, MSplitPane mSplitPane) {
        Sidebar sidebar = Sidebar.getInstance();
        mSplitPane.setSidebarVisible(true);
        if (tab != null) {
            if (bl) {
                if (sidebar.isSelected(tab)) {
                    sidebar.selectLastTab();
                } else {
                    sidebar.goTo(tab);
                }
            } else {
                sidebar.goTo(tab);
            }
        }
    }

    void update(Editor<?> editor, Designer designer, MAction mAction) {
        Button button = this.getButtonFor(Tab.DESIGNER);
        this.setDesigner(designer);
        if (designer == null) {
            if (button != null) {
                button.setText(Tab.DESIGNER.getTitle());
            }
            if (this.isDesignerSelected()) {
                this.goTo(Tab.TREE, false);
            }
            mAction.setEnabled(false);
        } else {
            if (button != null) {
                String string = Tab.DESIGNER.getTitle();
                String string2 = designer.getDisplayText();
                if (string2 != null) {
                    string = string + " - " + string2;
                }
                button.setText(string);
            }
            designer.repaint();
            if (editor != null) {
                designer.setLocked(!editor.getMetaInfo().canModify());
            }
            mAction.setEnabled(true);
            if (this.isDesignerSelected() && button != null) {
                button.select();
            }
        }
    }

    public final class Button
    extends MToggleButton {
        private final Action onInit;
        private final Action onShow;
        private boolean initDone;
        private final Tab tab;
        private final String id;

        private Button(String string, Action action, Action action2, Tab tab) {
            this.onInit = action;
            this.onShow = action2;
            this.tab = tab;
            this.id = string;
            if (tab != null) {
                if (tab == Tab.SUMMARY) {
                    this.setIcon(MIcon.small("ui/stop"));
                    this.setText(UI._("Please Wait..."));
                } else {
                    this.setIcon(MIcon.small(tab.getIconName()));
                    this.setText(tab.getTitle());
                }
                this.setToolTipText(tab.getToolTipText());
            }
            this.addMouseListener(new MMouseAdapter(){

                @Override
                public void popupTrigger(MouseEvent mouseEvent) {
                    Sidebar.this.showButtonMenu(mouseEvent);
                }
            });
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension dimension = super.getMinimumSize();
            return new Dimension(50, dimension.height);
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            String string = super.getToolTipText(mouseEvent);
            if (this.tab == Tab.SUMMARY) {
                HTMLBuilder hTMLBuilder = HTMLBuilder.newSwingDoc();
                hTMLBuilder.emit(TK.escapeXML(string));
                SummaryData summaryData = SummaryData.getInstance();
                TaskState taskState = null;
                for (Map.Entry<TaskState, SummaryData.Node> entry : summaryData.getTaskStateMap().entrySet()) {
                    TaskState taskState2 = entry.getKey();
                    if (!taskState2.isImportant()) continue;
                    TaskList taskList = new TaskList();
                    SummaryData.Node node = entry.getValue();
                    for (SummaryData.Node node2 : node.list(MV.MODEL)) {
                        for (SummaryData.Node node3 : node2.list(MV.MODEL)) {
                            taskList.add(node3.getTask());
                        }
                    }
                    if (taskList.isEmpty()) continue;
                    if (taskState2 != taskState) {
                        taskState = taskState2;
                        hTMLBuilder.beginTag("p");
                        hTMLBuilder.doubleTag("b", TK.escapeXML(taskState2.toString()), new Object[0]);
                        hTMLBuilder.endTag("p");
                    }
                    hTMLBuilder.emit(taskList.getToolTipText(2));
                }
                string = hTMLBuilder.endSwingDoc().toString();
            }
            return string;
        }

        public void select() {
            MainWindow.showSidebar();
            TK.fireActionPerformed(this, this.getActionListeners());
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setHorizontalAlignment(10);
            this.setRequestFocusEnabled(false);
            this.setStyle("padding: 0 5 0 5");
        }

        @Override
        protected void onClick() {
            if (this.tab == null) {
                if (!this.initDone) {
                    this.initDone = true;
                    if (this.onInit != null) {
                        MAction.fire(this.onInit, (Object)this);
                    }
                }
                Sidebar.this.mainPanel.showCard(this.id);
                if (this.onShow != null) {
                    MAction.fire(this.onShow, (Object)this);
                }
                this.setSelected(true);
            } else {
                Sidebar.this.selectTab(this.tab);
            }
        }

        private boolean isVisibleInSidebar() {
            final String string = "Sidebar." + this.id + ".visible";
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                return Config.getDefault().read(string, true);
            }
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return Config.getDefault().read(string, true);
                }
            });
        }

        private void setVisibleInSidebar(boolean bl) {
            this.setVisible(bl);
            Config config = Config.getDefault();
            config.write("Sidebar." + this.id + ".visible", bl);
            config.sync();
        }
    }

    public static enum Tab {
        TREE(UI._("Tree"), "ui/tree", UI._("Tree - all files and folders")),
        SUMMARY(UI._("Summary"), "summary", UI._("Summary - scheduled tasks ({0})", TK.toString(83, 3))),
        DESIGNER(UI._("Designer"), "ui/wizard", UI._("Designer - tools and properties ({0})", TK.toString(115, 0)));

        private String iconName;
        private String title;
        private String toolTipText;

        @Deprecated
        public String getIcon() {
            return this.iconName;
        }

        public String getIconName() {
            return this.iconName;
        }

        public String getTitle() {
            return this.title;
        }

        public String getToolTipText() {
            return this.toolTipText;
        }

        private Tab(String string2, String string3, String string4) {
            this.title = string2;
            this.iconName = string3;
            this.toolTipText = string4;
        }
    }
}

