/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.PointFilter;
import java.awt.Color;

public class ColorizeFilter
extends PointFilter {
    private Color color;

    public ColorizeFilter() {
        this(Color.GREEN);
    }

    public ColorizeFilter(Color color) {
        this.canFilterIndexColorModel = true;
        this.setColor(color);
    }

    @Override
    public int filterRGB(int n, int n2, int n3) {
        int n4 = n3 & 0xFF000000;
        int n5 = n3 >> 16 & 0xFF;
        int n6 = n3 >> 8 & 0xFF;
        int n7 = n3 & 0xFF;
        n5 = (n5 + this.color.getRed()) / 2;
        n6 = (n6 + this.color.getGreen()) / 2;
        n7 = (n7 + this.color.getBlue()) / 2;
        return n4 | n5 << 16 | n6 << 8 | n7;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("Color cannot be null");
        }
        this.color = color;
    }

    public String toString() {
        return "Colors/Colorize";
    }
}

