/*
 * Decompiled with CFR 0.152.
 */
package jreepad;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;
import javax.swing.tree.TreePath;
import jreepad.JreepadNode;
import jreepad.JreepadPrefs;
import jreepad.JreepadSearcher;
import jreepad.JreepadTreeModel;
import jreepad.io.AutoDetectReader;
import jreepad.io.JreepadWriter;
import jreepad.io.TreepadWriter;
import jreepad.io.XmlWriter;

public class find {
    private static final int PARAMMODE_SEARCHANY = 1;
    private static final int PARAMMODE_FILENAME = 2;
    private static final int PARAMMODE_SEARCHTITLE = 3;
    private static final int PARAMMODE_SEARCHARTICLE = 4;
    private static final int PARAMMODE_SEARCHLIMIT = 5;
    private static final int OUTPUT_HJT = 1;
    private static final int OUTPUT_TEXT = 2;
    private static final int OUTPUT_TITLES = 3;
    private static final int OUTPUT_BRIEF = 4;
    private static final int OUTPUT_XML = 5;
    private static final File prefsFile = new File(System.getProperty("user.home"), ".jreepref");

    public static void main(String[] args) throws IOException {
        int maxResults = 200;
        boolean caseSensitive = false;
        boolean orNotAnd = true;
        File userFile = null;
        int outputFormat = 5;
        Vector<String> titleSearches = new Vector<String>();
        Vector<String> articleSearches = new Vector<String>();
        if (args.length == 0 || args.length == 1 && (args[0].startsWith("-h") || args[0].startsWith("--h"))) {
            find.printUsage();
            System.exit(1);
        }
        int paramMode = 1;
        block16: for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-t")) {
                paramMode = 3;
                continue;
            }
            if (args[i].equals("-a")) {
                paramMode = 4;
                continue;
            }
            if (args[i].equals("-l")) {
                paramMode = 5;
                continue;
            }
            if (args[i].equals("-f")) {
                paramMode = 2;
                continue;
            }
            if (args[i].startsWith("-o")) {
                if (args[i].equals("-oh")) {
                    outputFormat = 1;
                    continue;
                }
                if (args[i].equals("-on")) {
                    outputFormat = 2;
                    continue;
                }
                if (args[i].equals("-ot")) {
                    outputFormat = 3;
                    continue;
                }
                if (args[i].equals("-ob")) {
                    outputFormat = 4;
                    continue;
                }
                if (!args[i].equals("-ox")) continue;
                outputFormat = 5;
                continue;
            }
            switch (paramMode) {
                case 2: {
                    userFile = new File(args[i]);
                    paramMode = 1;
                    continue block16;
                }
                case 3: {
                    titleSearches.add(args[i]);
                    continue block16;
                }
                case 5: {
                    maxResults = Integer.parseInt(args[i]);
                    paramMode = 1;
                    continue block16;
                }
                case 4: {
                    articleSearches.add(args[i]);
                    continue block16;
                }
                default: {
                    titleSearches.add(args[i]);
                    articleSearches.add(args[i]);
                }
            }
        }
        String inNodes = "";
        for (int i = 0; i < titleSearches.size(); ++i) {
            inNodes = inNodes + " " + (String)titleSearches.get(i);
        }
        String inArticles = "";
        for (int i = 0; i < articleSearches.size(); ++i) {
            inArticles = inArticles + " " + (String)articleSearches.get(i);
        }
        if (titleSearches.size() > 1 || articleSearches.size() > 1) {
            System.out.println("Warning: complicated searches (more than 1 item to find in article, or more than 1 article to find in title) don't currently work properly!");
        }
        String encoding = "UTF-8";
        File prefsLastFile = null;
        if (prefsFile.exists()) {
            try {
                ObjectInputStream prefsLoader = new ObjectInputStream(new FileInputStream(prefsFile));
                JreepadPrefs jreepref = (JreepadPrefs)prefsLoader.readObject();
                prefsLoader.close();
                encoding = jreepref.getEncoding();
                prefsLastFile = jreepref.getMostRecentFile();
                jreepref = null;
            }
            catch (Exception err) {
                // empty catch block
            }
        }
        if (userFile == null) {
            userFile = prefsLastFile;
        }
        if (userFile == null) {
            System.out.println("No Treepad/Jreepad file specified, and none found in the recently-used files list!");
            System.exit(1);
        } else if (!userFile.exists()) {
            System.out.println("File not found!");
            System.exit(1);
        }
        JreepadNode root = new JreepadNode();
        try {
            FileInputStream in = new FileInputStream(userFile);
            AutoDetectReader reader = new AutoDetectReader(encoding, false);
            root = reader.read(in).getRootNode();
        }
        catch (IOException err) {
            System.out.println("File input error: " + err);
            System.exit(1);
        }
        JreepadSearcher searcher = new JreepadSearcher(root);
        searcher.performSearch(inNodes, inArticles, new TreePath(root), orNotAnd, caseSensitive, maxResults);
        JreepadSearcher.JreepadSearchResult[] res = searcher.getSearchResults();
        if (res.length == 0) {
            System.out.println("No matches.");
            System.exit(1);
        }
        switch (outputFormat) {
            case 2: {
                for (int i = 0; i < res.length; ++i) {
                    System.out.println(find.formatResultSimpleText(res[i]));
                }
                break;
            }
            case 4: {
                for (int i = 0; i < res.length; ++i) {
                    System.out.println(find.formatResultBrieferText(res[i]));
                }
                break;
            }
            case 1: 
            case 5: {
                JreepadNode resultsParent = new JreepadNode("Search results", "");
                for (int i = 0; i < res.length; ++i) {
                    resultsParent.add(res[i].getNode());
                }
                String outputEncoding = "ISO-8859-1";
                JreepadWriter writer = outputFormat == 5 ? new XmlWriter() : new TreepadWriter(outputEncoding);
                writer.write(System.out, new JreepadTreeModel(resultsParent));
                break;
            }
            case 3: {
                for (int i = 0; i < res.length; ++i) {
                    System.out.println(res[i].getNode().getTitle());
                }
                break;
            }
        }
    }

    private static String formatResultSimpleText(JreepadSearcher.JreepadSearchResult res) {
        JreepadNode n = res.getNode();
        return "-- " + n.getArticle().getTitle() + " --\n" + n.getArticle().getContent();
    }

    private static String formatResultBrieferText(JreepadSearcher.JreepadSearchResult res) {
        JreepadNode n = res.getNode();
        return n.getTitle() + "\n    " + res.getArticleQuote().replace('\n', ' ');
    }

    private static void printUsage() {
        System.out.println("Usage: java jreepad.find -f mynotes.hjt \"Text to find\"");
        System.out.println("For more information use \"-m\" for a brief manual.");
    }

    private static void printManual() {
        System.out.println("Jreepad (c) Dan Stowell - open source under the Gnu Public Licence");
    }
}

