/*
 * Decompiled with CFR 0.152.
 */
package jreepad.editor;

import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import jreepad.JreepadArticle;
import jreepad.JreepadPrefs;
import jreepad.JreepadView;
import jreepad.editor.AbstractArticleView;
import jreepad.ui.FontHelper;

public class TableViewer
extends AbstractArticleView {
    private JTable table;

    public TableViewer(JreepadArticle article) {
        super(article);
        this.table = new JTable(TableViewer.getTableModel(article));
        this.table.setAutoResizeMode(0);
        this.table.setGridColor(Color.GRAY);
        this.table.setShowGrid(true);
        this.table.setShowVerticalLines(true);
        this.table.setShowHorizontalLines(true);
    }

    public void updateFont(int direction) {
        FontHelper.updateFont(this.getComponent(), direction);
    }

    public JComponent getComponent() {
        return this.table;
    }

    public void reloadArticle() {
        this.table.setModel(TableViewer.getTableModel(this.article));
    }

    private static TableModel getTableModel(JreepadArticle a) {
        Object[][] rowData = a.interpretContentAsCsv();
        Object[] columnNames = new String[rowData[0].length];
        for (int i = 0; i < columnNames.length; ++i) {
            columnNames[i] = " ";
        }
        return new ArticleTableModel(rowData, columnNames);
    }

    public String getText() {
        int w = this.table.getColumnCount();
        int h = this.table.getRowCount();
        StringBuffer csv = new StringBuffer();
        String quoteMark = TableViewer.getPrefs().addQuotesToCsvOutput ? "\"" : "";
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w - 1; ++j) {
                csv.append(quoteMark + (String)this.table.getValueAt(i, j) + quoteMark + ",");
            }
            csv.append(quoteMark + (String)this.table.getValueAt(i, w - 1) + quoteMark + "\n");
        }
        return csv.toString();
    }

    public String getSelectedText() {
        int x = this.table.getSelectedColumn();
        int y = this.table.getSelectedRow();
        if (x == -1 || y == -1) {
            return "";
        }
        return this.table.getValueAt(y, x).toString();
    }

    public static JreepadPrefs getPrefs() {
        return JreepadView.getPrefs();
    }

    private static class ArticleTableModel
    extends DefaultTableModel {
        public ArticleTableModel(Object[][] data, Object[] columnNames) {
            super(data, columnNames);
        }

        public ArticleTableModel() {
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

