/*
 * Decompiled with CFR 0.152.
 */
package jreepad;

import com.apple.eio.FileManager;
import edu.stanford.ejalbert.BrowserLauncher;
import edu.stanford.ejalbert.exception.BrowserLaunchingExecutionException;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ListIterator;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import jreepad.JreepadNode;
import jreepad.JreepadPrefs;
import jreepad.JreepadTreeModel;
import jreepad.JreepadView;
import jreepad.PrefsDialog;
import jreepad.SearchDialog;
import jreepad.TreePathCollection;
import jreepad.io.AutoDetectReader;
import jreepad.io.EncryptedWriter;
import jreepad.io.HtmlWriter;
import jreepad.io.JreepadWriter;
import jreepad.io.TreepadWriter;
import jreepad.io.XmlWriter;
import jreepad.ui.PasswordDialog;
import jreepad.ui.SaveFileChooser;

public class JreepadViewer
extends JFrame {
    public static String version = "1.6 rc1";
    private static Vector theApps = new Vector(1, 1);
    private Box toolBar;
    private Box toolBarIconic;
    private JreepadView theJreepad;
    private JreepadTreeModel document;
    private Container content;
    protected static ResourceBundle lang = ResourceBundle.getBundle("jreepad.lang.JreepadStrings");
    private JFileChooser fileChooser;
    private String windowTitle;
    protected Clipboard systemClipboard;
    private JButton addAboveButton;
    private JButton addBelowButton;
    private JButton addButton;
    private JButton removeButton;
    private JButton upButton;
    private JButton downButton;
    private JButton indentButton;
    private JButton outdentButton;
    private JComboBox viewSelector;
    private JComboBox viewSelectorIconic;
    private JButton newIconButton;
    private JButton openIconButton;
    private JButton addAboveIconButton;
    private JButton addBelowIconButton;
    private JButton addIconButton;
    private JButton removeIconButton;
    private JButton upIconButton;
    private JButton downIconButton;
    private JButton indentIconButton;
    private JButton outdentIconButton;
    private Thread autoSaveThread;
    private JDialog autoSaveDialog;
    private JCheckBox autoSaveCheckBox;
    private JSpinner autoSavePeriodSpinner;
    private JButton autoSaveOkButton;
    private JButton autoSaveCancelButton;
    private JDialog prefsDialog;
    private SearchDialog searchDialog;
    private JDialog nodeUrlDisplayDialog;
    private JTextField nodeUrlDisplayField;
    private JButton nodeUrlDisplayOkButton;
    private JMenu openRecentMenu;
    private JMenuItem undoMenuItem;
    private JMenuItem redoMenuItem;
    private JMenuItem webSearchMenuItem;
    private JMenuItem characterWrapArticleMenuItem;
    private JCheckBoxMenuItem viewToolbarIconsMenuItem;
    private JCheckBoxMenuItem viewToolbarTextMenuItem;
    private JCheckBoxMenuItem viewToolbarOffMenuItem;
    private ColouredStrip funkyGreenStrip;
    public static boolean MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    static final int MENU_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    public static final int appleAppCode = 1246905669;
    private ClassLoader loader = this.getClass().getClassLoader();
    private static final int FILE_FORMAT_HJT = 1;
    private static final int FILE_FORMAT_HTML = 2;
    private static final int FILE_FORMAT_XML = 3;
    private static final int FILE_FORMAT_TEXT = 4;
    private static final int FILE_FORMAT_TEXTASLIST = 5;
    private static final int FILE_FORMAT_ARTICLESTOTEXT = 6;
    private File[] openRecentTempFileList;

    public JreepadViewer() {
        this("");
    }

    public JreepadViewer(String fileNameToLoad) {
        this(fileNameToLoad, (String)null);
    }

    public JreepadViewer(String fileNameToLoad, String prefFilename) {
        ClassLoader loader = this.getClass().getClassLoader();
        URL iconUrl = loader.getResource("images/jreepadlogo-01-iconsize.gif");
        if (iconUrl != null) {
            this.setIconImage(new ImageIcon(iconUrl).getImage());
        } else {
            System.out.println("Icon image failed to load: images/jreepadlogo-01-iconsize.gif");
        }
        Toolkit theToolkit = this.getToolkit();
        Dimension wndSize = theToolkit.getScreenSize();
        this.systemClipboard = theToolkit.getSystemClipboard();
        JreepadViewer.setPrefs(new JreepadPrefs(wndSize));
        if (!JreepadViewer.getPrefs().seenLicense) {
            this.showLicense();
            JreepadViewer.getPrefs().seenLicense = true;
        }
        this.fileChooser = new JFileChooser();
        this.fileChooser.addChoosableFileFilter(SaveFileChooser.JREEPAD_FILE_FILTER);
        this.fileChooser.addChoosableFileFilter(SaveFileChooser.JREEPAD_ENCRYPTED_FILE_FILTER);
        this.fileChooser.addChoosableFileFilter(SaveFileChooser.TREEPAD_FILE_FILTER);
        this.content = this.getContentPane();
        this.document = new JreepadTreeModel();
        this.theJreepad = new JreepadView(this.document);
        this.establishMenus();
        this.establishToolbar();
        this.searchDialog = new SearchDialog((Frame)this, this.theJreepad);
        this.prefsDialog = new PrefsDialog(this);
        this.establishAutosaveDialogue();
        this.establishNodeUrlDisplayDialogue();
        this.autoSaveThread = new Thread("Autosave thread"){

            public void run() {
                while (JreepadViewer.getPrefs().autoSave) {
                    try {
                        1.sleep(60000L * (long)JreepadViewer.getPrefs().autoSavePeriod);
                        1.yield();
                        if (JreepadViewer.getPrefs().autoSave && JreepadViewer.this.document.getSaveLocation() != null) {
                            new SaveAction().actionPerformed(null);
                            continue;
                        }
                        JreepadViewer.this.updateWindowTitle();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        this.autoSaveThread.setPriority(1);
        if (JreepadViewer.getPrefs().autoSave) {
            this.autoSaveThread.start();
        }
        this.content.setLayout(new BoxLayout(this.content, 1));
        this.funkyGreenStrip = new ColouredStrip(new Color(0.09f, 0.4f, 0.12f), wndSize.width, 10);
        this.content.add(this.funkyGreenStrip);
        this.funkyGreenStrip.setVisible(JreepadViewer.getPrefs().showGreenStrip);
        this.content.add(this.toolBar);
        this.content.add(this.toolBarIconic);
        this.setToolbarMode(JreepadViewer.getPrefs().toolbarMode);
        this.content.add(this.theJreepad);
        File firstTimeFile = null;
        if (fileNameToLoad != "") {
            firstTimeFile = new File(fileNameToLoad);
        } else if (JreepadViewer.getPrefs().loadLastFileOnOpen && JreepadViewer.getPrefs().getMostRecentFile() != null) {
            firstTimeFile = JreepadViewer.getPrefs().getMostRecentFile();
        }
        if (firstTimeFile != null && firstTimeFile.isFile()) {
            this.openFile(firstTimeFile);
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JreepadViewer.this.quitAction();
            }
        });
        this.setTitleBasedOnFilename("");
        this.setBounds(JreepadViewer.getPrefs().windowLeft, JreepadViewer.getPrefs().windowTop, JreepadViewer.getPrefs().windowWidth, JreepadViewer.getPrefs().windowHeight);
        this.searchDialog.setBounds(JreepadViewer.getPrefs().windowWidth / 2, JreepadViewer.getPrefs().windowHeight / 6, (int)((float)JreepadViewer.getPrefs().windowWidth * 0.7f), (int)((float)JreepadViewer.getPrefs().windowHeight * 0.9f));
        this.autoSaveDialog.setBounds((int)((float)wndSize.width * 0.5f), JreepadViewer.getPrefs().windowHeight / 2, JreepadViewer.getPrefs().windowWidth / 2, JreepadViewer.getPrefs().windowHeight / 4);
        this.prefsDialog.setBounds(JreepadViewer.getPrefs().windowWidth / 2, JreepadViewer.getPrefs().windowHeight / 3, JreepadViewer.getPrefs().windowWidth, JreepadViewer.getPrefs().windowHeight);
        this.nodeUrlDisplayDialog.setBounds((int)((float)wndSize.width * 0.1f), (int)((float)JreepadViewer.getPrefs().windowHeight * 0.7f), (int)((float)JreepadViewer.getPrefs().windowWidth * 1.3f), JreepadViewer.getPrefs().windowHeight / 3);
        this.searchDialog.pack();
        this.autoSaveDialog.pack();
        this.prefsDialog.pack();
        this.nodeUrlDisplayDialog.pack();
        theApps.add(this);
        this.macOSXRegistration();
        this.setVisible(true);
        if (this.document.getSaveLocation() != null) {
            this.theJreepad.expandPaths(JreepadViewer.getPrefs().treePathCollection.paths);
        }
        this.theJreepad.returnFocusToTree();
    }

    private void establishMenus() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createFileMenu());
        menuBar.add(this.createEditMenu());
        menuBar.add(this.createActionsMenu());
        menuBar.add(this.createViewMenu());
        menuBar.add(this.createOptionsMenu());
        menuBar.add(this.createHelpMenu());
        this.setJMenuBar(menuBar);
    }

    private JMenu createFileMenu() {
        JMenu fileMenu = new JMenu(lang.getString("MENU_FILE"));
        fileMenu.setMnemonic(70);
        JMenuItem newMenuItem = new JMenuItem(lang.getString("MENUITEM_NEW"));
        newMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.newAction();
            }
        });
        fileMenu.add(newMenuItem);
        JMenuItem openMenuItem = new JMenuItem(lang.getString("MENUITEM_OPEN"));
        openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.openAction();
            }
        });
        fileMenu.add(openMenuItem);
        this.openRecentMenu = new JMenu(lang.getString("MENUITEM_OPENRECENT"));
        this.updateOpenRecentMenu();
        fileMenu.add(this.openRecentMenu);
        fileMenu.add(new SaveAction());
        fileMenu.add(new SaveAction(true));
        JMenuItem backupToMenuItem = new JMenuItem(lang.getString("MENUITEM_BACKUPTO"));
        backupToMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.backupToAction();
            }
        });
        fileMenu.add(backupToMenuItem);
        fileMenu.add(new JSeparator());
        JMenuItem printSubtreeMenuItem = new JMenuItem(lang.getString("MENUITEM_PRINTSUBTREE"));
        printSubtreeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.subtreeToBrowserForPrintAction();
            }
        });
        fileMenu.add(printSubtreeMenuItem);
        JMenuItem printArticleMenuItem = new JMenuItem(lang.getString("MENUITEM_PRINTARTICLE"));
        printArticleMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.articleToBrowserForPrintAction();
            }
        });
        fileMenu.add(printArticleMenuItem);
        fileMenu.add(new JSeparator());
        JMenu importMenu = new JMenu(lang.getString("MENUITEM_IMPORT"));
        fileMenu.add(importMenu);
        JMenuItem importHjtMenuItem = new JMenuItem(lang.getString("MENUITEM_IMPORT_HJT"));
        importHjtMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.importAction(1);
            }
        });
        importMenu.add(importHjtMenuItem);
        JMenuItem importTextMenuItem = new JMenuItem(lang.getString("MENUITEM_IMPORT_TEXTFILES"));
        importTextMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.importAction(4);
            }
        });
        importMenu.add(importTextMenuItem);
        JMenuItem importTextAsListMenuItem = new JMenuItem(lang.getString("MENUITEM_IMPORT_TEXTLIST"));
        importTextAsListMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.importAction(5);
            }
        });
        importMenu.add(importTextAsListMenuItem);
        fileMenu.add(this.createExportMenu());
        fileMenu.add(new JSeparator());
        if (!MAC_OS_X) {
            JMenuItem quitMenuItem = new JMenuItem(lang.getString("MENUITEM_QUIT"));
            quitMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JreepadViewer.this.quitAction();
                }
            });
            fileMenu.add(quitMenuItem);
            quitMenuItem.setMnemonic('Q');
            quitMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, MENU_MASK));
        }
        newMenuItem.setMnemonic('N');
        newMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, MENU_MASK));
        openMenuItem.setMnemonic('O');
        openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, MENU_MASK));
        this.openRecentMenu.setMnemonic('R');
        printSubtreeMenuItem.setMnemonic('P');
        printSubtreeMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, MENU_MASK));
        printArticleMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, MENU_MASK | 1));
        backupToMenuItem.setMnemonic('B');
        importMenu.setMnemonic('I');
        importHjtMenuItem.setMnemonic('f');
        importTextMenuItem.setMnemonic('t');
        importTextAsListMenuItem.setMnemonic('l');
        return fileMenu;
    }

    private JMenu createExportMenu() {
        JMenu exportMenu = new JMenu(lang.getString("MENUITEM_EXPORT"));
        JMenuItem exportHjtMenuItem = new JMenuItem(lang.getString("MENUITEM_EXPORT_HJT"));
        exportHjtMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.exportAction(1);
            }
        });
        exportMenu.add(exportHjtMenuItem);
        JMenuItem exportHtmlMenuItem = new JMenuItem(lang.getString("MENUITEM_EXPORT_HTML"));
        exportHtmlMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.exportAction(2);
            }
        });
        exportMenu.add(exportHtmlMenuItem);
        JMenuItem exportSimpleXmlMenuItem = new JMenuItem(lang.getString("MENUITEM_EXPORT_XML"));
        exportSimpleXmlMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.exportAction(3);
            }
        });
        exportMenu.add(exportSimpleXmlMenuItem);
        JMenuItem exportListMenuItem = new JMenuItem(lang.getString("MENUITEM_EXPORT_TEXTLIST"));
        exportListMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.exportAction(5);
            }
        });
        exportMenu.add(exportListMenuItem);
        exportMenu.add(new JSeparator());
        JMenuItem exportTextMenuItem = new JMenuItem(lang.getString("MENUITEM_EXPORT_ARTICLE"));
        exportTextMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.exportAction(4);
            }
        });
        exportMenu.add(exportTextMenuItem);
        JMenuItem exportSubtreeTextMenuItem = new JMenuItem(lang.getString("MENUITEM_EXPORT_ARTICLES"));
        exportSubtreeTextMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.exportAction(6);
            }
        });
        exportMenu.add(exportSubtreeTextMenuItem);
        exportMenu.setMnemonic('E');
        exportHjtMenuItem.setMnemonic('f');
        exportHtmlMenuItem.setMnemonic('h');
        exportSimpleXmlMenuItem.setMnemonic('x');
        exportTextMenuItem.setMnemonic('t');
        return exportMenu;
    }

    private JMenu createEditMenu() {
        JMenu editMenu = new JMenu(lang.getString("MENU_EDIT"));
        editMenu.setMnemonic(69);
        this.undoMenuItem = new JMenuItem(lang.getString("MENUITEM_UNDO"));
        this.undoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.undoAction();
                JreepadViewer.this.updateUndoRedoMenuState();
            }
        });
        editMenu.add(this.undoMenuItem);
        this.redoMenuItem = new JMenuItem(lang.getString("MENUITEM_REDO"));
        this.redoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.redoAction();
                JreepadViewer.this.updateUndoRedoMenuState();
            }
        });
        editMenu.add(this.redoMenuItem);
        editMenu.add(new JSeparator());
        JMenuItem addAboveMenuItem = new JMenuItem(lang.getString("MENUITEM_ADDABOVE"));
        addAboveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.addNodeAbove();
                JreepadViewer.this.updateWindowTitle();
            }
        });
        editMenu.add(addAboveMenuItem);
        JMenuItem addBelowMenuItem = new JMenuItem(lang.getString("MENUITEM_ADDBELOW"));
        addBelowMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.addNodeBelow();
                JreepadViewer.this.updateWindowTitle();
            }
        });
        editMenu.add(addBelowMenuItem);
        JMenuItem addChildMenuItem = new JMenuItem(lang.getString("MENUITEM_ADDCHILD"));
        addChildMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.addNode();
                JreepadViewer.this.updateWindowTitle();
            }
        });
        editMenu.add(addChildMenuItem);
        editMenu.add(new JSeparator());
        JMenuItem newFromClipboardMenuItem = new JMenuItem(lang.getString("MENUITEM_NEWFROMCLIPBOARD"));
        newFromClipboardMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.systemClipboardToNewNode();
            }
        });
        editMenu.add(newFromClipboardMenuItem);
        editMenu.add(new JSeparator());
        JMenuItem editNodeTitleMenuItem = new JMenuItem(lang.getString("MENUITEM_EDITNODETITLE"));
        editNodeTitleMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.editNodeTitleAction();
            }
        });
        editMenu.add(editNodeTitleMenuItem);
        editMenu.add(new JSeparator());
        JMenuItem deleteMenuItem = new JMenuItem(lang.getString("MENUITEM_DELETENODE"));
        deleteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.deleteNodeAction();
            }
        });
        editMenu.add(deleteMenuItem);
        editMenu.add(new JSeparator());
        JMenuItem upMenuItem = new JMenuItem(lang.getString("MENUITEM_MOVEUP"));
        upMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.moveCurrentNodeUp();
                JreepadViewer.this.theJreepad.returnFocusToTree();
                JreepadViewer.this.updateWindowTitle();
            }
        });
        editMenu.add(upMenuItem);
        JMenuItem downMenuItem = new JMenuItem(lang.getString("MENUITEM_MOVEDOWN"));
        downMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.moveCurrentNodeDown();
                JreepadViewer.this.theJreepad.returnFocusToTree();
                JreepadViewer.this.updateWindowTitle();
            }
        });
        editMenu.add(downMenuItem);
        editMenu.add(new JSeparator());
        JMenuItem indentMenuItem = new JMenuItem(lang.getString("MENUITEM_MOVEIN"));
        indentMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.indentCurrentNode();
                JreepadViewer.this.theJreepad.returnFocusToTree();
                JreepadViewer.this.updateWindowTitle();
            }
        });
        editMenu.add(indentMenuItem);
        JMenuItem outdentMenuItem = new JMenuItem(lang.getString("MENUITEM_MOVEOUT"));
        outdentMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.outdentCurrentNode();
                JreepadViewer.this.theJreepad.returnFocusToTree();
                JreepadViewer.this.updateWindowTitle();
            }
        });
        editMenu.add(outdentMenuItem);
        editMenu.add(new JSeparator());
        JMenuItem expandAllMenuItem = new JMenuItem(lang.getString("MENUITEM_EXPAND"));
        expandAllMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.expandAllCurrentNode();
            }
        });
        editMenu.add(expandAllMenuItem);
        JMenuItem collapseAllMenuItem = new JMenuItem(lang.getString("MENUITEM_COLLAPSE"));
        collapseAllMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.collapseAllCurrentNode();
            }
        });
        editMenu.add(collapseAllMenuItem);
        this.undoMenuItem.setMnemonic('u');
        this.undoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, MENU_MASK));
        this.redoMenuItem.setMnemonic('r');
        this.redoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, MENU_MASK | 1));
        addAboveMenuItem.setMnemonic('a');
        addAboveMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, MENU_MASK));
        addBelowMenuItem.setMnemonic('b');
        addBelowMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, MENU_MASK));
        addChildMenuItem.setMnemonic('c');
        addChildMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, MENU_MASK));
        newFromClipboardMenuItem.setAccelerator(KeyStroke.getKeyStroke(77, MENU_MASK));
        editNodeTitleMenuItem.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        upMenuItem.setMnemonic('u');
        upMenuItem.setAccelerator(KeyStroke.getKeyStroke(38, MENU_MASK | 8));
        downMenuItem.setMnemonic('d');
        downMenuItem.setAccelerator(KeyStroke.getKeyStroke(40, MENU_MASK | 8));
        indentMenuItem.setMnemonic('i');
        indentMenuItem.setAccelerator(KeyStroke.getKeyStroke(39, MENU_MASK | 8));
        outdentMenuItem.setMnemonic('o');
        outdentMenuItem.setAccelerator(KeyStroke.getKeyStroke(37, MENU_MASK | 8));
        expandAllMenuItem.setMnemonic('x');
        expandAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(61, MENU_MASK));
        collapseAllMenuItem.setMnemonic('l');
        collapseAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(45, MENU_MASK));
        deleteMenuItem.setMnemonic('k');
        deleteMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, MENU_MASK));
        this.undoMenuItem.setMnemonic('u');
        this.undoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, MENU_MASK));
        this.redoMenuItem.setMnemonic('r');
        this.redoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, MENU_MASK | 1));
        addAboveMenuItem.setMnemonic('a');
        addAboveMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, MENU_MASK));
        addBelowMenuItem.setMnemonic('b');
        addBelowMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, MENU_MASK));
        addChildMenuItem.setMnemonic('c');
        addChildMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, MENU_MASK));
        newFromClipboardMenuItem.setAccelerator(KeyStroke.getKeyStroke(77, MENU_MASK));
        upMenuItem.setMnemonic('u');
        upMenuItem.setAccelerator(KeyStroke.getKeyStroke(38, MENU_MASK | 8));
        downMenuItem.setMnemonic('d');
        downMenuItem.setAccelerator(KeyStroke.getKeyStroke(40, MENU_MASK | 8));
        indentMenuItem.setMnemonic('i');
        indentMenuItem.setAccelerator(KeyStroke.getKeyStroke(39, MENU_MASK | 8));
        outdentMenuItem.setMnemonic('o');
        outdentMenuItem.setAccelerator(KeyStroke.getKeyStroke(37, MENU_MASK | 8));
        expandAllMenuItem.setMnemonic('x');
        expandAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(61, MENU_MASK));
        collapseAllMenuItem.setMnemonic('l');
        collapseAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(45, MENU_MASK));
        deleteMenuItem.setMnemonic('k');
        deleteMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, MENU_MASK));
        return editMenu;
    }

    private JMenu createActionsMenu() {
        JMenu actionsMenu = new JMenu(lang.getString("MENU_ACTIONS"));
        actionsMenu.setMnemonic(84);
        JMenuItem searchMenuItem = new JMenuItem(lang.getString("MENUITEM_SEARCH"));
        searchMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.searchDialog.open();
            }
        });
        actionsMenu.add(searchMenuItem);
        JMenuItem launchUrlMenuItem = new JMenuItem(lang.getString("MENUITEM_FOLLOWLINK"));
        launchUrlMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.openURLSelectedInArticle();
            }
        });
        actionsMenu.add(launchUrlMenuItem);
        this.webSearchMenuItem = new JMenuItem(JreepadViewer.getPrefs().webSearchName);
        this.webSearchMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.webSearchTextSelectedInArticle();
            }
        });
        actionsMenu.add(this.webSearchMenuItem);
        actionsMenu.add(new JSeparator());
        this.characterWrapArticleMenuItem = new JMenuItem(lang.getString("MENUITEM_HARDWRAP1") + " " + JreepadViewer.getPrefs().characterWrapWidth + " " + lang.getString("MENUITEM_HARDWRAP2"));
        this.characterWrapArticleMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.wrapContentToCharWidth();
            }
        });
        actionsMenu.add(this.characterWrapArticleMenuItem);
        JMenuItem stripTagsMenuItem = new JMenuItem(lang.getString("MENUITEM_STRIPTAGS"));
        stripTagsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.stripAllTags();
            }
        });
        actionsMenu.add(stripTagsMenuItem);
        JMenuItem insertDateMenuItem = new JMenuItem(lang.getString("MENUITEM_INSERTDATE"));
        insertDateMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.insertDate();
            }
        });
        actionsMenu.add(insertDateMenuItem);
        actionsMenu.add(new JSeparator());
        JMenuItem sortMenuItem = new JMenuItem(lang.getString("MENUITEM_SORTONELEVEL"));
        sortMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.sortChildren();
                JreepadViewer.this.updateWindowTitle();
            }
        });
        actionsMenu.add(sortMenuItem);
        JMenuItem sortRecursiveMenuItem = new JMenuItem(lang.getString("MENUITEM_SORTALLLEVELS"));
        sortRecursiveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.sortChildrenRecursive();
                JreepadViewer.this.updateWindowTitle();
            }
        });
        actionsMenu.add(sortRecursiveMenuItem);
        searchMenuItem.setMnemonic('s');
        searchMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, MENU_MASK));
        this.webSearchMenuItem.setMnemonic('g');
        this.webSearchMenuItem.setAccelerator(KeyStroke.getKeyStroke(71, MENU_MASK));
        this.characterWrapArticleMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, MENU_MASK));
        this.characterWrapArticleMenuItem.setMnemonic('r');
        launchUrlMenuItem.setAccelerator(KeyStroke.getKeyStroke(76, MENU_MASK));
        launchUrlMenuItem.setMnemonic('l');
        stripTagsMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, MENU_MASK));
        stripTagsMenuItem.setMnemonic('t');
        insertDateMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, MENU_MASK));
        insertDateMenuItem.setMnemonic('e');
        return actionsMenu;
    }

    private JMenu createViewMenu() {
        JMenu viewMenu = new JMenu(lang.getString("MENU_VIEW"));
        viewMenu.setMnemonic('V');
        JMenuItem viewBothMenuItem = new JMenuItem(lang.getString("MENUITEM_VIEWBOTH"));
        viewBothMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.setViewMode(0);
            }
        });
        viewMenu.add(viewBothMenuItem);
        JMenuItem viewTreeMenuItem = new JMenuItem(lang.getString("MENUITEM_VIEWTREE"));
        viewTreeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.setViewMode(1);
            }
        });
        viewMenu.add(viewTreeMenuItem);
        JMenuItem viewArticleMenuItem = new JMenuItem(lang.getString("MENUITEM_VIEWARTICLE"));
        viewArticleMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.setViewMode(2);
            }
        });
        viewMenu.add(viewArticleMenuItem);
        viewMenu.add(new JSeparator());
        JMenu viewToolbarMenu = new JMenu(lang.getString("MENUITEM_TOOLBAR"));
        viewMenu.add(viewToolbarMenu);
        this.viewToolbarIconsMenuItem = new JCheckBoxMenuItem(lang.getString("MENUITEM_TOOLBAR_ICONS"));
        this.viewToolbarIconsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.setToolbarMode(1);
            }
        });
        viewToolbarMenu.add(this.viewToolbarIconsMenuItem);
        this.viewToolbarTextMenuItem = new JCheckBoxMenuItem(lang.getString("MENUITEM_TOOLBAR_TEXT"));
        this.viewToolbarTextMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.setToolbarMode(0);
            }
        });
        viewToolbarMenu.add(this.viewToolbarTextMenuItem);
        this.viewToolbarOffMenuItem = new JCheckBoxMenuItem(lang.getString("MENUITEM_TOOLBAR_OFF"));
        this.viewToolbarOffMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.setToolbarMode(2);
            }
        });
        viewToolbarMenu.add(this.viewToolbarOffMenuItem);
        viewMenu.add(new JSeparator());
        JMenu articleViewModeMenuItem = new JMenu(lang.getString("MENUITEM_ARTICLEFORMAT"));
        JMenuItem articleViewModeTextMenuItem = new JMenuItem(lang.getString("MENUITEM_ARTICLEFORMAT_TEXT"));
        articleViewModeTextMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.setArticleMode(1);
                JreepadViewer.this.updateUndoRedoMenuState();
            }
        });
        ((Container)articleViewModeMenuItem).add(articleViewModeTextMenuItem);
        JMenuItem articleViewModeHtmlMenuItem = new JMenuItem(lang.getString("MENUITEM_ARTICLEFORMAT_HTML"));
        articleViewModeHtmlMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.setArticleMode(2);
                JreepadViewer.this.updateUndoRedoMenuState();
            }
        });
        ((Container)articleViewModeMenuItem).add(articleViewModeHtmlMenuItem);
        JMenuItem articleViewModeCsvMenuItem = new JMenuItem(lang.getString("MENUITEM_ARTICLEFORMAT_CSV"));
        articleViewModeCsvMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.setArticleMode(3);
                JreepadViewer.this.updateUndoRedoMenuState();
            }
        });
        ((Container)articleViewModeMenuItem).add(articleViewModeCsvMenuItem);
        JMenuItem articleViewModeTextileMenuItem = new JMenuItem(lang.getString("MENUITEM_ARTICLEFORMAT_TEXTILE"));
        articleViewModeTextileMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.setArticleMode(4);
                JreepadViewer.this.updateUndoRedoMenuState();
            }
        });
        ((Container)articleViewModeMenuItem).add(articleViewModeTextileMenuItem);
        viewMenu.add(articleViewModeMenuItem);
        viewMenu.add(new JSeparator());
        JMenuItem thisNodesUrlMenuItem = new JMenuItem(lang.getString("MENUITEM_NODEADDRESS"));
        thisNodesUrlMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.getTreepadNodeUrl();
            }
        });
        viewMenu.add(thisNodesUrlMenuItem);
        thisNodesUrlMenuItem.setMnemonic('n');
        viewBothMenuItem.setMnemonic('b');
        viewTreeMenuItem.setMnemonic('t');
        viewArticleMenuItem.setMnemonic('a');
        viewBothMenuItem.setAccelerator(KeyStroke.getKeyStroke(49, MENU_MASK));
        viewTreeMenuItem.setAccelerator(KeyStroke.getKeyStroke(50, MENU_MASK));
        viewArticleMenuItem.setAccelerator(KeyStroke.getKeyStroke(51, MENU_MASK));
        this.viewToolbarIconsMenuItem.setAccelerator(KeyStroke.getKeyStroke(52, MENU_MASK));
        this.viewToolbarTextMenuItem.setAccelerator(KeyStroke.getKeyStroke(53, MENU_MASK));
        this.viewToolbarOffMenuItem.setAccelerator(KeyStroke.getKeyStroke(54, MENU_MASK));
        articleViewModeTextMenuItem.setAccelerator(KeyStroke.getKeyStroke(55, MENU_MASK));
        articleViewModeHtmlMenuItem.setAccelerator(KeyStroke.getKeyStroke(56, MENU_MASK));
        articleViewModeCsvMenuItem.setAccelerator(KeyStroke.getKeyStroke(57, MENU_MASK));
        articleViewModeTextileMenuItem.setAccelerator(KeyStroke.getKeyStroke(48, MENU_MASK));
        viewToolbarMenu.setMnemonic('o');
        viewMenu.add(new JSeparator());
        JMenu articleFontMenu = new JMenu(lang.getString("MENUITEM_FONT_ARTICLE"));
        viewMenu.add(articleFontMenu);
        JMenuItem increaseFontMenuItem = new JMenuItem(lang.getString("MENUITEM_FONT_INCREASE"));
        increaseFontMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.changeFont(1, 1);
            }
        });
        JMenuItem decreaseFontMenuItem = new JMenuItem(lang.getString("MENUITEM_FONT_DECREASE"));
        decreaseFontMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.changeFont(2, 1);
            }
        });
        articleFontMenu.add(increaseFontMenuItem);
        articleFontMenu.add(decreaseFontMenuItem);
        JMenu treeFontMenu = new JMenu(lang.getString("MENUITEM_FONT_TREE"));
        viewMenu.add(treeFontMenu);
        JMenuItem increaseTreeFontMenuItem = new JMenuItem(lang.getString("MENUITEM_FONT_INCREASE"));
        increaseTreeFontMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.changeFont(1, 2);
            }
        });
        JMenuItem decreaseTreeFontMenuItem = new JMenuItem(lang.getString("MENUITEM_FONT_DECREASE"));
        decreaseTreeFontMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.changeFont(2, 2);
            }
        });
        treeFontMenu.add(increaseTreeFontMenuItem);
        treeFontMenu.add(decreaseTreeFontMenuItem);
        return viewMenu;
    }

    private JMenu createOptionsMenu() {
        JMenu optionsMenu = new JMenu(lang.getString("MENU_OPTIONS"));
        optionsMenu.setMnemonic('O');
        JMenuItem autoSaveMenuItem = new JMenuItem(lang.getString("MENUITEM_AUTOSAVE_PREFS"));
        autoSaveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.showAutoSaveDialog();
            }
        });
        optionsMenu.add(autoSaveMenuItem);
        JMenuItem prefsMenuItem = new JMenuItem(lang.getString("MENUITEM_PREFS"));
        prefsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.showPrefsDialog();
            }
        });
        optionsMenu.add(prefsMenuItem);
        autoSaveMenuItem.setMnemonic('a');
        prefsMenuItem.setMnemonic('p');
        return optionsMenu;
    }

    private JMenu createHelpMenu() {
        JMenu helpMenu = new JMenu(lang.getString("MENU_HELP"));
        helpMenu.setMnemonic('H');
        JMenuItem keyboardHelpMenuItem = new JMenuItem(lang.getString("MENUITEM_KEYBOARDSHORTCUTS"));
        keyboardHelpMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.keyboardHelp();
            }
        });
        helpMenu.add(keyboardHelpMenuItem);
        JMenuItem linksHelpMenuItem = new JMenuItem(lang.getString("MENUITEM_LINKSHELP"));
        linksHelpMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.linksHelp();
            }
        });
        helpMenu.add(linksHelpMenuItem);
        JMenuItem dragDropHelpMenuItem = new JMenuItem(lang.getString("MENUITEM_DRAGDROPHELP"));
        dragDropHelpMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.dragDropHelp();
            }
        });
        helpMenu.add(dragDropHelpMenuItem);
        helpMenu.add(new JSeparator());
        if (!MAC_OS_X) {
            JMenuItem aboutMenuItem = new JMenuItem(lang.getString("MENUITEM_ABOUT"));
            aboutMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JreepadViewer.this.aboutAction();
                }
            });
            aboutMenuItem.setMnemonic('a');
            helpMenu.add(aboutMenuItem);
        }
        JMenuItem licenseMenuItem = new JMenuItem(lang.getString("MENUITEM_LICENSE"));
        licenseMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.showLicense();
            }
        });
        helpMenu.add(licenseMenuItem);
        keyboardHelpMenuItem.setMnemonic('k');
        dragDropHelpMenuItem.setMnemonic('d');
        linksHelpMenuItem.setMnemonic('l');
        licenseMenuItem.setMnemonic('i');
        return helpMenu;
    }

    public void establishToolbar() {
        this.toolBar = Box.createHorizontalBox();
        this.toolBarIconic = Box.createHorizontalBox();
        this.addAboveButton = new JButton(lang.getString("TOOLBAR_ADDABOVE"));
        this.addBelowButton = new JButton(lang.getString("TOOLBAR_ADDBELOW"));
        this.addButton = new JButton(lang.getString("TOOLBAR_ADDCHILD"));
        this.removeButton = new JButton(lang.getString("TOOLBAR_DELETE"));
        this.upButton = new JButton(lang.getString("TOOLBAR_UP"));
        this.downButton = new JButton(lang.getString("TOOLBAR_DOWN"));
        this.indentButton = new JButton(lang.getString("TOOLBAR_IN"));
        this.outdentButton = new JButton(lang.getString("TOOLBAR_OUT"));
        this.addAboveButton.setMnemonic('a');
        this.addBelowButton.setMnemonic('b');
        this.addButton.setMnemonic('c');
        this.upButton.setMnemonic('u');
        this.downButton.setMnemonic('d');
        this.indentButton.setMnemonic('i');
        this.outdentButton.setMnemonic('o');
        this.removeButton.setMnemonic('k');
        this.viewSelector = new JComboBox<String>(new String[]{lang.getString("TOOLBAR_VIEWBOTH"), lang.getString("TOOLBAR_VIEWTREE"), lang.getString("TOOLBAR_VIEWARTICLE")});
        this.viewSelector.setEditable(false);
        this.viewSelector.setSelectedIndex(0);
        this.viewSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                switch (JreepadViewer.this.viewSelector.getSelectedIndex()) {
                    case 1: {
                        JreepadViewer.this.setViewMode(1);
                        break;
                    }
                    case 2: {
                        JreepadViewer.this.setViewMode(2);
                        break;
                    }
                    default: {
                        JreepadViewer.this.setViewMode(0);
                    }
                }
            }
        });
        this.viewSelectorIconic = new JComboBox<String>(new String[]{lang.getString("TOOLBAR_VIEWBOTH"), lang.getString("TOOLBAR_VIEWTREE"), lang.getString("TOOLBAR_VIEWARTICLE")});
        this.viewSelectorIconic.setEditable(false);
        this.viewSelectorIconic.setSelectedIndex(0);
        this.viewSelectorIconic.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                switch (JreepadViewer.this.viewSelectorIconic.getSelectedIndex()) {
                    case 1: {
                        JreepadViewer.this.setViewMode(1);
                        break;
                    }
                    case 2: {
                        JreepadViewer.this.setViewMode(2);
                        break;
                    }
                    default: {
                        JreepadViewer.this.setViewMode(0);
                    }
                }
            }
        });
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.moveCurrentNodeUp();
                JreepadViewer.this.repaint();
                JreepadViewer.this.theJreepad.returnFocusToTree();
                JreepadViewer.this.updateWindowTitle();
            }
        });
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.moveCurrentNodeDown();
                JreepadViewer.this.repaint();
                JreepadViewer.this.theJreepad.returnFocusToTree();
                JreepadViewer.this.updateWindowTitle();
            }
        });
        this.indentButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.indentCurrentNode();
                JreepadViewer.this.repaint();
                JreepadViewer.this.theJreepad.returnFocusToTree();
                JreepadViewer.this.updateWindowTitle();
            }
        });
        this.outdentButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.outdentCurrentNode();
                JreepadViewer.this.repaint();
                JreepadViewer.this.theJreepad.returnFocusToTree();
                JreepadViewer.this.updateWindowTitle();
            }
        });
        this.addAboveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.addNodeAbove();
                JreepadViewer.this.repaint();
                JreepadViewer.this.updateWindowTitle();
            }
        });
        this.addBelowButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.addNodeBelow();
                JreepadViewer.this.repaint();
                JreepadViewer.this.updateWindowTitle();
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.addNode();
                JreepadViewer.this.repaint();
                JreepadViewer.this.updateWindowTitle();
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.deleteNodeAction();
            }
        });
        this.newIconButton = new JButton();
        this.newIconButton.setToolTipText(lang.getString("TOOLBAR_NEW"));
        this.newIconButton.setBorderPainted(false);
        this.newIconButton.setIcon(this.getIcon("New16.gif"));
        this.openIconButton = new JButton();
        this.openIconButton.setToolTipText(lang.getString("TOOLBAR_OPEN"));
        this.openIconButton.setBorderPainted(false);
        this.openIconButton.setIcon(this.getIcon("Open16.gif"));
        JButton saveIconButton = new JButton(new SaveAction());
        saveIconButton.setBorderPainted(false);
        saveIconButton.setText(null);
        this.addAboveIconButton = new JButton(lang.getString("TOOLBAR_ADDABOVE"));
        this.addBelowIconButton = new JButton(lang.getString("TOOLBAR_ADDBELOW"));
        this.addBelowIconButton.setMnemonic('b');
        this.addIconButton = new JButton();
        this.addIconButton.setMnemonic('c');
        this.addIconButton.setToolTipText(lang.getString("TOOLBAR_ADDCHILD"));
        this.addIconButton.setBorderPainted(false);
        this.addIconButton.setIcon(this.getIcon("Add16.gif"));
        this.removeIconButton = new JButton();
        this.removeIconButton.setMnemonic('k');
        this.removeIconButton.setToolTipText(lang.getString("TOOLBAR_DELETE"));
        this.removeIconButton.setBorderPainted(false);
        this.removeIconButton.setIcon(this.getIcon("Remove16.gif"));
        this.upIconButton = new JButton();
        this.upIconButton.setMnemonic('u');
        this.upIconButton.setToolTipText(lang.getString("TOOLBAR_UP"));
        this.upIconButton.setBorderPainted(false);
        this.upIconButton.setIcon(this.getIcon("Up16.gif"));
        this.downIconButton = new JButton();
        this.downIconButton.setMnemonic('d');
        this.downIconButton.setToolTipText(lang.getString("TOOLBAR_DOWN"));
        this.downIconButton.setBorderPainted(false);
        this.downIconButton.setIcon(this.getIcon("Down16.gif"));
        this.outdentIconButton = new JButton();
        this.outdentIconButton.setMnemonic('i');
        this.outdentIconButton.setToolTipText(lang.getString("TOOLBAR_IN"));
        this.outdentIconButton.setBorderPainted(false);
        this.outdentIconButton.setIcon(this.getIcon("Back16.gif"));
        this.indentIconButton = new JButton();
        this.indentIconButton.setMnemonic('o');
        this.indentIconButton.setToolTipText(lang.getString("TOOLBAR_OUT"));
        this.indentIconButton.setBorderPainted(false);
        this.indentIconButton.setIcon(this.getIcon("Forward16.gif"));
        this.newIconButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.newAction();
            }
        });
        this.openIconButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.openAction();
            }
        });
        this.upIconButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.moveCurrentNodeUp();
                JreepadViewer.this.repaint();
                JreepadViewer.this.theJreepad.returnFocusToTree();
                JreepadViewer.this.updateWindowTitle();
            }
        });
        this.downIconButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.moveCurrentNodeDown();
                JreepadViewer.this.repaint();
                JreepadViewer.this.theJreepad.returnFocusToTree();
                JreepadViewer.this.updateWindowTitle();
            }
        });
        this.indentIconButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.indentCurrentNode();
                JreepadViewer.this.repaint();
                JreepadViewer.this.theJreepad.returnFocusToTree();
                JreepadViewer.this.updateWindowTitle();
            }
        });
        this.outdentIconButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.outdentCurrentNode();
                JreepadViewer.this.repaint();
                JreepadViewer.this.theJreepad.returnFocusToTree();
                JreepadViewer.this.updateWindowTitle();
            }
        });
        this.addAboveIconButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.addNodeAbove();
                JreepadViewer.this.repaint();
                JreepadViewer.this.updateWindowTitle();
            }
        });
        this.addBelowIconButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.addNodeBelow();
                JreepadViewer.this.repaint();
                JreepadViewer.this.updateWindowTitle();
            }
        });
        this.addIconButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.theJreepad.addNode();
                JreepadViewer.this.repaint();
                JreepadViewer.this.updateWindowTitle();
            }
        });
        this.removeIconButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.deleteNodeAction();
            }
        });
        this.toolBar.add(this.addAboveButton);
        this.toolBar.add(this.addBelowButton);
        this.toolBar.add(this.addButton);
        this.toolBar.add(this.removeButton);
        this.toolBar.add(this.upButton);
        this.toolBar.add(this.downButton);
        this.toolBar.add(this.indentButton);
        this.toolBar.add(this.outdentButton);
        this.toolBar.add(this.viewSelector);
        this.toolBar.add(Box.createGlue());
        this.toolBarIconic.add(this.newIconButton);
        this.toolBarIconic.add(this.openIconButton);
        this.toolBarIconic.add(saveIconButton);
        this.toolBarIconic.add(this.addAboveIconButton);
        this.toolBarIconic.add(this.addBelowIconButton);
        this.toolBarIconic.add(this.addIconButton);
        this.toolBarIconic.add(this.removeIconButton);
        this.toolBarIconic.add(this.upIconButton);
        this.toolBarIconic.add(this.downIconButton);
        this.toolBarIconic.add(this.outdentIconButton);
        this.toolBarIconic.add(this.indentIconButton);
        this.toolBarIconic.add(this.viewSelectorIconic);
        this.toolBarIconic.add(Box.createGlue());
    }

    private final Icon getIcon(String name) {
        try {
            URL iconUrl = this.loader.getResource("images/" + name);
            return new ImageIcon(iconUrl);
        }
        catch (Exception e) {
            System.err.println("Jreepad: Icon image failed to load: images/" + name);
            return null;
        }
    }

    protected void setToolbarMode(int newMode) {
        switch (newMode) {
            case 0: {
                this.toolBar.setVisible(true);
                this.toolBarIconic.setVisible(false);
                break;
            }
            case 1: {
                this.toolBar.setVisible(false);
                this.toolBarIconic.setVisible(true);
                break;
            }
            case 2: {
                this.toolBar.setVisible(false);
                this.toolBarIconic.setVisible(false);
                break;
            }
            default: {
                return;
            }
        }
        JreepadViewer.getPrefs().toolbarMode = newMode;
        this.viewToolbarIconsMenuItem.setSelected(newMode == 1);
        this.viewToolbarTextMenuItem.setSelected(newMode == 0);
        this.viewToolbarOffMenuItem.setSelected(newMode == 2);
        this.repaint();
    }

    public void establishAutosaveDialogue() {
        this.autoSaveDialog = new JDialog(this, lang.getString("AUTOSAVE"), true);
        this.autoSaveDialog.setVisible(false);
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createGlue());
        Box hBox = Box.createHorizontalBox();
        this.autoSaveCheckBox = new JCheckBox(lang.getString("AUTOSAVE_EVERY"), JreepadViewer.getPrefs().autoSave);
        hBox.add(this.autoSaveCheckBox);
        this.autoSavePeriodSpinner = new JSpinner(new SpinnerNumberModel(JreepadViewer.getPrefs().autoSavePeriod, 1, 1000, 1));
        hBox.add(this.autoSavePeriodSpinner);
        hBox.add(new JLabel(lang.getString("AUTOSAVE_MINUTES")));
        vBox.add(hBox);
        vBox.add(Box.createGlue());
        hBox = Box.createHorizontalBox();
        this.autoSaveOkButton = new JButton(lang.getString("OK"));
        hBox.add(this.autoSaveOkButton);
        this.autoSaveCancelButton = new JButton(lang.getString("CANCEL"));
        hBox.add(this.autoSaveCancelButton);
        this.autoSaveOkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.getPrefs().autoSavePeriod = (Integer)JreepadViewer.this.autoSavePeriodSpinner.getValue();
                JreepadViewer.getPrefs().autoSave = JreepadViewer.this.autoSaveCheckBox.isSelected();
                JreepadViewer.this.autoSaveDialog.setVisible(false);
                if (JreepadViewer.getPrefs().autoSave && !JreepadViewer.this.autoSaveThread.isAlive()) {
                    JreepadViewer.this.autoSaveWarningMessage();
                    JreepadViewer.this.autoSaveThread.start();
                }
                JreepadViewer.this.updateWindowTitle();
            }
        });
        this.autoSaveCancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.autoSaveDialog.setVisible(false);
            }
        });
        vBox.add(Box.createGlue());
        vBox.add(hBox);
        this.autoSaveDialog.getContentPane().add(vBox);
    }

    public void autoSaveWarningMessage() {
        JOptionPane.showMessageDialog(this, lang.getString("AUTOSAVE_ACTIVE_LONG"), lang.getString("AUTOSAVE_ACTIVE"), 1);
    }

    public void establishNodeUrlDisplayDialogue() {
        this.nodeUrlDisplayDialog = new JDialog(this, "Node URL", true);
        this.nodeUrlDisplayDialog.setVisible(false);
        Box vBox = Box.createVerticalBox();
        vBox.add(new JLabel(lang.getString("MSG_NODEURL1")));
        this.nodeUrlDisplayField = new JTextField("node://its/a/secret");
        vBox.add(this.nodeUrlDisplayField);
        vBox.add(new JLabel(lang.getString("MSG_NODEURL2")));
        this.nodeUrlDisplayOkButton = new JButton(lang.getString("OK"));
        vBox.add(this.nodeUrlDisplayOkButton);
        this.nodeUrlDisplayOkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JreepadViewer.this.nodeUrlDisplayDialog.setVisible(false);
            }
        });
        this.nodeUrlDisplayDialog.getContentPane().add(vBox);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        String launchFilename = "";
        String launchPrefsFilename = null;
        boolean ARGMODE_FILE = false;
        boolean ARGMODE_PREF = true;
        boolean argMode = ARGMODE_FILE;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-h") || args[i].startsWith("--h")) {
                System.out.println("Jreepad command-line arguments:");
                System.out.println("  -p [prefsfile]    Load/save preferences from named location instead of default");
                System.out.println("  [filename]        Jreepad/treepad file to load on startup");
                System.out.println("  ");
                System.out.println("For example:");
                System.out.println("  java -jar Jreepad.jar -p /Users/jo/Library/jreeprefs.dat /Users/jo/Documents/mynotes.hjt");
                System.exit(1);
                continue;
            }
            if (args[i].equals("-p")) {
                argMode = ARGMODE_PREF;
                continue;
            }
            if (argMode == ARGMODE_PREF && launchPrefsFilename == null) {
                launchPrefsFilename = args[i];
                argMode = ARGMODE_FILE;
                continue;
            }
            if (argMode != ARGMODE_FILE || !launchFilename.equals("")) continue;
            launchFilename = args[i];
        }
        new JreepadViewer(launchFilename, launchPrefsFilename);
    }

    private boolean askAndSave(String prompt) {
        if (this.document.isContentSaved()) {
            return true;
        }
        int answer = JOptionPane.showConfirmDialog(this, prompt, "Save?", 1, 2);
        if (answer == 2) {
            return false;
        }
        if (answer == 0) {
            SaveAction saveAction = new SaveAction();
            saveAction.actionPerformed(null);
            if (!saveAction.isSuccessful()) {
                return false;
            }
        }
        return true;
    }

    private void newAction() {
        if (!this.askAndSave(lang.getString("PROMPT_SAVE_BEFORE_NEW"))) {
            return;
        }
        this.content.remove(this.theJreepad);
        this.document = new JreepadTreeModel();
        this.theJreepad = new JreepadView(this.document);
        this.content.add(this.theJreepad);
        this.searchDialog.setJreepad(this.theJreepad);
        this.setTitleBasedOnFilename("");
        this.validate();
        this.repaint();
        this.document.setContentSaved(true);
        this.updateUndoRedoMenuState();
    }

    private void openAction() {
        if (!this.askAndSave(lang.getString("PROMPT_SAVE_BEFORE_OPEN"))) {
            return;
        }
        this.fileChooser.setCurrentDirectory(JreepadViewer.getPrefs().openLocation);
        if (this.fileChooser.showOpenDialog(this) != 0) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.openFile(this.fileChooser.getSelectedFile());
        this.setCursor(Cursor.getDefaultCursor());
        this.updateUndoRedoMenuState();
    }

    public boolean openFile(File file) {
        JreepadViewer.getPrefs().openLocation = file;
        try {
            FileInputStream in = new FileInputStream(file);
            AutoDetectReader reader = new AutoDetectReader(JreepadViewer.getPrefs().getEncoding(), JreepadViewer.getPrefs().autoDetectHtmlArticles);
            this.document = reader.read(in);
            this.document.setSaveLocation(file);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e, lang.getString("MSG_LOAD_FILE_FAILED"), 0);
            return false;
        }
        this.content.remove(this.theJreepad);
        this.theJreepad = new JreepadView(this.document);
        this.content.add(this.theJreepad);
        this.searchDialog.setJreepad(this.theJreepad);
        JreepadViewer.getPrefs().exportLocation = JreepadViewer.getPrefs().importLocation = file;
        this.setTitleBasedOnFilename(file.getName());
        this.validate();
        this.repaint();
        return true;
    }

    private boolean backupToAction() {
        try {
            this.fileChooser.setCurrentDirectory(JreepadViewer.getPrefs().backupLocation);
            if (this.fileChooser.showSaveDialog(this) == 0 && this.checkOverwrite(this.fileChooser.getSelectedFile())) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                JreepadViewer.getPrefs().backupLocation = this.fileChooser.getSelectedFile();
                TreepadWriter writer = new TreepadWriter(JreepadViewer.getPrefs().getEncoding());
                FileOutputStream fos = new FileOutputStream(JreepadViewer.getPrefs().backupLocation);
                writer.write(fos, this.document);
                ((OutputStream)fos).close();
                this.setCursor(Cursor.getDefaultCursor());
                return true;
            }
            return false;
        }
        catch (IOException err) {
            this.setCursor(Cursor.getDefaultCursor());
            JOptionPane.showMessageDialog(this, err, lang.getString("TITLE_FILE_ERROR"), 0);
            return false;
        }
    }

    private void setTitleBasedOnFilename(String filename) {
        this.windowTitle = filename == "" ? "Jreepad (Java Treepad Editor)" : filename + " - Jreepad";
        this.updateWindowTitle();
    }

    private void updateWindowTitle() {
        this.setTitle(this.windowTitle + (this.document.isContentSaved() ? "" : "*") + (JreepadViewer.getPrefs().autoSave ? " [" + lang.getString("AUTOSAVE_ACTIVE") + "]" : ""));
    }

    private void importAction(int importFormat) {
        try {
            boolean multipleFiles;
            boolean bl = multipleFiles = importFormat == 4;
            if (multipleFiles) {
                this.fileChooser.setMultiSelectionEnabled(true);
            }
            this.fileChooser.setCurrentDirectory(JreepadViewer.getPrefs().importLocation);
            this.fileChooser.setSelectedFile(new File(this.theJreepad.getCurrentNode().getTitle()));
            if (this.fileChooser.showOpenDialog(this) == 0) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                JreepadViewer.getPrefs().importLocation = this.fileChooser.getSelectedFile();
                switch (importFormat) {
                    case 1: {
                        FileInputStream in = new FileInputStream(JreepadViewer.getPrefs().importLocation);
                        AutoDetectReader reader = new AutoDetectReader(JreepadViewer.getPrefs().getEncoding(), JreepadViewer.getPrefs().autoDetectHtmlArticles);
                        this.theJreepad.addChild(reader.read(in).getRootNode());
                        break;
                    }
                    case 4: {
                        this.theJreepad.addChildrenFromTextFiles(this.fileChooser.getSelectedFiles());
                        break;
                    }
                    case 5: {
                        this.theJreepad.addChildrenFromListTextFile(new InputStreamReader((InputStream)new FileInputStream(JreepadViewer.getPrefs().importLocation), JreepadViewer.getPrefs().getEncoding()));
                        break;
                    }
                    default: {
                        this.setCursor(Cursor.getDefaultCursor());
                        JOptionPane.showMessageDialog(this, "Unknown which format to import - coding error! Oops!", lang.getString("TITLE_MISC_ERROR"), 0);
                        return;
                    }
                }
                this.updateWindowTitle();
            }
            this.fileChooser.setMultiSelectionEnabled(false);
            this.setCursor(Cursor.getDefaultCursor());
        }
        catch (IOException err) {
            this.setCursor(Cursor.getDefaultCursor());
            JOptionPane.showMessageDialog(this, err, lang.getString("TITLE_MISC_ERROR"), 0);
        }
    }

    private void exportAction(int exportFormat) {
        try {
            this.fileChooser.setCurrentDirectory(JreepadViewer.getPrefs().exportLocation);
            String suggestFilename = this.theJreepad.getCurrentNode().getTitle();
            switch (exportFormat) {
                case 1: {
                    suggestFilename = suggestFilename + ".hjt";
                    break;
                }
                case 2: {
                    suggestFilename = suggestFilename + ".html";
                    break;
                }
                case 3: {
                    suggestFilename = suggestFilename + ".xml";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    suggestFilename = suggestFilename + ".txt";
                }
            }
            this.fileChooser.setSelectedFile(new File(suggestFilename));
            if (this.fileChooser.showSaveDialog(this) == 0 && this.checkOverwrite(this.fileChooser.getSelectedFile())) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                JreepadViewer.getPrefs().exportLocation = this.fileChooser.getSelectedFile();
                String output = null;
                JreepadWriter writer = null;
                switch (exportFormat) {
                    case 2: {
                        writer = new HtmlWriter(JreepadViewer.getPrefs().getEncoding(), JreepadViewer.getPrefs().htmlExportArticleType, JreepadViewer.getPrefs().htmlExportUrlsToLinks, JreepadViewer.getPrefs().htmlExportAnchorLinkType);
                        break;
                    }
                    case 3: {
                        writer = new XmlWriter();
                        break;
                    }
                    case 1: {
                        writer = new TreepadWriter(JreepadViewer.getPrefs().getEncoding());
                        break;
                    }
                    case 4: {
                        output = this.theJreepad.getCurrentNode().getContent();
                        break;
                    }
                    case 5: {
                        output = this.theJreepad.getCurrentNode().exportTitlesAsList();
                        break;
                    }
                    case 6: {
                        int answer = JOptionPane.showConfirmDialog(this, lang.getString("PROMPT_INCLUDE_TITLES"), lang.getString("TITLE_INCLUDE_TITLES"), 0, 3);
                        boolean titlesToo = answer == 0;
                        output = this.theJreepad.getCurrentNode().exportArticlesToText(titlesToo);
                        break;
                    }
                    default: {
                        this.setCursor(Cursor.getDefaultCursor());
                        JOptionPane.showMessageDialog(this, "Unknown which format to export - coding error! Oops!", lang.getString("TITLE_MISC_ERROR"), 0);
                        return;
                    }
                }
                FileOutputStream fos = new FileOutputStream(JreepadViewer.getPrefs().exportLocation);
                if (writer != null) {
                    writer.write(fos, new JreepadTreeModel(this.theJreepad.getCurrentNode()));
                    ((OutputStream)fos).close();
                } else {
                    OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, JreepadViewer.getPrefs().getEncoding());
                    osw.write(output);
                    osw.close();
                }
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
        catch (IOException err) {
            this.setCursor(Cursor.getDefaultCursor());
            JOptionPane.showMessageDialog(this, err, lang.getString("TITLE_FILE_ERROR"), 0);
        }
    }

    private void subtreeToBrowserForPrintAction() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        HtmlWriter writer = new HtmlWriter(JreepadViewer.getPrefs().getEncoding(), JreepadViewer.getPrefs().htmlExportArticleType, JreepadViewer.getPrefs().htmlExportUrlsToLinks, JreepadViewer.getPrefs().htmlExportAnchorLinkType, true);
        String output = writer.write(this.theJreepad.getCurrentNode());
        this.toBrowserForPrintAction(output);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void articleToBrowserForPrintAction() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        String output = this.theJreepad.getCurrentNode().getArticle().exportAsHtml(JreepadViewer.getPrefs().htmlExportArticleType, JreepadViewer.getPrefs().htmlExportUrlsToLinks, JreepadViewer.getPrefs().htmlExportAnchorLinkType, true);
        this.toBrowserForPrintAction(output);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void toBrowserForPrintAction(String output) {
        String surl = "";
        try {
            File systemTempFile = File.createTempFile("TMPjree", ".html");
            FileOutputStream fO = new FileOutputStream(systemTempFile);
            DataOutputStream dO = new DataOutputStream(fO);
            dO.writeBytes(output);
            dO.close();
            fO.close();
            this.setCursor(Cursor.getDefaultCursor());
            surl = systemTempFile.toURL().toString();
            new BrowserLauncher(null).openURLinBrowser(surl);
        }
        catch (BrowserLaunchingInitializingException e) {
            this.displayBrowserLauncherException(e, surl);
        }
        catch (BrowserLaunchingExecutionException e) {
            this.displayBrowserLauncherException(e, surl);
        }
        catch (UnsupportedOperatingSystemException e) {
            this.displayBrowserLauncherException(e, surl);
        }
        catch (IOException err) {
            JOptionPane.showMessageDialog(this, err, lang.getString("TITLE_FILE_ERROR"), 0);
        }
    }

    private void displayBrowserLauncherException(Exception e, String url) {
        JOptionPane.showMessageDialog(this, "Error while opening URL:\n" + url + "\n" + e.getMessage() + "\n\n" + "The \"BrowserLauncher\" used to open a URL is an open-source Java library \n" + "separate from Jreepad itself - i.e. a separate Sourceforge project. \n" + "It may be a good idea to submit a bug report to\n" + "http://browserlaunch2.sourceforge.net/\n\n" + "If you do, please remember to supply information about the operating system\n" + "you are using - which type, and which version.", lang.getString("TITLE_MISC_ERROR"), 0);
    }

    public void quitAction() {
        if (!this.askAndSave(lang.getString("PROMPT_SAVE_BEFORE_QUIT"))) {
            return;
        }
        JreepadViewer.getPrefs().treePathCollection = new TreePathCollection(this.theJreepad.getAllExpandedPaths());
        JreepadViewer.getPrefs().windowLeft = this.getX();
        JreepadViewer.getPrefs().windowTop = this.getY();
        JreepadViewer.getPrefs().windowWidth = this.getWidth();
        JreepadViewer.getPrefs().windowHeight = this.getHeight();
        this.savePreferencesFile();
        System.exit(0);
    }

    private void savePreferencesFile() {
        JreepadViewer.getPrefs().save();
    }

    private void setViewMode(int mode) {
        this.theJreepad.setViewMode(mode);
        if (mode == 2) {
            this.viewSelector.setSelectedIndex(2);
        } else if (mode == 1) {
            this.viewSelector.setSelectedIndex(1);
        } else {
            this.viewSelector.setSelectedIndex(0);
        }
        JreepadViewer.getPrefs().viewWhich = mode;
        this.updateUndoRedoMenuState();
    }

    private static JreepadPrefs getPrefs() {
        return JreepadView.getPrefs();
    }

    private static void setPrefs(JreepadPrefs thesePrefs) {
        JreepadView.setPrefs(thesePrefs);
    }

    private void setViewToolbar(boolean boo) {
        this.toolBar.setVisible(boo);
    }

    private void undoAction() {
        UndoManager undoMgr = this.theJreepad.getCurrentNode().getArticle().getUndoMgr();
        String undoStyle = undoMgr.getUndoPresentationName();
        try {
            while (undoStyle.equals(undoMgr.getUndoPresentationName())) {
                undoMgr.undo();
            }
        }
        catch (CannotUndoException cannotUndoException) {
            // empty catch block
        }
        this.updateWindowTitle();
        this.updateUndoRedoMenuState();
    }

    private void redoAction() {
        UndoManager undoMgr = this.theJreepad.getCurrentNode().getArticle().getUndoMgr();
        String redoStyle = undoMgr.getRedoPresentationName();
        try {
            while (redoStyle.equals(undoMgr.getRedoPresentationName())) {
                undoMgr.redo();
            }
        }
        catch (CannotRedoException cannotRedoException) {
            // empty catch block
        }
        this.updateWindowTitle();
        this.updateUndoRedoMenuState();
    }

    public void updateUndoRedoMenuState() {
        this.undoMenuItem.setEnabled(this.isArticleUndoPossible());
        this.redoMenuItem.setEnabled(this.isArticleRedoPossible());
    }

    public boolean isArticleUndoPossible() {
        if (JreepadViewer.getPrefs().viewWhich == 1) {
            return false;
        }
        return this.theJreepad.getCurrentNode().getArticle().getArticleMode() == 1;
    }

    public boolean isArticleRedoPossible() {
        if (JreepadViewer.getPrefs().viewWhich == 1) {
            return false;
        }
        if (this.theJreepad.getCurrentNode().getArticle().getArticleMode() != 1) {
            return false;
        }
        return this.theJreepad.getCurrentNode().getArticle().getUndoMgr().canRedo();
    }

    private void aboutAction() {
        JOptionPane.showMessageDialog(this, "Jreepad v " + version + "\n\n" + lang.getString("HELP_ABOUT") + "\n" + "\nJreepad \u00a9 2004-2007 Dan Stowell" + "\n" + "\nhttp://jreepad.sourceforge.net", "About Jreepad", 1);
    }

    private void showAutoSaveDialog() {
        this.autoSaveCheckBox.setSelected(JreepadViewer.getPrefs().autoSave);
        this.autoSavePeriodSpinner.getModel().setValue(new Integer(JreepadViewer.getPrefs().autoSavePeriod));
        this.autoSaveDialog.setVisible(true);
        this.autoSaveDialog.toFront();
    }

    private void showPrefsDialog() {
        this.prefsDialog.setVisible(true);
        this.prefsDialog.toFront();
        this.funkyGreenStrip.setVisible(JreepadViewer.getPrefs().showGreenStrip);
        this.webSearchMenuItem.setText(JreepadViewer.getPrefs().webSearchName);
        this.characterWrapArticleMenuItem.setText(lang.getString("MENUITEM_HARDWRAP1") + JreepadViewer.getPrefs().characterWrapWidth + lang.getString("MENUITEM_HARDWRAP2"));
    }

    private void deleteNodeAction() {
        if (JOptionPane.showConfirmDialog(this, lang.getString("PROMPT_CONFIRM_DELETE") + ":\n" + this.theJreepad.getCurrentNode().getTitle(), lang.getString("TITLE_CONFIRM_DELETE"), 0) != 0) {
            return;
        }
        this.theJreepad.removeNode();
        this.theJreepad.returnFocusToTree();
        this.updateWindowTitle();
    }

    private void getTreepadNodeUrl() {
        this.nodeUrlDisplayField.setText(this.theJreepad.getTreepadNodeUrl());
        this.nodeUrlDisplayDialog.setVisible(true);
    }

    private boolean checkOverwrite(File theFile) {
        if (theFile == null || !theFile.exists()) {
            return true;
        }
        return JOptionPane.showConfirmDialog(this, lang.getString("PROMPT_CONFIRM_OVERWRITE1") + " " + theFile.getName() + " " + lang.getString("PROMPT_CONFIRM_OVERWRITE2"), lang.getString("TITLE_CONFIRM_OVERWRITE"), 0) == 0;
    }

    public void showLicense() {
        JOptionPane.showMessageDialog(this, lang.getString("HELP_LICENSE") + "\n\n           http://www.gnu.org/copyleft/gpl.html\n" + "\n", lang.getString("MENUITEM_LICENSE"), 1);
    }

    public void wrapContentToCharWidth() {
        this.theJreepad.wrapContentToCharWidth(JreepadViewer.getPrefs().characterWrapWidth);
    }

    public void stripAllTags() {
        if (JOptionPane.showConfirmDialog(this, lang.getString("PROMPT_CONFIRM_STRIPTAGS"), lang.getString("TITLE_CONFIRM_STRIPTAGS"), 0) == 0) {
            this.theJreepad.stripAllTags();
        }
    }

    private void addToOpenRecentMenu(File f) {
        ListIterator iter = JreepadViewer.getPrefs().openRecentList.listIterator();
        while (iter.hasNext()) {
            File tempFile = (File)iter.next();
            if (tempFile != null && !tempFile.equals(f)) continue;
            iter.remove();
        }
        JreepadViewer.getPrefs().openRecentList.insertElementAt(f, 0);
        this.updateOpenRecentMenu();
    }

    private void updateOpenRecentMenu() {
        if (JreepadViewer.getPrefs().openRecentList.size() > JreepadViewer.getPrefs().openRecentListLength) {
            JreepadViewer.getPrefs().openRecentList.setSize(JreepadViewer.getPrefs().openRecentListLength);
        }
        try {
            this.openRecentTempFileList = new File[JreepadViewer.getPrefs().openRecentList.size()];
            for (int i = 0; i < JreepadViewer.getPrefs().openRecentList.size(); ++i) {
                this.openRecentTempFileList[i] = (File)JreepadViewer.getPrefs().openRecentList.get(i);
            }
        }
        catch (ClassCastException e) {
            System.err.println(e);
            this.openRecentTempFileList = new File[0];
        }
        this.openRecentMenu.setEnabled(JreepadViewer.getPrefs().openRecentList.size() > 1);
        this.openRecentMenu.removeAll();
        for (int i = 1; i < this.openRecentTempFileList.length; ++i) {
            File tempFile = this.openRecentTempFileList[i];
            JMenuItem tempMenuItem = new JMenuItem(tempFile.getParentFile().getName() + "/" + tempFile.getName());
            if (i < 10) {
                char theChar = ("" + i).charAt(0);
                tempMenuItem.setText("(" + theChar + ") " + tempMenuItem.getText());
                tempMenuItem.setMnemonic(theChar);
            }
            tempMenuItem.addActionListener(new FileOpeningActionListener(tempFile));
            this.openRecentMenu.add(tempMenuItem);
        }
    }

    private void insertDate() {
        this.theJreepad.insertDate();
    }

    public void macOSXRegistration() {
        if (MAC_OS_X) {
            try {
                Class<?> osxAdapter = Class.forName("jreepad.OSXAdapter");
                Class[] defArgs = new Class[]{JreepadViewer.class};
                Method registerMethod = osxAdapter.getDeclaredMethod("registerMacOSXApplication", defArgs);
                if (registerMethod != null) {
                    Object[] args = new Object[]{this};
                    registerMethod.invoke(osxAdapter, args);
                }
            }
            catch (NoClassDefFoundError e) {
                System.err.println("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + e + ")");
            }
            catch (ClassNotFoundException e) {
                System.err.println("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + e + ")");
            }
            catch (Exception e) {
                System.err.println("Exception while loading the OSXAdapter:");
                e.printStackTrace();
            }
        }
    }

    public void about() {
        this.aboutAction();
    }

    public void preferences() {
    }

    public void quit() {
        this.quitAction();
    }

    protected void systemClipboardToNewNode() {
        Transferable cont = this.systemClipboard.getContents(this);
        if (cont == null) {
            JOptionPane.showMessageDialog(this, lang.getString("MSG_CLIPBOARD_EMPTY"), lang.getString("TITLE_CLIPBOARD_EMPTY"), 0);
            return;
        }
        try {
            String titStr;
            int numRead;
            Reader readIt = DataFlavor.stringFlavor.getReaderForText(cont);
            char[] theStuff = new char[64];
            StringBuffer theStuffBuf = new StringBuffer();
            while ((numRead = readIt.read(theStuff)) != -1) {
                theStuffBuf.append(theStuff, 0, numRead);
            }
            String contStr = theStuffBuf.toString();
            int newlinePos = contStr.indexOf("\n");
            if (newlinePos == -1) {
                titStr = contStr;
                contStr = "";
            } else {
                titStr = contStr.substring(0, newlinePos - 1);
            }
            this.theJreepad.addChild(new JreepadNode(titStr, contStr));
        }
        catch (Exception err) {
            JOptionPane.showMessageDialog(this, lang.getString("MSG_CLIPBOARD_TEXTERROR"), lang.getString("TITLE_CLIPBOARD_ERROR"), 0);
            return;
        }
    }

    public void keyboardHelp() {
        String menuText;
        if (MAC_OS_X) {
            menuText = "Apple";
        } else {
            switch (MENU_MASK) {
                case 8: {
                    menuText = "Alt";
                    break;
                }
                case 4: {
                    menuText = "Meta";
                    break;
                }
                default: {
                    menuText = "Ctrl";
                }
            }
        }
        JOptionPane.showMessageDialog(this, "\nNAVIGATING AROUND THE TREE:\nUse the arrow (cursor) keys to navigate around the tree.\nUp/down will move you up/down the visible nodes.\nLeft/right will expand/collapse nodes.\n\nADDING/DELETING NODES:\n[" + menuText + "+T] Add sibling node above current node" + "\n[" + menuText + "+B] Add sibling node below current node" + "\n[" + menuText + "+D] Add child node to current node" + "\n[" + menuText + "+K] Delete current node" + "\n" + "\nMOVING NODES:" + "\n[" + menuText + "+up arrow] Move node up" + "\n[" + menuText + "+down arrow] Move node down" + "\n[" + menuText + "+right arrow] Indent node" + "\n[" + menuText + "+left arrow] Outdent node" + "\n" + "\nCOPYING AND PASTING:" + "\n[" + menuText + "+X] Cut selected text" + "\n[" + menuText + "+C] Copy selected text" + "\n[" + menuText + "+V] Paste selected text" + "\n - The copy/paste functions are included automatically" + "\n    by the Mac OSX runtime. I can't guarantee they exist" + "\n    for you if you're using a different operating system!" + "", lang.getString("HELP_KEYBOARD_TITLE"), 1);
    }

    public void linksHelp() {
        JOptionPane.showMessageDialog(this, lang.getString("HELP_LINKS"), lang.getString("HELP_LINKS_TITLE"), 1);
    }

    public void dragDropHelp() {
        JOptionPane.showMessageDialog(this, lang.getString("HELP_DRAGDROP"), lang.getString("HELP_DRAGDROP_TITLE"), 1);
    }

    static class ColouredStrip
    extends JPanel {
        Color col;

        ColouredStrip(Color col, int maxWidth, int maxHeight) {
            super(false);
            this.setMaximumSize(new Dimension(maxWidth, maxHeight));
            this.setBackground(col);
        }
    }

    private class FileOpeningActionListener
    implements ActionListener {
        File f;

        FileOpeningActionListener(File f) {
            this.f = f;
        }

        public void actionPerformed(ActionEvent e) {
            JreepadViewer.this.openFile(this.f);
        }
    }

    private class SaveAction
    extends AbstractAction {
        private boolean askForFilename;
        private boolean successful;

        public SaveAction() {
            this(false);
        }

        public SaveAction(boolean askForFilename) {
            super(askForFilename ? lang.getString("MENUITEM_SAVEAS") : lang.getString("MENUITEM_SAVE"), JreepadViewer.this.getIcon("Save16.gif"));
            this.successful = false;
            this.askForFilename = askForFilename;
            if (askForFilename) {
                this.putValue("MnemonicKey", new Integer(65));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, MENU_MASK));
            } else {
                this.putValue("MnemonicKey", new Integer(83));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, MENU_MASK));
                this.putValue("ShortDescription", lang.getString("TOOLBAR_SAVE"));
            }
        }

        public void actionPerformed(ActionEvent e) {
            int fileType = JreepadViewer.getPrefs().mainFileType;
            if (JreepadViewer.this.document.getSaveLocation() != null) {
                fileType = JreepadViewer.this.document.getFileType();
            }
            File saveLocation = JreepadViewer.this.document.getSaveLocation();
            if (this.askForFilename || saveLocation == null || saveLocation.isFile() && !saveLocation.canWrite()) {
                SaveFileChooser fileChooser = new SaveFileChooser(JreepadViewer.getPrefs().mainFileType);
                fileChooser.setCurrentDirectory(JreepadViewer.getPrefs().openLocation);
                fileChooser.setSelectedFile(new File(JreepadViewer.this.document.getRootNode().getTitle() + (fileType == 0 ? ".jree" : ".hjt")));
                if (fileChooser.showSaveDialog(JreepadViewer.this) != 0) {
                    this.successful = false;
                    return;
                }
                saveLocation = fileChooser.getSelectedFile();
                fileType = fileChooser.getFileType();
            }
            JreepadViewer.getPrefs().openLocation = saveLocation;
            try {
                JreepadWriter writer;
                JreepadViewer.this.setCursor(Cursor.getPredefinedCursor(3));
                String encoding = this.askForFilename || JreepadViewer.this.document.getEncoding() == null ? JreepadViewer.getPrefs().getEncoding() : JreepadViewer.this.document.getEncoding();
                if (fileType == 0) {
                    writer = new XmlWriter();
                } else if (fileType == 2) {
                    String password = JreepadViewer.this.document.getPassword();
                    if (password == null || this.askForFilename) {
                        password = PasswordDialog.showPasswordDialog(true);
                    }
                    if (password == null) {
                        this.successful = false;
                        return;
                    }
                    EncryptedWriter encryptedWriter = new EncryptedWriter(new XmlWriter());
                    encryptedWriter.setPassword(password);
                    writer = encryptedWriter;
                    JreepadViewer.this.document.setPassword(password);
                } else {
                    writer = new TreepadWriter(encoding);
                }
                FileOutputStream fos = new FileOutputStream(saveLocation);
                writer.write(fos, JreepadViewer.this.document);
                ((OutputStream)fos).close();
                if (MAC_OS_X) {
                    FileManager.setFileTypeAndCreator((String)saveLocation.toString(), (int)1246905669, (int)1246905669);
                }
                JreepadViewer.this.document.setSaveLocation(saveLocation);
                JreepadViewer.this.document.setFileType(fileType);
                JreepadViewer.this.document.setEncoding(encoding);
                JreepadViewer.this.updateWindowTitle();
                JreepadViewer.this.addToOpenRecentMenu(saveLocation);
                JreepadViewer.this.savePreferencesFile();
                JreepadViewer.this.setCursor(Cursor.getDefaultCursor());
                this.successful = true;
            }
            catch (IOException err) {
                JreepadViewer.this.setCursor(Cursor.getDefaultCursor());
                JOptionPane.showMessageDialog(JreepadViewer.this, err, lang.getString("TITLE_FILE_ERROR"), 0);
                this.successful = false;
            }
        }

        public boolean isSuccessful() {
            return this.successful;
        }
    }
}

